/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.query;

import java.util.Vector;

public class QueryTerm {
    private boolean casesensitive = false;
    private String searchmode = null;
    private String value = null;
    private String pathexpr = null;

    public QueryTerm(boolean casesensitive, String searchmode, String value) {
        this.casesensitive = casesensitive;
        this.searchmode = searchmode;
        this.value = value;
    }

    public QueryTerm(boolean casesensitive, String searchmode, String value, String pathexpr) {
        this(casesensitive, searchmode, value);
        this.pathexpr = pathexpr;
    }

    public boolean isCaseSensitive() {
        return this.casesensitive;
    }

    public void setCaseSensitive(boolean isCaseSensitive) {
        this.casesensitive = isCaseSensitive;
    }

    public String getSearchMode() {
        return this.searchmode;
    }

    public void setSearchMode(String mode) {
        this.searchmode = mode;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String val) {
        this.value = val;
    }

    public String getPathExpression() {
        return this.pathexpr;
    }

    public void setPathExpression(String val) {
        this.pathexpr = val;
    }

    public String printSQL(boolean useXMLIndex) {
        StringBuffer self = new StringBuffer();
        String casevalue = null;
        String nodedataterm = null;
        if (this.casesensitive) {
            nodedataterm = "nodedata";
            casevalue = this.value;
        } else {
            nodedataterm = "UPPER(nodedata)";
            casevalue = this.value.toUpperCase();
        }
        String searchvalue = null;
        searchvalue = this.searchmode.equals("starts-with") ? casevalue + "%" : (this.searchmode.equals("ends-with") ? "%" + casevalue : (this.searchmode.equals("contains") ? "%" + casevalue + "%" : casevalue));
        self.append("SELECT DISTINCT docid FROM xml_nodes WHERE \n");
        if (this.pathexpr != null) {
            self.append(nodedataterm + " LIKE " + "'" + searchvalue + "' ");
            self.append("AND parentnodeid IN ");
            if (useXMLIndex) {
                self.append("(SELECT nodeid FROM xml_index WHERE path LIKE '" + this.pathexpr + "') ");
            } else {
                self.append(this.useNestedStatements(this.pathexpr));
            }
        } else {
            self.append(nodedataterm + " LIKE " + "'" + searchvalue + "' ");
        }
        return self.toString();
    }

    public String toXml(int indent) {
        int i;
        StringBuffer self = new StringBuffer();
        for (i = 0; i < indent; ++i) {
            self.append(" ");
        }
        self.append("<queryterm");
        self.append(" searchmode=\"" + this.searchmode + "\"");
        self.append(" casesensitive=\"" + new Boolean(this.casesensitive) + "\"");
        self.append(">\n");
        for (i = 0; i < indent + 2; ++i) {
            self.append(" ");
        }
        self.append("<value>" + this.value + "</value>\n");
        if (this.pathexpr != null) {
            for (i = 0; i < indent + 2; ++i) {
                self.append(" ");
            }
            self.append("<pathexpr>" + this.pathexpr + "</pathexpr>\n");
        }
        for (i = 0; i < indent; ++i) {
            self.append(" ");
        }
        self.append("</queryterm>\n");
        return self.toString();
    }

    private String useNestedStatements(String pathexpr) {
        StringBuffer nestedStmts = new StringBuffer();
        Vector<String> nodes = new Vector<String>();
        String path = pathexpr;
        int inx = 0;
        do {
            inx = path.lastIndexOf("/");
            nodes.addElement(path.substring(inx + 1));
            path = path.substring(0, Math.abs(inx));
        } while (inx > 0);
        int i = 0;
        for (i = 0; i < nodes.size() - 1; ++i) {
            nestedStmts.append("(SELECT nodeid FROM xml_nodes WHERE nodename LIKE '" + (String)nodes.elementAt(i) + "'" + " AND parentnodeid IN ");
        }
        nestedStmts.append("(SELECT nodeid FROM xml_nodes WHERE nodename LIKE '" + (String)nodes.elementAt(i) + "'");
        for (i = 0; i < nodes.size(); ++i) {
            nestedStmts.append(")");
        }
        return nestedStmts.toString();
    }

    public String toString() {
        return this.printSQL(true);
    }
}

