/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.query;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.framework.ConfigXML;
import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.framework.SwingWorker;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.query.OpenDialogBox;
import edu.ucsb.nceas.morpho.query.Query;
import edu.ucsb.nceas.morpho.util.Command;
import java.awt.event.ActionEvent;
import java.util.Vector;

public class OpenDialogBoxCommand
implements Command {
    private Morpho morpho = null;
    private Query ownerQuery = null;

    public OpenDialogBoxCommand(Morpho morpho) {
        this.morpho = morpho;
    }

    public void execute(ActionEvent event) {
        this.ownerQuery = new Query(this.getOwnerQuery(), this.morpho);
        this.ownerQuery.setSearchLocal(true);
        MorphoFrame frame = UIController.getInstance().getCurrentActiveWindow();
        if (frame != null) {
            OpenDialogBox openDialogBox = new OpenDialogBox(frame, this.morpho, this.ownerQuery);
        }
    }

    private void doOpenDialog(final MorphoFrame morphoFrame) {
        SwingWorker worker = new SwingWorker(){
            OpenDialogBox open = null;

            public Object construct() {
                morphoFrame.setBusy(true);
                morphoFrame.setEnabled(false);
                this.open = new OpenDialogBox(morphoFrame, OpenDialogBoxCommand.this.morpho, OpenDialogBoxCommand.this.ownerQuery);
                return null;
            }

            public void finished() {
                morphoFrame.setEnabled(true);
                morphoFrame.setBusy(false);
                if (this.open != null) {
                    this.open.setModal(true);
                    this.open.setVisible(true);
                }
            }
        };
        worker.start();
    }

    protected String getOwnerQuery() {
        ConfigXML config = Morpho.getConfiguration();
        ConfigXML profile = this.morpho.getProfile();
        StringBuffer searchtext = new StringBuffer();
        searchtext.append("<?xml version=\"1.0\"?>\n");
        searchtext.append("<pathquery version=\"1.0\">\n");
        String lastname = profile.get("lastname", 0);
        String firstname = profile.get("firstname", 0);
        searchtext.append("<querytitle>My Data (" + firstname + " " + lastname);
        searchtext.append(")</querytitle>\n");
        Vector returnDoctypeList = config.get("returndoc");
        for (int i = 0; i < returnDoctypeList.size(); ++i) {
            searchtext.append("<returndoctype>");
            searchtext.append((String)returnDoctypeList.elementAt(i));
            searchtext.append("</returndoctype>\n");
        }
        Vector returnFieldList = config.get("returnfield");
        for (int i = 0; i < returnFieldList.size(); ++i) {
            searchtext.append("<returnfield>");
            searchtext.append((String)returnFieldList.elementAt(i));
            searchtext.append("</returnfield>\n");
        }
        searchtext.append("<owner>" + this.morpho.getUserName() + "</owner>\n");
        searchtext.append("<querygroup operator=\"UNION\">\n");
        searchtext.append("<queryterm casesensitive=\"true\" ");
        searchtext.append("searchmode=\"contains\">\n");
        searchtext.append("<value>%</value>\n");
        searchtext.append("</queryterm></querygroup></pathquery>");
        return searchtext.toString();
    }
}

