/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.query;

import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WidgetFactory;
import edu.ucsb.nceas.morpho.query.CancelCommand;
import edu.ucsb.nceas.morpho.query.DeleteCommand;
import edu.ucsb.nceas.morpho.query.OpenDialogBox;
import edu.ucsb.nceas.morpho.util.GUIAction;
import edu.ucsb.nceas.morpho.util.Log;
import java.awt.BorderLayout;
import java.awt.ItemSelectable;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class DeleteDialog
extends JDialog {
    private JButton executeButton = null;
    private JButton cancelButton = null;
    private GUIAction executeAction = new GUIAction("Delete", null, null);
    private JRadioButton deleteLocal = new JRadioButton("Delete local copy");
    private JRadioButton deleteNetwork = new JRadioButton("Delete network copy");
    private JRadioButton deleteBoth = new JRadioButton("Delete both copies");
    private static final int PADDINGWIDTH = 8;
    private static String WARNING = "Are you sure you want to delete the data package? \nIf yes, please choose one option and click the Delete button.";
    MorphoFrame morphoFrame = null;
    String morphoFrameType = null;
    OpenDialogBox openDialog = null;
    String selectDocId = null;
    private boolean inLocal = false;
    private boolean inNetwork = false;

    public DeleteDialog(MorphoFrame myParent, String frameType, String mySelectedDocId, boolean myInLocal, boolean myInNetwork) {
        super(myParent);
        this.morphoFrame = myParent;
        this.morphoFrameType = frameType;
        this.selectDocId = mySelectedDocId;
        this.inLocal = myInLocal;
        this.inNetwork = myInNetwork;
        this.initialize(this.morphoFrame);
    }

    public DeleteDialog(OpenDialogBox myParent, MorphoFrame grandParent, String mySelectedDocId, boolean myInLocal, boolean myInNetwork) {
        super(myParent);
        this.openDialog = myParent;
        this.morphoFrame = grandParent;
        this.selectDocId = mySelectedDocId;
        this.inLocal = myInLocal;
        this.inNetwork = myInNetwork;
        this.initialize(this.openDialog);
    }

    private void initialize(Window parent) {
        int parentWidth = parent.getWidth();
        int parentHeight = parent.getHeight();
        int dialogWidth = 400;
        int dialogHeight = 270;
        this.setSize(dialogWidth, dialogHeight);
        this.setResizable(false);
        double parentX = parent.getLocation().getX();
        double parentY = parent.getLocation().getY();
        double centerX = parentX + 0.5 * (double)parentWidth;
        double centerY = parentY + 0.5 * (double)parentHeight;
        int dialogX = new Double(centerX - 0.5 * (double)dialogWidth).intValue();
        int dialogY = new Double(centerY - 0.5 * (double)dialogHeight).intValue();
        this.setLocation(dialogX, dialogY);
        this.setTitle("Delete");
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.getContentPane().add("East", Box.createHorizontalStrut(8));
        this.getContentPane().add("West", Box.createHorizontalStrut(8));
        this.deleteLocal.setEnabled(false);
        this.deleteNetwork.setEnabled(false);
        this.deleteBoth.setEnabled(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.deleteLocal);
        group.add(this.deleteNetwork);
        group.add(this.deleteBoth);
        Vector<JRadioButton> enabledRadioButtonList = new Vector<JRadioButton>();
        if (this.inLocal) {
            this.deleteLocal.setEnabled(true);
            enabledRadioButtonList.add(this.deleteLocal);
        }
        if (this.inNetwork) {
            this.deleteNetwork.setEnabled(true);
            enabledRadioButtonList.add(this.deleteNetwork);
        }
        if (this.inLocal && this.inNetwork) {
            this.deleteBoth.setEnabled(true);
            enabledRadioButtonList.add(this.deleteBoth);
        }
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout(0, 0));
        Box noteBox = Box.createVerticalBox();
        noteBox.add(Box.createVerticalStrut(8));
        JLabel note = WidgetFactory.makeHTMLLabel(WARNING, 3);
        noteBox.add(note);
        noteBox.add(Box.createVerticalStrut(8));
        mainPanel.add("North", noteBox);
        Box radioBox = Box.createVerticalBox();
        radioBox.add(this.deleteLocal);
        radioBox.add(this.deleteNetwork);
        radioBox.add(this.deleteBoth);
        Box centerBox = Box.createHorizontalBox();
        centerBox.add(Box.createHorizontalGlue());
        centerBox.add(radioBox);
        centerBox.add(Box.createHorizontalGlue());
        mainPanel.add("Center", centerBox);
        this.getContentPane().add("Center", mainPanel);
        Box bottomBox = Box.createVerticalBox();
        this.getContentPane().add("South", bottomBox);
        bottomBox.add(Box.createVerticalStrut(8));
        Box controlButtonsBox = Box.createHorizontalBox();
        controlButtonsBox.add(Box.createHorizontalGlue());
        this.executeAction.setEnabled(false);
        this.executeButton = new JButton(this.executeAction);
        controlButtonsBox.add(this.executeButton);
        controlButtonsBox.add(Box.createHorizontalStrut(8));
        GUIAction cancelAction = new GUIAction("Cancel", null, new CancelCommand(this));
        this.cancelButton = new JButton(cancelAction);
        controlButtonsBox.add(this.cancelButton);
        controlButtonsBox.add(Box.createHorizontalStrut(8));
        bottomBox.add(controlButtonsBox);
        bottomBox.add(Box.createVerticalStrut(10));
        if (enabledRadioButtonList.size() > 0) {
            Object obj = enabledRadioButtonList.elementAt(0);
            JRadioButton selectedRadioButton = (JRadioButton)obj;
            selectedRadioButton.setSelected(true);
            this.enableExecuteButton(selectedRadioButton, this);
        }
        RadioButtonListener listener = new RadioButtonListener(this);
        this.deleteLocal.addItemListener(listener);
        this.deleteNetwork.addItemListener(listener);
        this.deleteBoth.addItemListener(listener);
        this.setVisible(false);
    }

    private void enableExecuteButton(Object object, JDialog dialog) {
        if (object == this.deleteLocal) {
            Log.debug(30, "In delete local branch");
            this.executeAction.setEnabled(true);
            this.executeAction.setCommand(new DeleteCommand(this.openDialog, dialog, this.morphoFrame, this.morphoFrameType, "local", this.selectDocId, this.inLocal, this.inNetwork));
        } else if (object == this.deleteNetwork) {
            Log.debug(30, "In delete network branch");
            this.executeAction.setEnabled(true);
            this.executeAction.setCommand(new DeleteCommand(this.openDialog, dialog, this.morphoFrame, this.morphoFrameType, "metacat", this.selectDocId, this.inLocal, this.inNetwork));
        } else if (object == this.deleteBoth) {
            Log.debug(50, "In delete both branch");
            this.executeAction.setEnabled(true);
            this.executeAction.setCommand(new DeleteCommand(this.openDialog, dialog, this.morphoFrame, this.morphoFrameType, "localmetacat", this.selectDocId, this.inLocal, this.inNetwork));
        }
    }

    private class RadioButtonListener
    implements ItemListener {
        private JDialog dialogs = null;

        public RadioButtonListener(JDialog myDialog) {
            this.dialogs = myDialog;
        }

        public void itemStateChanged(ItemEvent event) {
            ItemSelectable obj = event.getItemSelectable();
            DeleteDialog.this.enableExecuteButton(obj, this.dialogs);
        }
    }
}

