/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.metadisplay;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.exception.NullArgumentException;
import edu.ucsb.nceas.morpho.framework.ConfigXML;
import edu.ucsb.nceas.morpho.framework.EditingCompleteListener;
import edu.ucsb.nceas.morpho.plugins.MetaDisplayInterface;
import edu.ucsb.nceas.morpho.plugins.XMLFactoryInterface;
import edu.ucsb.nceas.morpho.plugins.metadisplay.History;
import edu.ucsb.nceas.morpho.plugins.metadisplay.HistoryItem;
import edu.ucsb.nceas.morpho.plugins.metadisplay.MetaDisplayUI;
import edu.ucsb.nceas.morpho.util.DocumentNotFoundException;
import edu.ucsb.nceas.morpho.util.IOUtil;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.morpho.util.XMLTransformer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.w3c.dom.Document;

public class MetaDisplay
implements MetaDisplayInterface,
EditingCompleteListener {
    public static final String BLANK_HTML_PAGE = "<html><head></head><body bgcolor=\"#eeeeee\">&nbsp;</body></html>";
    private final String CONFIG_KEY_CSS_LOCATION = "emlCSSLocation";
    private final String CONFIG_KEY_MCONFJAR_LOC = "morphoConfigJarLocation";
    private final MetaDisplayUI ui;
    private final XMLTransformer transformer;
    private final History history;
    private final Vector editingCompletelistenerList;
    private final Vector listenerList = new Vector();
    private final ConfigXML config;
    private XMLFactoryInterface factory;
    private String identifier;
    private String FULL_STYLE_PATH;
    private Properties currentTransformProps;

    public MetaDisplay() {
        this.editingCompletelistenerList = new Vector();
        this.history = new History();
        this.ui = new MetaDisplayUI(this);
        this.config = Morpho.getConfiguration();
        this.transformer = XMLTransformer.getInstance();
    }

    public Component getDisplayComponent(String identifier, XMLFactoryInterface factory, ActionListener listener) throws NullArgumentException, DocumentNotFoundException {
        Log.debug(50, "getDisplayComponent() called; id = " + identifier);
        this.setFactory(factory);
        this.addActionListener(listener);
        this.display(identifier);
        return this.ui;
    }

    public Component getDisplayComponent(XMLFactoryInterface factory, ActionListener listener) throws NullArgumentException {
        Log.debug(50, "getDisplayComponent() called");
        this.setFactory(factory);
        this.addActionListener(listener);
        this.ui.setHTML(BLANK_HTML_PAGE);
        this.updateBackButtonStatus();
        return this.ui;
    }

    private String getAsString(Reader reader) throws DocumentNotFoundException {
        StringBuffer docBuff = null;
        try {
            docBuff = IOUtil.getAsStringBuffer(reader, true);
        }
        catch (IOException ioe) {
            Log.debug(12, "Error reading reader " + ioe.getMessage());
            DocumentNotFoundException dnfe = new DocumentNotFoundException("MetaDisplay.getAsString() - Nested IOException " + ioe);
            dnfe.fillInStackTrace();
            throw dnfe;
        }
        if (docBuff == null) {
            Log.debug(12, "getAsString() got NULL buffer from IOUtil.getAsStringBuffer()");
            return "";
        }
        return docBuff.toString();
    }

    public void display(String identifier) throws DocumentNotFoundException {
        Log.debug(50, "display(String identifier) called; id = " + identifier);
        String oldID = this.identifier;
        Properties oldProps = this.clonePropertiesObject(this.currentTransformProps);
        try {
            this.displayThisID(identifier);
        }
        catch (DocumentNotFoundException dnfe) {
            this.setIDBackTo(oldID);
            this.currentTransformProps = oldProps;
            this.updateBackButtonStatus();
            throw dnfe;
        }
        Log.debug(50, "in display() - adding props to History: " + oldProps);
        this.history.add(new HistoryItem(oldID, oldProps));
        Log.debug(50, this.history.toString());
        this.updateBackButtonStatus();
    }

    public void display(String identifier, Reader XMLDocument) throws NullArgumentException, DocumentNotFoundException {
        Log.debug(50, "display(String identifier, Reader XMLDocument) called; id = " + identifier);
        String oldID = this.identifier;
        Properties oldProps = this.clonePropertiesObject(this.currentTransformProps);
        this.setIdentifier(identifier);
        if (XMLDocument == null) {
            Log.debug(12, "MetaDisplay.display() received NULL XML Document - displaying blank document");
            this.ui.setHTML(BLANK_HTML_PAGE);
        } else {
            try {
                this.doTransform(XMLDocument);
            }
            catch (DocumentNotFoundException dnfe) {
                this.setIDBackTo(oldID);
                this.currentTransformProps = oldProps;
                throw dnfe;
            }
        }
        this.fireActionEvent(10, this.getIdentifier());
        Log.debug(50, "in display() - adding props to History: " + oldProps);
        this.history.add(new HistoryItem(oldID, oldProps));
        Log.debug(50, this.history.toString());
    }

    public void display(String identifier, Document domDoc) throws NullArgumentException {
        Log.debug(50, "display(String identifier, Document domDoc) called; id = " + identifier);
        String oldID = this.identifier;
        Properties oldProps = this.clonePropertiesObject(this.currentTransformProps);
        this.setIdentifier(identifier);
        if (domDoc == null) {
            Log.debug(12, "MetaDisplay.display() received NULL XML Document - displaying blank document");
            this.ui.setHTML(BLANK_HTML_PAGE);
        } else {
            try {
                this.doTransform(domDoc);
            }
            catch (Exception dnfe) {
                this.setIDBackTo(oldID);
                this.currentTransformProps = oldProps;
            }
        }
        this.fireActionEvent(10, this.getIdentifier());
        Log.debug(50, "in display() - adding props to History: " + oldProps);
        this.history.add(new HistoryItem(oldID, oldProps));
        Log.debug(50, this.history.toString());
    }

    public void displayPrevious() throws DocumentNotFoundException {
        String oldID = this.identifier;
        Properties oldProps = this.clonePropertiesObject(this.currentTransformProps);
        try {
            HistoryItem prev = this.history.getPrevious();
            Log.debug(50, "in displayPrevious() - setting prev TransfmrProps=" + prev.transformProperties);
            this.transformer.setTransformerProperties(prev.transformProperties);
            this.displayThisID(prev.identifier);
        }
        catch (DocumentNotFoundException dnfe) {
            this.setIDBackTo(oldID);
            this.transformer.setTransformerProperties(oldProps);
            this.updateBackButtonStatus();
            throw dnfe;
        }
        this.updateBackButtonStatus();
    }

    public void redisplay() throws DocumentNotFoundException {
        Log.debug(50, "redisplay() called");
        this.display(this.getIdentifier());
    }

    public void addActionListener(ActionListener listener) {
        Log.debug(50, "addActionListener() called");
        if (listener == null) {
            return;
        }
        if (!this.listenerList.contains(listener)) {
            this.listenerList.add(listener);
        }
    }

    public void removeActionListener(ActionListener listener) {
        Log.debug(50, "removeActionListener() called");
        if (this.listenerList.contains(listener)) {
            this.listenerList.remove(listener);
        }
    }

    protected void fireActionEvent(int descriptionInt, String commandStr) {
        Log.debug(50, "fireActionEvent(); description int: " + descriptionInt + " command string : " + commandStr);
        ActionEvent ae = new ActionEvent(this, descriptionInt, commandStr);
        Enumeration listeners = this.listenerList.elements();
        while (listeners.hasMoreElements()) {
            ((ActionListener)listeners.nextElement()).actionPerformed(ae);
        }
    }

    public void addEditingCompleteListener(EditingCompleteListener listener) {
        Log.debug(50, "MetaDisplay: addEditingCompleteListener() called");
        if (listener == null) {
            return;
        }
        if (!this.editingCompletelistenerList.contains(listener)) {
            this.editingCompletelistenerList.add(listener);
        }
    }

    public void removeEditingCompleteListener(EditingCompleteListener listener) {
        Log.debug(50, "MetaDisplay: removeActionListener() called");
        if (this.editingCompletelistenerList.contains(listener)) {
            this.editingCompletelistenerList.remove(listener);
        }
    }

    public void editingCompleted(String xmlString, String id, String location) {
        Log.debug(40, "MetaDisplay: editingCompleted() callback received.");
        Enumeration listeners = this.editingCompletelistenerList.elements();
        while (listeners.hasMoreElements()) {
            ((EditingCompleteListener)listeners.nextElement()).editingCompleted(xmlString, id, location);
        }
    }

    public void editingCanceled(String xmlString, String id, String location) {
        Log.debug(50, "MetaDisplay: editingCanceled() callback received.");
        Enumeration listeners = this.editingCompletelistenerList.elements();
        while (listeners.hasMoreElements()) {
            ((EditingCompleteListener)listeners.nextElement()).editingCanceled(xmlString, id, location);
        }
    }

    public XMLFactoryInterface getFactory() {
        return this.factory;
    }

    public void setFactory(XMLFactoryInterface factory) throws NullArgumentException {
        if (factory == null) {
            NullArgumentException iae = new NullArgumentException("XML Factory may not be null");
            iae.fillInStackTrace();
            throw iae;
        }
        this.factory = factory;
    }

    protected History getHistory() {
        return this.history;
    }

    private void displayThisID(String ID) throws DocumentNotFoundException {
        this.transformer.addTransformerProperty("stylePath", this.getFullStylePath());
        Reader xmlReader = null;
        try {
            this.setIdentifier(ID);
        }
        catch (NullArgumentException nae) {
            Log.debug(12, "NullArgumentException setting identifier: " + ID + "; " + nae.getMessage());
            DocumentNotFoundException dnfe = new DocumentNotFoundException("Nested NullArgumentException:" + nae.getMessage());
            this.transformer.removeAllTransformerProperties();
            dnfe.fillInStackTrace();
            throw dnfe;
        }
        try {
            if (this.factory.openAsDom(ID) == null) {
                xmlReader = this.factory.openAsReader(ID);
            }
        }
        catch (DocumentNotFoundException dnfe) {
            Log.debug(12, "DocumentNotFoundException getting Reader for ID: " + ID + "; " + dnfe.getMessage());
            this.transformer.removeAllTransformerProperties();
            dnfe.fillInStackTrace();
            throw dnfe;
        }
        Reader resultReader = null;
        resultReader = this.factory.openAsDom(ID) == null ? this.doTransform(xmlReader) : this.doTransform(this.factory.openAsDom(ID));
        String htmlDoc = this.getAsString(resultReader);
        this.fireActionEvent(10, this.getIdentifier());
        this.ui.setHTML(htmlDoc);
        this.currentTransformProps = this.transformer.getCurrentTransformerProperties();
        Log.debug(50, "in displayThisID() - used TransfmrProps=" + this.currentTransformProps);
        this.transformer.removeAllTransformerProperties();
    }

    private Reader doTransform(Reader xml) throws DocumentNotFoundException {
        Reader result = null;
        Document doc = this.factory.openAsDom(this.identifier);
        if (doc != null) {
            result = this.doTransform(doc);
            return result;
        }
        try {
            result = this.transformer.transform(xml);
        }
        catch (IOException ioe) {
            String errMsg = "MetaDisplay.doTransform(): \nthrowing DocumentNotFoundException. \nNested IOException is:\n" + ioe.getMessage() + "\nXML document received was:\n" + this.getAsString(xml);
            Log.debug(12, errMsg);
            DocumentNotFoundException d = new DocumentNotFoundException(errMsg);
            d.fillInStackTrace();
            throw d;
        }
        Log.debug(50, "doTransform returning Reader: " + result + " for ID: " + this.identifier);
        return result;
    }

    private Reader doTransform(Document doc) {
        Reader result = null;
        try {
            result = this.transformer.transform(doc);
        }
        catch (IOException ioe) {
            String errMsg = "MetaDisplay.doTransform(): \nthrowing DocumentNotFoundException. \nNested IOException is:\n" + ioe.getMessage() + "\nXML document received was:\n" + doc;
            Log.debug(12, errMsg);
        }
        Log.debug(50, "doTransform returning Reader: " + result + " for ID: " + this.identifier);
        return result;
    }

    private void setIdentifier(String identifier) throws NullArgumentException {
        if (identifier == null || identifier.trim().equals("")) {
            NullArgumentException nae = new NullArgumentException("identifier must have a value");
            nae.fillInStackTrace();
            throw nae;
        }
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    private void setIDBackTo(String oldID) {
        try {
            this.setIdentifier(oldID);
        }
        catch (NullArgumentException nae) {
            Log.debug(12, "NullArgumentException setIDBackTo(" + oldID + "); " + nae.getMessage());
        }
    }

    private void updateBackButtonStatus() {
        if (this.getHistory().previewPreviousID() == null) {
            this.ui.getHeader().setBackButtonEnabled(false);
        } else {
            this.ui.getHeader().setBackButtonEnabled(true);
        }
    }

    public void useTransformerProperty(String key, String value) {
        Log.debug(50, "MetaDisplay.useTransformerProperty(" + key + ", " + value + ")");
        this.transformer.addTransformerProperty(key, value);
    }

    public String getTransformerProperty(String key) {
        if (key == null) {
            return "";
        }
        return this.currentTransformProps.getProperty(key);
    }

    private String getFullStylePath() {
        if (this.FULL_STYLE_PATH == null) {
            StringBuffer pathBuff = new StringBuffer();
            pathBuff.append("jar:file:");
            pathBuff.append(new File("").getAbsolutePath());
            pathBuff.append("/");
            pathBuff.append(this.config.get("morphoConfigJarLocation", 0));
            pathBuff.append("!/");
            pathBuff.append(this.config.get("emlCSSLocation", 0));
            this.FULL_STYLE_PATH = pathBuff.toString();
            Object var1_1 = null;
        }
        return this.FULL_STYLE_PATH;
    }

    private Properties clonePropertiesObject(Properties propsToClone) {
        if (propsToClone == null) {
            return null;
        }
        if (propsToClone.isEmpty()) {
            return new Properties();
        }
        Properties returnProps = new Properties();
        Iterator<Object> keys = propsToClone.keySet().iterator();
        String nextKey = null;
        while (keys.hasNext()) {
            nextKey = String.valueOf(keys.next());
            returnProps.setProperty(String.valueOf(nextKey), propsToClone.getProperty(nextKey));
        }
        return returnProps;
    }

    protected MetaDisplayUI getMetaDisplayUI() {
        return this.ui;
    }

    public void setTitle(String title) {
        this.ui.getHeader().setTitleBarText(title);
    }
}

