/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages;

import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WidgetFactory;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardContainerFrame;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardSettings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class FileChooserWidget
extends JPanel {
    private final String EMPTY_STRING = "";
    private JLabel fileNameLabel;
    private JLabel descLabel;
    private JTextField fileNameField;
    private JButton fileNameButton;
    private String importFileURL;
    private static File lastDataDir = null;

    public FileChooserWidget(String label, String descText, String initialText) {
        this.init();
        if (initialText == null) {
            initialText = "";
        }
        this.fileNameField.setText(initialText);
        this.setDescription(descText);
        this.setLabelText(label);
    }

    private void init() {
        this.setLayout(new GridLayout(3, 1));
        this.descLabel = WidgetFactory.makeHTMLLabel("", 1);
        this.add(this.descLabel);
        JPanel fileNamePanel = WidgetFactory.makePanel();
        fileNamePanel.setLayout(new BorderLayout());
        fileNamePanel.setMaximumSize(WizardSettings.WIZARD_CONTENT_SINGLE_LINE_DIMS);
        this.fileNameLabel = WidgetFactory.makeLabel("", true);
        this.fileNameLabel.setBackground(Color.lightGray);
        fileNamePanel.add((Component)this.fileNameLabel, "West");
        this.fileNameField = WidgetFactory.makeOneLineTextField();
        this.fileNameField.setEnabled(false);
        this.fileNameField.setEditable(false);
        this.fileNameField.setDisabledTextColor(WizardSettings.WIZARD_CONTENT_TEXT_COLOR);
        fileNamePanel.add((Component)this.fileNameField, "Center");
        this.fileNameButton = WidgetFactory.makeJButton("locate...", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                fc.setDialogTitle("Select a data file to import...");
                String userdir = System.getProperty("user.dir");
                String homedir = System.getProperty("user.home");
                String osname = System.getProperty("os.name");
                if (lastDataDir == null) {
                    File mydocs;
                    fc.setCurrentDirectory(new File(userdir));
                    if (osname.indexOf("Window") > -1 && (mydocs = new File(homedir + File.separator + "My Documents")).exists()) {
                        fc.setCurrentDirectory(mydocs);
                    }
                } else {
                    fc.setCurrentDirectory(lastDataDir);
                }
                int returnVal = fc.showOpenDialog(WizardContainerFrame.frame);
                File file = null;
                if (returnVal == 0 && (file = fc.getSelectedFile()) != null) {
                    lastDataDir = new File(file.getParent());
                    FileChooserWidget.this.setImportFileURL(file.getAbsolutePath());
                    FileChooserWidget.this.fileNameField.setText(FileChooserWidget.this.getImportFileURL());
                }
            }
        });
        fileNamePanel.add((Component)this.fileNameButton, "East");
        this.add(fileNamePanel);
    }

    protected JLabel getLabel() {
        return this.fileNameLabel;
    }

    protected void setLabelText(String text) {
        this.fileNameLabel.setText(text);
    }

    protected JButton getButton() {
        return this.fileNameButton;
    }

    protected JTextField getTextArea() {
        return this.fileNameField;
    }

    protected String getImportFileURL() {
        return this.importFileURL;
    }

    protected void setDescription(String desc) {
        if (desc == null) {
            desc = "";
        }
        this.descLabel.setText(desc);
    }

    protected void setImportFileURL(String filePath) {
        this.importFileURL = filePath;
    }
}

