/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages;

import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.framework.ModalDialog;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.CustomList;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WidgetFactory;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardContainerFrame;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.AttributePage;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class Entity
extends AbstractUIPage {
    private final String pageID = "ENTITY";
    private String nextPageID = "SUMMARY";
    private final String pageNumber = "";
    private final String title = "Data Information:";
    private final String subtitle = "Table (Entity)";
    private final String xPathRoot = "/eml:eml/dataset/dataTable";
    private final String[] colNames = new String[]{"Attribute Name", "Attribute Definition", "Measurement Scale"};
    private final Object[] editors = null;
    private JTextField entityNameField;
    private JTextArea entityDescField;
    private JLabel entityNameLabel;
    private CustomList attributeList;
    private JLabel attributesLabel;
    private WizardContainerFrame mainWizFrame;
    private OrderedMap returnMap = new OrderedMap();

    public Entity(WizardContainerFrame frame) {
        this.mainWizFrame = frame;
        this.init();
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(WidgetFactory.makeDefaultSpacer());
        JLabel desc1 = WidgetFactory.makeHTMLLabel("<b>Enter some information about the data table contained in your file.</b> If you have more than one data table, additional tables may be added after the completion of this wizard.", 2);
        this.add(desc1);
        this.add(WidgetFactory.makeDefaultSpacer());
        this.add(WidgetFactory.makeDefaultSpacer());
        JPanel attributePanel = WidgetFactory.makePanel(1);
        this.entityNameLabel = WidgetFactory.makeLabel("Table name:", true);
        attributePanel.add(this.entityNameLabel);
        this.entityNameField = WidgetFactory.makeOneLineTextField();
        attributePanel.add(this.entityNameField);
        this.add(attributePanel);
        this.add(WidgetFactory.makeDefaultSpacer());
        JLabel entityDesc = WidgetFactory.makeHTMLLabel("Enter a paragraph that describes the table or entity, its type, and relevant information about the data that it contains.<br></br><font color=\"666666\">&nbsp;&nbsp;[Example:&nbsp;&nbsp;&nbsp;Species abundance data for 1996 at the VCR LTER site]</font>", 3);
        this.add(entityDesc);
        JPanel entityDescPanel = WidgetFactory.makePanel();
        JLabel entityLabel = WidgetFactory.makeLabel("Description", false);
        entityLabel.setVerticalAlignment(1);
        entityLabel.setAlignmentY(1.0f);
        entityDescPanel.add(entityLabel);
        this.entityDescField = WidgetFactory.makeTextArea("", 6, true);
        JScrollPane jscrl = new JScrollPane(this.entityDescField);
        entityDescPanel.add(jscrl);
        this.add(entityDescPanel);
        this.add(WidgetFactory.makeDefaultSpacer());
        this.add(WidgetFactory.makeHTMLLabel("One or more attributes (columns) must be defined:", 1));
        JPanel attribsPanel = WidgetFactory.makePanel();
        this.attributesLabel = WidgetFactory.makeLabel("Attributes", true);
        attribsPanel.add(this.attributesLabel);
        this.attributeList = WidgetFactory.makeList(this.colNames, this.editors, 4, true, true, false, true, true, true);
        attribsPanel.add(this.attributeList);
        this.add(attribsPanel);
        this.initActions();
    }

    private void initActions() {
        this.attributeList.setCustomAddAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Log.debug(45, "\nEntity: CustomAddAction called");
                Entity.this.showNewAttributeDialog();
            }
        });
        this.attributeList.setCustomEditAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Log.debug(45, "\nEntity: CustomEditAction called");
                Entity.this.showEditAttributeDialog();
            }
        });
    }

    private void showNewAttributeDialog() {
        AttributePage attributePage = new AttributePage();
        ModalDialog wpd = new ModalDialog(attributePage, WizardContainerFrame.getDialogParent(), 770, 570, false);
        wpd.setBounds(wpd.getX(), WizardContainerFrame.frame.getY(), 770, 600);
        wpd.setVisible(true);
        if (wpd.USER_RESPONSE == 10) {
            List newRow = attributePage.getSurrogate();
            newRow.add(attributePage);
            this.attributeList.addRow(newRow);
        }
        WidgetFactory.unhiliteComponent(this.attributesLabel);
    }

    private void showEditAttributeDialog() {
        List selRowList = this.attributeList.getSelectedRowList();
        if (selRowList == null || selRowList.size() < 4) {
            return;
        }
        Object dialogObj = selRowList.get(3);
        if (dialogObj == null || !(dialogObj instanceof AttributePage)) {
            return;
        }
        AttributePage editAttributePage = (AttributePage)dialogObj;
        ModalDialog wpd = new ModalDialog(editAttributePage, WizardContainerFrame.getDialogParent(), 770, 570, false);
        wpd.setBounds(wpd.getX(), WizardContainerFrame.frame.getY(), 770, 600);
        wpd.setVisible(true);
        if (wpd.USER_RESPONSE == 10) {
            List newRow = editAttributePage.getSurrogate();
            newRow.add(editAttributePage);
            this.attributeList.replaceSelectedRow(newRow);
        }
    }

    public void onLoadAction() {
        this.entityNameField.requestFocus();
    }

    public void onRewindAction() {
        WidgetFactory.unhiliteComponent(this.attributesLabel);
    }

    public boolean onAdvanceAction() {
        if (this.entityNameField.getText().trim().equals("")) {
            WidgetFactory.hiliteComponent(this.entityNameLabel);
            this.entityNameField.requestFocus();
            return false;
        }
        if (this.attributeList.getRowCount() < 1) {
            WidgetFactory.hiliteComponent(this.attributesLabel);
            return false;
        }
        ArrayList<String> colNames = new ArrayList<String>();
        boolean importNeeded = false;
        AttributePage nextAttributePage = null;
        List rowLists = this.attributeList.getListOfRowLists();
        if (rowLists == null) {
            return true;
        }
        int index = 1;
        int attrsToBeImported = 0;
        AbstractDataPackage adp = UIController.getInstance().getCurrentAbstractDataPackage();
        if (adp == null) {
            Log.debug(10, "Error! Unable to obtain the ADP in the Entity page!");
        } else {
            attrsToBeImported = adp.getAttributeImportCount();
        }
        String entityName = this.entityNameField.getText().trim();
        Iterator it = rowLists.iterator();
        while (adp != null && it.hasNext()) {
            Object nextUserObject;
            List nextRowList;
            Object nextRowObj = it.next();
            if (nextRowObj == null || (nextRowList = (List)nextRowObj).size() < 4 || (nextUserObject = nextRowList.get(3)) == null) continue;
            String colName = (String)nextRowList.get(0);
            nextAttributePage = (AttributePage)nextUserObject;
            if (nextAttributePage.isImportNeeded()) {
                OrderedMap map = nextAttributePage.getPageData("/eml:eml/dataset/dataTable/attributeList/attribute[" + index + "]");
                String mScale = (String)nextRowList.get(2);
                adp.addAttributeForImport(entityName, colName, mScale, map, "/eml:eml/dataset/dataTable/attributeList/attribute[" + index + "]", true);
                importNeeded = true;
            }
            colNames.add(colName);
            ++index;
        }
        if (adp != null) {
            adp.setLastImportedEntity(entityName);
            adp.setLastImportedAttributes(colNames);
            adp.setLastImportedDataSet(null);
        }
        if (attrsToBeImported > 0) {
            this.nextPageID = "CODE_DEFINITION";
        } else if (importNeeded) {
            this.nextPageID = "CODE_IMPORT_PAGE";
        }
        return true;
    }

    public OrderedMap getPageData() {
        this.returnMap.clear();
        this.returnMap.put((Object)"/eml:eml/dataset/dataTable/entityName", (Object)this.entityNameField.getText().trim());
        String entityDesc = this.entityDescField.getText().trim();
        if (!entityDesc.equals("")) {
            this.returnMap.put((Object)"/eml:eml/dataset/dataTable/entityDescription", (Object)entityDesc);
        }
        this.returnMap.put((Object)"/eml:eml/dataset/dataTable/physical/objectName", (Object)"");
        this.returnMap.put((Object)"/eml:eml/dataset/dataTable/physical/dataFormat", (Object)"");
        int index = 1;
        Object nextRowObj2 = null;
        List nextRowList = null;
        Object nextUserObject = null;
        OrderedMap nextNVPMap = null;
        AttributePage nextAttributePage = null;
        List rowLists = this.attributeList.getListOfRowLists();
        if (rowLists == null) {
            return null;
        }
        for (Object nextRowObj2 : rowLists) {
            if (nextRowObj2 == null || (nextRowList = (List)nextRowObj2).size() < 4 || (nextUserObject = nextRowList.get(3)) == null) continue;
            nextAttributePage = nextUserObject;
            nextNVPMap = nextAttributePage.getPageData("/eml:eml/dataset/dataTable/attributeList/attribute[" + index++ + "]");
            this.returnMap.putAll((Map)nextNVPMap);
        }
        return this.returnMap;
    }

    public OrderedMap getPageData(String rootXPath) {
        throw new UnsupportedOperationException("getPageData(String rootXPath) Method Not Implemented");
    }

    public String getPageID() {
        return "ENTITY";
    }

    public String getTitle() {
        return "Data Information:";
    }

    public String getSubtitle() {
        return "Table (Entity)";
    }

    public String getNextPageID() {
        return this.nextPageID;
    }

    public String getPageNumber() {
        return "";
    }

    public boolean setPageData(OrderedMap data, String xPathRoot) {
        return false;
    }
}

