/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages;

import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WidgetFactory;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardPageSubPanelAPI;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.CitationPage;
import edu.ucsb.nceas.utilities.OrderedMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

class ArticlePanel
extends JPanel
implements WizardPageSubPanelAPI {
    CitationPage parent;
    private JLabel journalLabel;
    private JLabel volumeLabel;
    private JLabel rangeLabel;
    private JLabel publisherLabel;
    private JLabel issueLabel;
    private JTextField journalField;
    private JTextField volumeField;
    private JTextField rangeField;
    private JTextField publisherField;
    private JTextField issueField;

    ArticlePanel(CitationPage page) {
        this.parent = page;
        this.init();
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel journalPanel = WidgetFactory.makePanel(1);
        this.journalLabel = WidgetFactory.makeLabel("Journal:", true);
        journalPanel.add(this.journalLabel);
        this.journalField = WidgetFactory.makeOneLineTextField();
        journalPanel.add(this.journalField);
        journalPanel.setBorder(new EmptyBorder(0, 5, 0, 10));
        this.add(journalPanel);
        this.add(WidgetFactory.makeHalfSpacer());
        this.add(Box.createGlue());
        JPanel volumePanel = WidgetFactory.makePanel(1);
        this.volumeLabel = WidgetFactory.makeLabel("Volume:", true);
        volumePanel.add(this.volumeLabel);
        this.volumeField = WidgetFactory.makeOneLineTextField();
        volumePanel.add(this.volumeField);
        volumePanel.setBorder(new EmptyBorder(0, 5, 0, 10));
        this.add(Box.createGlue());
        this.add(volumePanel);
        this.add(WidgetFactory.makeHalfSpacer());
        this.add(Box.createGlue());
        JPanel issuePanel = WidgetFactory.makePanel(1);
        this.issueLabel = WidgetFactory.makeLabel("Issue:", false);
        issuePanel.add(this.issueLabel);
        this.issueField = WidgetFactory.makeOneLineTextField();
        issuePanel.add(this.issueField);
        issuePanel.setBorder(new EmptyBorder(0, 5, 0, 10));
        this.add(Box.createGlue());
        this.add(issuePanel);
        this.add(WidgetFactory.makeHalfSpacer());
        this.add(Box.createGlue());
        JPanel rangePanel = WidgetFactory.makePanel(1);
        this.rangeLabel = WidgetFactory.makeLabel("Page Range:", true);
        rangePanel.add(this.rangeLabel);
        this.rangeField = WidgetFactory.makeOneLineTextField();
        rangePanel.add(this.rangeField);
        rangePanel.setBorder(new EmptyBorder(0, 5, 0, 10));
        this.add(Box.createGlue());
        this.add(rangePanel);
        this.add(WidgetFactory.makeHalfSpacer());
        this.add(Box.createGlue());
        JPanel publisherPanel = WidgetFactory.makePanel(1);
        this.publisherLabel = WidgetFactory.makeLabel("Publisher:", false);
        publisherPanel.add(this.publisherLabel);
        this.publisherField = WidgetFactory.makeOneLineTextField();
        publisherPanel.add(this.publisherField);
        publisherPanel.setBorder(new EmptyBorder(0, 5, 0, 10));
        this.add(publisherPanel);
        this.add(WidgetFactory.makeHalfSpacer());
        this.add(Box.createGlue());
    }

    public boolean validateUserInput() {
        if (this.journalField.getText().trim().equals("")) {
            WidgetFactory.hiliteComponent(this.journalLabel);
            this.journalField.requestFocus();
            return false;
        }
        WidgetFactory.unhiliteComponent(this.journalLabel);
        if (this.volumeField.getText().trim().equals("")) {
            WidgetFactory.hiliteComponent(this.volumeLabel);
            this.volumeField.requestFocus();
            return false;
        }
        WidgetFactory.unhiliteComponent(this.volumeLabel);
        if (this.rangeField.getText().trim().equals("")) {
            WidgetFactory.hiliteComponent(this.rangeLabel);
            this.rangeField.requestFocus();
            return false;
        }
        WidgetFactory.unhiliteComponent(this.rangeLabel);
        return true;
    }

    public void onLoadAction() {
    }

    public OrderedMap getPanelData(String xPathRoot) {
        OrderedMap map = new OrderedMap();
        map.put((Object)(xPathRoot + "/journal[1]"), (Object)this.journalField.getText());
        map.put((Object)(xPathRoot + "/volume[1]"), (Object)this.volumeField.getText());
        String issue = this.issueField.getText();
        if (!issue.trim().equals("")) {
            map.put((Object)(xPathRoot + "/issue[1]"), (Object)issue);
        }
        map.put((Object)(xPathRoot + "/pageRange[1]"), (Object)this.rangeField.getText());
        String pub = this.publisherField.getText();
        if (!pub.trim().equals("")) {
            map.put((Object)(xPathRoot + "/publisher[1]/organizationName[1]"), (Object)pub);
        }
        return map;
    }

    public void setPanelData(String xPathRoot, OrderedMap map) {
        String pub;
        this.journalField.setText((String)map.get((Object)(xPathRoot + "/journal[1]")));
        this.volumeField.setText((String)map.get((Object)(xPathRoot + "/volume[1]")));
        String pr = (String)map.get((Object)(xPathRoot + "/pageRange[1]"));
        this.rangeField.setText(pr);
        String issue = (String)map.get((Object)(xPathRoot + "/issue[1]"));
        if (issue != null) {
            this.issueField.setText(issue);
            map.remove((Object)(xPathRoot + "/issue[1]"));
        }
        if ((pub = (String)map.get((Object)(xPathRoot + "/publisher[1]/organizationName[1]"))) != null) {
            this.publisherField.setText(pub);
            map.remove((Object)(xPathRoot + "/publisher[1]/organizationName[1]"));
        }
    }
}

