/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages;

import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.framework.ModalDialog;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.CustomList;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WidgetFactory;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardContainerFrame;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardPageLibrary;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.AccessPage;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;

public class Access
extends AbstractUIPage {
    public final String pageID = "ACCESS";
    public final String nextPageID = "SUMMARY";
    public final String pageNumber = "14";
    public final String title = "Access Information";
    public final String subtitle = " ";
    private JPanel radioPanel;
    private String xPathRoot = "/eml:eml/dataset/access/";
    private boolean publicReadAccess = true;
    private final String[] buttonsText = new String[]{"Yes, give read-only access to public.", "No."};
    private final String ALLOW_REL_XPATH = "allow[";
    private final String DENY_REL_XPATH = "deny[";
    private final String AUTHSYSTEM_REL_XPATH = "@authSystem";
    private final String ORDER_REL_XPATH = "@order";
    private final String[] colNames = new String[]{"Name", "Organization", "Email/Description", "Permissions"};
    private final Object[] editors = null;
    private CustomList accessList;
    private String AUTHSYSTEM_VALUE = "knb";
    private String ORDER_VALUE = "denyFirst";
    public static DefaultMutableTreeNode accessTreeNode = null;
    public static String accessTreeMetacatServerName = null;
    private OrderedMap returnMap = new OrderedMap();
    OrderedMap publicMap = null;

    public Access() {
        this.init();
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        Box vBox = Box.createVerticalBox();
        vBox.add(WidgetFactory.makeDefaultSpacer());
        JLabel desc = WidgetFactory.makeHTMLLabel("<p><b>Would you like the allow the public to read your data package?</b></p>", 3);
        vBox.add(desc);
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Log.debug(45, "got radiobutton command: " + e.getActionCommand());
                if (e.getActionCommand().equals(Access.this.buttonsText[0])) {
                    Access.this.publicReadAccess = true;
                }
                if (e.getActionCommand().equals(Access.this.buttonsText[1])) {
                    Access.this.publicReadAccess = false;
                }
            }
        };
        this.radioPanel = WidgetFactory.makeRadioPanel(this.buttonsText, 0, listener);
        this.radioPanel.setBorder(new EmptyBorder(0, 5, 0, 0));
        vBox.add(this.radioPanel);
        vBox.add(WidgetFactory.makeDefaultSpacer());
        JLabel desc1 = WidgetFactory.makeHTMLLabel("<p><b>Would you like to give special access rights to other people?</b> You can specify access for other members of your team or any other person. Use the table below to add, edit and delete access rights to your data package.</p>", 3);
        vBox.add(desc1);
        this.accessList = WidgetFactory.makeList(this.colNames, this.editors, 4, true, true, false, true, true, true);
        this.accessList.setBorder(new EmptyBorder(0, 5, 5, 10));
        vBox.add(this.accessList);
        vBox.add(WidgetFactory.makeDefaultSpacer());
        this.add(vBox);
        this.initActions();
    }

    private void initActions() {
        this.accessList.setCustomAddAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Log.debug(45, "\nAccess: CustomAddAction called");
                Access.this.showNewAccessDialog();
            }
        });
        this.accessList.setCustomEditAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Log.debug(45, "\nAccess: CustomEditAction called");
                Access.this.showEditAccessDialog();
            }
        });
    }

    protected void showNewAccessDialog() {
        AccessPage accessPage = (AccessPage)WizardPageLibrary.getPage("ACCESS_PAGE");
        ModalDialog wpd = new ModalDialog(accessPage, WizardContainerFrame.getDialogParent(), 770, 570, false);
        wpd.setVisible(true);
        if (wpd.USER_RESPONSE == 10) {
            List newRows = accessPage.getSurrogate();
            for (ArrayList newRow : newRows) {
                newRow.add(accessPage);
                this.accessList.addRow(newRow);
            }
        }
    }

    protected void showEditAccessDialog() {
        List selRowList = this.accessList.getSelectedRowList();
        if (selRowList == null || selRowList.size() < 5) {
            Log.debug(45, selRowList.size() + "");
            return;
        }
        Object dialogObj = selRowList.get(4);
        if (dialogObj == null || !(dialogObj instanceof AccessPage)) {
            return;
        }
        AccessPage editAccessPage = (AccessPage)dialogObj;
        ModalDialog wpd = new ModalDialog(editAccessPage, WizardContainerFrame.getDialogParent(), 770, 570, false);
        wpd.resetBounds();
        wpd.setVisible(true);
        ArrayList<Integer> delRow = new ArrayList<Integer>();
        List rowLists = this.accessList.getListOfRowLists();
        Iterator it = rowLists.iterator();
        int count = 0;
        while (it.hasNext()) {
            List row = (List)it.next();
            if (row.get(4) == dialogObj) {
                delRow.add(new Integer(count));
            }
            ++count;
        }
        if (wpd.USER_RESPONSE == 10) {
            int size;
            for (int j = size = delRow.size(); j > 0; --j) {
                Integer i = (Integer)delRow.get(j - 1);
                this.accessList.removeRow(i);
            }
            List newRows = editAccessPage.getSurrogate();
            for (ArrayList newRow : newRows) {
                newRow.add(editAccessPage);
                this.accessList.addRow(newRow);
            }
        }
    }

    public void onLoadAction() {
    }

    public void onRewindAction() {
    }

    public boolean onAdvanceAction() {
        return true;
    }

    public OrderedMap getPageData() {
        return this.getPageData(this.xPathRoot);
    }

    public OrderedMap getPageData(String rootXPath) {
        List rowLists;
        this.returnMap.clear();
        int allowIndex = 1;
        int denyIndex = 1;
        Object nextRowObj2 = null;
        List nextRowList = null;
        Object nextUserObject = null;
        OrderedMap nextNVPMap = null;
        AccessPage nextAccessPage = null;
        if (this.publicReadAccess) {
            this.returnMap.put((Object)(rootXPath + "@authSystem"), (Object)this.AUTHSYSTEM_VALUE);
            this.returnMap.put((Object)(rootXPath + "@order"), (Object)this.ORDER_VALUE);
            this.returnMap.put((Object)(rootXPath + "allow[" + allowIndex + "]/principal"), (Object)"public");
            this.returnMap.put((Object)(rootXPath + "allow[" + allowIndex++ + "]/permission"), (Object)"read");
        }
        if ((rowLists = this.accessList.getListOfRowLists()) != null && rowLists.isEmpty()) {
            return this.returnMap;
        }
        if (!this.publicReadAccess) {
            this.returnMap.put((Object)(rootXPath + "@authSystem"), (Object)this.AUTHSYSTEM_VALUE);
            this.returnMap.put((Object)(rootXPath + "@order"), (Object)this.ORDER_VALUE);
        }
        Vector<Object> pagesProcessed = new Vector<Object>();
        for (Object nextRowObj2 : rowLists) {
            if (nextRowObj2 == null || (nextRowList = (List)nextRowObj2).size() < 5 || (nextUserObject = (Object)nextRowList.get(4)) == null || pagesProcessed.contains(nextUserObject)) continue;
            pagesProcessed.add(nextUserObject);
            nextAccessPage = (AccessPage)nextUserObject;
            nextNVPMap = nextAccessPage.accessIsAllow ? nextAccessPage.getPageData(rootXPath + "allow[" + allowIndex++ + "]") : nextAccessPage.getPageData(rootXPath + "deny[" + denyIndex++ + "]");
            this.returnMap.putAll((Map)nextNVPMap);
        }
        return this.returnMap;
    }

    public String getPageID() {
        return "ACCESS";
    }

    public String getTitle() {
        return "Access Information";
    }

    public String getSubtitle() {
        return " ";
    }

    public String getNextPageID() {
        return "SUMMARY";
    }

    public String getPageNumber() {
        return "14";
    }

    private void resetBlankData() {
        this.accessList.removeAllRows();
    }

    public boolean setPageData(OrderedMap map, String xPathRoot) {
        List newRows;
        boolean checkAccess;
        AccessPage nextStep;
        if (xPathRoot != null && xPathRoot.trim().length() > 0) {
            this.xPathRoot = xPathRoot;
        }
        if (map == null || map.isEmpty()) {
            this.resetBlankData();
            JPanel innerPanel = (JPanel)this.radioPanel.getComponent(1);
            JRadioButton allowReadAccess = (JRadioButton)innerPanel.getComponent(0);
            JRadioButton denyReadAccess = (JRadioButton)innerPanel.getComponent(1);
            allowReadAccess.setSelected(false);
            denyReadAccess.setSelected(true);
            this.publicReadAccess = false;
            return true;
        }
        ArrayList toDeleteList = new ArrayList();
        Iterator keyIt = map.keySet().iterator();
        Object nextXPathObj = null;
        String nextXPath = null;
        Object nextValObj = null;
        String nextVal = null;
        ArrayList accessAllowList = new ArrayList();
        ArrayList accessDenyList = new ArrayList();
        while (keyIt.hasNext()) {
            nextXPathObj = keyIt.next();
            if (nextXPathObj == null) continue;
            nextXPath = (String)nextXPathObj;
            nextValObj = map.get(nextXPathObj);
            nextVal = nextValObj == null ? "" : ((String)nextValObj).trim();
            Log.debug(45, "Access:  nextXPath = " + nextXPath + "\n nextVal   = " + nextVal);
            nextXPath = nextXPath.substring(nextXPath.lastIndexOf(this.xPathRoot) + this.xPathRoot.length());
            Log.debug(45, "Access: TRIMMED nextXPath   = " + nextXPath);
            if (nextXPath.startsWith("@authSystem")) {
                this.AUTHSYSTEM_VALUE = nextVal;
                toDeleteList.add(nextXPathObj);
                continue;
            }
            if (nextXPath.startsWith("@order")) {
                this.ORDER_VALUE = nextVal;
                toDeleteList.add(nextXPathObj);
                continue;
            }
            if (nextXPath.startsWith("allow[")) {
                Log.debug(45, ">>>>>>>>>> adding to accessAllowList: nextXPathObj=" + nextXPathObj + "; nextValObj=" + nextValObj);
                this.addToAccess(nextXPathObj, nextValObj, accessAllowList, "allow[");
                toDeleteList.add(nextXPathObj);
                continue;
            }
            if (nextXPath.startsWith("deny[")) {
                Log.debug(45, ">>>>>>>>>> adding to accessDenystepList: nextXPathObj=" + nextXPathObj + "; nextValObj=" + nextValObj);
                this.addToAccess(nextXPathObj, nextValObj, accessDenyList, "deny[");
                toDeleteList.add(nextXPathObj);
                continue;
            }
            if (!nextXPath.startsWith("@scope")) continue;
            toDeleteList.add(nextXPathObj);
        }
        Iterator dlIt = toDeleteList.iterator();
        while (dlIt.hasNext()) {
            map.remove(dlIt.next());
        }
        boolean returnVal = map.isEmpty();
        if (!returnVal) {
            Log.debug(20, "Access.setPageData returning FALSE! Map still contains:" + map);
            return false;
        }
        Iterator allowIt = accessAllowList.iterator();
        Iterator denyIt = accessDenyList.iterator();
        Object nextStepMapObj = null;
        OrderedMap nextStepMap = null;
        int accessPredicate = 1;
        this.accessList.removeAllRows();
        boolean accessAllowRetVal = true;
        boolean accessDenyRetVal = true;
        while (allowIt.hasNext()) {
            nextStepMapObj = allowIt.next();
            if (nextStepMapObj == null || (nextStepMap = (OrderedMap)nextStepMapObj).isEmpty() || nextStepMap == this.publicMap) continue;
            nextStep = (AccessPage)WizardPageLibrary.getPage("ACCESS_PAGE");
            checkAccess = nextStep.setPageData(nextStepMap, this.xPathRoot + "allow[" + accessPredicate++ + "]");
            if (!checkAccess) {
                accessAllowRetVal = false;
            }
            newRows = nextStep.getSurrogate();
            for (ArrayList newRow : newRows) {
                newRow.add(nextStep);
                this.accessList.addRow(newRow);
            }
        }
        while (denyIt.hasNext()) {
            nextStepMapObj = denyIt.next();
            if (nextStepMapObj == null || (nextStepMap = (OrderedMap)nextStepMapObj).isEmpty() || nextStepMap == this.publicMap) continue;
            nextStep = (AccessPage)WizardPageLibrary.getPage("ACCESS_PAGE");
            checkAccess = nextStep.setPageData(nextStepMap, this.xPathRoot + "deny[" + accessPredicate++ + "]/");
            if (!checkAccess) {
                accessDenyRetVal = false;
            }
            newRows = nextStep.getSurrogate();
            for (ArrayList newRow : newRows) {
                newRow.add(nextStep);
                this.accessList.addRow(newRow);
            }
        }
        if (!accessAllowRetVal || !accessDenyRetVal) {
            Log.debug(20, "Access.setPageData - Access sub-class returned FALSE");
        }
        if (this.publicMap != null) {
            Iterator pmIt = this.publicMap.keySet().iterator();
            boolean invalidSizeError = false;
            boolean hasRead = false;
            boolean hasPublic = false;
            if (this.publicMap.size() != 2) {
                invalidSizeError = true;
            }
            while (pmIt.hasNext() && !invalidSizeError) {
                nextXPathObj = pmIt.next();
                if (nextXPathObj == null) continue;
                nextXPath = (String)nextXPathObj;
                nextValObj = this.publicMap.get(nextXPathObj);
                String string = nextVal = nextValObj == null ? "" : ((String)nextValObj).trim();
                if (nextVal.compareTo("read") == 0) {
                    hasRead = true;
                    JPanel innerPanel = (JPanel)this.radioPanel.getComponent(1);
                    JRadioButton allowReadAccess = (JRadioButton)innerPanel.getComponent(0);
                    JRadioButton denyReadAccess = (JRadioButton)innerPanel.getComponent(1);
                    if (nextXPath.indexOf("allow") > -1) {
                        allowReadAccess.setSelected(true);
                        denyReadAccess.setSelected(false);
                        continue;
                    }
                    allowReadAccess.setSelected(false);
                    denyReadAccess.setSelected(true);
                    continue;
                }
                if (nextVal.compareTo("public") != 0) continue;
                hasPublic = true;
            }
            if (invalidSizeError && !hasRead && !hasPublic) {
                Log.debug(20, "Access.setPageData returning FALSE! Map contains invalid public access:" + this.publicMap);
            }
        } else {
            JPanel innerPanel = (JPanel)this.radioPanel.getComponent(1);
            JRadioButton allowReadAccess = (JRadioButton)innerPanel.getComponent(0);
            JRadioButton denyReadAccess = (JRadioButton)innerPanel.getComponent(1);
            allowReadAccess.setSelected(false);
            denyReadAccess.setSelected(true);
            this.publicReadAccess = false;
        }
        return returnVal && accessAllowRetVal && accessDenyRetVal;
    }

    private void addToAccess(Object nextPersonnelXPathObj, Object nextPersonnelVal, List accessstepList, String xPath) {
        if (nextPersonnelXPathObj == null) {
            return;
        }
        String nextPersonnelXPath = (String)nextPersonnelXPathObj;
        int predicate = this.getFirstPredicate(nextPersonnelXPath, xPath);
        if (predicate >= accessstepList.size()) {
            for (int i = accessstepList.size(); i <= predicate; ++i) {
                accessstepList.add(new OrderedMap());
            }
        }
        if (predicate < accessstepList.size()) {
            Object nextMapObj = accessstepList.get(predicate);
            OrderedMap nextMap = (OrderedMap)nextMapObj;
            nextMap.put(nextPersonnelXPathObj, nextPersonnelVal);
            if (((String)nextPersonnelVal).compareTo("public") == 0) {
                this.publicMap = nextMap;
            }
        } else {
            Log.debug(15, "**** ERROR - Access.addToAccess() - predicate > accessstepList.size()");
        }
    }

    private int getFirstPredicate(String xpath, String firstSegment) {
        String tempXPath = xpath.substring(xpath.indexOf(firstSegment) + firstSegment.length());
        return Integer.parseInt(tempXPath.substring(0, tempXPath.indexOf("]")));
    }
}

