/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.framework;

import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.util.UISettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class ModalDialog
extends JDialog {
    public short USER_RESPONSE;
    public static final short OK_OPTION = 10;
    public static final short CANCEL_OPTION = 20;
    public static final short CLOSED_OPTION = 30;
    private final int PADDING = 5;
    protected AbstractUIPage wizardPage;
    private int dialogWidth;
    private int dialogHeight;
    private Frame parent;
    private Container contentPane;
    protected JPanel middlePanel;
    private JPanel bottomPanel;
    private JButton okButton;

    public ModalDialog(AbstractUIPage page, Frame parent, int width, int height) {
        this(page, parent, width, height, true);
    }

    public ModalDialog(AbstractUIPage page, Frame parent, int width, int height, boolean showNow) {
        super(parent, true);
        this.parent = parent;
        this.wizardPage = page;
        this.dialogWidth = width;
        this.dialogHeight = height;
        this.init();
        this.setVisible(showNow);
        this.validate();
    }

    private void init() {
        this.resetBounds();
        this.initContentPane();
        this.initTopPanel();
        this.initMiddlePanel();
        this.initBottomPanel();
        this.initButtons();
        this.wizardPage.onLoadAction();
    }

    public boolean onAdvanceAction() {
        if (this.wizardPage == null) {
            return false;
        }
        return this.wizardPage.onAdvanceAction();
    }

    public void resetBounds() {
        int xcoord;
        int ycoord;
        if (this.parent == null) {
            ycoord = 50;
            xcoord = 50;
        } else {
            xcoord = this.parent.getX() + this.parent.getWidth() / 2 - this.dialogWidth / 2;
            ycoord = this.parent.getY() + this.parent.getHeight() / 2 - this.dialogHeight / 2;
        }
        this.setBounds(xcoord, ycoord, this.dialogWidth, this.dialogHeight);
    }

    private void initContentPane() {
        this.contentPane = this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
    }

    private void initTopPanel() {
        this.contentPane.add(Box.createRigidArea(new Dimension(15, 15)), "North");
    }

    private void initMiddlePanel() {
        this.middlePanel = new JPanel();
        this.middlePanel.setLayout(new BorderLayout());
        if (this.wizardPage != null) {
            this.middlePanel.add((Component)this.wizardPage, "Center");
        }
        this.contentPane.add((Component)this.wizardPage, "Center");
        this.wizardPage.validate();
        this.validate();
    }

    private void initBottomPanel() {
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new BoxLayout(this.bottomPanel, 0));
        this.bottomPanel.add(Box.createHorizontalGlue());
        this.bottomPanel.setOpaque(false);
        this.bottomPanel.setBorder(BorderFactory.createMatteBorder(2, 0, 0, 0, UISettings.TITLEBAR_COLOR));
        this.contentPane.add((Component)this.bottomPanel, "South");
    }

    private void initButtons() {
        this.okButton = this.addButton("OK", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ModalDialog.this.okAction();
            }
        });
        this.addButton("Cancel", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ModalDialog.this.cancelAction();
            }
        });
        this.getRootPane().setDefaultButton(this.okButton);
    }

    private JButton addButton(String title, ActionListener actionListener) {
        JButton button = new JButton(title);
        button.setForeground(UISettings.POPUPDIALOG_BUTTON_TEXT_COLOR);
        button.setFont(UISettings.POPUPDIALOG_BUTTON_FONT);
        if (actionListener != null) {
            button.addActionListener(actionListener);
        }
        this.bottomPanel.add(button);
        this.bottomPanel.add(Box.createHorizontalStrut(5));
        return button;
    }

    private void okAction() {
        if (this.onAdvanceAction()) {
            this.setVisible(false);
        }
        if (this.parent != null) {
            this.parent.toFront();
        }
        this.USER_RESPONSE = (short)10;
    }

    private void cancelAction() {
        this.setVisible(false);
        if (this.parent != null) {
            this.parent.toFront();
        }
        this.USER_RESPONSE = (short)20;
    }
}

