/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.framework;

import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.morpho.util.UISettings;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;

public class HelpCommand
implements Command {
    private HelpSet mainHS = null;
    private HelpBroker mainHB = null;
    private ActionListener helpListener = null;
    static final String helpsetName = "morpho";
    private String id = null;
    private String errorMessage = null;
    private int helpWidth = 800;
    private int helpHeight = 520;
    private Dimension size = new Dimension(this.helpWidth, this.helpHeight);
    private int helpCenterX = HelpCommand.caculateCenterX(0.0, UISettings.CLIENT_SCREEN_WIDTH, this.helpWidth);
    private int helpCenterY = HelpCommand.caculateCenterY(0.0, UISettings.CLIENT_SCREEN_HEIGHT, this.helpHeight);
    private Point location = new Point(this.helpCenterX, this.helpCenterY);

    public HelpCommand() {
        try {
            ClassLoader cl = HelpCommand.class.getClassLoader();
            URL url = HelpSet.findHelpSet((ClassLoader)cl, (String)helpsetName);
            this.mainHS = new HelpSet(cl, url);
        }
        catch (Exception ee) {
            this.errorMessage = "Help Set morpho not found!";
            Log.debug(30, this.errorMessage);
            return;
        }
        catch (ExceptionInInitializerError ex) {
            Log.debug(30, "initialization error:");
            ex.getException().printStackTrace();
        }
        this.mainHB = this.mainHS.createHelpBroker();
        this.mainHB.setSize(this.size);
        this.mainHB.setLocation(this.location);
        this.helpListener = new CSH.DisplayHelpFromSource(this.mainHB);
    }

    public HelpCommand(String id) {
        this();
        this.id = id;
    }

    public void execute(ActionEvent event) {
        if (this.helpListener != null) {
            MorphoFrame parent = UIController.getInstance().getCurrentActiveWindow();
            if (parent != null) {
                int parentWidth = parent.getWidth();
                int parentHeight = parent.getHeight();
                double parentX = parent.getLocation().getX();
                double parentY = parent.getLocation().getY();
                this.helpCenterX = HelpCommand.caculateCenterX(parentX, parentWidth, this.helpWidth);
                this.helpCenterY = HelpCommand.caculateCenterY(parentY, parentHeight, this.helpHeight);
                this.location.setLocation(this.helpCenterX, this.helpCenterY);
                this.mainHB.setLocation(this.location);
                if (this.id != null) {
                    this.mainHB.setCurrentID(this.id);
                }
            }
            this.helpListener.actionPerformed(event);
        } else {
            Log.debug(5, this.errorMessage);
        }
    }

    public static int caculateCenterX(double parentX, int parentWidth, int childWidth) {
        double parentCenterX = parentX + 0.5 * (double)parentWidth;
        int childCenterX = new Double(parentCenterX - 0.5 * (double)childWidth).intValue();
        return childCenterX;
    }

    public static int caculateCenterY(double parentY, int parentHeight, int childHeight) {
        double parentCenterY = parentY + 0.5 * (double)parentHeight;
        int childCenterY = new Double(parentCenterY - 0.5 * (double)childHeight).intValue();
        return childCenterY;
    }
}

