/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.datapackage.AccessionNumber;
import edu.ucsb.nceas.morpho.datapackage.AddDocumentationCommand;
import edu.ucsb.nceas.morpho.datapackage.DeleteColumnCommand;
import edu.ucsb.nceas.morpho.datapackage.DeleteRowCommand;
import edu.ucsb.nceas.morpho.datapackage.DeleteTableCommand;
import edu.ucsb.nceas.morpho.datapackage.DelimiterField;
import edu.ucsb.nceas.morpho.datapackage.EditColumnMetaDataCommand;
import edu.ucsb.nceas.morpho.datapackage.ImportDataCommand;
import edu.ucsb.nceas.morpho.datapackage.InsertColumnCommand;
import edu.ucsb.nceas.morpho.datapackage.InsertRowCommand;
import edu.ucsb.nceas.morpho.datapackage.PackageUtil;
import edu.ucsb.nceas.morpho.datapackage.PersistentTableModel;
import edu.ucsb.nceas.morpho.datapackage.PersistentVector;
import edu.ucsb.nceas.morpho.datapackage.SortDataTableCommand;
import edu.ucsb.nceas.morpho.datapackage.TableCopyCommand;
import edu.ucsb.nceas.morpho.datapackage.TableCutCommand;
import edu.ucsb.nceas.morpho.datapackage.TablePasteCommand;
import edu.ucsb.nceas.morpho.framework.ConfigXML;
import edu.ucsb.nceas.morpho.framework.DataPackageInterface;
import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceProvider;
import edu.ucsb.nceas.morpho.util.GUIAction;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.morpho.util.StateChangeEvent;
import edu.ucsb.nceas.morpho.util.StateChangeMonitor;
import edu.ucsb.nceas.morpho.util.StoreStateChangeEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.EventObject;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DataViewer
extends JPanel
implements StoreStateChangeEvent {
    private JPopupMenu popup;
    private JMenuItem addDocumentation = null;
    private GUIAction addDocumentationAction = null;
    private JMenuItem createNewDatatable = null;
    private GUIAction createNewDatatableAction = null;
    private JMenuItem deleteDatatable = null;
    private GUIAction deleteDatatableAction = null;
    private JMenuItem sortBySelectedColumn = null;
    private GUIAction sortAction = null;
    private JMenuItem insertRowAfter = null;
    private GUIAction insertRowAfterAction = null;
    private JMenuItem insertRowBefore = null;
    private GUIAction insertRowBeforeAction = null;
    private JMenuItem deleteRow = null;
    private GUIAction deleteRowAction = null;
    private JMenuItem insertColumnBefore = null;
    private GUIAction insertColumnBeforeAction = null;
    private JMenuItem insertColumnAfter = null;
    private GUIAction insertColumnAfterAction = null;
    private JMenuItem deleteColumn = null;
    private GUIAction deleteColumnAction = null;
    private JMenuItem editColumnMetadata = null;
    private GUIAction editColumnMetadataAction = null;
    File dataFile = null;
    String dataFileId = null;
    File entityFile = null;
    File attributeFile = null;
    File physicalFile = null;
    String entityFileId = null;
    String format = "";
    boolean ignoreConsecutiveDelimiters = false;
    String field_delimiter = "";
    int num_records;
    String delimiter_string = "";
    String numHeaderLines = "0";
    int num_header_lines = 0;
    int num_columns;
    Vector column_labels;
    int nlines;
    int nlines_max = 100000;
    String[] lines;
    Vector vec;
    AbstractDataPackage adp = null;
    int entityIndex = -1;
    String entityName = "";
    String entityDescription = "";
    private Vector storedStateChangeEventlist = new Vector();
    boolean missing_metadata_flag = false;
    private String currentURLInfo = null;
    JPanel DataViewerPanel = new JPanel();
    JPanel TablePanel = new JPanel();
    JScrollPane DataScrollPanel = new JScrollPane();
    JPanel ControlPanel = new JPanel();
    JPanel HeaderPanel = new JPanel();
    JLabel headerLabel;
    JPanel ButtonControlPanel = new JPanel();
    JLabel DataIDLabel = new JLabel();
    JButton CancelButton = new JButton();
    JButton UpdateButton = new JButton();
    JPanel controlPanel;
    JButton controlOK;
    JButton controlCancel;
    JDialog columnDialog;
    PersistentVector pv;
    PersistentTableModel ptm;
    JTable table;
    int sortdirection = 1;
    boolean columnAddFlag = true;
    Document attributeDoc;
    Morpho morpho;
    ConfigXML config;
    String datadir;
    String separator;
    String cachedir;
    String tempdir;
    String dataString = "";
    String dataID = "";
    DataViewer thisRef;
    private boolean showDataView = true;
    boolean text_flag = false;

    public DataViewer() {
        this.setLayout(new BorderLayout(0, 0));
        this.setVisible(false);
        this.DataViewerPanel.setLayout(new BorderLayout(0, 0));
        this.TablePanel.setLayout(new BorderLayout(0, 0));
        this.DataViewerPanel.add("Center", this.TablePanel);
        this.TablePanel.add("Center", this.DataScrollPanel);
        this.ControlPanel.setLayout(new BorderLayout(0, 0));
        this.DataViewerPanel.add("South", this.ControlPanel);
        this.ButtonControlPanel.setLayout(new FlowLayout(2, 5, 5));
        this.DataIDLabel.setText("Data ID: ");
        this.DataIDLabel.setNextFocusableComponent(this.CancelButton);
        this.ButtonControlPanel.add(this.DataIDLabel);
        this.CancelButton.setText("Revert");
        this.CancelButton.setActionCommand("Revert");
        String canceltext = "Removes all changes since last Update";
        this.CancelButton.setToolTipText(canceltext);
        this.ButtonControlPanel.add(this.CancelButton);
        this.UpdateButton.setText("Update");
        this.UpdateButton.setActionCommand("Update");
        String updatetext = "Saves all data changes to new version of the Data Package";
        this.UpdateButton.setToolTipText(updatetext);
        this.ButtonControlPanel.add(this.UpdateButton);
        this.headerLabel = new JLabel("DataTitle");
        this.headerLabel.setForeground(Color.white);
        this.HeaderPanel.setBackground(Color.gray);
        this.HeaderPanel.add(this.headerLabel);
        this.DataViewerPanel.add("North", this.HeaderPanel);
        this.thisRef = this;
        SymAction lSymAction = new SymAction();
        this.CancelButton.addActionListener(lSymAction);
        this.UpdateButton.addActionListener(lSymAction);
        this.popup = new JPopupMenu();
        this.addDocumentationAction = new GUIAction("Add Documentation...", null, new AddDocumentationCommand());
        this.addDocumentation = new JMenuItem(this.addDocumentationAction);
        this.popup.add(this.addDocumentation);
        this.createNewDatatableAction = new GUIAction("Create/Import New Data Table...", null, new ImportDataCommand());
        this.createNewDatatable = new JMenuItem(this.createNewDatatableAction);
        this.popup.add(this.createNewDatatable);
        this.deleteDatatableAction = new GUIAction("Delete Current Data Table", null, new DeleteTableCommand());
        this.deleteDatatable = new JMenuItem(this.deleteDatatableAction);
        this.popup.add(this.deleteDatatable);
        this.popup.add(new JSeparator());
        this.sortAction = new GUIAction("Sort by Selected Column", null, new SortDataTableCommand());
        this.sortBySelectedColumn = new JMenuItem(this.sortAction);
        this.popup.add(this.sortBySelectedColumn);
        this.popup.add(new JSeparator());
        this.insertRowAfterAction = new GUIAction("Insert Row After Selection", null, new InsertRowCommand("after"));
        this.insertRowAfter = new JMenuItem(this.insertRowAfterAction);
        this.popup.add(this.insertRowAfter);
        this.insertRowBeforeAction = new GUIAction("Insert Row Before Selection", null, new InsertRowCommand("before"));
        this.insertRowBefore = new JMenuItem(this.insertRowBeforeAction);
        this.popup.add(this.insertRowBefore);
        this.deleteRowAction = new GUIAction("Delete Selected Row", null, new DeleteRowCommand());
        this.deleteRow = new JMenuItem(this.deleteRowAction);
        this.popup.add(this.deleteRow);
        this.popup.add(new JSeparator());
        this.insertColumnAfterAction = new GUIAction("Insert Column After Selection", null, new InsertColumnCommand("after"));
        this.insertColumnAfter = new JMenuItem(this.insertColumnAfterAction);
        this.popup.add(this.insertColumnAfter);
        this.insertColumnBeforeAction = new GUIAction("Insert Column Before Selection", null, new InsertColumnCommand("before"));
        this.insertColumnBefore = new JMenuItem(this.insertColumnBeforeAction);
        this.popup.add(this.insertColumnBefore);
        this.deleteColumnAction = new GUIAction("Delete Selected Column", null, new DeleteColumnCommand());
        this.deleteColumn = new JMenuItem(this.deleteColumnAction);
        this.popup.add(this.deleteColumn);
        this.popup.add(new JSeparator());
        this.editColumnMetadataAction = new GUIAction("Edit Column Documentation", null, new EditColumnMetaDataCommand());
        this.editColumnMetadata = new JMenuItem(this.editColumnMetadataAction);
        this.popup.add(this.editColumnMetadata);
    }

    public DataViewer(Morpho morpho, String sTitle) {
        this();
        this.morpho = morpho;
        this.config = morpho.getConfiguration();
        ConfigXML profile = morpho.getProfile();
        DataViewer dataViewer = this;
        String profileDirName = dataViewer.config.getConfigDirectory() + File.separator + this.config.get("profile_directory", 0) + File.separator + profile.get("profilename", 0);
        this.datadir = profileDirName + File.separator + profile.get("datadir", 0);
        this.tempdir = profileDirName + File.separator + profile.get("tempdir", 0);
        this.cachedir = profileDirName + File.separator + profile.get("cachedir", 0);
        this.separator = profile.get("separator", 0);
        this.separator = this.separator.trim();
    }

    public DataViewer(String sTitle, String dataID, String dataString) {
        this();
        this.dataID = dataID;
        this.dataString = dataString;
    }

    public DataViewer(Morpho morpho, String sTitle, File dataFile) {
        this();
        this.morpho = morpho;
        this.config = morpho.getConfiguration();
        ConfigXML profile = morpho.getProfile();
        DataViewer dataViewer = this;
        String profileDirName = dataViewer.config.getConfigDirectory() + File.separator + this.config.get("profile_directory", 0) + File.separator + profile.get("profilename", 0);
        this.datadir = profileDirName + File.separator + profile.get("datadir", 0);
        this.tempdir = profileDirName + File.separator + profile.get("tempdir", 0);
        this.cachedir = profileDirName + File.separator + profile.get("cachedir", 0);
        this.separator = profile.get("separator", 0);
        this.separator = this.separator.trim();
        this.dataFile = dataFile;
    }

    public void setCurrentURLInfo(String curURL) {
        this.currentURLInfo = curURL;
    }

    public void setDataFile(File file) {
        this.dataFile = file;
    }

    public void setDataFileId(String dfid) {
        this.dataFileId = dfid;
    }

    public PersistentVector getPV() {
        return this.pv;
    }

    public void setPV(PersistentVector vector) {
        this.pv = vector;
    }

    public boolean getShowDataView() {
        return this.showDataView;
    }

    public JTable getDataTable() {
        return this.table;
    }

    public Document getAttributeDoc() {
        return this.attributeDoc;
    }

    public Vector getColumnLabels() {
        return this.column_labels;
    }

    public void setColumnLabels(Vector collabels) {
        this.column_labels = collabels;
    }

    public String getFieldDelimiter() {
        return this.delimiter_string;
    }

    public JPanel getTablePanel() {
        return this.TablePanel;
    }

    public JPanel getDataViewerPanel() {
        return this.DataViewerPanel;
    }

    public PersistentTableModel getPersistentTableModel() {
        return this.ptm;
    }

    public Morpho getMorpho() {
        return this.morpho;
    }

    public String getEntityFileId() {
        return this.entityFileId;
    }

    public boolean getDataChangedFlag() {
        boolean ret = false;
        if (this.ptm != null) {
            ret = this.ptm.getChangeFlag();
        }
        return ret;
    }

    public void setDataChangedFlag(boolean changedFlag) {
        if (this.ptm != null) {
            this.ptm.setChangeFlag(changedFlag);
        }
    }

    public int getSortDirection() {
        return this.sortdirection;
    }

    public void setSortDirection(int direction) {
        this.sortdirection = direction;
    }

    public boolean getTextFlag() {
        return this.text_flag;
    }

    public void setEntityIndex(int indx) {
        this.entityIndex = indx;
    }

    public int getEntityIndex() {
        return this.entityIndex;
    }

    public void init() {
        Node[] attributeArray;
        this.missing_metadata_flag = false;
        if (this.entityIndex == -1) {
            Log.debug(1, "Entity index has not been set!");
            return;
        }
        Node[] physicalArray = this.adp.getPhysicalArray(this.entityIndex);
        if (physicalArray.length == 0) {
            Log.debug(15, "Physical information about the data is missing!");
            this.missing_metadata_flag = true;
        } else {
            this.format = this.adp.getPhysicalFormat(this.entityIndex, 0);
            if (this.format.trim().length() < 1) {
                this.missing_metadata_flag = true;
            }
            Log.debug(20, "format: " + this.format);
            this.field_delimiter = this.adp.getPhysicalFieldDelimiter(this.entityIndex, 0);
            this.ignoreConsecutiveDelimiters = this.adp.ignoreConsecutiveDelimiters(this.entityIndex, 0);
            this.delimiter_string = this.getDelimiterString();
            Log.debug(20, "delimiter_string: " + this.delimiter_string);
            String nhl = this.adp.getPhysicalNumberHeaderLines(this.entityIndex, 0);
            this.numHeaderLines = nhl.length() > 0 ? nhl : "0";
            Log.debug(20, "numHeaderLines: " + this.numHeaderLines);
        }
        String s = this.adp.getEntityNumRecords(this.entityIndex);
        if (s != null && s.length() > 0) {
            try {
                this.num_records = new Integer(s.trim());
            }
            catch (Exception w) {
                Log.debug(20, "error converting to integer");
            }
        }
        this.entityName = this.adp.getEntityName(this.entityIndex).trim();
        this.entityDescription = this.adp.getEntityDescription(this.entityIndex).trim();
        if (this.entityName.length() > 0) {
            this.headerLabel.setText(this.entityName);
        }
        if (this.entityDescription.length() > 0) {
            this.headerLabel.setText(this.entityDescription);
        }
        if ((attributeArray = this.adp.getAttributeArray(this.entityIndex)) == null || attributeArray.length == 0) {
            Log.debug(15, "Attribute information about the data is missing!");
            this.missing_metadata_flag = true;
        } else {
            this.column_labels = new Vector();
            for (int i = 0; i < attributeArray.length; ++i) {
                String unitString = "";
                String dataTypeString = "";
                String temp = this.adp.getAttributeName(this.entityIndex, i);
                dataTypeString = this.adp.getAttributeDataType(this.entityIndex, i);
                unitString = this.adp.getAttributeUnit(this.entityIndex, i);
                temp = "<html><font face=\"Courier\"> <center><small><nobr>" + dataTypeString + "</nobr><br><nobr>" + unitString + "</nobr><br></small><b><nobr>" + temp + "</nobr></b></center></font></html>";
                this.column_labels.addElement(temp);
            }
        }
        if (this.missing_metadata_flag) {
            Log.debug(30, "attempting to display as text");
            this.buildTextDisplay();
        } else {
            if (this.format.indexOf("text") > -1) {
                this.text_flag = true;
            } else if (this.format.indexOf("Text") > -1) {
                this.text_flag = true;
            } else if (this.format.indexOf("asci") > -1) {
                this.text_flag = true;
            } else if (this.format.indexOf("Asci") > -1) {
                this.text_flag = true;
            } else if (this.format.indexOf("ASCI") > -1) {
                this.text_flag = true;
            } else if (this.format.trim().length() < 1) {
                Log.debug(1, "Format string in physical module is empty!");
            }
            boolean image_flag = false;
            if (this.format.indexOf("image") > -1) {
                image_flag = true;
            } else if (this.format.indexOf("Image") > -1) {
                image_flag = true;
            } else if (this.format.indexOf("IMAGE") > -1) {
                image_flag = true;
            } else if (this.format.indexOf("gif") > -1) {
                image_flag = true;
            } else if (this.format.indexOf("GIF") > -1) {
                image_flag = true;
            } else if (this.format.indexOf("jpeg") > -1) {
                image_flag = true;
            } else if (this.format.indexOf("JPEG") > -1) {
                image_flag = true;
            } else if (this.format.indexOf("jpg") > -1) {
                image_flag = true;
            } else if (this.format.indexOf("JPG") > -1) {
                image_flag = true;
            }
            if (image_flag) {
                String filename = this.dataFile.getPath();
                Log.debug(30, "trying to display image! " + filename);
                ImageIcon icon = new ImageIcon(filename);
                JLabel imagelabel = new JLabel(icon);
                this.DataScrollPanel.getViewport().removeAll();
                this.DataScrollPanel.getViewport().add(imagelabel);
                this.storingStateChangeEvent(new StateChangeEvent(this.DataViewerPanel, StateChangeEvent.CREATE_NONEDITABLE_ENTITY_DATAPACKAGE_FRAME));
            } else if (this.text_flag && this.dataFile != null) {
                if (this.column_labels != null && this.column_labels.size() > 0) {
                    if (this.field_delimiter.trim().length() > 0 && this.dataFile.length() > 0L) {
                        this.buildTable();
                        this.storingStateChangeEvent(new StateChangeEvent(this.DataViewerPanel, StateChangeEvent.CREATE_EDITABLE_ENTITY_DATAPACKAGE_FRAME));
                    } else if (this.dataFile == null || this.dataFile.length() < 1L) {
                        this.numHeaderLines = "0";
                        this.buildTable();
                        this.storingStateChangeEvent(new StateChangeEvent(this.DataViewerPanel, StateChangeEvent.CREATE_EDITABLE_ENTITY_DATAPACKAGE_FRAME));
                    } else {
                        this.buildTextDisplay();
                        this.storingStateChangeEvent(new StateChangeEvent(this.DataViewerPanel, StateChangeEvent.CREATE_NONEDITABLE_ENTITY_DATAPACKAGE_FRAME));
                    }
                }
            } else {
                String msg = "Unable to display this data.\nHowever, an empty table with the column header information will be shown.";
                if (this.currentURLInfo != null && this.currentURLInfo.length() > 0) {
                    msg = msg + "\nData is referenced by the URL \n" + this.currentURLInfo;
                }
                Log.debug(9, msg);
                this.showDataView = false;
                this.dataFile = null;
                this.buildTable();
                this.table.setBackground(this.table.getParent().getBackground());
                this.table.setEnabled(false);
                this.storingStateChangeEvent(new StateChangeEvent(this.DataViewerPanel, StateChangeEvent.CREATE_NONEDITABLE_ENTITY_DATAPACKAGE_FRAME));
            }
        }
    }

    public void setAbstractDataPackage(AbstractDataPackage adp) {
        this.adp = adp;
    }

    public AbstractDataPackage getAbstractDataPackage() {
        return this.adp;
    }

    public void setAttributeFile(File attr) {
        this.attributeFile = attr;
    }

    public void setEntityFile(File ent) {
        this.entityFile = ent;
    }

    public void setEntityFileId(String id) {
        this.entityFileId = id;
    }

    public void setPhysicalFile(File phys) {
        this.physicalFile = phys;
    }

    public void setDataID(String dataID) {
        this.dataID = dataID;
        this.DataIDLabel.setText("DataFile: " + dataID);
    }

    public void getEntityInfo() {
        if (this.entityFile == null) {
            Log.debug(15, "Entity information about the data is missing!");
            this.missing_metadata_flag = true;
        } else {
            String s;
            String s2;
            String s3;
            Vector<String> numRecordsPath = new Vector<String>();
            numRecordsPath.addElement("table-entity/numberOfRecords");
            NodeList numRecordsList = PackageUtil.getPathContent(this.entityFile, numRecordsPath, this.morpho);
            if (numRecordsList != null && numRecordsList.getLength() != 0 && (s3 = numRecordsList.item(0).getFirstChild().getNodeValue()) != null && s3.length() > 0) {
                try {
                    this.num_records = new Integer(s3.trim());
                }
                catch (Exception w) {
                    // empty catch block
                }
            }
            Vector<String> entityNamesPath = new Vector<String>();
            entityNamesPath.addElement("table-entity/entityName");
            NodeList entityNamesList = PackageUtil.getPathContent(this.entityFile, entityNamesPath, this.morpho);
            if (entityNamesList != null && entityNamesList.getLength() != 0 && (s2 = entityNamesList.item(0).getFirstChild().getNodeValue()) != null && s2.length() > 0) {
                try {
                    this.entityName = s2.trim();
                }
                catch (Exception w) {
                    // empty catch block
                }
            }
            Vector<String> entityDescriptionPath = new Vector<String>();
            entityDescriptionPath.addElement("table-entity/entityDescription");
            NodeList entityDescriptionList = PackageUtil.getPathContent(this.entityFile, entityDescriptionPath, this.morpho);
            if (entityDescriptionList != null && entityDescriptionList.getLength() != 0 && (s = entityDescriptionList.item(0).getFirstChild().getNodeValue()) != null && s.length() > 0) {
                try {
                    this.entityDescription = s.trim();
                }
                catch (Exception w) {
                    // empty catch block
                }
            }
            if (this.entityName.length() > 0) {
                this.headerLabel.setText(this.entityName);
            }
            if (this.entityDescription.length() > 0) {
                this.headerLabel.setText(this.entityDescription);
            }
        }
    }

    public static void main(String[] args) {
        new DataViewer().setVisible(true);
    }

    private Vector getColumnValues(String str) {
        String sDelim = this.getDelimiterString();
        String oldToken = "";
        String token = "";
        Vector<String> res = new Vector<String>();
        boolean ignoreConsequtiveDelimiters = false;
        if (ignoreConsequtiveDelimiters) {
            StringTokenizer st = new StringTokenizer(str, sDelim, false);
            while (st.hasMoreTokens()) {
                token = st.nextToken().trim();
                res.addElement(token);
            }
        } else {
            StringTokenizer st = new StringTokenizer(str, sDelim, true);
            while (st.hasMoreTokens()) {
                token = st.nextToken().trim();
                if (!this.inDelimiterList(token, sDelim)) {
                    res.addElement(token);
                } else if (this.inDelimiterList(oldToken, sDelim) && this.inDelimiterList(token, sDelim)) {
                    res.addElement("");
                }
                oldToken = token;
            }
        }
        return res;
    }

    private boolean inDelimiterList(String token, String delim) {
        boolean result = false;
        int test = delim.indexOf(token);
        result = test > -1;
        return result;
    }

    private String getDelimiterString() {
        String str = "";
        String temp = this.field_delimiter.trim();
        if (temp.startsWith("#x")) {
            if ((temp = temp.substring(2)).equals("0A")) {
                str = "\n";
            }
            if (temp.equals("09")) {
                str = "\t";
            }
            if (temp.equals("20")) {
                str = " ";
            }
        } else {
            str = temp;
        }
        this.delimiter_string = str;
        return str;
    }

    public void parseFile() {
        String temp;
        if (this.dataFile == null) {
            return;
        }
        File f = this.dataFile;
        try {
            BufferedReader in = new BufferedReader(new FileReader(f));
            this.nlines = 0;
            try {
                while ((temp = in.readLine()) != null && this.nlines < this.nlines_max) {
                    if (temp.length() <= 0) continue;
                    ++this.nlines;
                }
                in.close();
            }
            catch (Exception e) {}
        }
        catch (Exception w) {
            // empty catch block
        }
        this.lines = new String[this.nlines];
        try {
            BufferedReader in1 = new BufferedReader(new FileReader(f));
            try {
                for (int i = 0; i < this.nlines; ++i) {
                    temp = in1.readLine();
                    while (temp.length() == 0) {
                        temp = in1.readLine();
                    }
                    this.lines[i] = temp + "\n";
                }
                in1.close();
            }
            catch (Exception e) {}
        }
        catch (Exception w1) {
            // empty catch block
        }
    }

    private void buildTextDisplay() {
        JTextArea ta = new JTextArea();
        ta.setEditable(false);
        this.parseFile();
        for (int i = 0; i < this.nlines; ++i) {
            ta.append(this.lines[i] + "\n");
        }
        ta.setCaretPosition(0);
        this.DataScrollPanel.getViewport().removeAll();
        this.DataScrollPanel.getViewport().add(ta);
    }

    private void buildTable() {
        this.num_header_lines = 0;
        Integer temp = new Integer(this.numHeaderLines);
        if (temp != null) {
            this.num_header_lines = temp;
        }
        this.vec = new Vector();
        this.table = new JTable();
        this.pv = new PersistentVector();
        this.pv.setFieldDelimiter(this.field_delimiter);
        this.pv.setFirstRow(this.num_header_lines);
        this.pv.setIgnoreConsecutiveDelimiters(this.ignoreConsecutiveDelimiters);
        if (this.dataFile == null || this.dataFile.length() < 1L) {
            Log.debug(20, "Null Data File");
            this.field_delimiter = ",";
            String[] row = new String[this.column_labels.size()];
            for (int ii = 0; ii < this.column_labels.size(); ++ii) {
                row[ii] = "";
            }
            this.pv.initEmpty(row, 10);
            this.pv.setFieldDelimiter(this.field_delimiter);
        } else {
            this.pv.init(this.dataFile, this.num_header_lines);
        }
        this.ptm = new PersistentTableModel(this.pv, this.column_labels);
        this.ptm.setFieldDelimiter(this.field_delimiter);
        UIManager.put("Table.focusCellBackground", new Color(0, 0, 150));
        UIManager.put("Table.focusCellForeground", Color.white);
        this.table.setModel(this.ptm);
        this.table.setColumnSelectionAllowed(true);
        this.table.setRowSelectionAllowed(true);
        this.table.setSelectionMode(2);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setAutoResizeMode(0);
        this.table.registerKeyboardAction(new GUIAction("Copy", null, new TableCopyCommand()), KeyStroke.getKeyStroke("ctrl C"), 0);
        this.table.registerKeyboardAction(new GUIAction("Paste", null, new TablePasteCommand()), KeyStroke.getKeyStroke("ctrl V"), 0);
        this.table.registerKeyboardAction(new GUIAction("Cut", null, new TableCutCommand()), KeyStroke.getKeyStroke("ctrl X"), 0);
        this.DataScrollPanel.getViewport().removeAll();
        this.DataScrollPanel.getViewport().add(this.table);
        JTableHeader header = this.table.getTableHeader();
        header.addMouseListener(new HeaderMouseListener());
        PopupListener popupListener = new PopupListener();
        this.table.addMouseListener(popupListener);
        if (this.table.getRowCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
            this.table.setColumnSelectionInterval(0, 0);
        }
        this.setUpDelimiterEditor(this.table, this.field_delimiter, this.TablePanel);
    }

    private void setUpDelimiterEditor(JTable jtable, String delimiter, JPanel pane) {
        int columns = jtable.getColumnCount();
        final DelimiterField delimiterField = new DelimiterField(pane, delimiter, "", columns);
        delimiterField.setHorizontalAlignment(4);
        DefaultCellEditor delimiterEditor = new DefaultCellEditor(delimiterField){

            public Object getCellEditorValue() {
                return new String(delimiterField.getValue());
            }

            public boolean shouldSelectCell(EventObject evnt) {
                super.shouldSelectCell(evnt);
                delimiterField.selectAll();
                return true;
            }
        };
        TableColumnModel columnModel = jtable.getColumnModel();
        for (int j = 0; j < columns; ++j) {
            columnModel.getColumn(j).setCellEditor(delimiterEditor);
            columnModel.getColumn(j).setPreferredWidth(85);
        }
    }

    void CancelButton_actionPerformed(ActionEvent event) {
        this.init();
    }

    void vecToString() {
        StringBuffer headerlines = new StringBuffer();
        StringBuffer resultString = new StringBuffer();
        for (int k = 0; k < this.num_header_lines; ++k) {
            headerlines.append(this.lines[k].trim() + "\n");
        }
        resultString.append(headerlines.toString());
        for (int i = 0; i < this.nlines - 1; ++i) {
            StringBuffer lineString = new StringBuffer();
            Vector innerVec = (Vector)this.vec.elementAt(i);
            for (int j = 0; j < innerVec.size(); ++j) {
                lineString.append((String)innerVec.elementAt(j) + this.delimiter_string);
            }
            resultString.append(lineString.toString() + "\n");
        }
        this.dataString = resultString.toString();
    }

    public void storingStateChangeEvent(StateChangeEvent event) {
        if (this.storedStateChangeEventlist != null) {
            this.storedStateChangeEventlist.add(event);
        }
    }

    public Vector getStoredStateChangeEvent() {
        return this.storedStateChangeEventlist;
    }

    public void broadcastStoredStateChangeEvent() {
        if (this.storedStateChangeEventlist != null) {
            for (int i = 0; i < this.storedStateChangeEventlist.size(); ++i) {
                StateChangeEvent event = (StateChangeEvent)this.storedStateChangeEventlist.elementAt(i);
                StateChangeMonitor.getInstance().notifyStateChange(event);
            }
        }
    }

    public void saveCurrentTable(boolean changePackageId) {
        if (this.adp != null) {
            String fileName;
            String oldId;
            String id = "";
            AccessionNumber an = new AccessionNumber(Morpho.thisStaticInstance);
            id = this.dataFileId == null ? (this.dataFile != null ? ((oldId = an.getDocIdFromInternalFileName(fileName = this.dataFile.getName())) != null ? an.incRev(oldId) : an.getNextId()) : an.getNextId()) : an.incRev(this.dataFileId);
            this.dataFileId = id;
            String tempfilename = this.parseId(id);
            this.ptm.getPersistentVector().writeObjects(this.tempdir + "/" + tempfilename);
            File newDataFile = new File(this.tempdir + "/" + tempfilename);
            long newDataFileLength = newDataFile.length();
            int rowcnt = this.ptm.getRowCount();
            String rowcntS = new Integer(rowcnt).toString();
            this.adp.setEntityNumRecords(this.entityIndex, rowcntS);
            String sizeS = new Long(newDataFileLength).toString();
            this.adp.setPhysicalSize(this.entityIndex, 0, sizeS);
            this.adp.setPhysicalFieldDelimiter(this.entityIndex, 0, this.field_delimiter);
            this.adp.setDistributionUrl(this.entityIndex, 0, 0, "ecogrid://knb/" + this.dataFileId);
            this.adp.setLocation("");
            if (changePackageId) {
                AccessionNumber a = new AccessionNumber(this.morpho);
                String curid = this.adp.getAccessionNumber();
                String newid = null;
                newid = !curid.equals("") ? a.incRev(curid) : a.getNextId();
                this.adp.setAccessionNumber(newid);
            }
        }
    }

    void UpdateButton_actionPerformed(ActionEvent event) {
        Object thisFrame = null;
        this.saveCurrentTable(true);
        if (this.adp != null) {
            MorphoFrame morphoFrame = UIController.getInstance().getCurrentActiveWindow();
            morphoFrame.setVisible(false);
            UIController uicontroller = UIController.getInstance();
            try {
                ServiceController services = ServiceController.getInstance();
                ServiceProvider provider = services.getServiceProvider(DataPackageInterface.class);
                DataPackageInterface dataPackageInt = (DataPackageInterface)((Object)provider);
                dataPackageInt.openNewDataPackage(this.adp, null);
                uicontroller.removeWindow(morphoFrame);
                morphoFrame.dispose();
            }
            catch (Exception e) {
                Log.debug(5, "Exception in converting edited XML to DOM!");
            }
        }
    }

    private String parseId(String id) {
        String path = new String();
        path = id.substring(0, id.indexOf("."));
        File pathFile = new File(this.tempdir + "/" + path);
        if (!pathFile.exists()) {
            pathFile.mkdir();
        }
        path = path + "/" + id.substring(id.indexOf(this.separator) + 1, id.length());
        return path;
    }

    class HeaderMouseListener
    implements MouseListener {
        private boolean trigger = false;

        HeaderMouseListener() {
        }

        public void mouseClicked(MouseEvent event) {
            TableColumnModel colModel = DataViewer.this.table.getColumnModel();
            int index = colModel.getColumnIndexAtX(event.getX());
            TableColumn column = colModel.getColumn(index);
            int modelIndex = column.getModelIndex();
            if (DataViewer.this.table.getRowCount() > 0) {
                DataViewer.this.table.setRowSelectionInterval(0, DataViewer.this.table.getRowCount() - 1);
            }
            DataViewer.this.table.setColumnSelectionInterval(modelIndex, modelIndex);
            if (event.isPopupTrigger()) {
                this.trigger = true;
            } else {
                StateChangeEvent stateEvent = new StateChangeEvent(DataViewer.this.table, StateChangeEvent.SELECT_DATATABLE_COLUMN);
                StateChangeMonitor stateMonitor = StateChangeMonitor.getInstance();
                stateMonitor.notifyStateChange(stateEvent);
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger() || this.trigger) {
                this.trigger = false;
                DataViewer.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        public void mousePressed(MouseEvent event) {
        }

        public void mouseEntered(MouseEvent event) {
        }

        public void mouseExited(MouseEvent event) {
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == DataViewer.this.CancelButton) {
                DataViewer.this.CancelButton_actionPerformed(event);
            } else if (object == DataViewer.this.UpdateButton) {
                DataViewer.this.UpdateButton_actionPerformed(event);
            }
        }
    }

    class PopupListener
    extends MouseAdapter {
        boolean trigger = false;

        PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            DataViewer.this.table.clearSelection();
            int selrow = DataViewer.this.table.rowAtPoint(new Point(e.getX(), e.getY()));
            int selcol = DataViewer.this.table.columnAtPoint(new Point(e.getX(), e.getY()));
            DataViewer.this.table.setRowSelectionInterval(selrow, selrow);
            DataViewer.this.table.setEditingRow(selrow);
            DataViewer.this.table.setColumnSelectionInterval(selcol, selcol);
            if (e.isPopupTrigger()) {
                this.trigger = true;
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger() || this.trigger) {
                this.trigger = false;
                DataViewer.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

