/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.framework.ModalDialog;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.DataPackageWizardInterface;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceNotHandledException;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.awt.event.ActionEvent;
import java.util.Map;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AddTaxonomicCovCommand
implements Command {
    private AbstractUIPage taxonomicPage;
    private OrderedMap existingValuesMap = null;
    private final String TAXONOMIC_COVERAGE_SUBTREE_NODENAME = "taxonomicCoverage";

    public void execute(ActionEvent event) {
        this.showTaxonomicDialog();
    }

    private void showTaxonomicDialog() {
        DataPackageWizardInterface dpwPlugin = null;
        try {
            ServiceController sc = ServiceController.getInstance();
            dpwPlugin = (DataPackageWizardInterface)((Object)sc.getServiceProvider(DataPackageWizardInterface.class));
        }
        catch (ServiceNotHandledException se) {
            Log.debug(6, se.getMessage());
        }
        if (dpwPlugin == null) {
            return;
        }
        this.taxonomicPage = dpwPlugin.getPage("TAXONOMIC");
        boolean pageCanHandleAllData = this.backupAndDisplayCurrentData();
        if (pageCanHandleAllData) {
            ModalDialog wpd = new ModalDialog(this.taxonomicPage, UIController.getInstance().getCurrentActiveWindow(), 800, 600, false);
            wpd.setSize(800, 600);
            wpd.setVisible(true);
            if (wpd.USER_RESPONSE == 10) {
                this.insertTaxonomicNode(this.taxonomicPage.getPageData("/coverage/taxonomicCoverage[1]"));
            } else {
                AbstractDataPackage adp = UIController.getInstance().getCurrentAbstractDataPackage();
                adp.removeTaxonomicNodes();
                if (this.existingValuesMap != null) {
                    OrderedMap newMap = this.preprendKeysWithString(this.existingValuesMap, "/coverage");
                    this.insertTaxonomicNode(newMap);
                }
            }
        } else {
            UIController.getInstance().launchEditorAtSubtreeForCurrentFrame("coverage", 0);
        }
    }

    private void insertTaxonomicNode(OrderedMap map) {
        AbstractDataPackage adp = UIController.getInstance().getCurrentAbstractDataPackage();
        Element covRoot = null;
        if (adp == null) {
            return;
        }
        try {
            DOMImplementation impl = DOMImplementationImpl.getDOMImplementation();
            Document doc = impl.createDocument("", "coverage", null);
            covRoot = doc.getDocumentElement();
            XMLUtilities.getXPathMapAsDOMTree((Map)map, (Node)covRoot);
            NodeList kids = covRoot.getChildNodes();
            adp.removeTaxonomicNodes();
            for (int i = 0; i < kids.getLength(); ++i) {
                Node kid = kids.item(i);
                adp.insertCoverage(kid);
            }
        }
        catch (Exception w) {
            Log.debug(5, "Unable to add OrderMap elements to DOM");
            w.printStackTrace();
        }
        UIController.showNewPackage(adp);
    }

    private OrderedMap preprendKeysWithString(OrderedMap map, String prefix) {
        if (map == null) {
            return null;
        }
        OrderedMap newMap = new OrderedMap();
        if (map.size() < 1) {
            return newMap;
        }
        for (String key : map.keySet()) {
            newMap.put((Object)(prefix + key), map.get((Object)key));
        }
        return newMap;
    }

    private OrderedMap getTaxonSubtreeMap(AbstractDataPackage adp) {
        NodeList taxonList = adp.getTaxonomicNodeList();
        if (taxonList == null) {
            Log.debug(45, "\n no taxon data in datapackage yet");
            return null;
        }
        int totTaxa = taxonList.getLength();
        if (totTaxa != 1) {
            Log.debug(45, "More than 1 taxon definition found!!!!");
        }
        OrderedMap map = XMLUtilities.getDOMTreeAsXPathMap((Node)taxonList.item(0));
        return map;
    }

    private boolean backupAndDisplayCurrentData() {
        AbstractDataPackage adp = UIController.getInstance().getCurrentAbstractDataPackage();
        if (adp == null) {
            return false;
        }
        this.existingValuesMap = this.getTaxonSubtreeMap(adp);
        if (this.existingValuesMap == null) {
            Log.debug(45, "No taxon subtree in the datapackage, so adding one...");
            DOMImplementation impl = DOMImplementationImpl.getDOMImplementation();
            Document doc = impl.createDocument("", "taxonomicCoverage", null);
            Element blankTaxonRoot = doc.getDocumentElement();
            Element sysNode = doc.createElement("taxonomicSystem");
            blankTaxonRoot.appendChild(sysNode);
            Element classNode = doc.createElement("classificationSystem");
            sysNode.appendChild(classNode);
            Element citeNode = doc.createElement("classificationSystemCitation");
            classNode.appendChild(citeNode);
            Element titleNode = doc.createElement("title");
            citeNode.appendChild(titleNode);
            Log.debug(45, "\n\nblankTaxonRoot: " + XMLUtilities.getDOMTreeAsString((Node)blankTaxonRoot));
            try {
                adp.insertCoverage(blankTaxonRoot);
                Log.debug(45, "\n\nadp after insertion of blank taxon subtree: " + adp);
            }
            catch (Throwable t) {
                Log.debug(45, "** ERROR: AddTaxonomicCovCommand, trying to add blankTaxonRoot: " + t);
                t.printStackTrace();
                return false;
            }
        } else {
            Log.debug(45, "Found project subtree in the datapackage; reading...");
        }
        Log.debug(45, "sending previous data to projectPage -\n\n" + this.existingValuesMap);
        OrderedMap newMap = null;
        if (this.existingValuesMap != null) {
            newMap = this.preprendKeysWithString(this.existingValuesMap, "");
        }
        boolean pageCanHandleAllData = this.taxonomicPage.setPageData(newMap, "/taxonomicCoverage");
        return pageCanHandleAllData;
    }
}

