/*
 * Decompiled with CFR 0.152.
 */
package edu.tesc.scidb.MetadataChecker;

import edu.tesc.scidb.databank.sms.tdm.Col;
import edu.tesc.scidb.databank.sms.tdm.ColImpl;
import edu.tesc.scidb.databank.sms.tdm.Database;
import edu.tesc.scidb.databank.sms.tdm.DatabaseImpl;
import edu.tesc.scidb.databank.sms.tdm.Table;
import edu.tesc.scidb.databank.sms.tdm.TableImpl;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class CreateTdmRep {
    public static Database getRep(File mdbFile) {
        Connection dbConn = null;
        DatabaseMetaData metadata = null;
        try {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            String dbinfo = "jdbc:odbc:Driver={Microsoft Access Driver (*.mdb)};DBQ=" + mdbFile.getAbsolutePath();
            dbConn = DriverManager.getConnection(dbinfo);
        }
        catch (SQLException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        try {
            metadata = dbConn.getMetaData();
        }
        catch (SQLException e) {
            return null;
        }
        StringBuffer filename = new StringBuffer(mdbFile.getName());
        int dotPos = filename.lastIndexOf(".");
        if (dotPos != -1) {
            filename.delete(dotPos, filename.length() - 1);
        }
        DatabaseImpl db = new DatabaseImpl(filename.toString());
        CreateTdmRep.addTables(db, metadata);
        return db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    private static void addTables(Database db, DatabaseMetaData metadata) {
        Vector<TableImpl> tables;
        block12: {
            ResultSet rs = null;
            tables = new Vector<TableImpl>();
            String[] tableTypesAllowed = new String[]{"TABLE"};
            rs = metadata.getTables(null, null, "%", tableTypesAllowed);
            while (rs.next()) {
                tables.add(new TableImpl(rs.getString("TABLE_NAME")));
            }
            try {
                rs.close();
            }
            catch (SQLException e) {}
            break block12;
            catch (SQLException e) {
                try {
                    rs.close();
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                return;
                catch (Throwable throwable) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e3) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        for (Table table : tables) {
            CreateTdmRep.addColumns(table, metadata);
            CreateTdmRep.addPrimaryKeys(table, metadata);
            CreateTdmRep.addForeignKeyReferences(table, metadata);
            db.addTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void addColumns(Table table, DatabaseMetaData metadata) {
        block17: {
            ResultSet rs = null;
            rs = metadata.getColumns(null, null, table.getName(), "%");
            while (rs.next()) {
                ColImpl column = new ColImpl(rs.getString("COLUMN_NAME"), CreateTdmRep.convertSqlTypeToTdmType(rs.getInt("DATA_TYPE")));
                column.setProperty("description", rs.getString("REMARKS"));
                String isNullable = rs.getString("IS_NULLABLE");
                if (isNullable.equalsIgnoreCase("NO")) {
                    column.setProperty("notNull", "1");
                }
                table.addCol(column);
            }
            try {
                rs.close();
            }
            catch (NullPointerException e) {
            }
            catch (SQLException e) {}
            break block17;
            catch (SQLException e) {
                try {
                    rs.close();
                }
                catch (NullPointerException e2) {
                }
                catch (SQLException e3) {
                    // empty catch block
                }
                return;
                catch (Throwable throwable) {
                    try {
                        rs.close();
                    }
                    catch (NullPointerException e4) {
                    }
                    catch (SQLException e5) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addPrimaryKeys(Table table, DatabaseMetaData metadata) {
        ResultSet rs = null;
        try {
            rs = metadata.getIndexInfo(null, null, table.getName(), true, true);
            while (rs.next()) {
                String indexName = rs.getString("INDEX_NAME");
                String colName = rs.getString("COLUMN_NAME");
                if (indexName == null || !indexName.endsWith("PK") && !indexName.equals("PrimaryKey")) continue;
                Col primaryKeyColumn = table.getCol(colName);
                primaryKeyColumn.setProperty("primaryKey", "1");
            }
        }
        catch (SQLException e) {
            System.err.println("Error while getting primary key information: " + e.getMessage());
        }
        finally {
            try {
                rs.close();
            }
            catch (NullPointerException e) {
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addForeignKeyReferences(Table table, DatabaseMetaData metadata) {
        ResultSet rs = null;
        try {
            Statement lookupStatement = metadata.getConnection().createStatement();
            rs = lookupStatement.executeQuery("SELECT szColumn, szReferencedObject FROM MSysRelationships WHERE szObject='" + table.getName() + "'");
            while (rs.next()) {
                Col column = table.getCol(rs.getString(1));
                column.setProperty("references", rs.getString(2));
            }
        }
        catch (SQLException e) {
            System.err.println("Error while getting foreign key information: " + e.getMessage());
        }
        finally {
            try {
                rs.close();
            }
            catch (NullPointerException e) {
            }
            catch (SQLException sQLException) {}
        }
    }

    private static String convertSqlTypeToTdmType(int sqlType) {
        switch (sqlType) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return "Integer";
            }
            case 3: 
            case 6: 
            case 8: {
                return "Decimal";
            }
            case -7: 
            case 16: {
                return "Boolean";
            }
            case 91: {
                return "Date";
            }
            case 92: {
                return "Time";
            }
            case 1: 
            case 12: {
                return "String";
            }
        }
        return "String";
    }
}

