/*
 * Decompiled with CFR 0.152.
 */
package com.toedter.calendar;

import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class JDayChooser
extends JPanel
implements ActionListener,
KeyListener,
FocusListener {
    private JButton[] days;
    private JButton selectedDay = null;
    private int day;
    private Color oldDayBackgroundColor;
    private Color selectedColor;
    private Color colorRed;
    private Color colorBlue;
    private String[] dayNames;
    private Calendar calendar;
    private Calendar today;
    private Locale locale = Locale.getDefault();
    private boolean initialized = false;

    public JDayChooser() {
        this.days = new JButton[49];
        Calendar calendar = Calendar.getInstance(this.locale);
        this.today = (Calendar)calendar.clone();
        this.setLayout(new GridLayout(7, 7));
        for (int y = 0; y < 7; ++y) {
            for (int x = 0; x < 7; ++x) {
                int index = x + 7 * y;
                if (y == 0) {
                    this.days[index] = new JButton(){

                        public void addMouseListener(MouseListener l) {
                        }

                        public boolean isFocusTraversable() {
                            return false;
                        }
                    };
                    this.days[index].setBackground(new Color(180, 180, 200));
                } else {
                    this.days[index] = new JButton("x");
                    this.days[index].addActionListener(this);
                    this.days[index].addKeyListener(this);
                    this.days[index].addFocusListener(this);
                }
                this.days[index].setMargin(new Insets(0, 0, 0, 0));
                this.days[index].setFocusPainted(false);
                this.add(this.days[index]);
            }
        }
        this.init();
        this.setDay(Calendar.getInstance().get(5));
        this.initialized = true;
    }

    protected void init() {
        this.colorRed = new Color(164, 0, 0);
        this.colorBlue = new Color(0, 0, 164);
        JButton testButton = new JButton();
        this.oldDayBackgroundColor = testButton.getBackground();
        this.selectedColor = new Color(160, 160, 160);
        this.calendar = Calendar.getInstance(this.locale);
        int firstDayOfWeek = this.calendar.getFirstDayOfWeek();
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(this.locale);
        this.dayNames = dateFormatSymbols.getShortWeekdays();
        int day = firstDayOfWeek;
        for (int i = 0; i < 7; ++i) {
            this.days[i].setText(this.dayNames[day]);
            if (day == 1) {
                this.days[i].setForeground(this.colorRed);
            } else {
                this.days[i].setForeground(this.colorBlue);
            }
            if (day < 7) {
                ++day;
                continue;
            }
            day -= 6;
        }
        this.drawDays();
    }

    protected void drawDays() {
        int i;
        Calendar tmpCalendar = (Calendar)this.calendar.clone();
        int firstDayOfWeek = tmpCalendar.getFirstDayOfWeek();
        tmpCalendar.set(5, 1);
        int firstDay = tmpCalendar.get(7) - firstDayOfWeek;
        if (firstDay < 0) {
            firstDay += 7;
        }
        for (i = 0; i < firstDay; ++i) {
            this.days[i + 7].setVisible(false);
            this.days[i + 7].setText("");
        }
        tmpCalendar.add(2, 1);
        Date firstDayInNextMonth = tmpCalendar.getTime();
        tmpCalendar.add(2, -1);
        Date day = tmpCalendar.getTime();
        int n = 0;
        Color foregroundColor = this.getForeground();
        while (day.before(firstDayInNextMonth)) {
            this.days[i + n + 7].setText(Integer.toString(n + 1));
            this.days[i + n + 7].setVisible(true);
            if (tmpCalendar.get(6) == this.today.get(6) && tmpCalendar.get(1) == this.today.get(1)) {
                this.days[i + n + 7].setForeground(this.colorRed);
            } else {
                this.days[i + n + 7].setForeground(foregroundColor);
            }
            if (n + 1 == this.day) {
                this.days[i + n + 7].setBackground(this.selectedColor);
                this.selectedDay = this.days[i + n + 7];
            } else {
                this.days[i + n + 7].setBackground(this.oldDayBackgroundColor);
            }
            ++n;
            tmpCalendar.add(5, 1);
            day = tmpCalendar.getTime();
        }
        for (int k = n + i + 7; k < 49; ++k) {
            this.days[k].setVisible(false);
            this.days[k].setText("");
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale l) {
        if (!this.initialized) {
            super.setLocale(l);
        } else {
            this.locale = l;
            this.init();
        }
    }

    public void setDay(int d) {
        if (d < 1) {
            d = 1;
        }
        Calendar tmpCalendar = (Calendar)this.calendar.clone();
        tmpCalendar.set(5, 1);
        tmpCalendar.add(2, 1);
        tmpCalendar.add(5, -1);
        int maxDaysInMonth = tmpCalendar.get(5);
        if (d > maxDaysInMonth) {
            d = maxDaysInMonth;
        }
        int oldDay = this.day;
        this.day = d;
        if (this.selectedDay != null) {
            this.selectedDay.setBackground(this.oldDayBackgroundColor);
            this.selectedDay.repaint();
        }
        for (int i = 7; i < 49; ++i) {
            if (!this.days[i].getText().equals(Integer.toString(this.day))) continue;
            this.selectedDay = this.days[i];
            this.selectedDay.setBackground(this.selectedColor);
            break;
        }
        this.firePropertyChange("day", oldDay, this.day);
    }

    public int getDay() {
        return this.day;
    }

    public void setMonth(int month) {
        this.calendar.set(2, month);
        this.setDay(this.day);
        this.drawDays();
    }

    public void setYear(int year) {
        this.calendar.set(1, year);
        this.drawDays();
    }

    public void setCalendar(Calendar c) {
        this.calendar = c;
        this.drawDays();
    }

    public void setFont(Font font) {
        if (this.days != null) {
            for (int i = 0; i < 49; ++i) {
                this.days[i].setFont(font);
            }
        }
    }

    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.days != null) {
            for (int i = 7; i < 49; ++i) {
                this.days[i].setForeground(fg);
            }
            this.drawDays();
        }
    }

    public String getName() {
        return "JDayChooser";
    }

    public void actionPerformed(ActionEvent e) {
        JButton button = (JButton)e.getSource();
        String buttonText = button.getText();
        int day = new Integer(buttonText);
        this.setDay(day);
    }

    public void focusGained(FocusEvent e) {
        JButton button = (JButton)e.getSource();
        String buttonText = button.getText();
        if (buttonText != null && !buttonText.equals("")) {
            this.actionPerformed(new ActionEvent(e.getSource(), 0, null));
        }
    }

    public void focusLost(FocusEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        int offset;
        int n = e.getKeyCode() == 38 ? -7 : (e.getKeyCode() == 40 ? 7 : (e.getKeyCode() == 37 ? -1 : (offset = e.getKeyCode() == 39 ? 1 : 0)));
        if (offset != 0) {
            for (int i = this.getComponentCount() - 1; i >= 0; --i) {
                if (this.getComponent(i) != this.selectedDay) continue;
                if ((i += offset) <= 7 || i >= this.days.length || !this.days[i].isVisible()) break;
                this.days[i].requestFocus();
                break;
            }
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (int i = 0; i < this.days.length; i = (int)((short)(i + 1))) {
            if (this.days[i] == null) continue;
            this.days[i].setEnabled(enabled);
        }
    }

    public static void main(String[] s) {
        JFrame frame = new JFrame("JDayChooser");
        frame.getContentPane().add(new JDayChooser());
        frame.pack();
        frame.setVisible(true);
    }
}

