/*
 * Decompiled with CFR 0.152.
 */
package edu.hope.cs.mcfall.swing;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.swing.filechooser.FileFilter;

public abstract class ExtensionFileFilter
extends FileFilter {
    protected Set<String> acceptedExtensions = new HashSet<String>();
    protected boolean allowDirectories;

    public ExtensionFileFilter() {
        this(false);
    }

    public ExtensionFileFilter(boolean allowDirectories) {
        this.allowDirectories = allowDirectories;
    }

    public boolean accept(File f) {
        if (f.isDirectory()) {
            return this.allowDirectories;
        }
        String extension = this.getExtension(f);
        if (extension != null) {
            return this.acceptedExtensions.contains(extension);
        }
        return false;
    }

    public boolean accept(File dir, String name) {
        return this.accept(new File(dir, name));
    }

    public String getExtension(File file) {
        String extension = null;
        String s = file.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            extension = s.substring(i + 1).toLowerCase();
        }
        return extension;
    }

    protected void addExtension(String extension) {
        this.acceptedExtensions.add(extension);
    }
}

