/*
 * Decompiled with CFR 0.152.
 */
package tool.pdf;

import com.pt.io.FileList;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import multivalent.Behavior;
import multivalent.Context;
import multivalent.Document;
import multivalent.Leaf;
import multivalent.Node;
import multivalent.ParseException;
import multivalent.node.LeafText;
import multivalent.std.adaptor.pdf.COS;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.IRef;
import multivalent.std.adaptor.pdf.PDF;
import multivalent.std.adaptor.pdf.PDFReader;
import multivalent.std.adaptor.pdf.PDFWriter;
import phelps.awt.geom.Rectangles2D;
import phelps.io.Files;
import phelps.io.PrintStreams;
import phelps.lang.Integers;
import phelps.util.Arrayss;
import phelps.util.Units;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Markup {
    static final boolean DEBUG = false;
    public static final String VERSION = "1.2 of $Date: 2004/03/28 07:38:10 $";
    public static final String COPYRIGHT = "Copyright (c) 2004 - 2005  Thomas A. Phelps.  All rights reserved.";
    private static final String USAGE = "java tool.pdf.Markup [<options>] <PDF-file...>\n\t[-scanurl] [-scanpage] [-header <expr>] [-header2 <expr>]\n\t[-overwrite] [-page <range>]\n\t[-analyze] [-apply <file>]\n\t[-password <password>] [-verbose] [-quiet]";
    private static final String HEAD_NONE = "no outline";
    private static final String HEAD_FONT = "font";
    private static final String HEAD_SLIDE = "slide";
    private static final String HEAD_PATTERN = "pattern";
    private static final String HEAD_NUMBER = "number";
    private static final String HEAD_OUTLINE = "outline";
    private String range_;
    private String head_;
    private Matcher head1_;
    private Matcher head2_;
    private Matcher head3_;
    private Matcher head4_;
    private boolean furl_;
    private boolean fpageref_;
    private boolean fnowrite_;
    private int pagenum_;
    private String apply_;
    private boolean foverwrite_;
    private String password_;
    private boolean fverbose_;
    private boolean fquiet_;
    private boolean fmonitor_;
    private PrintStream out_;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$tool$pdf$Markup;

    public Markup() {
        this.defaults();
    }

    public void defaults() {
        this.range_ = null;
        this.head_ = HEAD_NONE;
        this.head4_ = null;
        this.head3_ = null;
        this.head2_ = null;
        this.head1_ = null;
        this.fpageref_ = false;
        this.furl_ = false;
        this.fnowrite_ = false;
        this.pagenum_ = -1;
        this.apply_ = null;
        this.password_ = null;
        this.foverwrite_ = false;
        this.fmonitor_ = false;
        this.fquiet_ = false;
        this.fverbose_ = false;
        this.out_ = PrintStreams.DEVNULL;
    }

    public void setOut(PrintStream printStream) {
        this.out_ = printStream != null ? printStream : PrintStreams.DEVNULL;
    }

    public void setRange(String string) {
        this.range_ = string;
    }

    public void setPassword(String string) {
        this.password_ = string;
    }

    public void setHeaders(String string, String string2, String string3, String string4) {
        String string5 = string != null ? string.toLowerCase() : null;
        this.head_ = null;
        if (string == null) {
            this.head_ = HEAD_NONE;
            this.head4_ = null;
            this.head3_ = null;
            this.head2_ = null;
            this.head1_ = null;
        } else if (string5.startsWith(HEAD_FONT)) {
            this.head_ = HEAD_FONT;
        } else if (string5.startsWith("numberdot")) {
            this.head_ = HEAD_NUMBER;
        } else if (string5.startsWith("num")) {
            this.head_ = HEAD_NUMBER;
        } else if (string5.startsWith("tex")) {
            string = "^((Chapter|Appendix)\\s+.+)";
            string2 = "^\\d+\\.\\d+\\s+([A-Z].*)";
            string3 = "^\\d+\\.\\d+\\.\\d+\\s+([A-Z].*)";
            string4 = "^\\.\\d+\\.\\d+\\.\\d+\\.\\d+\\s+(.*)";
        } else if (string5.startsWith("outlinedot")) {
            string = "^[IVXL]+\\.\\s+(.+)";
            string2 = "^[A-Z]+\\.\\s+(.+)";
            string3 = null;
            string4 = null;
        } else if (string5.startsWith("out")) {
            string = "^[IVXL]+\\s+(.+)";
            string2 = "^[A-Z]+\\s+(.+)";
            string3 = "\\d+\\s+(.+)";
            string4 = null;
        } else if (string5.equals("matloff")) {
            string = "^[IVXL]+\\.\\s+(.+)";
            string2 = "^[A-Z]+\\.\\s+(.+)";
            string3 = "^1?\\d\\.\\s+([A-Z][^\u2014]+)\u2014.*";
            string4 = null;
        }
        if (this.head_ == null) {
            this.head_ = HEAD_PATTERN;
            try {
                this.head1_ = Pattern.compile(string).matcher("");
                this.head2_ = string2 != null ? Pattern.compile(string2).matcher("") : null;
                this.head3_ = string3 != null ? Pattern.compile(string3).matcher("") : null;
                this.head4_ = string4 != null ? Pattern.compile(string4).matcher("") : null;
            }
            catch (Exception exception) {
                System.err.println(new StringBuffer().append("BAD REGEXP: ").append(exception).toString());
                System.exit(1);
            }
        }
    }

    private void markup(File file) throws IOException {
        if (this.fverbose_) {
            System.out.println(file);
        }
        if (!($assertionsDisabled || file != null && file.exists())) {
            throw new AssertionError();
        }
        PDFReader pDFReader = null;
        String string = file.getPath();
        String string2 = new StringBuffer().append(string.toLowerCase().endsWith(".pdf") ? string.substring(0, string.length() - 4) : string).append("-mu.pdf").toString();
        try {
            pDFReader = new PDFReader(file);
            this.markup(file, new File(string2));
        }
        catch (ParseException parseException) {
            System.err.println(parseException);
        }
        catch (IOException iOException) {
            System.err.println(new StringBuffer().append("Can't open ").append(file).toString());
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markup(File file, File file2) throws IOException, ParseException {
        if (!this.fverbose_) {
            this.out_.println(file);
        }
        PDFReader pDFReader = new PDFReader(file);
        PDFWriter pDFWriter = this.fnowrite_ ? null : new PDFWriter(file2, pDFReader, false);
        try {
            this.markup(pDFReader, pDFWriter);
            if (pDFWriter != null) {
                pDFWriter.writePDF();
            }
        }
        finally {
            pDFReader.close();
            if (pDFWriter != null) {
                pDFWriter.close();
            }
        }
    }

    private void markup(PDFReader pDFReader, PDFWriter pDFWriter) throws IOException, ParseException {
        List<ScanRec> list;
        pDFReader.setPassword(this.password_);
        if (!pDFReader.isAuthorized()) {
            throw new ParseException("invalid password");
        }
        List<ScanRec> list2 = list = this.apply_ != null ? this.read(Files.getFile(this.apply_)) : this.scan(pDFReader);
        if (pDFWriter == null) {
            this.dump(list);
        } else if (list.size() != 0) {
            this.apply(list, pDFReader, pDFWriter);
        }
    }

    private List<ScanRec> scan(PDFReader pDFReader) throws IOException, ParseException {
        ArrayList<ScanRec> arrayList = new ArrayList<ScanRec>(100);
        Document document = new Document("top", null, null);
        Context context = document.getStyleSheet().getContext(null, null);
        PDF pDF = (PDF)Behavior.getInstance("AdobePDF", "AdobePDF", null, null, null);
        pDF.setReader(pDFReader);
        pDF.setHints(1049112);
        pDF.setZoom(100.0f);
        int n = pDFReader.getPageCnt();
        for (int n2 : Units.parseRange(this.range_, 1, pDFReader.getPageCnt())) {
            document.clear();
            document.putAttr("page", Integer.toString(n2));
            document.putAttr("pages", Integer.toString(n));
            pDF.parse(document);
            Rectangle rectangle = pDF.getMediaBox();
            String string = null;
            String string2 = null;
            String string3 = "";
            Object object = null;
            Leaf leaf = document.getLastLeaf();
            for (Object object2 = document.getFirstLeaf(); object2 != null && object2 != leaf; object2 = ((Node)object2).getNextLeaf()) {
                boolean bl;
                boolean bl2 = bl = object == null || ((Leaf)object).bbox.x >= ((Leaf)object2).bbox.x || Math.abs(((Leaf)object2).bbox.y + ((Leaf)object2).baseline - (((Leaf)object).bbox.y + ((Leaf)object).baseline)) > 12;
                if (object2 instanceof LeafText) {
                    LeafText leafText = (LeafText)object2;
                    string = leafText.getName();
                    string2 = string.toLowerCase();
                    if (string.length() != 0) {
                        boolean bl3;
                        Rectangle rectangle2 = new Rectangle(((Leaf)object2).bbox.x, rectangle.height - ((Leaf)object2).bbox.y, ((Leaf)object2).bbox.width, ((Leaf)object2).bbox.height);
                        char c = string.charAt(0);
                        context.reset((Node)object2, 0);
                        boolean bl4 = context.getFont().getWeight() > 500;
                        boolean bl5 = bl3 = (0x40 & context.getFont().getFlags()) != 0;
                        if (HEAD_NONE != this.head_ && bl) {
                            Object object3;
                            StringBuffer stringBuffer = new StringBuffer(string);
                            object = null;
                            for (object3 = ((Node)object2).getNextLeaf(); object3 != null && object3 != leaf && (object == null || ((Leaf)object3).bbox.x > ((Leaf)object).bbox.x && Math.abs(((Leaf)object).bbox.y + ((Leaf)object).baseline - (((Leaf)object3).bbox.y + ((Leaf)object3).baseline)) < 5) && object3 instanceof LeafText; object3 = ((Node)object3).getNextLeaf()) {
                                stringBuffer.append(' ').append(((LeafText)object3).getText());
                                object = object3;
                            }
                            object3 = stringBuffer.toString().trim();
                            String string4 = null;
                            String string5 = null;
                            if (((String)object3).length() != 0) {
                                if (this.head1_ != null && this.head1_.reset((CharSequence)object3) != null && this.head1_.find()) {
                                    string5 = "head1";
                                    string4 = this.head1_.groupCount() == 0 ? this.head1_.group() : this.head1_.group(1);
                                } else if (this.head2_ != null && this.head2_.reset((CharSequence)object3) != null && this.head2_.find()) {
                                    string5 = "head2";
                                    string4 = this.head2_.groupCount() == 0 ? this.head2_.group() : this.head2_.group(1);
                                } else if (this.head3_ != null && this.head3_.reset((CharSequence)object3) != null && this.head3_.find()) {
                                    string5 = "head3";
                                    string4 = this.head3_.groupCount() == 0 ? this.head3_.group() : this.head3_.group(1);
                                } else if (this.head4_ != null && this.head4_.reset((CharSequence)object3) != null && this.head4_.find()) {
                                    string5 = "head4";
                                    String string6 = string4 = this.head4_.groupCount() == 0 ? this.head4_.group() : this.head4_.group(1);
                                }
                            }
                            if (string4 != null && string4.length() > 0) {
                                if (!$assertionsDisabled && string5 == null) {
                                    throw new AssertionError();
                                }
                                ScanRec scanRec = new ScanRec(string5, string4, rectangle2, n2);
                                arrayList.add(scanRec);
                                object2 = object;
                                if (this.fmonitor_) {
                                    System.out.println(new StringBuffer().append(scanRec.type).append(": ").append((String)object3).toString());
                                }
                            }
                        }
                        if (this.furl_) {
                            int n3 = string2.indexOf("http://");
                            if (n3 < 0) {
                                n3 = string2.indexOf("www.");
                            }
                            if (n3 >= 0) {
                                string = string.substring(n3);
                                if (this.fmonitor_) {
                                    System.out.println(new StringBuffer().append("page ").append(n2).append(", URL: ").append(string).append(", bbox = ").append(rectangle2).toString());
                                }
                                for (int i = string.length() - 1; i > 0; --i) {
                                }
                                arrayList.add(new ScanRec("URL", string, rectangle2, n2));
                            }
                        }
                        if (this.fpageref_) {
                            // empty if block
                        }
                    }
                }
                string3 = string;
                object = object2;
            }
        }
        return arrayList;
    }

    private List<ScanRec> read(File file) throws IOException {
        String string;
        ArrayList<ScanRec> arrayList = new ArrayList<ScanRec>(100);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        while ((string = bufferedReader.readLine()) != null) {
        }
        bufferedReader.close();
        return arrayList;
    }

    private void dump(List<ScanRec> list) {
        this.out_.println("# markup.  Fuse to PDF with -apply.");
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            this.out_.println(list.get(i));
        }
    }

    private void apply(List<ScanRec> list, PDFReader pDFReader, PDFWriter pDFWriter) throws IOException {
        Object object;
        Object object2;
        Dict dict;
        Object object3;
        IRef[] iRefArray;
        Object object4;
        int n;
        Dict dict2 = pDFWriter.getCatalog();
        int n2 = Integer.MAX_VALUE;
        int n3 = list.size();
        for (n = 0; n < n3; ++n) {
            object4 = list.get(n);
            if ("head1" == ((ScanRec)object4).type && n2 > 1) {
                n2 = 1;
                break;
            }
            if ("head2" == ((ScanRec)object4).type && n2 > 2) {
                n2 = 2;
                continue;
            }
            if ("head3" == ((ScanRec)object4).type && n2 > 3) {
                n2 = 3;
                continue;
            }
            if ("head4" != ((ScanRec)object4).type || n2 <= 4) continue;
            n2 = 4;
        }
        if (n2 < Integer.MAX_VALUE) {
            Dict[] dictArray;
            if (this.foverwrite_) {
                dict2.remove("Outlines");
            }
            if (pDFWriter.getObject(dict2.get("Outlines")) != null) {
                throw new IOException("already has Outline -- need -overwrite");
            }
            n = n2 - 1;
            if (n > 0) {
                int n4 = list.size();
                for (n3 = 0; n3 < n4; ++n3) {
                    dictArray = list.get(n3);
                    if ("head2" == dictArray.type) {
                        dictArray.type = "head1";
                        continue;
                    }
                    if ("head3" == dictArray.type) {
                        dictArray.type = "head2";
                        continue;
                    }
                    if ("head4" != dictArray.type) continue;
                    dictArray.type = "head3";
                }
            }
            if ("head1" != list.get((int)0).type) {
                list.add(0, new ScanRec("head1", "First Page", null, 1));
            }
            Dict dict3 = new Dict();
            object4 = pDFWriter.addObject(dict3);
            dict3.put("Type", "Outline");
            dict2.put("Outlines", object4);
            if (dict2.get("PageMode") == null) {
                dict2.put("PageMode", "UseOutlines");
            }
            dictArray = new Dict[5];
            iRefArray = new IRef[5];
            dictArray[0] = dict3;
            iRefArray[0] = object4;
            object3 = dict3;
            dict = null;
            object2 = object4;
            object = null;
            int n5 = list.size();
            int n6 = 0;
            for (int i = 0; i < n5; ++i) {
                Dict dict4;
                Object object5;
                ScanRec scanRec = list.get(i);
                int n7 = "head1" == scanRec.type ? 1 : ("head2" == scanRec.type ? 2 : ("head3" == scanRec.type ? 3 : 4));
                dict = new Dict(7);
                object = pDFWriter.addObject(dict);
                dict.put("Title", new StringBuffer(scanRec.txt));
                dict.put("Dest", new Object[]{pDFReader.getPageRef(scanRec.page), "XYZ", Integers.ZERO, Integers.getInteger(scanRec.bbox.y), COS.OBJECT_NULL});
                Object object6 = null;
                Object object7 = null;
                if (n7 > n6) {
                    object5 = object2;
                } else if (n7 == n6) {
                    object6 = object3;
                    object7 = object2;
                    object5 = (IRef)((Dict)object3).get("Parent");
                } else {
                    int n8;
                    if (!$assertionsDisabled && n7 >= n6) {
                        throw new AssertionError();
                    }
                    for (n8 = n6; n8 > n7; --n8) {
                        dictArray[n8] = null;
                        iRefArray[n8] = null;
                    }
                    object6 = dictArray[n7];
                    object7 = iRefArray[n7];
                    object5 = null;
                    for (n8 = n7 - 1; n8 >= 0; --n8) {
                        if (iRefArray[n8] == null) continue;
                        object5 = iRefArray[n8];
                        break;
                    }
                }
                dict.put("Parent", object5);
                if (object6 != null) {
                    ((Dict)object6).put("Next", object);
                    dict.put("Prev", object7);
                }
                if ((dict4 = (Dict)pDFWriter.getObject(object5)).get("First") == null) {
                    dict4.put("First", object);
                    dict4.put("Count", Integers.ZERO);
                }
                dict4.put("Last", object);
                int n9 = (Integer)dict4.get("Count") - 1;
                dict4.put("Count", Integers.getInteger(n9));
                dictArray[n7] = dict;
                iRefArray[n7] = object;
                n6 = n7;
                object3 = dict;
                object2 = object;
            }
            dict3.remove("Count");
        }
        n3 = list.size();
        for (n = 0; n < n3; ++n) {
            object4 = list.get(n);
            if ("URL" != ((ScanRec)object4).type) continue;
            int n10 = ((ScanRec)object4).page;
            iRefArray = (IRef[])pDFWriter.getObject(pDFReader.getPageRef(n10));
            object3 = (Object[])pDFWriter.getObject(iRefArray.get("Annots"));
            if (object3 == null) {
                object3 = new Object[1];
                iRefArray.put("Annots", pDFWriter.addObject(object3));
            } else {
                object3 = Arrayss.resize((Object[])object3, 1 + ((Object[])object3).length);
                iRefArray.put("Annots", object3);
            }
            dict = new Dict(5);
            object3[((Object[])object3).length - 1] = pDFWriter.addObject(dict);
            dict.put("Subtype", "Link");
            object2 = ((ScanRec)object4).bbox;
            dict.put("Rect", new Object[]{Integers.getInteger(((Rectangle)object2).x), Integers.getInteger(((Rectangle)object2).y - ((Rectangle)object2).height), Integers.getInteger(((Rectangle)object2).x + ((Rectangle)object2).width), Integers.getInteger(((Rectangle)object2).y)});
            object = new Dict(5);
            ((Dict)object).put("S", "URI");
            ((Dict)object).put("URI", new StringBuffer(((ScanRec)object4).txt));
            dict.put("A", object);
        }
    }

    private int commandLine(String[] stringArray) {
        String string;
        int n;
        this.out_ = System.out;
        int n2 = stringArray.length;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        for (n = 0; n < n2 && (string = stringArray[n]).startsWith("-"); ++n) {
            if ((string = string.toLowerCase()).startsWith("--")) {
                string = string.substring(1);
            }
            if (string.startsWith("-url")) {
                this.furl_ = true;
                continue;
            }
            if (string.startsWith("-pageref")) {
                this.fpageref_ = true;
                continue;
            }
            if (string.startsWith("-header2") || string.startsWith("-head2")) {
                string3 = stringArray[++n];
                continue;
            }
            if (string.startsWith("-header3") || string.startsWith("-head3")) {
                string4 = stringArray[++n];
                continue;
            }
            if (string.startsWith("-header4") || string.startsWith("-head4")) {
                string5 = stringArray[++n];
                continue;
            }
            if (string.startsWith("-head")) {
                string2 = stringArray[++n];
                continue;
            }
            if (string.startsWith("-anal") || string.startsWith("-nowrite")) {
                this.fnowrite_ = true;
                continue;
            }
            if (string.startsWith("-pagenum")) {
                this.range_ = stringArray[++n];
                continue;
            }
            if (string.startsWith("-apply")) {
                this.apply_ = stringArray[++n];
                continue;
            }
            if (string.startsWith("-overwrite")) {
                this.foverwrite_ = true;
                continue;
            }
            if (string.startsWith("-page") || string.startsWith("-range")) {
                this.setRange(stringArray[++n]);
                continue;
            }
            if (string.startsWith("-pass")) {
                this.setPassword(stringArray[++n]);
                continue;
            }
            if (string.startsWith("-verb")) {
                this.fverbose_ = true;
                continue;
            }
            if (string.startsWith("-mon")) {
                this.fverbose_ = true;
                this.fmonitor_ = true;
                this.fquiet_ = false;
                continue;
            }
            if (string.startsWith("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (string.startsWith("-h")) {
                System.out.println(USAGE);
                System.exit(0);
                continue;
            }
            System.err.println(new StringBuffer().append("Unknown option: ").append(string).toString());
            System.err.println(USAGE);
            System.exit(1);
        }
        this.setHeaders(string2, string3, string4, string5);
        if (n == n2) {
            System.err.println(USAGE);
            System.exit(0);
        }
        if (this.apply_ != null && this.fnowrite_ && this.pagenum_ < 0) {
            System.err.println("no scanning and no writing -- nothing to do");
            System.exit(1);
        }
        return n;
    }

    public static void main(String[] stringArray) {
        Markup markup = new Markup();
        int n = markup.commandLine(stringArray);
        Iterator<File> iterator = new FileList(stringArray, n, COS.FILTER).iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            if (System.getSecurityManager() != null) continue;
            try {
                markup.markup(file);
            }
            catch (Exception exception) {
                System.err.println(new StringBuffer().append(file).append(": ").append(exception).toString());
            }
        }
        System.exit(0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        $assertionsDisabled = !(class$tool$pdf$Markup == null ? (class$tool$pdf$Markup = Markup.class$("tool.pdf.Markup")) : class$tool$pdf$Markup).desiredAssertionStatus();
    }

    class ScanRec {
        static final String TYPE_URL = "URL";
        static final String TYPE_PAGEREF = "pageref";
        static final String TYPE_HEAD1 = "head1";
        static final String TYPE_HEAD2 = "head2";
        static final String TYPE_HEAD3 = "head3";
        static final String TYPE_HEAD4 = "head4";
        String type;
        String txt;
        Rectangle bbox;
        int page;

        ScanRec(String string, String string2, Rectangle rectangle, int n) {
            this.type = string;
            this.txt = string2;
            this.bbox = rectangle;
            this.page = n;
        }

        public String toString() {
            return this.type + " " + this.page + " " + Rectangles2D.pretty(this.bbox) + " " + this.txt;
        }
    }
}

