/*
 * Decompiled with CFR 0.152.
 */
package tool.doc;

import com.pt.io.FileList;
import com.pt.io.InputUni;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import multivalent.Context;
import multivalent.Document;
import multivalent.Node;
import multivalent.Span;
import multivalent.VObject;
import multivalent.std.adaptor.XML;
import multivalent.std.span.HyperlinkSpan;
import phelps.awt.Colors;
import phelps.io.Files;
import tool.doc.DocWalker;
import tool.doc.DocWalkerObserver;

public class ExtractText
implements DocWalkerObserver {
    public static final String VERSION = "2.0 of $Date: 2006/01/01 07:31:55 $";
    private static final String USAGE = "java tool.doc.ExtractText <options> <document-path/URI/directory>\n\t[-output (unicode|doctree|xml)]\n\t[-bbox] [-style] [-links] [-span]\n\t[-header <string>] [-indent <string>] [-separator <string>]\n\t[-page <range>] [-password <password>]";
    public static final Object FORMAT_TREE;
    public static final Object FORMAT_UNICODE;
    public static final Object FORMAT_XML;
    private Object format_;
    private boolean fbbox_;
    private boolean flinks_;
    private boolean fstyle_;
    private boolean fspan_;
    private StringBuffer sb_;
    private String password_;
    private boolean fverbose_;
    private boolean fquiet_;
    private boolean fmonitor_;
    private boolean ftest_;
    private String tab_;
    private String range_;
    private String sep_;
    private int level_;
    private int spanopen_;
    private List<VObject> stack_;
    private static final Span SPAN_BOLD;
    private static final Span SPAN_ITALIC;
    private static final Span SPAN_UNDERLINE;
    private Node styleNode_;
    private int styleOffset_;
    private Context styleContext_;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$multivalent$Span;

    public ExtractText() {
        this.defaults();
    }

    public void defaults() {
        this.format_ = FORMAT_UNICODE;
        this.fspan_ = false;
        this.fstyle_ = false;
        this.flinks_ = false;
        this.fbbox_ = false;
        this.tab_ = "  ";
        this.range_ = "all";
        this.sep_ = "================================================================================";
        this.password_ = null;
        this.ftest_ = false;
        this.fmonitor_ = false;
        this.fquiet_ = false;
        this.fverbose_ = false;
    }

    public void setFormat(Object object) {
        this.format_ = object;
    }

    public void setSpan(boolean bl) {
        this.fspan_ = bl;
        if (bl) {
            this.fstyle_ = false;
        }
    }

    public void setBbox(boolean bl) {
        this.fbbox_ = bl;
    }

    public void setLinks(boolean bl) {
        this.flinks_ = bl;
    }

    public void setStyle(boolean bl) {
        this.fstyle_ = bl;
        if (bl) {
            this.fspan_ = false;
        }
    }

    public void setIndent(String string) {
        this.tab_ = string != null ? string : "";
    }

    public void setPageSeparator(String string) {
        this.sep_ = string != null ? string : "";
    }

    public void setPassword(String string) {
        this.password_ = string;
    }

    public String extract(InputUni inputUni) throws Exception {
        int n = 6664;
        if (FORMAT_UNICODE == this.format_) {
            n |= 0x400;
        } else if (!this.fbbox_) {
            n |= 0x400;
        }
        this.level_ = 0;
        this.spanopen_ = 0;
        this.stack_ = new ArrayList<VObject>();
        this.styleNode_ = null;
        this.styleOffset_ = Integer.MIN_VALUE;
        this.styleContext_ = new Context();
        StringBuffer stringBuffer = this.sb_ = new StringBuffer(10240);
        DocWalker docWalker = new DocWalker(inputUni, n);
        docWalker.addObserver(this);
        docWalker.extractAll();
        for (int i = stringBuffer.length() - 1; i >= 0; --i) {
            if (Character.isWhitespace(stringBuffer.charAt(i))) continue;
            stringBuffer.setLength(i + 1);
            break;
        }
        String string = stringBuffer.toString();
        return string;
    }

    public String extract(URI uRI) throws Exception {
        InputUni inputUni = InputUni.getInstance(uRI, null, null);
        String string = this.extract(inputUni);
        inputUni.close();
        return string;
    }

    public void feature(int n, Object object) {
        if (FORMAT_TREE == this.format_) {
            this.toDump(n, object, this.sb_);
        } else if (FORMAT_UNICODE == this.format_) {
            this.toText(n, object, this.sb_);
        } else {
            this.toXML(n, object, this.sb_);
        }
    }

    private void toDump(int n, Object object, StringBuffer stringBuffer) {
        int n2 = stringBuffer.length();
        switch (n) {
            case 1: {
                Document document = (Document)object;
                stringBuffer.append("<document");
                this.appendAttribute("uri", document.getURI(), stringBuffer);
                stringBuffer.append(" >\n");
                Iterator<Map.Entry<String, Object>> iterator = document.getAttributes().entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, Object> entry = iterator.next();
                    this.indent(1, stringBuffer);
                    stringBuffer.append("<meta");
                    this.appendAttribute(entry.getKey(), entry.getValue(), stringBuffer);
                    stringBuffer.append(" />\n");
                }
                break;
            }
            case 2: {
                stringBuffer.append("</document>\n");
                break;
            }
            case 3: {
                stringBuffer.append("<page>\n");
                break;
            }
            case 4: {
                stringBuffer.append("</page>\n");
                break;
            }
            case 10: {
                Node node = (Node)object;
                String string = node.getName();
                if (n2 > 0 && stringBuffer.charAt(n2 - 1) != '\n') {
                    stringBuffer.append("\n");
                }
                this.indent(this.level_, stringBuffer);
                stringBuffer.append("<").append(string);
                this.appendBbox(node, stringBuffer);
                this.appendAttributes(node, stringBuffer);
                stringBuffer.append(">");
                ++this.level_;
                break;
            }
            case 11: {
                Node node = (Node)object;
                String string = node.getName();
                --this.level_;
                if (n2 >= 2 && stringBuffer.charAt(n2 - 1) == '\n' && stringBuffer.charAt(n2 - 2) == '>') {
                    this.indent(this.level_, stringBuffer);
                }
                stringBuffer.append("</").append(string).append(">\n");
                break;
            }
            case 12: {
                Node node = (Node)object;
                String string = node.getName();
                if (n2 >= 2 && stringBuffer.charAt(n2 - 1) == '\n' && stringBuffer.charAt(n2 - 2) == '>') {
                    this.indent(this.level_, stringBuffer);
                }
                stringBuffer.append("<").append(string);
                this.appendAttributes(node, stringBuffer);
                stringBuffer.append(" />\n");
                break;
            }
            case 13: {
                boolean bl;
                Span span = (Span)object;
                boolean bl2 = bl = span instanceof HyperlinkSpan ? this.flinks_ : this.fspan_;
                if (!bl) break;
                stringBuffer.append("<").append(span.getName());
                this.appendAttributes(span, stringBuffer);
                stringBuffer.append(">");
                break;
            }
            case 14: {
                boolean bl;
                Span span = (Span)object;
                boolean bl3 = bl = span instanceof HyperlinkSpan ? this.flinks_ : this.fspan_;
                if (!bl) break;
                stringBuffer.append("</").append(span.getName()).append(">");
                break;
            }
            case 15: {
                if (n2 > 0 && stringBuffer.charAt(n2 - 1) != '>' && stringBuffer.charAt(n2 - 1) != '\n') {
                    stringBuffer.append(" ");
                }
                if (!this.fbbox_) break;
                stringBuffer.append("<word");
                this.appendBbox((Node)object, stringBuffer);
                stringBuffer.append(">");
                break;
            }
            case 16: {
                if (!this.fbbox_) break;
                stringBuffer.append("</word>");
                break;
            }
            case 21: {
                stringBuffer.append(object);
                break;
            }
            case 20: {
                stringBuffer.append("<!--").append(object).append("-->\n");
                break;
            }
            case 18: {
                stringBuffer.append("\n");
            }
        }
    }

    private void toText(int n, Object object, StringBuffer stringBuffer) {
        int n2;
        int n3 = stringBuffer.length();
        int n4 = n2 = n3 >= 1 ? (int)stringBuffer.charAt(n3 - 1) : 65535;
        if (this.flinks_) {
            Object object2;
            if (13 == n && object instanceof HyperlinkSpan && (object2 = ((HyperlinkSpan)object).getTarget()) instanceof URI) {
                stringBuffer.append(object2).append("\n");
            }
        } else {
            switch (n) {
                case 21: {
                    String string = (String)object;
                    stringBuffer.append(string);
                    break;
                }
                case 16: {
                    if (n3 < 1 || n2 == 10) break;
                    stringBuffer.append(" ");
                    break;
                }
                case 18: {
                    stringBuffer.append("\n");
                    break;
                }
                case 10: 
                case 11: {
                    if (n3 < 2 || n2 == 10 && stringBuffer.charAt(n3 - 2) == '\n') break;
                    stringBuffer.append("\n");
                    break;
                }
                case 1: {
                    Document document = (Document)object;
                    stringBuffer.append("URI: ").append(document.getURI()).append("\n");
                    Iterator<Map.Entry<String, Object>> iterator = document.getAttributes().entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<String, Object> entry = iterator.next();
                        stringBuffer.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
                    }
                    break;
                }
                case 4: {
                    stringBuffer.append("\n\n\n").append(this.sep_).append("\n\n\n");
                }
            }
        }
    }

    private void toXML(int n, Object object, StringBuffer stringBuffer) {
        int n2 = stringBuffer.length();
        switch (n) {
            case 1: {
                stringBuffer.append("<?xml");
                this.appendAttribute("version", "1.0", stringBuffer);
                this.appendAttribute("encoding", "UTF-8", stringBuffer);
                stringBuffer.append("?>\n");
                stringBuffer.append("<document>\n");
                ++this.level_;
                break;
            }
            case 2: {
                --this.level_;
                stringBuffer.append("</document>\n");
                break;
            }
            case 3: {
                stringBuffer.append("<page>\n");
                ++this.level_;
                break;
            }
            case 4: {
                --this.level_;
                stringBuffer.append("</page>\n");
                break;
            }
            case 10: {
                this.closeSpans(null, stringBuffer);
                Node node = (Node)object;
                String string = node.getName();
                if (n2 > 0 && stringBuffer.charAt(n2 - 1) != '\n') {
                    stringBuffer.append("\n");
                }
                this.indent(this.level_, stringBuffer);
                stringBuffer.append("<");
                this.appendName(string, stringBuffer);
                this.appendBbox(node, stringBuffer);
                this.appendAttributes(node, stringBuffer);
                stringBuffer.append(">");
                this.stack_.add(node);
                ++this.level_;
                break;
            }
            case 11: {
                Node node = (Node)object;
                String string = node.getName();
                this.closeSpans(null, stringBuffer);
                --this.level_;
                if (n2 >= 2 && stringBuffer.charAt(n2 - 1) == '\n' && stringBuffer.charAt(n2 - 2) == '>') {
                    this.indent(this.level_, stringBuffer);
                }
                stringBuffer.append("</");
                this.appendName(string, stringBuffer);
                stringBuffer.append(">\n");
                this.stack_.remove(node);
                break;
            }
            case 12: {
                Node node = (Node)object;
                String string = node.getName();
                if (n2 >= 2 && stringBuffer.charAt(n2 - 1) == '\n' && stringBuffer.charAt(n2 - 2) == '>') {
                    this.indent(this.level_, stringBuffer);
                }
                stringBuffer.append("<");
                this.appendName(string, stringBuffer);
                this.appendAttributes(node, stringBuffer);
                stringBuffer.append(" />\n");
                break;
            }
            case 13: {
                boolean bl;
                Span span = (Span)object;
                boolean bl2 = bl = span instanceof HyperlinkSpan ? this.flinks_ : this.fspan_;
                if (bl) {
                    this.stack_.add(span);
                    this.openSpans(stringBuffer);
                }
                this.deltaStyle(span.getStart().leaf, span.getStart().offset);
                break;
            }
            case 14: {
                boolean bl;
                Span span = (Span)object;
                boolean bl3 = bl = span instanceof HyperlinkSpan ? this.flinks_ : this.fspan_;
                if (bl) {
                    this.closeSpans(span, stringBuffer);
                    this.stack_.remove(span);
                }
                this.deltaStyle(span.getEnd().leaf, span.getEnd().offset);
                break;
            }
            case 21: {
                String string = (String)object;
                XML.encode(string, stringBuffer, false);
                break;
            }
            case 20: {
                stringBuffer.append("<!--").append(object).append("-->\n");
                break;
            }
            case 15: {
                Node node = (Node)object;
                if (node.getParentNode().childAt(0) == node) {
                    this.deltaStyle(node, 0, "close");
                    this.openSpans(stringBuffer);
                    this.deltaStyle(node, 0, "open");
                }
                if (!this.fbbox_) break;
                stringBuffer.append("<word");
                this.appendBbox(node, stringBuffer);
                stringBuffer.append(">");
                this.stack_.add(node);
                break;
            }
            case 16: {
                Node node = (Node)object;
                stringBuffer.append(this.fbbox_ ? "</word>" : " ");
                this.closeSpans(node, stringBuffer);
                this.stack_.remove(node);
                break;
            }
            case 18: {
                stringBuffer.append("\n");
            }
        }
    }

    private void appendAttributes(VObject vObject, StringBuffer stringBuffer) {
        Map<String, Object> map = vObject.getAttributes();
        if (map != null) {
            Iterator<Map.Entry<String, Object>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                this.appendAttribute(entry.getKey(), entry.getValue(), stringBuffer);
            }
        }
    }

    private void appendAttribute(String string, Object object, StringBuffer stringBuffer) {
        stringBuffer.append(" ");
        this.appendName(string, stringBuffer);
        if (!string.equals(object)) {
            if (FORMAT_XML == this.format_) {
                String string2 = object.toString();
                char c = string2.indexOf("'") != -1 ? (char)'\"' : '\'';
                stringBuffer.append("=").append(c);
                int n = string2.length();
                for (int i = 0; i < n; ++i) {
                    char c2 = string2.charAt(i);
                    if (c2 == c) {
                        stringBuffer.append(c == '\\' ? "&#x27;" : "&#x22;");
                        continue;
                    }
                    if (c2 == ' ' || c2 == '\r' || c2 == '\n' || c2 == '\t') {
                        stringBuffer.append(" ");
                        continue;
                    }
                    stringBuffer.append(c2);
                }
                stringBuffer.append(c);
            } else {
                stringBuffer.append("=").append("'").append(object).append("'");
            }
        }
    }

    private void appendBbox(Node node, StringBuffer stringBuffer) {
        if (this.fbbox_) {
            Rectangle rectangle = node.bbox;
            this.appendAttribute("bbox", rectangle.width + "x" + rectangle.height + "@" + rectangle.x + "," + rectangle.y, stringBuffer);
        }
    }

    private void appendName(String string, StringBuffer stringBuffer) {
        if (string == null || string.length() == 0) {
            return;
        }
        int n = 0;
        char c = string.charAt(0);
        if (Character.isLetter(c)) {
            stringBuffer.append(c);
            ++n;
        } else {
            stringBuffer.append("_");
        }
        int n2 = string.length();
        while (n < n2) {
            c = string.charAt(n);
            if (Character.isLetter(c) || Character.isDigit(c) || c == '.' || c == '-' || c == '_' || c == ':') {
                stringBuffer.append(c);
            }
            ++n;
        }
    }

    private void openSpans(StringBuffer stringBuffer) {
        int n = this.stack_.size();
        for (int i = this.spanopen_; i < n; ++i) {
            VObject vObject = this.stack_.get(i);
            if (!(vObject instanceof Span)) continue;
            Span span = (Span)vObject;
            stringBuffer.append("<");
            this.appendName(span.getName(), stringBuffer);
            this.appendAttributes(span, stringBuffer);
            stringBuffer.append(">");
        }
        this.spanopen_ = this.stack_.size();
    }

    private void closeSpans(VObject vObject, StringBuffer stringBuffer) {
        int n;
        int n2 = n = vObject == null ? 0 : this.stack_.lastIndexOf(vObject);
        if (n == -1 || n >= this.spanopen_) {
            return;
        }
        for (int i = this.spanopen_ - 1; i >= n; --i) {
            VObject vObject2 = this.stack_.get(i);
            if (!(vObject2 instanceof Span)) continue;
            Span span = (Span)vObject2;
            stringBuffer.append("</");
            this.appendName(span.getName(), stringBuffer);
            stringBuffer.append(">");
        }
        this.spanopen_ = n;
    }

    private void deltaStyle(Node node, int n) {
        this.deltaStyle(node, n, "both");
    }

    private void deltaStyle(Node node, int n, String string) {
        boolean bl;
        if (!this.fstyle_ || node == this.styleNode_ && n == this.styleOffset_) {
            return;
        }
        if (!($assertionsDisabled || this.fstyle_ && !this.fspan_)) {
            throw new AssertionError();
        }
        this.fstyle_ = false;
        this.fspan_ = true;
        Context context = new Context();
        Context context2 = this.styleContext_;
        context.reset(node, n);
        if (context.spot != null) {
            context.family = context.spot.getFamily();
            context.size = context.spot.getSize();
            context.weight = context.spot.getWeight();
            context.flags = context.spot.getFlags();
        }
        boolean bl2 = bl = (double)Math.abs(context2.size - context.size) > 0.01 || context2.family != context.family && (context.family == null || !context.family.equals(context2.family)) || context2.foreground != context.foreground && (context.foreground == null || !context.foreground.equals(context2.foreground)) || context2.background != context.background && (context.background == null || !context.background.equals(context2.background));
        if ("close".equals(string) || "both".equals(string)) {
            if (bl) {
                for (int i = this.stack_.size() - 1; i >= 0; --i) {
                    VObject vObject;
                    if ((class$multivalent$Span == null ? ExtractText.class$("multivalent.Span") : class$multivalent$Span) != (vObject = this.stack_.get(i)).getClass() || ((Span)vObject).getName() != "font") continue;
                    this.feature(14, vObject);
                    break;
                }
            }
            if (!context2.underline.equals(context.underline)) {
                this.feature(14, SPAN_UNDERLINE);
            }
            if ((context2.flags & 0x40) != 0 && (context.flags & 0x40) == 0) {
                this.feature(14, SPAN_ITALIC);
            }
            if (context2.weight >= 700 && context.weight < 700) {
                this.feature(14, SPAN_BOLD);
            }
        }
        if ("open".equals(string) || "both".equals(string)) {
            if (context2.weight < 700 && context.weight >= 700) {
                this.feature(13, SPAN_BOLD);
            }
            if ((context2.flags & 0x40) == 0 && (context.flags & 0x40) != 0) {
                this.feature(13, SPAN_ITALIC);
            }
            if (context.underline != Context.COLOR_INVALID && !context.underline.equals(context2.underline)) {
                this.feature(13, SPAN_UNDERLINE);
            }
            if (bl) {
                Span span = new Span();
                span.setName("font");
                if (context.family != null && !context.family.equals("Times") && !context.family.equals("Times-Roman")) {
                    span.putAttr("face", context.family);
                }
                if (context.size != 12.0f) {
                    span.putAttr("size", Float.toString(context.size));
                }
                if (context.foreground != null && !Color.BLACK.equals(context.foreground)) {
                    span.putAttr("color", Colors.getName(context.foreground));
                }
                if (context.background != null && !Color.WHITE.equals(context.background)) {
                    span.putAttr("background-color", Colors.getName(context.background));
                }
                if (span.hasAttributes()) {
                    this.feature(13, span);
                }
            }
        }
        if (!"close".equals(string)) {
            this.styleNode_ = node;
            this.styleOffset_ = n;
            this.styleContext_ = context;
        }
        this.fstyle_ = true;
        this.fspan_ = false;
    }

    private void indent(int n, StringBuffer stringBuffer) {
        String string = this.tab_;
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(string);
        }
    }

    public int commandLine(String[] stringArray) {
        String string;
        int n;
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).startsWith("-"); ++n) {
            if ((string = string.toLowerCase()).startsWith("--")) {
                string = string.substring(1);
            }
            if ((string.startsWith("-out") || string.startsWith("-format")) && n + 1 < n2) {
                if ((string = stringArray[++n].toLowerCase()).startsWith("uni") || string.equals("text")) {
                    this.setFormat(FORMAT_UNICODE);
                    continue;
                }
                if (string.startsWith("doc") || string.startsWith("tree") || string.equals("dump")) {
                    this.setFormat(FORMAT_TREE);
                    continue;
                }
                if (string.equals("xml")) {
                    this.setFormat(FORMAT_XML);
                    continue;
                }
                System.err.println("Unknown output format: " + string);
                System.err.println(USAGE);
                System.exit(1);
                continue;
            }
            if (string.startsWith("-span")) {
                this.setSpan(true);
                continue;
            }
            if (string.startsWith("-lay") || string.startsWith("-bbox")) {
                this.setBbox(true);
                continue;
            }
            if (string.startsWith("-link")) {
                this.setLinks(true);
                continue;
            }
            if (string.startsWith("-style")) {
                this.setStyle(true);
                continue;
            }
            if (string.startsWith("-indent")) {
                this.setIndent(stringArray[++n]);
                continue;
            }
            if (string.startsWith("-pass") || string.startsWith("-owner")) {
                this.setPassword(stringArray[++n]);
                continue;
            }
            if (string.startsWith("-verb")) {
                this.fverbose_ = true;
                this.fquiet_ = false;
                continue;
            }
            if (string.startsWith("-mon")) {
                this.fverbose_ = true;
                this.fmonitor_ = true;
                this.fquiet_ = false;
                continue;
            }
            if (string.equals("-test")) {
                this.ftest_ = true;
                continue;
            }
            if (string.startsWith("-q")) {
                this.fquiet_ = true;
                this.fmonitor_ = false;
                this.fverbose_ = false;
                continue;
            }
            if (string.startsWith("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (string.startsWith("-h")) {
                System.out.println(USAGE);
                System.exit(0);
                continue;
            }
            System.err.println("Unknown option: " + string);
            System.err.println(USAGE);
            System.exit(1);
        }
        return n;
    }

    public static void main(String[] stringArray) throws Exception {
        long l = System.currentTimeMillis();
        ExtractText extractText = new ExtractText();
        URI uRI = new File(".").getCanonicalFile().toURI();
        int n = 0;
        long l2 = 0L;
        long l3 = 0L;
        int n2 = stringArray.length;
        for (int i = extractText.commandLine(stringArray); i < n2; ++i) {
            Serializable serializable;
            String string = stringArray[i];
            if (extractText.fmonitor_) {
                System.err.println(string);
            }
            Iterator<File> iterator = null;
            if (string.startsWith("@") || Files.getFile(string).canRead()) {
                iterator = new FileList(string, null).iterator();
            } else {
                serializable = new ArrayList<URI>(1);
                serializable.add(uRI.resolve(string));
                iterator = serializable.iterator();
            }
            while (iterator.hasNext()) {
                try {
                    serializable = iterator.next();
                    String string2 = extractText.extract(InputUni.getInstance(serializable, null, null));
                    System.out.println(string2);
                    ++n;
                    if (serializable instanceof File) {
                        l2 += ((File)serializable).length();
                    }
                    l3 += (long)string2.length();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        long l4 = System.currentTimeMillis();
        System.err.println(n + " documents, length = " + l2 + " => " + l3 + ", in " + (double)(l4 - l) / 1000.0 + " sec");
        System.exit(0);
    }

    static {
        $assertionsDisabled = !ExtractText.class.desiredAssertionStatus();
        FORMAT_TREE = new String("tree");
        FORMAT_UNICODE = new String("Unicode");
        FORMAT_XML = new String("XML");
        SPAN_BOLD = new Span();
        SPAN_ITALIC = new Span();
        SPAN_UNDERLINE = new Span();
        SPAN_BOLD.setName("b");
        SPAN_ITALIC.setName("i");
        SPAN_UNDERLINE.setName("u");
    }
}

