/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import multivalent.Behavior;
import multivalent.DocInfo;
import multivalent.Document;
import multivalent.ESISNode;
import multivalent.INode;
import multivalent.Layer;
import multivalent.Leaf;
import multivalent.Node;
import multivalent.SemanticEvent;
import multivalent.Span;
import multivalent.node.LeafText;
import multivalent.std.span.BoxSpan;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Autosearch
extends Behavior {
    public static final String ATTR_REGEX = "regex";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_URI = "uri";
    public static final String ATTR_TAG = "tag";
    static final Pattern TYPES = Pattern.compile("(?i)default|box", 2);
    Pattern pat_ = null;
    String type_ = null;
    Pattern uripat_ = null;
    String tag_ = "autosearch";

    @Override
    public boolean semanticEventBefore(SemanticEvent semanticEvent, String string) {
        if (super.semanticEventBefore(semanticEvent, string)) {
            return true;
        }
        if (("openedDocument" == string || "openedDocumentPage" == string) && this.pat_ != null) {
            DocInfo docInfo = (DocInfo)semanticEvent.getArg();
            Document document = docInfo.doc;
            if (this.uripat_ == null || this.uripat_.matcher(docInfo.uri.toString()).find()) {
                Layer layer = document.getLayer("<scratch>");
                this.searchSubtree(document, this.pat_.matcher(""), layer);
            }
        }
        return false;
    }

    int searchSubtree(INode iNode, Matcher matcher, Layer layer) {
        int n = 0;
        int n2 = iNode.size();
        for (int i = 0; i < n2; ++i) {
            Node node = iNode.childAt(i);
            if (node.isStruct()) {
                n += this.searchSubtree((INode)node, matcher, layer);
                continue;
            }
            if (!(node instanceof LeafText)) continue;
            matcher.reset(node.getName());
            if (!matcher.find()) continue;
            Span span = null;
            span = "box" == this.type_ ? (BoxSpan)Behavior.getInstance(this.tag_, "multivalent.std.span.BoxSpan", null, layer) : (Span)Behavior.getInstance(this.tag_, "multivalent.Span", null, layer);
            span.moveq((Leaf)node, matcher.start(), (Leaf)node, matcher.end());
            ++n;
        }
        return n;
    }

    @Override
    public void restore(ESISNode eSISNode, Map<String, Object> map, Layer layer) {
        super.restore(eSISNode, map, layer);
        String string = this.getAttr(ATTR_REGEX);
        if (string != null) {
            try {
                this.pat_ = Pattern.compile(string);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                System.err.println(new StringBuffer().append("bad regexp: ").append(string).toString());
            }
        }
        if ((string = this.getAttr(ATTR_TYPE)) != null && TYPES.matcher(string).matches()) {
            this.type_ = string.toLowerCase().intern();
        }
        if ((string = this.getAttr(ATTR_URI)) != null) {
            try {
                this.uripat_ = Pattern.compile(string);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                System.err.println(new StringBuffer().append("bad URI regexp: ").append(string).toString());
            }
        }
        this.tag_ = this.getAttr(ATTR_TAG, "autosearch").toLowerCase();
    }
}

