/*
 * Decompiled with CFR 0.152.
 */
package multivalent.gui;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.Map;
import java.util.TimerTask;
import multivalent.Browser;
import multivalent.Context;
import multivalent.EventListener;
import multivalent.INode;
import multivalent.IScrollPane;
import multivalent.Leaf;
import phelps.lang.Maths;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VScrollbar
extends Leaf
implements EventListener {
    public static final byte SHOW_NEVER = 0;
    public static final byte SHOW_AS_NEEDED = 1;
    public static final byte SHOW_ALWAYS = 2;
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    public static final int NOWHERE = 0;
    public static final int TOPARROW = 1;
    public static final int TOPTROUGH = 2;
    public static final int NIB = 3;
    public static final int BOTTOMTROUGH = 4;
    public static final int BOTTOMARROW = 5;
    static final int FAR = 500;
    static final int FUZZ = 50;
    public static int SIZE;
    static int arrowH;
    private static int y0_;
    private static int val0_;
    private static int partID_;
    private static EventListener oldgrab_;
    private boolean active_ = false;
    int lineInc_ = 5;
    int blockInc_ = 10;
    int orientation_ = 0;
    int val_ = 0;
    int min_ = 0;
    int max_ = 100;
    int sh_ = this.max_ - this.min_;
    int sbh_ = 0;
    int esbh_ = 0;
    int nibh_ = 0;
    byte show_ = 1;
    private TimerTask tt = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$multivalent$gui$VScrollbar;

    public VScrollbar(int n) {
        this(n == 0 ? "vscrollbar" : "hscrollbar", null, null, n);
    }

    public VScrollbar(String string, Map<String, Object> map, INode iNode, int n) {
        super(string, map, iNode);
        this.orientation_ = n;
        if (!($assertionsDisabled || n >= 0 && n <= 1)) {
            throw new AssertionError();
        }
    }

    public void setMinMax(int n, int n2) {
        if (!$assertionsDisabled && n > n2) {
            throw new AssertionError();
        }
        this.min_ = n;
        this.max_ = n2;
        this.sh_ = Math.max(this.max_ - this.min_, 1);
        this.computeValues();
    }

    public int getMin() {
        return this.min_;
    }

    public int getMax() {
        return this.max_;
    }

    public int getValue() {
        return this.val_;
    }

    public void setShowPolicy(byte by) {
        if (!($assertionsDisabled || by >= 0 && by <= 2)) {
            throw new AssertionError();
        }
        this.show_ = by;
    }

    public byte getShowPolicy() {
        return this.show_;
    }

    public void setValue(int n, boolean bl) {
        if (!this.isValid()) {
            this.val_ = Maths.minmax(this.min_, n, this.max_);
        } else {
            if (bl && this.sh_ > this.sbh_) {
                int n2 = this.val_;
                int n3 = this.val_ + this.sbh_;
                n = n < n2 - 500 || n > n3 + 500 ? (n -= this.sbh_ / 2) : (n - 50 < n2 ? (n -= 50) : (n + 50 > n3 ? (n += 50 - this.sbh_) : n2));
            }
            if (this.val_ != (n = Math.max(this.min_, Math.min(n, this.max_ - this.sbh_)))) {
                this.val_ = n;
                IScrollPane iScrollPane = this.getIScrollPane();
                if (iScrollPane.isValid()) {
                    iScrollPane.repaint(250L);
                }
            }
        }
    }

    public void setValue(int n) {
        this.setValue(n, false);
    }

    public int getBlockIncrement() {
        return this.blockInc_;
    }

    public int getLineIncrement() {
        return this.lineInc_;
    }

    @Override
    public boolean formatNode(int n, int n2, Context context) {
        int n3 = 2 * arrowH + 10;
        this.valid_ = true;
        if (n == 0 || n2 == 0) {
            this.bbox.setSize(0, 0);
        } else {
            if (this.orientation_ == 0) {
                this.sbh_ = Math.max(n2, n3);
                this.bbox.setSize(SIZE, this.sbh_);
            } else {
                this.sbh_ = Math.max(n, n3);
                this.bbox.setSize(this.sbh_, SIZE);
            }
            this.esbh_ = this.sbh_ - 2 * arrowH;
            this.computeValues();
        }
        return !this.valid_;
    }

    private void computeValues() {
        if (this.isValid() && this.sh_ > 0) {
            if (this.sh_ <= this.sbh_) {
                this.nibh_ = this.esbh_;
                this.blockInc_ = 0;
                this.lineInc_ = 0;
                this.val_ = this.min_;
            } else {
                this.nibh_ = this.esbh_ * this.sbh_ / this.sh_;
                this.lineInc_ = Math.max(this.sbh_ / 10, 10);
                this.blockInc_ = Math.max(this.sbh_ - this.lineInc_, 0);
                this.val_ = Math.max(this.min_, Math.min(this.val_, this.max_ - this.sbh_));
            }
        }
    }

    @Override
    public boolean paintNodeContent(Context context, int n, int n2) {
        if (this.show_ == 0 || this.show_ == 1 && this.nibh_ == this.esbh_) {
            return true;
        }
        int n3 = this.bbox.width;
        int n4 = this.bbox.height;
        Graphics2D graphics2D = context.g;
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, n3, n4);
        graphics2D.setStroke(Context.STROKE_DEFAULT);
        graphics2D.setColor(Color.BLACK);
        if (this.orientation_ == 0) {
            int n5 = n3 / 2;
            int n6 = n4 - arrowH;
            graphics2D.drawLine(n5, 0, 0, arrowH);
            graphics2D.drawLine(0, arrowH, n3, arrowH);
            graphics2D.drawLine(n3, arrowH, n5, 0);
            graphics2D.drawLine(n5, n4, 0, n6);
            graphics2D.drawLine(0, n6, n3, n6);
            graphics2D.drawLine(n3, n6, n5, n4);
            graphics2D.drawLine(n5, arrowH, n5, n6);
            graphics2D.drawLine(n5 + 1, arrowH, n5 + 1, n6);
            graphics2D.setColor(Color.LIGHT_GRAY);
            graphics2D.fill3DRect(n5 - arrowH / 2, this.val_ * this.esbh_ / this.sh_ + arrowH + 1, arrowH + 1, Math.max(this.nibh_, 5), true);
        } else {
            int n7 = n4 / 2;
            int n8 = n3 - arrowH;
            graphics2D.drawLine(0, n7, arrowH, 0);
            graphics2D.drawLine(arrowH, 0, arrowH, n4);
            graphics2D.drawLine(arrowH, n4, 0, n7);
            graphics2D.drawLine(n3, n7, n8, 0);
            graphics2D.drawLine(n8, 0, n8, n4);
            graphics2D.drawLine(n8, n4, n3, n7);
            graphics2D.drawLine(arrowH, n7, n8, n7);
            graphics2D.drawLine(arrowH, n7 + 1, n8, n7 + 1);
            graphics2D.setColor(Color.LIGHT_GRAY);
            graphics2D.fill3DRect(this.val_ * this.esbh_ / this.sh_ + arrowH + 1, n7 - arrowH / 2, Math.max(this.nibh_, 5), arrowH + 1, true);
        }
        return true;
    }

    @Override
    public boolean eventNode(AWTEvent aWTEvent, Point point) {
        int n;
        if (this.val_ <= this.min_ && this.val_ + this.sbh_ >= this.max_ || point == null) {
            return false;
        }
        int n2 = n = this.orientation_ == 0 ? point.y : point.x;
        if (aWTEvent.getID() == 501) {
            Browser browser = this.getBrowser();
            oldgrab_ = browser.getGrab();
            if (oldgrab_ != null) {
                browser.releaseGrab(oldgrab_);
            }
            browser.setGrab(this);
            partID_ = this.idLocation(point);
            switch (partID_) {
                case 1: {
                    this.setValue(this.val_ - this.lineInc_);
                    break;
                }
                case 5: {
                    this.setValue(this.val_ + this.lineInc_);
                    break;
                }
                case 2: {
                    this.setValue(this.val_ - this.blockInc_);
                    break;
                }
                case 4: {
                    this.setValue(this.val_ + this.blockInc_);
                    break;
                }
                case 3: {
                    y0_ = n;
                    val0_ = this.val_;
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError(partID_);
                    }
                    break;
                }
            }
        } else {
            return false;
        }
        this.active_ = true;
        this.tt = new TimerTask(){

            public void run() {
                switch (partID_) {
                    case 1: {
                        VScrollbar.this.setValue(VScrollbar.this.val_ - VScrollbar.this.lineInc_);
                        break;
                    }
                    case 5: {
                        VScrollbar.this.setValue(VScrollbar.this.val_ + VScrollbar.this.lineInc_);
                        break;
                    }
                    case 2: {
                        VScrollbar.this.setValue(VScrollbar.this.val_ - VScrollbar.this.blockInc_);
                        break;
                    }
                    case 4: {
                        VScrollbar.this.setValue(VScrollbar.this.val_ + VScrollbar.this.blockInc_);
                        break;
                    }
                }
            }
        };
        this.getGlobal().getTimer().schedule(this.tt, 1000L, 100L);
        return true;
    }

    @Override
    public void event(AWTEvent aWTEvent) {
        Browser browser = this.getBrowser();
        Point point = this.getAbsLocation();
        Point point2 = browser.getCurScrn();
        int n = (this.orientation_ == 0 ? point2.y - point.y : point2.x - point.x) - this.getValue();
        int n2 = aWTEvent.getID();
        if (n2 == 506) {
            if (partID_ == 3) {
                this.setValue(val0_ + (n - y0_) * this.sh_ / this.esbh_);
            }
        } else if (n2 == 502) {
            this.tt.cancel();
            browser.releaseGrab(this);
            if (oldgrab_ != null) {
                browser.setGrab(oldgrab_);
            }
            partID_ = 0;
            this.active_ = false;
        }
    }

    public int idLocation(Point point) {
        int n;
        int n2;
        if (this.orientation_ == 0) {
            n2 = point.y;
            n = this.bbox.height;
        } else {
            n2 = point.x;
            n = this.bbox.width;
        }
        int n3 = 0;
        n3 = n2 <= arrowH ? 1 : (n2 >= n - arrowH ? 5 : (n2 < this.val_ * this.esbh_ / this.sh_ ? 2 : (n2 > this.val_ * this.esbh_ / this.sh_ + this.nibh_ ? 4 : 3)));
        return n3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        $assertionsDisabled = !(class$multivalent$gui$VScrollbar == null ? (class$multivalent$gui$VScrollbar = VScrollbar.class$("multivalent.gui.VScrollbar")) : class$multivalent$gui$VScrollbar).desiredAssertionStatus();
        SIZE = 15;
        arrowH = 10;
        partID_ = 0;
        oldgrab_ = null;
    }
}

