/*
 * Decompiled with CFR 0.152.
 */
package multivalent.gui;

import com.pt.awt.NFont;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.util.Map;
import multivalent.Browser;
import multivalent.Context;
import multivalent.DocInfo;
import multivalent.Document;
import multivalent.EventListener;
import multivalent.INode;
import multivalent.Leaf;
import multivalent.SemanticEvent;
import phelps.lang.Booleans;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VFrame
extends INode
implements EventListener {
    public static final String MSG_RESIZED = "frameResized";
    public static final String MSG_MOVED = "frameMoved";
    public static final String MSG_CLOSED = "frameClosed";
    public static final String MSG_RAISED = "frameRaised";
    public static final String PREF_VANISHING = "vanishingTitle";
    public static final int WIDTH_MIN = 75;
    public static final int HEIGHT_MIN = 40;
    static NFont FONT_TITLE = NFont.getInstance("Dialog", 700, 2, 12.0f);
    static int titleh = (int)FONT_TITLE.getHeight() + 2 + 1;
    String title_ = null;
    boolean pinned_ = true;
    public boolean resizable = true;
    public boolean lampshade = false;
    private boolean in_ = true;
    private Point p0_;
    private Rectangle bbox0_ = new Rectangle();
    private boolean resizelens_ = false;
    private boolean movelens_ = false;
    private boolean metagrab_ = false;

    public VFrame(String string, Map<String, Object> map, INode iNode) {
        super(string, map, iNode);
        if (iNode != null && iNode == this.getDocument()) {
            this.setPinned(this.pinned_);
        }
        this.setBounds(100, 100, 300, 200);
    }

    public VFrame(String string, Map<String, Object> map, INode iNode, URI uRI) {
        this(string, map, iNode);
        Browser browser = this.getBrowser();
        if (browser != null && uRI != null) {
            try {
                Document document = new Document("content", null, this);
                DocInfo docInfo = new DocInfo(uRI);
                docInfo.doc = document;
                browser.event(new SemanticEvent(browser, "openDocument", docInfo));
                this.getDocument().repaint(100L);
            }
            catch (Exception exception) {
                System.err.println("can't create document");
                exception.printStackTrace();
            }
        }
    }

    public String getTitle() {
        if (this.title_ != null) {
            return this.title_;
        }
        Leaf leaf = this.getFirstLeaf();
        if (leaf != null) {
            return leaf.getName();
        }
        return "";
    }

    public void setTitle(String string) {
        this.title_ = string;
        this.repaint(100L, 0, 0, this.bbox.width, titleh);
    }

    public void setIn(boolean bl) {
        this.in_ = bl;
    }

    public Rectangle getContentBounds() {
        Rectangle rectangle = new Rectangle(this.bbox.x, this.bbox.y + titleh, this.bbox.width, this.bbox.height - titleh);
        if (this.lampshade) {
            rectangle.setSize(0, 0);
        }
        return rectangle;
    }

    public boolean isPinned() {
        return this.pinned_;
    }

    public void setPinned(boolean bl) {
        Document document = this.getDocument();
        if (document != null) {
            if (this.pinned_ != bl) {
                int n = document.getHsb().getValue();
                int n2 = document.getVsb().getValue();
                if (bl) {
                    this.bbox.translate(n, n2);
                } else {
                    this.bbox.translate(-n, -n2);
                }
            }
            this.remove();
            INode iNode = document.getVisualLayer(bl ? "multivalent.node.IRootAbs" : "multivalent.node.IRootScreen");
            iNode.appendChild(this);
            this.pinned_ = bl;
            document.repaint(100L);
        }
    }

    public void raise() {
        INode iNode = this.getParentNode();
        if (iNode != null && iNode.getLastChild() != this) {
            Document document;
            iNode.removeChild(this);
            iNode.appendChild(this);
            Browser browser = this.getBrowser();
            if (browser != null) {
                browser.eventq(MSG_RAISED, this);
            }
            if ((document = this.getDocument()) != null) {
                document.repaint(100L);
            }
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.setLocation(n, n2);
        this.setSize(n3, n4);
    }

    public void setSize(int n, int n2) {
        if (n != this.bbox.width || n2 != this.bbox.height) {
            int n3 = Math.max(this.bbox.width, n);
            int n4 = Math.max(this.bbox.height, n2);
            this.bbox.width = Math.max(n, 75);
            this.bbox.height = Math.max(n2, 40);
            this.markDirtySubtree(false);
            Browser browser = this.getBrowser();
            if (browser != null) {
                browser.eventq(MSG_RESIZED, this);
            }
            this.repaint(100L, 0, 0, n3, n4);
        }
    }

    public void setLocation(int n, int n2) {
        this.bbox.setLocation(Math.max(0, n), Math.max(0, n2));
        this.markDirty();
        Browser browser = this.getBrowser();
        if (browser != null) {
            browser.eventq(MSG_MOVED, this);
            browser.repaint(100L);
        }
    }

    public void close() {
        Browser browser = this.getBrowser();
        browser.eventq(MSG_CLOSED, this);
        browser.repaint(100L);
        this.remove();
    }

    @Override
    public boolean formatNode(int n, int n2, Context context) {
        int n3;
        Rectangle rectangle = new Rectangle(this.bbox);
        boolean bl = super.formatNode(this.bbox.width, this.bbox.height - titleh, context);
        int n4 = Integer.MAX_VALUE;
        int n5 = this.size();
        for (n3 = 0; n3 < n5; ++n3) {
            n4 = Math.min(n4, this.childAt((int)n3).bbox.y);
        }
        n3 = titleh - n4;
        int n6 = this.size();
        for (n5 = 0; n5 < n6; ++n5) {
            this.childAt((int)n5).bbox.y += n3;
        }
        this.bbox.setBounds(rectangle);
        return bl;
    }

    @Override
    public void paintNode(Rectangle rectangle, Context context) {
        int n;
        if (!this.lampshade) {
            super.paintNode(rectangle, context);
        }
        if (!this.in_ && !this.lampshade) {
            return;
        }
        Graphics2D graphics2D = context.g;
        int n2 = this.bbox.width - 28 - 1;
        graphics2D.setColor(Color.LIGHT_GRAY);
        graphics2D.fill3DRect(0, 0, this.bbox.width - 1, titleh, true);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawRect(0, 0, this.bbox.width - 1, titleh);
        String string = this.getTitle();
        int n3 = (int)FONT_TITLE.stringAdvance(string).getX();
        FONT_TITLE.drawString(graphics2D, this.getTitle(), 5.0f, FONT_TITLE.getAscent() + 2.0f);
        for (n = 0; n < titleh; n += 6) {
            graphics2D.drawLine(n3 + 7, n, n2 - 2, n);
        }
        graphics2D.setColor(Color.LIGHT_GRAY);
        graphics2D.fillRect(this.bbox.width - 14 - 1, 2, 14, titleh - 4);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawRect(this.bbox.width - 12 - 1, (titleh - 10) / 2, 10, 10);
        graphics2D.setColor(Color.LIGHT_GRAY);
        graphics2D.fillRect(n2, 2, 14, titleh - 4);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawRect(n2 + 2, (titleh - 10) / 2, 10, 10);
        graphics2D.drawRect(n2 + 2, (titleh - 10) / 2 + 4, 10, 2);
        if (this.resizable && !this.lampshade) {
            n = this.bbox.width - 2;
            int n4 = this.bbox.height - 2;
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawLine(n - 10, n4, n, n4 - 10);
            graphics2D.drawLine(n - 5, n4, n, n4 - 5);
        }
    }

    @Override
    public boolean eventBeforeAfter(AWTEvent aWTEvent, Point point) {
        int n = aWTEvent.getID();
        if (n == 504) {
            this.in_ = true;
            this.repaint(100L);
        } else if (n == 505 && Booleans.parseBoolean(this.getGlobal().getPreference(PREF_VANISHING, "true"), true)) {
            this.in_ = false;
            this.repaint(1000L);
        }
        return super.eventBeforeAfter(aWTEvent, point);
    }

    @Override
    public boolean eventNode(AWTEvent aWTEvent, Point point) {
        Browser browser = this.getBrowser();
        int n = aWTEvent.getID();
        if (n == 501 && (((MouseEvent)aWTEvent).getModifiers() & 0x10) != 0) {
            int n2 = point.x;
            int n3 = point.y;
            if (n3 < titleh) {
                this.metagrab_ = true;
                if (n2 > this.bbox.width - 15) {
                    this.close();
                } else if (n2 > this.bbox.width - 26) {
                    this.lampshade = !this.lampshade;
                    this.repaint(100L);
                } else {
                    this.movelens_ = true;
                }
            } else if (this.lampshade) {
                return true;
            }
            boolean bl = this.resizelens_ = this.resizable && n2 > this.bbox.width - 10 && n3 > this.bbox.height - 10;
        }
        if (this.metagrab_ || this.movelens_ || this.resizelens_) {
            this.p0_ = browser.getCurScrn();
            this.bbox0_.setBounds(this.bbox);
            if (this.movelens_ && 500 <= n && n <= 507 && !((MouseEvent)aWTEvent).isAltDown()) {
                this.raise();
            }
            browser.setCurNode(this, 0);
            browser.setGrab(this);
        } else {
            super.eventNode(aWTEvent, point);
        }
        return true;
    }

    @Override
    public void event(AWTEvent aWTEvent) {
        int n = aWTEvent.getID();
        Browser browser = this.getBrowser();
        if (n == 506) {
            Point point = browser.getCurScrn();
            int n2 = point.x - this.p0_.x;
            int n3 = point.y - this.p0_.y;
            int n4 = Math.abs(n2);
            int n5 = Math.abs(n3);
            if (n4 > 10 && n5 <= 5) {
                n3 = 0;
            } else if (n4 <= 5 && n5 > 10) {
                n2 = 0;
            }
            if (this.resizelens_) {
                this.setSize(this.bbox0_.width + n2, this.bbox0_.height + n3);
            } else if (this.movelens_) {
                this.setLocation(this.bbox0_.x + n2, this.bbox0_.y + n3);
            }
        } else if (n == 502) {
            this.resizelens_ = false;
            this.movelens_ = false;
            browser.releaseGrab(this);
            this.metagrab_ = false;
        }
    }
}

