/*
 * Decompiled with CFR 0.152.
 */
package com.pt.io;

import com.pt.io.RandomAccess;
import java.io.IOException;
import java.io.InputStream;
import phelps.io.InputStreams;
import phelps.lang.Maths;
import phelps.util.Arrayss;

public class RandomAccessByteArray
implements RandomAccess {
    private String mode_;
    private byte[] buf_;
    private long pos_ = 0L;
    private long length_;
    private long fp0_ = 0L;
    private long length0_ = Long.MAX_VALUE;
    static final /* synthetic */ boolean $assertionsDisabled;

    public RandomAccessByteArray(byte[] byArray, String string) {
        this.buf_ = byArray;
        this.length_ = byArray.length;
        this.mode_ = string;
    }

    public RandomAccessByteArray(InputStream inputStream, String string) throws IOException {
        this(InputStreams.toByteArray(inputStream, 32768L), string);
    }

    public RandomAccessByteArray(long l) {
        this.length_ = 0L;
        this.buf_ = new byte[Math.max((int)l, 1024)];
        this.mode_ = "rw";
    }

    private void resize(long l) {
        if (l != (long)this.buf_.length) {
            byte[] byArray = new byte[(int)l];
            System.arraycopy(this.buf_, 0, byArray, 0, (int)Math.min((long)this.buf_.length, l));
            this.buf_ = byArray;
        }
    }

    public int read() {
        return this.getFilePointer() < this.length() ? this.buf_[(int)this.pos_++] & 0xFF : -1;
    }

    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) {
        if (!($assertionsDisabled || byArray != null && n >= 0 && n2 >= 0 && n2 + n <= byArray.length)) {
            throw new AssertionError();
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.getFilePointer() >= this.length()) {
            return -1;
        }
        n2 = Math.min(n2, (int)(this.length() - this.getFilePointer()));
        System.arraycopy(this.buf_, (int)this.pos_, byArray, n, n2);
        this.pos_ += (long)n2;
        return n2;
    }

    public void readFully(byte[] byArray) {
        this.read(byArray);
    }

    public void readFully(byte[] byArray, int n, int n2) {
        this.read(byArray, n, n2);
    }

    public void writeString8(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.write(string.charAt(i));
        }
    }

    public void writeString16(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.writeChar(string.charAt(i));
        }
    }

    public void writeChar(char c) throws IOException {
        this.write(c >> 8);
        this.write(c);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.mode_.indexOf("w") == -1) {
            throw new IOException("File not opened for writing");
        }
        if (!($assertionsDisabled || byArray != null && n >= 0 && n2 >= 0 && n + n2 <= byArray.length)) {
            throw new AssertionError();
        }
        long l = Math.max(this.getFilePointer() + (long)n2, this.length());
        if (l > (long)this.buf_.length) {
            this.resize(Math.max(this.length() * 2L, 5120L));
            this.length_ = l;
        }
        System.arraycopy(byArray, n, this.buf_, (int)this.pos_, n2);
        this.pos_ += (long)n2;
    }

    public void write(int n) throws IOException {
        if (this.mode_.indexOf("w") == -1) {
            throw new IOException("File not opened for writing");
        }
        if (this.getFilePointer() + 1L > (long)this.buf_.length) {
            this.resize(Math.max(this.length() + 102400L, 5120L));
            ++this.length_;
        }
        this.buf_[(int)this.pos_++] = (byte)n;
    }

    public long getFilePointer() {
        return this.pos_ - this.fp0_;
    }

    public void setLength(long l) {
        if (!$assertionsDisabled && l < 0L) {
            throw new AssertionError();
        }
        this.resize((int)l);
        this.length_ = l;
    }

    public long length() {
        return this.length0_ == Long.MAX_VALUE ? this.length_ : this.length0_;
    }

    public void seek(long l) {
        this.pos_ = Maths.minmax(0L, this.fp0_ + l, this.fp0_ + this.length());
    }

    public int skipBytes(int n) throws IOException {
        long l = this.getFilePointer();
        this.seek(Math.min(l + (long)n, this.length()));
        return (int)(this.getFilePointer() - l);
    }

    public void slice(long l, long l2) throws IOException {
        l = Maths.minmax(0L, l, this.length_);
        if (l2 < 0L) {
            l2 = this.length_ - l;
        } else if (l > 0L || l2 < Long.MAX_VALUE) {
            l2 = Maths.minmax(0L, l2, this.length_ - l);
        }
        if (l != this.fp0_ || l2 != this.length0_) {
            this.fp0_ = l;
            this.length0_ = l2;
            this.seek(0L);
        }
    }

    public byte[] toByteArray() {
        int n = (int)this.length();
        byte[] byArray = this.fp0_ == 0L && this.buf_.length == n ? this.buf_ : Arrayss.subset(this.buf_, (int)this.fp0_, n);
        this.close();
        return byArray;
    }

    public void close() {
        this.buf_ = null;
    }

    static {
        $assertionsDisabled = !RandomAccessByteArray.class.desiredAssertionStatus();
    }
}

