/*
 * Decompiled with CFR 0.152.
 */
package com.pt.awt.font;

import com.pt.awt.NFont;
import com.pt.awt.font.BitmapRec;
import com.pt.awt.font.CMap;
import com.pt.awt.font.CacheBitmap;
import com.pt.awt.font.CacheGlyph;
import com.pt.awt.font.Encoding;
import com.pt.awt.font.GlyphRec;
import com.pt.awt.font.NFontManager;
import com.pt.awt.font.NFontSimple;
import com.pt.doc.Dict;
import com.pt.doc.PostScript;
import com.pt.io.RandomAccess;
import com.pt.io.RandomAccessByteArray;
import com.pt.lang.UnicodeBlocks;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import phelps.io.InputStreams;
import phelps.lang.Characters;
import phelps.lang.Floats;
import phelps.lang.Integers;
import phelps.lang.Strings;
import phelps.util.Arrayss;

public class NFontType1
extends NFontSimple
implements Cloneable {
    private static final boolean DEBUG = false;
    public static final String COPYRIGHT = "Copyright (c) 2003 - 2005  Thomas A. Phelps.  All rights reserved.";
    public static final String FORMAT = "Type1";
    public static final String FORMAT_CFF = "CFF";
    public static final String SUBFORMAT_PFA = "PFA";
    public static final String SUBFORMAT_PFB_IBM = "PFB/IBM";
    public static final String SUBFORMAT_PFB = "PFB";
    public static final String SUBFORMAT_DECRYPTED = "decrypted";
    public static final String SUBFORMAT_CFF_CID = "CFF/CID";
    public static final int PFB_00_LENGTH;
    private static final int PFB_IBM_ASCII = 1;
    private static final int PFB_IBM_BINARY = 2;
    private static final int PFB_IBM_EOF = 3;
    private static final AffineTransform MATRIX_DEFAULT;
    private static final int CS_HSTEM = 1;
    private static final int CS_VSTEM = 3;
    private static final int CS_VMOVETO = 4;
    private static final int CS_RLINETO = 5;
    private static final int CS_HLINETO = 6;
    private static final int CS_VLINETO = 7;
    private static final int CS_RRCURVETO = 8;
    private static final int CS_CLOSEPATH = 9;
    private static final int CS_CALLSUBR = 10;
    private static final int CS_RETURN = 11;
    private static final int CS_ESCAPE = 12;
    private static final int CS_HSBW = 13;
    private static final int CS_ENDCHAR = 14;
    private static final int CS_HSTEMHM = 18;
    private static final int CS_HINTMASK = 19;
    private static final int CS_CNTRMASK = 20;
    private static final int CS_RMOVETO = 21;
    private static final int CS_HMOVETO = 22;
    private static final int CS_VSTEMHM = 23;
    private static final int CS_RCURVELINE = 24;
    private static final int CS_RLINECURVE = 25;
    private static final int CS_VVCURVETO = 26;
    private static final int CS_HHCURVETO = 27;
    private static final int CS_SHORTINT = 28;
    private static final int CS_CALLGSUBR = 29;
    private static final int CS_VHCURVETO = 30;
    private static final int CS_HVCURVETO = 31;
    private static final int CS_ESC_DX = 32;
    private static final int CS_DIV = 44;
    private static final int CS_DOTSECTION = 32;
    private static final int CS_VSTEM3 = 33;
    private static final int CS_HSTEM3 = 34;
    private static final int CS_SEAC = 38;
    private static final int CS_SBW = 39;
    private static final int CS_CALLOTHERSUBR = 48;
    private static final int CS_POP = 49;
    private static final int CS_SETCURRENTPOINT = 65;
    private static final int CS_AND = 35;
    private static final int CS_OR = 36;
    private static final int CS_NOT = 37;
    private static final int CS_ABS = 41;
    private static final int CS_ADD = 42;
    private static final int CS_SUB = 43;
    private static final int CS_NEG = 46;
    private static final int CS_EQ = 47;
    private static final int CS_DROP = 50;
    private static final int CS_PUT = 52;
    private static final int CS_GET = 53;
    private static final int CS_IFELSE = 54;
    private static final int CS_RANDOM = 55;
    private static final int CS_MUL = 56;
    private static final int CS_SQRT = 58;
    private static final int CS_DUP = 59;
    private static final int CS_EXCH = 60;
    private static final int CS_INDEX = 61;
    private static final int CS_ROLL = 62;
    private static final int CS_HFLEX = 66;
    private static final int CS_FLEX = 67;
    private static final int CS_HFLEX1 = 68;
    private static final int CS_FLEX1 = 69;
    private static final String[] CS_NAME;
    private static final int R_EEXEC = 55665;
    private static final int R_CHARSTRING = 4330;
    private static final int C1 = 52845;
    private static final int C2 = 22719;
    private static final String[] CFF_SID;
    private static final int[] CHARSET_EXPERT;
    private static final int[] CHARSET_EXPERT_SUBSET;
    private static final String[] CFF_EXPERT_MAP;
    private static final Encoding CFF_ENCODING_STANDARD;
    private static final Encoding CFF_ENCODING_EXPERT;
    private static final String[] CFF_FLOAT;
    private static final String[] CFF_KEYS;
    private static final String[] FONTINFO_KEYS;
    private static final Object TYPE_DELTA;
    private static final Object TYPE_SID;
    private static final Object[] CFF_TOP_NORM;
    private static final Object[] CFF_PRIVATE_NORM;
    private static final Rectangle2D BBOX_MISSING;
    private static final float WIDTH_INVALID = Float.MIN_VALUE;
    private static final Random rand_;
    private NFontType1 ur_;
    private RandomAccess ra_ = null;
    private long raoff_;
    private Dict dict_;
    private byte[][][] subrs_;
    private byte[][] gsubrs_;
    private int gbias_;
    private byte[][] charstrings_;
    private int[] charstringsoff_;
    private String format_;
    private String subformat_;
    private int rights_;
    private int hint_ = -1;
    private int charstringType_;
    private int lenIV_;
    private int glyphcnt_;
    private CMap c2g_;
    float[] widths_ = null;
    private Dict[] fd_;
    private int[] fds_ = null;
    private GlyphRec notdef_;
    private int spacech_ = Integer.MIN_VALUE;
    private int flags_;
    private int weight_;
    private UnicodeBlocks[] blocks_ = null;
    private String create_;
    private AffineTransform u_;
    private CacheGlyph gc_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public NFontType1(URL uRL) throws FontFormatException, IOException {
        super(uRL);
        this.parse(InputStreams.toByteArray(uRL.openStream(), 102400L));
    }

    NFontType1(URL uRL, int n, int n2) throws FontFormatException, IOException {
        super(uRL);
        this.ur_ = this;
        this.raoff_ = n;
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError();
        }
        this.format_ = "OpenType";
        this.subformat_ = "none";
        this.getRA();
        if (!$assertionsDisabled && this.ra_.getFilePointer() != 0L) {
            throw new AssertionError();
        }
        if ((long)n2 < 102400L) {
            this.ra_.seek(this.raoff_);
            byte[] byArray = new byte[n2];
            this.ra_.readFully(byArray);
            this.ra_.close();
            this.releaseRA();
            this.ra_ = new RandomAccessByteArray(byArray, "r");
            this.raoff_ = 0L;
        }
        this.parseCFF();
        if (this.ra_ instanceof RandomAccessByteArray) {
            this.ra_ = null;
        } else {
            this.releaseRA();
        }
    }

    public NFontType1(URL uRL, byte[] byArray) throws FontFormatException, IOException {
        super(uRL);
        this.parse(byArray);
    }

    private void parse(byte[] byArray) throws FontFormatException, IOException {
        if (!($assertionsDisabled || byArray != null && byArray.length >= 10)) {
            throw new AssertionError();
        }
        this.ur_ = this;
        this.format_ = FORMAT;
        int n = byArray[0] & 0xFF;
        int n2 = byArray[3] & 0xFF;
        if (0 <= n && n <= 10 && 0 <= n2 && n2 <= 4) {
            this.format_ = FORMAT_CFF;
            this.subformat_ = "none";
        } else if (byArray[0] == -128) {
            this.subformat_ = SUBFORMAT_PFB_IBM;
        } else {
            int n3 = NFontType1.getClen(byArray);
            if (n3 == -1) {
                throw new FontFormatException("not PFB or PFA (maybe Type 3)");
            }
            if (byArray[n3] == 32) {
                this.subformat_ = SUBFORMAT_DECRYPTED;
            } else {
                this.subformat_ = SUBFORMAT_PFA;
                int n4 = n3 + 50;
                for (int i = n3; i < n4; ++i) {
                    if (Characters.isHexDigit((char)byArray[i] & 0xFF)) continue;
                    this.subformat_ = SUBFORMAT_PFB;
                    break;
                }
            }
        }
        this.create_ = null;
        if (FORMAT_CFF == this.format_) {
            this.ra_ = new RandomAccessByteArray(byArray, "r");
            this.raoff_ = 0L;
            this.parseCFF();
            this.ra_ = null;
        } else if ((byArray = NFontType1.normalize(byArray))[0] == 37 && byArray[1] == 33) {
            try {
                this.parsePFB(byArray);
            }
            catch (IOException iOException) {}
        } else {
            throw new FontFormatException("no valid Type 1 font header (%! or 0x80)");
        }
        if (!$assertionsDisabled && this.charstringType_ != 1 && this.charstringType_ != 2) {
            throw new AssertionError(this.charstringType_);
        }
    }

    public NFontType1 deriveFont(float f) {
        NFontType1 nFontType1 = (NFontType1)super.deriveFont(f);
        nFontType1.u_ = new AffineTransform(this.m_);
        nFontType1.u_.scale(f, f);
        nFontType1.u_.concatenate(nFontType1.at_);
        return nFontType1;
    }

    public NFontType1 deriveFont(AffineTransform affineTransform) {
        NFontType1 nFontType1 = (NFontType1)super.deriveFont(affineTransform);
        nFontType1.u_ = new AffineTransform(this.m_);
        nFontType1.u_.scale(nFontType1.size_, nFontType1.size_);
        nFontType1.u_.concatenate(affineTransform);
        return nFontType1;
    }

    public NFontType1 deriveFont(Encoding encoding, CMap cMap) {
        if (encoding == null) {
            encoding = this.ur_.encoding_;
        }
        NFontType1 nFontType1 = (NFontType1)super.deriveFont(encoding, cMap);
        nFontType1.setEncoding(encoding);
        return nFontType1;
    }

    private void setEncoding(Encoding encoding) {
        if (!$assertionsDisabled && encoding == null) {
            throw new AssertionError();
        }
        this.encoding_ = encoding;
        CMap cMap = Encoding.IDENTITY == encoding ? CMap.IDENTITY : this.encoding_.mapTo(this.intrinsic_);
        this.setCID(cMap);
    }

    private void setCID(CMap cMap) {
        this.c2g_ = cMap;
        this.spacech_ = Integer.MIN_VALUE;
    }

    private void getRA() throws IOException {
        if (this.ra_ == null) {
            if (!$assertionsDisabled && this.getSource() == null) {
                throw new AssertionError();
            }
            this.ra_ = NFontType1.getMultiplex().getRA(this, this.getSource());
        }
    }

    void releaseRA() {
        if (this.ra_ != null) {
            NFontType1.getMultiplex().releaseRA(this.ra_);
            this.ra_ = null;
        }
    }

    public NFontType1 deriveFont(String string, boolean[] blArray) {
        int n;
        if (FORMAT_CFF == this.getFormat()) {
            throw new UnsupportedOperationException("Type 1 only -- not CFF");
        }
        NFontType1 nFontType1 = this.deriveFont(this.size_);
        nFontType1.charstrings_ = new byte[this.charstrings_.length][];
        int n2 = this.subrs_[0] != null ? this.subrs_[0].length : 0;
        boolean[] blArray2 = new boolean[n2];
        int n3 = blArray.length;
        for (n = 0; n < n3; ++n) {
            if (!blArray[n]) continue;
            char c = this.c2g_.toSelector((char)n);
            nFontType1.charstrings_[c] = this.charstrings_[c];
            if (n2 <= 0) continue;
            this.buildChar(c, new GeneralPath(0), blArray2, null, 0.0f, 0.0f);
        }
        n = this.intrinsic_.getChar(".notdef");
        nFontType1.charstrings_[n] = this.charstrings_[n];
        while (n2 > 4 && !blArray2[n2 - 1]) {
            --n2;
        }
        nFontType1.subrs_ = new byte[1][n2][];
        if (n2 > 0) {
            if (n2 >= 4) {
                System.arraycopy(this.subrs_[0], 0, nFontType1.subrs_[0], 0, 4);
            }
            for (n3 = 4; n3 < n2; ++n3) {
                if (!blArray2[n3]) continue;
                nFontType1.subrs_[0][n3] = this.subrs_[0][n3];
            }
        }
        if (string != null) {
            nFontType1.dict_ = new Dict(this.dict_);
            nFontType1.dict_.put("FontName", string);
        }
        return nFontType1;
    }

    public static int getClen(byte[] byArray) {
        byte by;
        String string = "eexec";
        int n = Arrayss.indexOf(byArray, Strings.getBytes8(string));
        if (n == -1) {
            return -1;
        }
        n += string.length();
        while ((by = byArray[n]) == 13 || by == 10) {
            ++n;
        }
        if (!($assertionsDisabled || n > 0 && byArray.length - n > 0)) {
            throw new AssertionError((Object)(n + ", " + byArray.length));
        }
        return n;
    }

    private void parsePFB(byte[] byArray) throws FontFormatException, IOException {
        Object object;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        PushbackInputStream pushbackInputStream = new PushbackInputStream(byteArrayInputStream, 5);
        Object[] objectArray = new Object[100];
        int n = 0;
        Dict dict = null;
        Dict[] dictArray = new Dict[20];
        int n2 = 0;
        PostScript.eatSpace(pushbackInputStream);
        this.subrs_ = new byte[1][][];
        this.charstrings_ = null;
        this.lenIV_ = 4;
        Encoding encoding = Encoding.IDENTITY;
        this.intrinsic_ = Encoding.IDENTITY;
        boolean bl = true;
        while ((object = PostScript.readObject(pushbackInputStream)) != null) {
            Class<?> clazz = object.getClass();
            if (PostScript.CLASS_COMMENT == clazz) {
                String string;
                int n3;
                if (this.create_ != null || (n3 = (string = new String((char[])object)).indexOf("CreationDate:")) == -1) continue;
                this.create_ = string.substring(n3 + "CreationDate:".length()).trim();
                continue;
            }
            if (PostScript.CLASS_NAME != clazz) {
                objectArray[n++] = object;
                continue;
            }
            if (((String)object).startsWith("/")) {
                if ("/Encoding".equals(object)) {
                    object = PostScript.readObject(pushbackInputStream);
                    if ("StandardEncoding".equals(object)) {
                        PostScript.readObject(pushbackInputStream);
                        encoding = Encoding.ADOBE_STANDARD;
                    } else {
                        Object[] objectArray2 = new String[256];
                        Arrays.fill(objectArray2, ".notdef");
                        while ((object = PostScript.readObject(pushbackInputStream)) != null && !"def".equals(object) && !"readonly".equals(object)) {
                            if (!"dup".equals(object) || PostScript.CLASS_INTEGER != (object = PostScript.readObject(pushbackInputStream)).getClass()) continue;
                            int n4 = ((Number)object).intValue();
                            objectArray2[n4] = Strings.valueOf(((String)PostScript.readObject(pushbackInputStream)).substring(1));
                        }
                        encoding = new Encoding("embedded", (String[])objectArray2);
                        if (Encoding.ADOBE_STANDARD.equals(encoding)) {
                            encoding = Encoding.ADOBE_STANDARD;
                        }
                    }
                    n = 0;
                    continue;
                }
                if ("/Subrs".equals(object)) {
                    int n5 = ((Number)PostScript.readObject(pushbackInputStream)).intValue();
                    this.subrs_[0] = new byte[n5][];
                    int n6 = 0;
                    while (n6 < n5) {
                        object = PostScript.readObject(pushbackInputStream);
                        if ("dup".equals(object)) {
                            int n7 = ((Number)PostScript.readObject(pushbackInputStream)).intValue();
                            this.subrs_[0][n7] = this.RD(pushbackInputStream);
                            ++n6;
                            continue;
                        }
                        if (!"ND".equals(object) && !"|-".equals(object) && !"def".equals(object)) continue;
                    }
                    n = 0;
                    bl = false;
                    continue;
                }
                if ("/CharStrings".equals(object)) {
                    if (!$assertionsDisabled && this.charstrings_ != null) {
                        throw new AssertionError();
                    }
                    int n8 = ((Number)PostScript.readObject(pushbackInputStream)).intValue();
                    this.charstrings_ = new byte[n8 + 1][];
                    this.charstrings_[0] = null;
                    Object[] objectArray3 = new String[n8 + 1];
                    Arrays.fill(objectArray3, ".notdef");
                    this.glyphcnt_ = n8;
                    int n9 = 1;
                    while (n9 <= n8) {
                        object = PostScript.readObject(pushbackInputStream);
                        if (object == null) {
                            throw new FontFormatException("insufficient data -- probably corrupt");
                        }
                        if (PostScript.CLASS_NAME == object.getClass() && ((String)object).startsWith("/")) {
                            String string = ((String)object).substring(1);
                            objectArray3[n9] = string;
                            this.charstrings_[n9] = this.RD(pushbackInputStream);
                            ++n9;
                            continue;
                        }
                        if (!"end".equals(object)) continue;
                        this.glyphcnt_ = n9 - 1;
                        break;
                    }
                    this.intrinsic_ = new Encoding("induced", (String[])objectArray3);
                    n = 0;
                    bl = false;
                    continue;
                }
                objectArray[n++] = ((String)object).substring(1);
                continue;
            }
            String string = (String)object;
            int n10 = 0;
            if ("definefont".equals(string)) break;
            if ("readonly".equals(string)) {
                n10 = n;
            } else if ("[".equals(string)) {
                ArrayList<Object> arrayList = new ArrayList<Object>(10);
                int n11 = 1;
                while (n11 > 0) {
                    object = PostScript.readObject(pushbackInputStream);
                    if (object == null || "]".equals(object)) {
                        if (--n11 <= 0) continue;
                        arrayList.add(object);
                        continue;
                    }
                    arrayList.add(object);
                }
                objectArray[n++] = arrayList;
                n10 = n;
            } else if (bl) {
                if ("dict".equals(string)) {
                    int n12 = ((Number)objectArray[n - 1]).intValue();
                    Dict dict2 = new Dict(n12);
                    if (this.dict_ == null) {
                        this.dict_ = dict2;
                    } else if (n >= 2) {
                        dict.put(objectArray[n - 2], dict2);
                    }
                    dict = dict2;
                } else if ("end".equals(string)) {
                    dict = --n2 > 0 ? dictArray[n2 - 1] : this.dict_;
                } else if ("def".equals(string) && n >= 2) {
                    dict.put(objectArray[n - 2], objectArray[n - 1]);
                    if ("lenIV".equals(objectArray[n - 2])) {
                        this.lenIV_ = ((Number)objectArray[n - 1]).intValue();
                    }
                }
            }
            n = n10;
        }
        pushbackInputStream.close();
        this.charstringType_ = 1;
        if (this.dict_ == null || this.dict_.get("Private") == null || this.charstrings_ == null) {
            throw new FontFormatException("no /Private -- corrupt encrypted portion");
        }
        if (this.charstrings_ == null) {
            this.charstrings_ = new byte[0][0];
        }
        this.setEncoding(encoding);
        this.touni_ = encoding.guessToUnicode();
        this.setup();
    }

    private byte[] RD(PushbackInputStream pushbackInputStream) throws FontFormatException, IOException {
        int n = pushbackInputStream.read();
        if (48 > n || n > 57) {
            throw new FontFormatException("expected number (0x30..0x39) in /CharStrings RD but saw 0x" + Integer.toHexString(n));
        }
        pushbackInputStream.unread(n);
        int n2 = ((Number)PostScript.readObject(pushbackInputStream)).intValue() - this.lenIV_;
        if (!$assertionsDisabled && n2 > 65535) {
            throw new AssertionError(n2);
        }
        n = pushbackInputStream.read();
        while (n != 32 && n != 9 && n != 10 && n != 13) {
            n = pushbackInputStream.read();
        }
        for (int i = 0; i < this.lenIV_; ++i) {
            pushbackInputStream.read();
        }
        byte[] byArray = new byte[n2];
        InputStreams.readFully(pushbackInputStream, byArray);
        PostScript.eatSpace(pushbackInputStream);
        return byArray;
    }

    private static void decrypt(byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        if (!($assertionsDisabled || byArray != null && byArray.length > 0 && n > 0 && n2 > 0)) {
            throw new AssertionError((Object)(byArray + " " + n + " " + n2));
        }
        byte[] byArray2 = byArray;
        boolean bl = true;
        for (n4 = 0; n4 < 4; ++n4) {
            if (byArray2[n4 + n] == 32) continue;
            bl = false;
            break;
        }
        if (bl) {
            return;
        }
        NFontType1.decrypt(55665, byArray2, n, n2);
        n4 = 4;
        int n5 = Arrayss.indexOf(byArray2, Strings.getBytes8("lenIV"));
        if (n5 >= 0) {
            n5 += "lenIV".length();
            while (Character.isWhitespace((char)byArray2[n5])) {
                ++n5;
            }
            n4 = 0;
            while (Character.isDigit((char)byArray2[n5])) {
                n4 = n4 * 10 + byArray2[n5] - 48;
                ++n5;
            }
        }
        for (n3 = 0; n3 < 4; ++n3) {
            byArray2[n + n3] = 32;
        }
        int n6 = n3 + n2 - 1;
        for (n3 = n; n3 < n6; ++n3) {
            byte by;
            if ((byArray2[n3] != 82 || byArray2[n3 + 1] != 68) && (byArray2[n3] != 45 || byArray2[n3 + 1] != 124) || byArray2[n3 - 1] != 32 || (by = byArray2[n3 - 2]) < 48 || by > 57) continue;
            int n7 = by - 48;
            int n8 = n3 - 3;
            int n9 = 10;
            while ((by = byArray2[n8]) >= 48 && by <= 57) {
                n7 += (by - 48) * n9;
                --n8;
                n9 *= 10;
            }
            NFontType1.decrypt(4330, byArray2, n3 += 3, n7);
            for (n8 = 0; n8 < n4; ++n8) {
                byArray2[n3 + n8] = 88;
            }
            n3 += n7;
        }
    }

    private static void encrypt(byte[] byArray, int n, int n2) {
        int n3;
        if (!($assertionsDisabled || byArray != null && byArray.length >= n + n2 && n > 0 && n2 > 0)) {
            throw new AssertionError(byArray.length);
        }
        byte[] byArray2 = byArray;
        int n4 = n3 + n2 - 1;
        for (n3 = n; n3 < n4; ++n3) {
            byte by;
            if ((byArray2[n3] != 82 || byArray2[n3 + 1] != 68) && (byArray2[n3] != 45 || byArray2[n3 + 1] != 124) || byArray2[n3 - 1] != 32 || (by = byArray2[n3 - 2]) < 48 || by > 57) continue;
            int n5 = by - 48;
            int n6 = n3 - 3;
            int n7 = 10;
            while ((by = byArray2[n6]) >= 48 && by <= 57) {
                n5 += (by - 48) * n7;
                --n6;
                n7 *= 10;
            }
            NFontType1.encrypt(4330, byArray2, n3 += 3, n5);
            n3 += n5;
        }
        while (true) {
            NFontType1.encrypt(55665, byArray2, n, n2);
            n3 = byArray2[n] & 0xFF;
            if (n3 != 32 || n3 != 9 || n3 != 10 || n3 != 13) break;
            NFontType1.encrypt(55665, byArray2, n, n2);
            int n8 = n;
            byArray2[n8] = (byte)(byArray2[n8] + 1);
        }
    }

    private static void decrypt(int n, byte[] byArray, int n2, int n3) {
        int n4 = n2 + n3;
        for (int i = n2; i < n4; ++i) {
            int n5 = byArray[i] & 0xFF;
            byArray[i] = (byte)(n5 ^ n >> 8);
            n = (n5 + n) * 52845 + 22719 & 0xFFFF;
        }
    }

    private static void encrypt(int n, byte[] byArray, int n2, int n3) {
        int n4 = n2 + n3;
        for (int i = n2; i < n4; ++i) {
            int n5 = byArray[i] & 0xFF;
            int n6 = (n5 ^ n >> 8) & 0xFF;
            byArray[i] = (byte)n6;
            n = (n6 + n) * 52845 + 22719 & 0xFFFF;
        }
    }

    private void parseCFF() throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        RandomAccess randomAccess = this.ra_;
        randomAccess.seek(this.raoff_);
        int n6 = randomAccess.read();
        int n7 = randomAccess.read();
        int n8 = randomAccess.read();
        int n9 = randomAccess.read();
        randomAccess.seek(this.raoff_ + (long)n8);
        int[] nArray = this.readINDEX(randomAccess);
        int n10 = nArray.length - 1;
        byte[] byArray = new byte[nArray[n10] - nArray[0]];
        randomAccess.readFully(byArray);
        String[] stringArray = new String[n10];
        int n11 = nArray[0];
        for (int i = 0; i < n10; ++i) {
            if (nArray[i] - n11 <= 0 || byArray[nArray[i] - n11] == 0) {
                stringArray[i] = "";
                continue;
            }
            try {
                stringArray[i] = new String(byArray, nArray[i] - n11, nArray[i + 1] - nArray[i], "US-ASCII");
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (!$assertionsDisabled && n10 != 1) {
            throw new AssertionError(n10);
        }
        nArray = this.readINDEX(randomAccess);
        if (!$assertionsDisabled && nArray.length != 2) {
            throw new AssertionError();
        }
        this.dict_ = this.readDICT(randomAccess, nArray[0], nArray[1] - nArray[0], new Dict(n10 * 4 / 3));
        Dict dict = this.dict_;
        Object object = dict.get("CharstringType");
        this.charstringType_ = object != null ? ((Number)object).intValue() : 2;
        nArray = this.readINDEX(randomAccess);
        n10 = nArray.length - 1;
        byArray = new byte[nArray[n10] - nArray[0]];
        randomAccess.readFully(byArray);
        String[] stringArray2 = new String[n10];
        int n12 = nArray[0];
        for (n5 = 0; n5 < n10; ++n5) {
            try {
                stringArray2[n5] = new String(byArray, nArray[n5] - n12, nArray[n5 + 1] - nArray[n5], "US-ASCII");
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        nArray = this.readINDEX(randomAccess);
        n10 = nArray.length - 1;
        this.gsubrs_ = new byte[n10][];
        this.gbias_ = this.charstringType_ == 1 ? 0 : (n10 < 1240 ? 107 : (n10 < 33900 ? 1131 : 32768));
        for (n5 = 0; n5 < n10; ++n5) {
            this.gsubrs_[n5] = new byte[nArray[n5 + 1] - nArray[n5]];
            randomAccess.readFully(this.gsubrs_[n5]);
        }
        n5 = ((Number)dict.get("CharStrings")).intValue();
        randomAccess.seek((long)n5 + this.raoff_);
        nArray = this.readINDEX(randomAccess);
        n12 = n10 = nArray.length - 1;
        if (randomAccess instanceof RandomAccessByteArray) {
            this.charstrings_ = new byte[n10][];
            this.charstringsoff_ = null;
            for (int i = 0; i < n12; ++i) {
                n4 = nArray[i + 1] - nArray[i];
                if (n4 > 0) {
                    this.charstrings_[i] = new byte[n4];
                    randomAccess.readFully(this.charstrings_[i]);
                    continue;
                }
                this.charstrings_[i] = null;
            }
        } else {
            this.charstrings_ = null;
            this.charstringsoff_ = nArray;
            randomAccess.seek((long)nArray[n10] + this.raoff_);
        }
        this.glyphcnt_ = 0;
        for (int i = 0; i < n12; ++i) {
            if (nArray[i] >= nArray[i + 1]) continue;
            ++this.glyphcnt_;
        }
        object = dict.get("charset");
        int[] nArray2 = new int[n12];
        if (object == null || (n5 = ((Number)object).intValue()) == 0) {
            nArray2 = null;
        } else if (n5 == 1) {
            nArray2 = CHARSET_EXPERT;
        } else if (n5 == 2) {
            nArray2 = CHARSET_EXPERT_SUBSET;
        } else {
            randomAccess.seek((long)n5 + this.raoff_);
            n4 = randomAccess.read();
            if (n4 == 0) {
                n3 = 1;
                while (n3 < n12) {
                    nArray2[n3] = randomAccess.read() << 8 | randomAccess.read();
                    ++n3;
                    n5 += 2;
                }
            } else {
                if (!$assertionsDisabled && n4 != 1 && n4 != 2) {
                    throw new AssertionError(n4);
                }
                n3 = 1;
                while (n3 < n12) {
                    n2 = randomAccess.read() << 8 | randomAccess.read();
                    int n13 = n4 == 1 ? randomAccess.read() : randomAccess.read() << 8 | randomAccess.read();
                    for (n = 0; n <= n13; ++n) {
                        nArray2[n3++] = n2 + n;
                    }
                }
            }
        }
        if (dict.get("ROS") != null) {
            this.subformat_ = SUBFORMAT_CFF_CID;
            this.parseCFF_CID(randomAccess, dict, nArray2, stringArray2);
        } else {
            this.parseCFF_CFF(randomAccess, dict, nArray2, stringArray2);
        }
        if (SUBFORMAT_CFF_CID != this.subformat_) {
            if (!$assertionsDisabled && this.fd_ != null) {
                throw new AssertionError();
            }
            this.fd_ = new Dict[1];
            this.fd_[0] = this.dict_;
        }
        n4 = this.fd_.length;
        this.subrs_ = new byte[n4][][];
        n2 = n4;
        for (n3 = 0; n3 < n4; ++n3) {
            Dict dict2 = (Dict)this.fd_[n3].get("Private");
            object = dict2.get("Subrs");
            if (object == null) continue;
            randomAccess.seek((long)((Number)object).intValue() + this.raoff_);
            nArray = this.readINDEX(randomAccess);
            n10 = nArray.length - 1;
            this.subrs_[n3] = new byte[n10][];
            for (n = 0; n < n10; ++n) {
                byte[] byArray2 = new byte[nArray[n + 1] - nArray[n]];
                this.subrs_[n3][n] = byArray2;
                randomAccess.readFully(byArray2);
            }
        }
        this.normalizeDict(dict, CFF_KEYS, CFF_TOP_NORM, stringArray2);
        Dict dict3 = new Dict(13);
        String[] stringArray3 = FONTINFO_KEYS;
        int n14 = stringArray3.length;
        for (n = 0; n < n14; ++n) {
            String string = stringArray3[n];
            Object object2 = dict.remove(string);
            if (object2 == null) continue;
            dict3.put(string, object2);
        }
        if (dict3.size() > 0) {
            dict.put("FontInfo", dict3);
        }
        if (SUBFORMAT_CFF_CID == this.subformat_) {
            n14 = this.fd_.length;
            for (int i = 0; i < n14; ++i) {
                if (this.fd_[i].get("FontName") != null) continue;
                this.fd_[i].put("FontName", stringArray[i]);
            }
        } else {
            if (!$assertionsDisabled && this.dict_.get("FontName") != null) {
                throw new AssertionError();
            }
            this.dict_.put("FontName", stringArray[0]);
        }
        this.setup();
    }

    private void parseCFF_CFF(RandomAccess randomAccess, Dict dict, int[] nArray, String[] stringArray) throws IOException {
        int n;
        Encoding encoding;
        int n2;
        Object object;
        if (nArray == null) {
            this.intrinsic_ = CFF_ENCODING_STANDARD;
        } else {
            object = new String[nArray.length];
            n2 = nArray.length;
            for (int i = 0; i < n2; ++i) {
                object[i] = this.getSID(nArray[i], stringArray);
            }
            this.intrinsic_ = new Encoding("intrinsic", (String[])object);
        }
        object = dict.get("Encoding");
        if (object == null) {
            encoding = Encoding.ADOBE_STANDARD;
        } else {
            n2 = ((Number)object).intValue();
            if (n2 == 0) {
                encoding = Encoding.ADOBE_STANDARD;
            } else if (n2 == 1) {
                encoding = CFF_ENCODING_EXPERT;
            } else {
                int n3;
                int n4;
                randomAccess.seek((long)n2 + this.raoff_);
                n = randomAccess.read();
                boolean bl = (n & 0x80) != 0;
                String[] stringArray2 = new String[256];
                boolean bl2 = false;
                if ((n &= 0x7F) == 0) {
                    n4 = randomAccess.read();
                    for (n3 = 1; n3 <= n4; ++n3) {
                        stringArray2[randomAccess.read()] = nArray != null ? this.getSID(nArray[n3], stringArray) : CFF_SID[n3];
                    }
                } else {
                    if (!$assertionsDisabled && n != 1) {
                        throw new AssertionError();
                    }
                    n4 = randomAccess.read();
                    int n5 = 1;
                    for (n3 = 0; n3 < n4; ++n3) {
                        int n6 = randomAccess.read();
                        int n7 = randomAccess.read();
                        int n8 = 0;
                        while (n8 <= n7) {
                            stringArray2[n6 + n8] = nArray != null ? this.getSID(nArray[n5], stringArray) : CFF_SID[n5];
                            ++n8;
                            ++n5;
                        }
                    }
                }
                if (bl) {
                    n4 = randomAccess.read();
                    n3 = 0;
                    while (n3 < n4) {
                        stringArray2[randomAccess.read()] = this.getSID(randomAccess.read() << 8 | randomAccess.read(), stringArray);
                        ++n3;
                        n2 += 3;
                    }
                }
                stringArray2[0] = ".notdef";
                encoding = new Encoding("custom", stringArray2);
            }
        }
        Object[] objectArray = (Object[])dict.get("Private");
        n = ((Number)objectArray[1]).intValue();
        Dict dict2 = this.readDICT(randomAccess, n, ((Number)objectArray[0]).intValue(), new Dict(13));
        this.normalizeDict(dict2, CFF_KEYS, CFF_PRIVATE_NORM, stringArray);
        object = dict2.get("Subrs");
        if (object != null) {
            dict2.put("Subrs", Integers.getInteger(((Number)object).intValue() + n));
        }
        dict.put("Private", dict2);
        this.setEncoding(encoding);
        this.touni_ = encoding.guessToUnicode();
    }

    private void parseCFF_CID(RandomAccess randomAccess, Dict dict, int[] nArray, String[] stringArray) throws IOException {
        int n;
        int n2;
        Object object;
        int n3;
        this.intrinsic_ = Encoding.IDENTITY;
        int n4 = ((Number)dict.get("FDArray")).intValue();
        randomAccess.seek((long)n4 + this.raoff_);
        int[] nArray2 = this.readINDEX(randomAccess);
        int n5 = nArray2.length - 1;
        this.fd_ = new Dict[n5];
        for (n3 = 0; n3 < n5; ++n3) {
            object = this.readDICT(randomAccess, nArray2[n3], nArray2[n3 + 1] - nArray2[n3], new Dict(13));
            this.normalizeDict((Dict)object, CFF_KEYS, CFF_TOP_NORM, stringArray);
            Object[] objectArray = (Object[])((Dict)object).get("Private");
            n4 = ((Number)objectArray[1]).intValue();
            n2 = ((Number)objectArray[0]).intValue();
            n = n4;
            Dict dict2 = this.readDICT(randomAccess, n4, n2, new Dict(13));
            this.normalizeDict(dict2, CFF_KEYS, CFF_PRIVATE_NORM, stringArray);
            Object object2 = dict2.get("Subrs");
            if (object2 != null) {
                dict2.put("Subrs", Integers.getInteger(((Number)object2).intValue() + n));
            }
            ((Dict)object).put("Private", dict2);
            this.fd_[n3] = object;
        }
        n3 = nArray.length;
        object = new char[n3];
        int n6 = Integer.MAX_VALUE;
        n2 = Integer.MIN_VALUE;
        for (n = 0; n < n3; ++n) {
            int n7 = nArray[n];
            object[n] = (char)n7;
            if (n7 < n6) {
                n6 = n7;
                continue;
            }
            if (n7 <= n2) continue;
            n2 = n7;
        }
        this.firstch_ = n6;
        this.lastch_ = n2;
        n4 = ((Number)dict.get("FDSelect")).intValue();
        randomAccess.seek((long)n4 + this.raoff_);
        n = randomAccess.read();
        int[] nArray3 = new int[n3];
        if (n == 0) {
            for (int i = 0; i < n3; ++i) {
                nArray3[i] = randomAccess.read();
            }
        } else {
            if (!$assertionsDisabled && n != 3) {
                throw new AssertionError(n);
            }
            int n8 = randomAccess.read() << 8 | randomAccess.read();
            int n9 = randomAccess.read() << 8 | randomAccess.read();
            for (int i = 0; i < n8; ++i) {
                int n10 = randomAccess.read();
                int n11 = randomAccess.read() << 8 | randomAccess.read();
                for (int j = n9; j < n11; ++j) {
                    nArray3[j] = n10;
                }
                n9 = n11;
            }
        }
        this.fds_ = nArray3;
        this.setCID(new CMap((char[])object).reverse());
    }

    private Dict readDICT(RandomAccess randomAccess, int n, int n2, Dict dict) throws IOException {
        Object[] objectArray = new Object[256];
        int n3 = 0;
        randomAccess.seek((long)n + this.raoff_);
        for (int i = 0; i < n2; ++i) {
            Object object;
            int n4 = randomAccess.read();
            if (n4 <= 27) {
                String string;
                if (!($assertionsDisabled || n3 >= 1 && n4 <= 21)) {
                    throw new AssertionError();
                }
                Object object2 = object = n3 == 1 ? objectArray[0] : Arrayss.subset(objectArray, 0, n3);
                if (n4 != 12) {
                    string = CFF_KEYS[n4];
                } else {
                    string = CFF_KEYS[22 + randomAccess.read()];
                    ++i;
                }
                if (string != null) {
                    dict.put(string, object);
                }
                n3 = 0;
                continue;
            }
            if (n4 == 28) {
                objectArray[n3++] = Integers.getInteger((byte)randomAccess.read() << 8 | randomAccess.read());
                i += 2;
                continue;
            }
            if (n4 == 29) {
                objectArray[n3++] = Integers.getInteger((byte)randomAccess.read() << 24 | randomAccess.read() << 16 | randomAccess.read() << 8 | randomAccess.read());
                i += 4;
                continue;
            }
            if (n4 == 30) {
                object = new StringBuffer(10);
                while (true) {
                    n4 = randomAccess.read();
                    ++i;
                    int n5 = n4 >> 4;
                    if (!($assertionsDisabled || 0 <= n5 && n5 <= 15)) {
                        throw new AssertionError((Object)(Integer.toHexString(n4) + " / " + n5));
                    }
                    if (n5 == 15) break;
                    ((StringBuffer)object).append(CFF_FLOAT[n5]);
                    n5 = n4 & 0xF;
                    if (n5 == 15) break;
                    ((StringBuffer)object).append(CFF_FLOAT[n5]);
                }
                float f = ((StringBuffer)object).length() > 0 ? Float.parseFloat(((StringBuffer)object).toString()) : 0.0f;
                objectArray[n3++] = new Float(f);
                continue;
            }
            if (n4 == 31) {
                if (!$assertionsDisabled) {
                    throw new AssertionError(n4);
                }
                continue;
            }
            if (n4 <= 246) {
                objectArray[n3++] = Integers.getInteger(n4 - 139);
                continue;
            }
            if (n4 <= 250) {
                objectArray[n3++] = Integers.getInteger((n4 - 247 << 8) + randomAccess.read() + 108);
                ++i;
                continue;
            }
            if (n4 <= 254) {
                objectArray[n3++] = Integers.getInteger(-(n4 - 251 << 8) - randomAccess.read() - 108);
                ++i;
                continue;
            }
            if (!$assertionsDisabled) {
                throw new AssertionError(n4);
            }
        }
        return dict;
    }

    private int[] readINDEX(RandomAccess randomAccess) throws IOException {
        int n = (int)(randomAccess.getFilePointer() - this.raoff_);
        int n2 = randomAccess.read() << 8 | randomAccess.read();
        int[] nArray = new int[n2 + 1];
        if (n2 == 0) {
            return nArray;
        }
        int n3 = randomAccess.read();
        int n4 = nArray.length;
        int n5 = n + 3 + (n2 + 1) * n3 - 1;
        for (int i = 0; i < n4; ++i) {
            int n6 = 0;
            for (int j = 0; j < n3; ++j) {
                n6 = n6 << 8 | randomAccess.read();
            }
            nArray[i] = n6 + n5;
            if (!$assertionsDisabled && i != 0 && nArray[i] < nArray[i - 1]) {
                throw new AssertionError();
            }
        }
        randomAccess.seek((long)nArray[0] + this.raoff_);
        return nArray;
    }

    private String getSID(int n, String[] stringArray) {
        return n < CFF_SID.length ? CFF_SID[n] : stringArray[n - CFF_SID.length];
    }

    private void normalizeDict(Dict dict, String[] stringArray, Object[] objectArray, String[] stringArray2) {
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            Object object = objectArray[i];
            if (string == null || null == object) continue;
            Object object2 = dict.get(string);
            if (object2 != null) {
                Object[] objectArray2;
                if (TYPE_SID == object) {
                    dict.put(string, this.getSID(((Number)object2).intValue(), stringArray2));
                    continue;
                }
                if (TYPE_DELTA != object) continue;
                if (object2 instanceof Object[]) {
                    objectArray2 = (Object[])object2;
                } else {
                    Object[] objectArray3 = new Object[1];
                    objectArray2 = objectArray3;
                    objectArray3[0] = object2;
                }
                Object[] objectArray4 = objectArray2;
                float f = 0.0f;
                int n2 = objectArray4.length;
                for (int j = 0; j < n2; ++j) {
                    objectArray4[j] = Floats.getFloat(f += ((Number)objectArray4[j]).floatValue());
                }
                continue;
            }
            if (TYPE_SID == object || TYPE_DELTA == object) continue;
            dict.put(string, object);
        }
    }

    private void setup() {
        int n;
        Dict dict;
        int n2;
        int n3;
        Object object;
        Object object2;
        float[] fArray = this.getFloats(this.dict_.get("FontMatrix"));
        this.u_ = this.m_ = fArray != null ? new AffineTransform(fArray[0], fArray[1], fArray[2], -fArray[3], fArray[4], fArray[5]) : MATRIX_DEFAULT;
        Object object3 = this.dict_.get("FontBBox");
        if (object3 != null) {
            float[] fArray2 = this.getFloats(object3);
            this.bbox_ = new Rectangle2D.Double(fArray2[0], fArray2[1], fArray2[2], fArray2[3]);
        }
        if (object3 == null || this.bbox_.getWidth() < 10.0 && this.bbox_.getHeight() > 2000.0 || this.bbox_.getWidth() == 0.0 && this.bbox_.getHeight() == 0.0) {
            this.bbox_ = BBOX_MISSING;
        }
        int n4 = this.getMaxGlyphNum();
        this.gc_ = new CacheGlyph(this, this.m_);
        if ("OpenType" != this.getFormat()) {
            int n5;
            boolean bl;
            this.widths_ = new float[Math.max(1, n4)];
            object2 = null;
            object = null;
            boolean bl2 = bl = FORMAT_CFF == this.getFormat();
            if (bl) {
                n5 = this.fd_.length;
                object2 = new float[n5];
                object = new float[n5];
                for (n3 = 0; n3 < n5; ++n3) {
                    Dict dict2 = (Dict)(SUBFORMAT_CFF_CID == this.subformat_ ? this.fd_[n3] : this.dict_).get("Private");
                    if (!$assertionsDisabled && dict2 == null) {
                        throw new AssertionError();
                    }
                    object3 = dict2.get("defaultWidthX");
                    object2[n3] = object3 != null ? ((Number)object3).floatValue() : 0.0f;
                    object3 = dict2.get("nominalWidthX");
                    object[n3] = object3 != null ? ((Number)object3).floatValue() : 0.0f;
                }
            }
            for (n5 = 0; n5 < n4; ++n5) {
                byte[] byArray = this.charstrings_[n5];
                if (byArray == null) continue;
                Object object4 = this.buildChar(n5, null);
                int n6 = n2 = this.fds_ == null ? 0 : this.fds_[n5];
                if (bl) {
                    object4 = Float.MIN_VALUE == object4 ? object2[n2] : (Object)(object4 + object[n2]);
                } else if (!$assertionsDisabled && Float.MIN_VALUE == object4) {
                    throw new AssertionError((Object)(this.getName() + " " + n5));
                }
                this.widths_[n5] = object4;
            }
        }
        object2 = this.getName();
        object = this.getFamily();
        Dict dict3 = (Dict)this.dict_.get("FontInfo");
        this.weight_ = dict3 != null && (object3 = dict3.get("Weight")) != null ? NFontManager.guessWeight("name-" + object3.toString()) : NFontManager.guessWeight((String)object2);
        this.flags_ = NFontManager.guessFlags((String)object2, (String)object);
        if (dict3 != null) {
            this.rights_ = NFontManager.guessRights(dict3.get("Copyright") + " || " + dict3.get("Notice"));
            object3 = dict3.get("isFixedPitch");
            if (object3 == Boolean.TRUE || object3 instanceof Number && ((Number)object3).intValue() != 0) {
                this.flags_ |= 1;
            }
            if ((object3 = dict3.get("ItalicAngle")) instanceof Number && ((Number)object3).doubleValue() != 0.0) {
                this.flags_ |= 0x40;
            }
        } else {
            this.rights_ = 131073;
        }
        if ((dict = (Dict)this.dict_.get("Private")) != null && ((object3 = dict.get("ForceBold")) == Boolean.TRUE || object3 instanceof Number && ((Number)object3).intValue() != 0)) {
            this.flags_ |= 0x40000;
        }
        n3 = 1;
        n2 = n + 26;
        for (n = Arrayss.indexOf(CFF_SID, "Asmall"); n < n2; ++n) {
            if (this.intrinsic_.getChar(CFF_SID[n]) != '\u0000') continue;
            n3 = 0;
            break;
        }
        if (n3 != 0) {
            this.flags_ |= 0x20000;
        }
        this.notdef_ = this.canDisplayGID(0) ? this.getGlyphRec(0) : GlyphRec.ZERO_CONTOUR;
    }

    private float[] getFloats(Object object) {
        float[] fArray;
        block5: {
            fArray = null;
            if (object == null) break block5;
            if (PostScript.CLASS_ARRAY == object.getClass()) {
                List list = (List)object;
                int n = list.size();
                fArray = new float[n];
                for (int i = 0; i < n; ++i) {
                    fArray[i] = ((Number)list.get(i)).floatValue();
                }
            } else {
                if (!$assertionsDisabled && PostScript.CLASS_ARRAY_EX != object.getClass()) {
                    throw new AssertionError();
                }
                Object[] objectArray = (Object[])object;
                int n = objectArray.length;
                fArray = new float[n];
                for (int i = 0; i < n; ++i) {
                    fArray[i] = ((Number)objectArray[i]).floatValue();
                }
            }
        }
        return fArray;
    }

    GlyphRec getGlyphRec(int n) {
        if (!this.canDisplayGID(n)) {
            return this.notdef_;
        }
        GlyphRec glyphRec = this.gc_.getGlyphRec(n);
        if (glyphRec == null) {
            GeneralPath generalPath = new GeneralPath(0);
            this.buildChar(n, generalPath);
            Rectangle2D rectangle2D = generalPath.getBounds2D();
            Point2D.Double double_ = new Point2D.Double(rectangle2D.getX(), rectangle2D.getY());
            Point2D.Double double_2 = new Point2D.Double(rectangle2D.getWidth(), rectangle2D.getHeight());
            this.m_.transform(double_, double_);
            this.m_.transform(double_2, double_2);
            float f = (float)((Point2D)double_).getX();
            float f2 = (float)((Point2D)double_2).getX();
            if ((double)f > 0.0) {
                f2 += f;
            }
            float f3 = -((float)((Point2D)double_).getY());
            float f4 = -((float)((Point2D)double_2).getY());
            if ((double)f3 > 0.0) {
                f4 += f3;
            }
            glyphRec = new GlyphRec(generalPath, f, f3, f2, f4);
            this.gc_.setGlyph(n, glyphRec);
        }
        return glyphRec;
    }

    private float buildChar(int n, GeneralPath generalPath) {
        float f = this.buildChar(n, generalPath, null, null, 0.0f, 0.0f);
        return f;
    }

    private float buildChar(int n, GeneralPath generalPath, boolean[] blArray, boolean[] blArray2, float f, float f2) {
        int n2;
        byte[] byArray = null;
        if (this.charstrings_ != null) {
            byArray = this.charstrings_[n];
        } else {
            try {
                this.getRA();
                this.ra_.seek((long)this.charstringsoff_[n] + this.raoff_);
                byArray = new byte[this.charstringsoff_[n + 1] - this.charstringsoff_[n]];
                this.ra_.readFully(byArray);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (byArray == null) {
            return 0.0f;
        }
        byte[][] byArray2 = this.subrs_[this.fds_ == null ? 0 : this.fds_[n]];
        int n3 = n2 = byArray2 != null ? byArray2.length : 0;
        int n4 = this.charstringType_ == 1 ? 0 : (n2 < 1240 ? 107 : (n2 < 33900 ? 1131 : 32768));
        float f3 = Float.MIN_VALUE;
        byte[][] byArrayArray = new byte[10][];
        int[] nArray = new int[10];
        int n5 = 0;
        byArrayArray[0] = byArray;
        byte[] byArray3 = byArray;
        float[] fArray = new float[48];
        int n6 = 0;
        float[] fArray2 = new float[32];
        float[] fArray3 = new float[20];
        int n7 = 0;
        float[] fArray4 = new float[14];
        int n8 = 0;
        boolean bl = false;
        int n9 = 0;
        boolean bl2 = this.charstringType_ == 2;
        int n10 = 0;
        int n11 = byArray3.length;
        block56: while (n10 < n11) {
            float f4;
            int n12;
            if ((n12 = byArray3[n10++] & 0xFF) <= 31) {
                int n13;
                if (12 == n12) {
                    n12 = (byArray3[n10++] & 0xFF) + 32;
                }
                if (bl2) {
                    if (!$assertionsDisabled && f3 != Float.MIN_VALUE) {
                        throw new AssertionError();
                    }
                    n13 = 0;
                    if (1 == n12 || 18 == n12 || 3 == n12 || 23 == n12 || 20 == n12 || 19 == n12 || 21 == n12 || 9 == n12) {
                        bl2 = false;
                        int n14 = n13 = (n6 & 1) == 1 ? 1 : 0;
                        if (n13 != 0) {
                            f3 = fArray[0];
                        }
                    } else if (22 == n12 || 4 == n12) {
                        bl2 = false;
                        int n15 = n13 = (n6 & 1) == 0 ? 1 : 0;
                        if (n13 != 0) {
                            f3 = fArray[0];
                        }
                    } else if (14 == n12) {
                        bl2 = false;
                        int n16 = n13 = n6 > 0 && n6 != 4 ? 1 : 0;
                        if (n13 != 0) {
                            f3 = fArray[n6 - 1];
                        }
                    }
                    if (!bl2) {
                        if (generalPath == null) {
                            n10 = n11;
                            break;
                        }
                        if (n13 != 0) {
                            System.arraycopy(fArray, 1, fArray, 0, --n6);
                        }
                    }
                }
                switch (n12) {
                    case 4: 
                    case 21: 
                    case 22: {
                        if (22 == n12) {
                            f += fArray[0];
                        } else if (4 == n12) {
                            f2 += fArray[0];
                        } else {
                            f += fArray[0];
                            f2 += fArray[1];
                        }
                        if (bl) {
                            fArray4[n8++] = f;
                            fArray4[n8++] = f2;
                        } else {
                            generalPath.moveTo(f, f2);
                        }
                        n6 = 0;
                        break;
                    }
                    case 5: {
                        for (n13 = 0; n13 < n6; n13 += 2) {
                            generalPath.lineTo(f += fArray[n13], f2 += fArray[n13 + 1]);
                        }
                        n6 = 0;
                        break;
                    }
                    case 6: {
                        n13 = 0;
                        while (n13 + 2 <= n6) {
                            generalPath.lineTo(f += fArray[n13], f2);
                            generalPath.lineTo(f, f2 += fArray[n13 + 1]);
                            n13 += 2;
                        }
                        if ((n6 & 1) == 1) {
                            generalPath.lineTo(f += fArray[n6 - 1], f2);
                        }
                        n6 = 0;
                        break;
                    }
                    case 7: {
                        n13 = 0;
                        while (n13 + 2 <= n6) {
                            generalPath.lineTo(f, f2 += fArray[n13]);
                            generalPath.lineTo(f += fArray[n13 + 1], f2);
                            n13 += 2;
                        }
                        if ((n6 & 1) == 1) {
                            generalPath.lineTo(f, f2 += fArray[n6 - 1]);
                        }
                        n6 = 0;
                        break;
                    }
                    case 8: 
                    case 24: 
                    case 25: 
                    case 67: 
                    case 69: {
                        float f5;
                        float f6;
                        float f7;
                        float f8;
                        int n17 = 0;
                        if (69 == n12) {
                            float f9 = fArray[0] + fArray[2] + fArray[4] + fArray[6] + fArray[8];
                            f4 = fArray[1] + fArray[3] + fArray[5] + fArray[7] + fArray[9];
                            if (Math.abs(f9) > Math.abs(f4)) {
                                fArray[n6++] = f4;
                            } else {
                                fArray[n6] = fArray[n6 - 1];
                                fArray[n6 - 1] = -f9;
                                ++n6;
                            }
                        }
                        if (25 == n12) {
                            int n18 = 0;
                            int n19 = n6 - 6;
                            while (n18 + 2 <= n19) {
                                generalPath.lineTo(f += fArray[n18], f2 += fArray[n18 + 1]);
                                n18 += 2;
                                n17 += 2;
                            }
                        }
                        int n20 = n17;
                        while (n20 + 6 <= n6) {
                            f8 = f + fArray[n20];
                            f7 = f2 + fArray[n20 + 1];
                            f6 = f8 + fArray[n20 + 2];
                            f5 = f7 + fArray[n20 + 3];
                            f = f6 + fArray[n20 + 4];
                            f2 = f5 + fArray[n20 + 5];
                            generalPath.curveTo(f8, f7, f6, f5, f, f2);
                            n20 += 6;
                        }
                        if (24 == n12) {
                            generalPath.lineTo(f += fArray[n6 - 2], f2 += fArray[n6 - 1]);
                        }
                        n6 = 0;
                        break;
                    }
                    case 27: {
                        float f5;
                        float f6;
                        float f7;
                        float f8;
                        if ((n6 & 1) == 1) {
                            f2 += fArray[0];
                        }
                        for (n13 = 0 + (n6 & 1); n13 < n6; n13 += 4) {
                            f8 = f + fArray[n13];
                            f7 = f2;
                            f6 = f8 + fArray[n13 + 1];
                            f5 = f7 + fArray[n13 + 2];
                            f = f6 + fArray[n13 + 3];
                            f2 = f5;
                            generalPath.curveTo(f8, f7, f6, f5, f, f2);
                        }
                        n6 = 0;
                        break;
                    }
                    case 31: {
                        float f8 = f + fArray[0];
                        float f7 = f2;
                        float f6 = f8 + fArray[1];
                        float f5 = f7 + fArray[2];
                        f = n6 == 5 ? f6 + fArray[4] : f6;
                        f2 = f5 + fArray[3];
                        generalPath.curveTo(f8, f7, f6, f5, f, f2);
                    }
                    case 30: {
                        float f5;
                        float f6;
                        float f7;
                        float f8;
                        int n21 = n13 = 31 == n12 ? 4 : 0;
                        while (n13 + 4 <= n6) {
                            f8 = f;
                            f7 = f2 + fArray[n13];
                            f6 = f8 + fArray[n13 + 1];
                            f5 = f7 + fArray[n13 + 2];
                            f = f6 + fArray[n13 + 3];
                            f2 = n13 + 5 == n6 ? f5 + fArray[n13 + 4] : f5;
                            generalPath.curveTo(f8, f7, f6, f5, f, f2);
                            if ((n13 += 4) + 4 <= n6) {
                                f8 = f + fArray[n13];
                                f7 = f2;
                                f6 = f8 + fArray[n13 + 1];
                                f5 = f7 + fArray[n13 + 2];
                                f = n13 + 5 == n6 ? f6 + fArray[n13 + 4] : f6;
                                f2 = f5 + fArray[n13 + 3];
                                generalPath.curveTo(f8, f7, f6, f5, f, f2);
                            }
                            n13 += 4;
                        }
                        n6 = 0;
                        break;
                    }
                    case 26: {
                        float f5;
                        float f6;
                        float f7;
                        float f8;
                        if ((n6 & 1) == 1) {
                            f += fArray[0];
                        }
                        for (n13 = 0 + (n6 & 1); n13 < n6; n13 += 4) {
                            f8 = f;
                            f7 = f2 + fArray[n13];
                            f6 = f8 + fArray[n13 + 1];
                            f5 = f7 + fArray[n13 + 2];
                            f = f6;
                            f2 = f5 + fArray[n13 + 3];
                            generalPath.curveTo(f8, f7, f6, f5, f, f2);
                        }
                        n6 = 0;
                        break;
                    }
                    case 66: {
                        float f10 = f2;
                        float f8 = f + fArray[0];
                        float f7 = f2;
                        float f6 = f8 + fArray[1];
                        float f5 = f7 + fArray[2];
                        f = f6 + fArray[3];
                        f2 = f5;
                        generalPath.curveTo(f8, f7, f6, f5, f, f2);
                        f8 = f + fArray[4];
                        f7 = f2;
                        f6 = f8 + fArray[5];
                        f5 = f10;
                        f = f6 + fArray[6];
                        f2 = f10;
                        generalPath.curveTo(f8, f7, f6, f5, f, f2);
                        n6 = 0;
                        break;
                    }
                    case 68: {
                        float f10 = f2;
                        float f8 = f + fArray[0];
                        float f7 = f2 + fArray[1];
                        float f6 = f8 + fArray[2];
                        float f5 = f7 + fArray[3];
                        f = f6 + fArray[4];
                        f2 = f5;
                        generalPath.curveTo(f8, f7, f6, f5, f, f2);
                        f8 = f + fArray[5];
                        f7 = f2;
                        f6 = f8 + fArray[6];
                        f5 = f7 + fArray[7];
                        f = f6 + fArray[8];
                        f2 = f10;
                        generalPath.curveTo(f8, f7, f6, f5, f, f2);
                        n6 = 0;
                        break;
                    }
                    case 14: {
                        if (n6 == 4) {
                            this.buildChar(this.intrinsic_.getChar(Encoding.ADOBE_STANDARD.getName((char)fArray[2])), generalPath, blArray, blArray2, 0.0f, 0.0f);
                            this.buildChar(this.intrinsic_.getChar(Encoding.ADOBE_STANDARD.getName((char)fArray[3])), generalPath, blArray, blArray2, fArray[0], fArray[1]);
                        }
                        n10 = n11;
                        n6 = 0;
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 18: 
                    case 23: {
                        if (!$assertionsDisabled && n6 % 2 != 0) {
                            throw new AssertionError();
                        }
                        n9 += n6 / 2;
                        n6 = 0;
                        break;
                    }
                    case 19: 
                    case 20: {
                        if (n6 > 0) {
                            n9 += n6 / 2;
                        }
                        n10 += (n9 + 7) / 8;
                        n6 = 0;
                        break;
                    }
                    case 41: {
                        if (!((double)fArray[n6 - 1] < 0.0)) continue block56;
                        fArray[n6 - 1] = -fArray[n6 - 1];
                        break;
                    }
                    case 42: {
                        int n22 = n6 - 2;
                        fArray[n22] = fArray[n22] + fArray[n6 - 1];
                        --n6;
                        break;
                    }
                    case 43: {
                        int n23 = n6 - 2;
                        fArray[n23] = fArray[n23] - fArray[n6 - 1];
                        --n6;
                        break;
                    }
                    case 44: {
                        int n24 = n6 - 2;
                        fArray[n24] = fArray[n24] / fArray[n6 - 1];
                        --n6;
                        break;
                    }
                    case 46: {
                        fArray[n6 - 1] = -fArray[n6 - 1];
                        break;
                    }
                    case 55: {
                        float f10 = rand_.nextFloat();
                        fArray[n6++] = f10 > 0.0f ? f10 : 1.0E-6f;
                        break;
                    }
                    case 56: {
                        int n25 = n6 - 2;
                        fArray[n25] = fArray[n25] * fArray[n6 - 1];
                        --n6;
                        break;
                    }
                    case 58: {
                        fArray[n6 - 1] = (float)Math.sqrt(fArray[n6 - 1]);
                        break;
                    }
                    case 50: {
                        --n6;
                        break;
                    }
                    case 60: {
                        float f10 = fArray[n6 - 2];
                        fArray[n6 - 2] = fArray[n6 - 1];
                        fArray[n6 - 1] = f10;
                        break;
                    }
                    case 61: {
                        int n26 = (int)fArray[n6 - 1];
                        fArray[n6 - 1] = n26 >= 0 ? fArray[n6 - 1 - 1 - n26] : fArray[n6 - 1 - 1];
                        break;
                    }
                    case 62: {
                        int n27;
                        float f10;
                        n13 = (int)fArray[n6 - 2];
                        int n28 = (int)fArray[n6 - 1];
                        if (n13 <= 0 || n28 <= 0) continue block56;
                        int n29 = n6 - 2;
                        int n30 = n27;
                        int n31 = n30 + n28 % n13;
                        for (n27 = n6 - 2 - n13; n27 < n29; ++n27) {
                            f10 = fArray[n27];
                            fArray[n27] = fArray[n31];
                            fArray[n31] = f10;
                            if (++n31 != n29) continue;
                            n31 = n30;
                        }
                        continue block56;
                    }
                    case 59: {
                        fArray[n6] = fArray[n6 - 1];
                        ++n6;
                        break;
                    }
                    case 52: {
                        fArray2[(int)fArray[n6 - 1]] = fArray[n6 - 2];
                        n6 -= 2;
                        break;
                    }
                    case 53: {
                        fArray[n6 - 1] = fArray2[(int)fArray[n6 - 1]];
                        break;
                    }
                    case 35: {
                        fArray[n6 - 2] = fArray[n6 - 2] != 0.0f && fArray[n6 - 1] != 0.0f ? 1.0f : 0.0f;
                        --n6;
                        break;
                    }
                    case 36: {
                        fArray[n6 - 2] = fArray[n6 - 2] != 0.0f || fArray[n6 - 1] != 0.0f ? 1.0f : 0.0f;
                        --n6;
                        break;
                    }
                    case 37: {
                        fArray[n6 - 1] = fArray[n6 - 1] == 0.0f ? 1.0f : 0.0f;
                        break;
                    }
                    case 47: {
                        fArray[n6 - 2] = fArray[n6 - 2] == fArray[n6 - 1] ? 1.0f : 0.0f;
                        --n6;
                        break;
                    }
                    case 54: {
                        if (fArray[n6 - 2] > fArray[n6 - 1]) {
                            fArray[n6 - 4] = fArray[n6 - 3];
                        }
                        n6 -= 3;
                        break;
                    }
                    case 10: {
                        if (!$assertionsDisabled && n6 < 1) {
                            throw new AssertionError(n6);
                        }
                        int n26 = (int)fArray[n6 - 1];
                        --n6;
                        byArrayArray[n5] = byArray3;
                        nArray[n5] = n10;
                        ++n5;
                        if (blArray != null) {
                            blArray[n26 + n4] = true;
                        }
                        byArray3 = byArray2[n26 + n4];
                        n10 = 0;
                        n11 = byArray3.length;
                        break;
                    }
                    case 29: {
                        byArrayArray[n5] = byArray3;
                        nArray[n5] = n10;
                        ++n5;
                        int n26 = (int)fArray[n6 - 1];
                        --n6;
                        if (blArray2 != null) {
                            blArray2[n26 + this.gbias_] = true;
                        }
                        byArray3 = this.gsubrs_[n26 + this.gbias_];
                        n10 = 0;
                        n11 = byArray3.length;
                        break;
                    }
                    case 11: {
                        byArray3 = byArrayArray[--n5];
                        n10 = nArray[n5];
                        n11 = byArray3.length;
                        break;
                    }
                    case 13: {
                        if (!$assertionsDisabled && n6 != 2) {
                            throw new AssertionError(n6);
                        }
                        f += fArray[0];
                        f3 = fArray[1];
                        if (generalPath == null) {
                            n10 = n11;
                        }
                        n6 = 0;
                        break;
                    }
                    case 39: {
                        if (!$assertionsDisabled && n6 != 4) {
                            throw new AssertionError(n6);
                        }
                        f += fArray[0];
                        f2 = fArray[1];
                        f3 = fArray[2];
                        if (generalPath == null) {
                            n10 = n11;
                        }
                        n6 = 0;
                        break;
                    }
                    case 9: {
                        if (generalPath.getCurrentPoint() != null) {
                            generalPath.closePath();
                        }
                        n6 = 0;
                        break;
                    }
                    case 32: 
                    case 33: 
                    case 34: {
                        n6 = 0;
                        break;
                    }
                    case 48: {
                        int n27;
                        float f10 = fArray[n6 - 1];
                        int n26 = n6 - 2 - (int)fArray[n6 - 2];
                        n7 = 0;
                        for (n27 = n6 - 3; n27 >= n26; --n27) {
                            fArray3[n7++] = fArray[n27];
                        }
                        n6 = n26;
                        switch ((int)f10) {
                            case 0: {
                                --n7;
                                if (!bl) continue block56;
                                if (!$assertionsDisabled && n8 != 14) {
                                    throw new AssertionError(n8);
                                }
                                generalPath.curveTo(fArray4[2], fArray4[3], fArray4[4], fArray4[5], fArray4[6], fArray4[7]);
                                generalPath.curveTo(fArray4[8], fArray4[9], fArray4[10], fArray4[11], fArray4[12], fArray4[13]);
                                bl = false;
                                break;
                            }
                            case 1: {
                                if (!$assertionsDisabled && bl) {
                                    throw new AssertionError();
                                }
                                n8 = 0;
                                bl = true;
                                break;
                            }
                            case 2: {
                                break;
                            }
                            case 3: {
                                break;
                            }
                        }
                        continue block56;
                    }
                    case 49: {
                        fArray[n6++] = fArray3[--n7];
                        break;
                    }
                    case 65: {
                        if (!$assertionsDisabled && n6 != 2) {
                            throw new AssertionError();
                        }
                        f = fArray[0];
                        f2 = fArray[1];
                        n6 = 0;
                        break;
                    }
                    case 38: {
                        if (!$assertionsDisabled && n6 != 5) {
                            throw new AssertionError();
                        }
                        this.buildChar(this.intrinsic_.getChar(Encoding.ADOBE_STANDARD.getName((char)fArray[3])), generalPath, blArray, blArray2, 0.0f, 0.0f);
                        this.buildChar(this.intrinsic_.getChar(Encoding.ADOBE_STANDARD.getName((char)fArray[4])), generalPath, blArray, blArray2, fArray[1] - fArray[0], fArray[2]);
                        n6 = 0;
                        break;
                    }
                    case 28: {
                        fArray[n6++] = byArray3[n10] << 8 | byArray3[n10 + 1] & 0xFF;
                        n10 += 2;
                        break;
                    }
                    default: {
                        NFontType1.getLogger().info("bogus charstring command: " + n12 + " in " + n + " " + this.intrinsic_.getName((char)n));
                        n6 = 0;
                    }
                }
                continue;
            }
            if (n12 <= 246) {
                fArray[n6++] = n12 - 139;
                continue;
            }
            if (n12 <= 250) {
                fArray[n6++] = (n12 - 247 << 8) + (byArray3[n10++] & 0xFF) + 108;
                continue;
            }
            if (n12 <= 254) {
                fArray[n6++] = -(n12 - 251 << 8) - (byArray3[n10++] & 0xFF) - 108;
                continue;
            }
            if (this.charstringType_ == 2) {
                float f11 = byArray3[n10] << 8 | byArray3[n10 + 1] & 0xFF;
                f4 = (float)((byArray3[n10 + 2] & 0xFF) << 8 | byArray3[n10 + 3] & 0xFF) / 65536.0f;
                fArray[n6++] = f11 + (f11 >= 0.0f ? f4 : -f4);
            } else {
                fArray[n6++] = (byArray3[n10] & 0xFF) << 24 | (byArray3[n10 + 1] & 0xFF) << 16 | (byArray3[n10 + 2] & 0xFF) << 8 | byArray3[n10 + 3] & 0xFF;
            }
            n10 += 4;
        }
        if (n9 > 0) {
            this.hint_ = 1;
        }
        if (generalPath != null && generalPath.getCurrentPoint() == null) {
            generalPath.moveTo(f3, 0.0f);
        }
        return f3;
    }

    public String getName() {
        Object object = (SUBFORMAT_CFF_CID == this.getFormat() ? this.fd_[0] : this.dict_).get("FontName");
        Dict dict = (Dict)this.dict_.get("FontInfo");
        if (object == null) {
            object = dict.get("FullName");
        }
        if (object == null) {
            object = dict.get("BaseFontName");
        }
        return object != null ? object.toString().trim() : "[no name]";
    }

    public String getFamily() {
        Object object = null;
        Dict dict = (Dict)this.dict_.get("FontInfo");
        if (dict != null) {
            object = dict.get("FamilyName");
        }
        if (object == null) {
            object = NFontManager.guessFamily(this.getName());
        }
        return object.toString().trim();
    }

    public String getCopyright() {
        Object object = null;
        Dict dict = (Dict)this.dict_.get("FontInfo");
        if (dict != null && (object = dict.get("Copyright")) == null) {
            object = dict.get("Notice");
        }
        return object != null ? object.toString() : null;
    }

    public String getVersion() {
        String string;
        Dict dict = (Dict)this.dict_.get("FontInfo");
        Object object = dict != null ? dict.get("version") : null;
        String string2 = string = object != null ? object.toString() : null;
        if (this.create_ != null) {
            string = string != null ? string + " of " + this.create_ : this.create_;
        }
        return string != null ? string : super.getVersion();
    }

    public String getFormat() {
        return this.format_;
    }

    public String getSubformat() {
        return this.subformat_;
    }

    public int getRights() {
        return this.rights_;
    }

    public int getFlags() {
        return this.flags_;
    }

    public int getWeight() {
        return this.weight_;
    }

    public boolean isHinted() {
        if (this.hint_ == -1) {
            this.hint_ = 0;
            int n = this.getMaxGlyphNum();
            for (int i = 1; i < n && this.hint_ != 1; ++i) {
                this.getGlyphRec(i);
            }
            this.releaseRA();
        }
        return this.hint_ == 1;
    }

    public int getPaintType() {
        Object object = this.dict_.get("PaintType");
        return object instanceof Number ? ((Number)object).intValue() : 0;
    }

    public int getCharstringType() {
        return this.charstringType_;
    }

    public int getNumGlyphs() {
        return this.glyphcnt_;
    }

    public int getMaxGlyphNum() {
        return this.charstrings_ != null ? this.charstrings_.length : this.charstringsoff_.length - 1;
    }

    public UnicodeBlocks[] getUnicode() {
        if (this.ur_.blocks_ == null) {
            this.ur_.blocks_ = NFontManager.createMasks(this.intrinsic_.guessToUnicode().reverse());
        }
        return this.ur_.blocks_;
    }

    public boolean canDisplayEchar(int n) {
        char c = this.c2g_.toSelector(n);
        return (c != '\u0000' || 0 == n) && this.canDisplayGID(c);
    }

    private boolean canDisplayGID(int n) {
        return n < this.getMaxGlyphNum() && (this.charstrings_ == null || this.charstrings_[n] != null);
    }

    public char getSpaceEchar() {
        if (this.spacech_ == Integer.MIN_VALUE) {
            char c;
            char c2;
            this.spacech_ = this.encoding_ != null && "space".equals(this.encoding_.getName(32)) && this.canDisplayEchar(32) ? 32 : (this.touni_ != null ? (int)this.touni_.fromSelector(32) : (this.encoding_ != null && (c2 = this.encoding_.getChar("space")) != '\u0000' && this.canDisplayEchar(c2) ? (int)c2 : ((c = this.c2g_.toSelector(32)) != '\u0000' && this.canDisplayGID(c) && ((GeneralPath)this.getGlyphRec((int)c).shape).getPathIterator(new AffineTransform()).isDone() ? 32 : 65534)));
        }
        return (char)this.spacech_;
    }

    public Point2D echarAdvance(int n) {
        char c = this.c2g_.toSelector(n);
        double d = !this.canDisplayGID(c) ? 0.0 : (this.newwidths_ != null && this.firstch_ <= n && n <= this.lastch_ && this.newwidths_[n - this.firstch_] > 1 ? (double)this.newwidths_[n - this.firstch_] * 0.001 : (double)this.widths_[c] * this.m_.getScaleX());
        return new Point2D.Double(d * (double)this.size_ * this.at_.getScaleX(), d * (double)this.size_ * this.at_.getShearY());
    }

    public Rectangle2D getEstringBounds(String string, int n, int n2) {
        Rectangle2D rectangle2D = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        double d = 0.0;
        int n3 = Math.min(n2, string.length());
        for (int i = Math.max(0, n); i < n3; ++i) {
            char c = string.charAt(i);
            char c2 = this.c2g_.toSelector(c);
            if (c2 == '\u0000' && c != '\u0000') continue;
            GlyphRec glyphRec = this.getGlyphRec(c2);
            rectangle2D.add(d + (double)glyphRec.xmin, -glyphRec.ymin);
            rectangle2D.add(d + (double)glyphRec.xmax, -glyphRec.ymax);
            d += this.newwidths_ != null && this.firstch_ <= c && c <= this.lastch_ && this.newwidths_[c - this.firstch_] > 1 ? (double)this.newwidths_[c - this.firstch_] * 0.001 : (double)this.widths_[c2] * this.m_.getScaleX();
        }
        this.releaseRA();
        if (2 == this.at_.getType() || 0 == this.at_.getType()) {
            double d2 = this.at_.getScaleX() * (double)this.getSize();
            ((Rectangle2D)rectangle2D).setRect(((RectangularShape)rectangle2D).getX() * d2, ((RectangularShape)rectangle2D).getY() * d2, ((RectangularShape)rectangle2D).getWidth() * d2, ((RectangularShape)rectangle2D).getHeight() * d2);
        } else {
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo((float)((RectangularShape)rectangle2D).getX(), (float)((RectangularShape)rectangle2D).getY());
            generalPath.lineTo((float)(((RectangularShape)rectangle2D).getX() + ((RectangularShape)rectangle2D).getWidth()), (float)(((RectangularShape)rectangle2D).getY() + ((RectangularShape)rectangle2D).getHeight()));
            generalPath.transform(AffineTransform.getScaleInstance(this.getSize(), this.getSize()));
            generalPath.transform(this.at_);
            rectangle2D = generalPath.getBounds2D();
        }
        return rectangle2D;
    }

    public void drawString(Graphics2D graphics2D, String string, float f, float f2) {
        super.drawString(graphics2D, string, f, f2, 1057L, this.getPaintType(), null);
    }

    public void drawEstring(Graphics2D graphics2D, String string, float f, float f2, long l, int n, Color color) {
        boolean bl;
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        if (3 == n) {
            return;
        }
        Color color2 = graphics2D.getColor();
        AffineTransform affineTransform = graphics2D.getTransform();
        BasicStroke basicStroke = null;
        CacheBitmap cacheBitmap = this.gc_.getCacheBitmap(this, this.at_, affineTransform, this.newwidths_, n, color2);
        boolean bl2 = bl = cacheBitmap != CacheBitmap.NONE;
        if (!bl) {
            graphics2D.translate(f, f2);
            graphics2D.transform(this.u_);
            if (1 == n || 2 == n || 5 == n || 6 == n) {
                basicStroke = (BasicStroke)graphics2D.getStroke();
                graphics2D.setStroke(new BasicStroke((float)((double)basicStroke.getLineWidth() / Math.sqrt(Math.abs(this.u_.getDeterminant()))), basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), basicStroke.getDashArray(), basicStroke.getDashPhase()));
            }
        }
        double d = f;
        double d2 = 0.0;
        int n2 = Math.round(f2);
        String string2 = this.c2g_.toSelector(string);
        int n3 = string2.length();
        for (int i = 0; i < n3; ++i) {
            double d3;
            char c = string2.charAt(i);
            GlyphRec glyphRec = this.getGlyphRec(c);
            if (glyphRec == this.notdef_) {
                c = '\u0000';
            }
            double d4 = this.widths_[Math.min(c, this.widths_.length - 1)];
            char c2 = string.charAt(i);
            int n4 = c2 - this.firstch_;
            double d5 = this.newwidths_ != null && Encoding.IDENTITY != this.getEncoding() && 0 <= n4 && n4 < this.newwidths_.length && this.newwidths_[n4] > 1 ? (double)this.newwidths_[n4] * 0.001 / this.m_.getScaleX() : 0.0;
            double d6 = d3 = d5 <= 1.0 || Math.abs(d4 - d5) <= 2.0 || this.pdfbad_[n4] ? 1.0 : d5 / d4;
            if (bl) {
                int n5 = (int)Math.round(d + d2);
                if ((d2 = (double)n5 - d) > 1.0) {
                    --n5;
                    d2 -= 1.0;
                } else if (d2 < -1.0) {
                    ++n5;
                    d2 += 1.0;
                }
                BitmapRec bitmapRec = cacheBitmap.getBitmap(c, glyphRec, d3);
                graphics2D.drawImage((Image)bitmapRec.img, n5 + bitmapRec.dx, n2 + bitmapRec.dy, null);
                d += (d5 != 0.0 ? d5 : d4) * this.u_.getScaleX();
                continue;
            }
            Shape shape = glyphRec.shape;
            if (d3 != 1.0) {
                graphics2D.scale(d3, 1.0);
            }
            if (0 == n || 2 == n || 4 == n || 6 == n) {
                graphics2D.fill(shape);
            }
            if (1 == n || 2 == n || 5 == n || 6 == n) {
                if (color == null || color.equals(color2)) {
                    graphics2D.draw(shape);
                } else {
                    graphics2D.setColor(color);
                    graphics2D.draw(shape);
                    graphics2D.setColor(color2);
                }
            }
            if (d3 != 1.0) {
                graphics2D.scale(1.0 / d3, 1.0);
            }
            graphics2D.translate(d5 != 0.0 ? d5 : d4, 0.0);
        }
        if (!bl) {
            graphics2D.setTransform(affineTransform);
        }
        if (basicStroke != null) {
            graphics2D.setStroke(basicStroke);
        }
        this.releaseRA();
    }

    public static byte[] normalize(byte[] byArray) throws FontFormatException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        byArray = (byte[])byArray.clone();
        int n8 = byArray.length;
        if ((byArray[0] & 0xFF) == 128) {
            n7 = 0;
            n6 = 0;
            n5 = byArray.length;
            while (n7 < n5) {
                if (!$assertionsDisabled && (byArray[n7] & 0xFF) != 128) {
                    throw new AssertionError((Object)(byArray[n7] + " @ " + n7 + " of " + byArray.length));
                }
                if ((byArray[n7] & 0xFF) != 128) break;
                n4 = byArray[n7 + 1] & 0xFF;
                if (3 == n4) {
                    n8 = n6;
                    break;
                }
                n3 = byArray[n7 + 2] & 0xFF | (byArray[n7 + 3] & 0xFF) << 8 | (byArray[n7 + 4] & 0xFF) << 16 | (byArray[n7 + 5] & 0xFF) << 24;
                if (1 != n4 && 2 != n4) {
                    throw new FontFormatException("invalid type in IBM segment: " + n4);
                }
                System.arraycopy(byArray, n7 += 6, byArray, n6, n3);
                n7 += n3;
                n6 += n3;
            }
        }
        n7 = NFontType1.getClen(byArray);
        n6 = Arrayss.lastIndexOf(byArray, Strings.getBytes8("cleartomark"));
        n5 = n6 > n7 ? n6 : n8;
        --n5;
        n4 = 0;
        while (n4 < 512 && n5 > n7) {
            n3 = byArray[n5] & 0xFF;
            if (n3 == 48) {
                ++n4;
            } else if (n3 != 32 && n3 != 9 && n3 != 10 && n3 != 13) break;
            --n5;
        }
        if (++n5 < n8 && Character.isWhitespace((char)(byArray[n5] & 0xFF))) {
            ++n5;
        }
        n8 = n5;
        n4 = n8 - n7;
        n3 = 1;
        int n9 = 0;
        for (n2 = n7; n2 < n8; ++n2) {
            n = byArray[n2] & 0xFF;
            if (Characters.isHexDigit(n)) {
                ++n9;
                continue;
            }
            if (Character.isWhitespace((char)n)) continue;
            n3 = 0;
            break;
        }
        if (n3 != 0) {
            if (!$assertionsDisabled && n9 % 2 != 0) {
                throw new AssertionError(n9);
            }
            n2 = 0;
            n = n7;
            int n10 = n7;
            while (n2 < n9) {
                while (Character.isWhitespace((char)(byArray[n10] & 0xFF))) {
                    ++n10;
                }
                byArray[n] = (byte)Integers.parseHex(byArray[n10], byArray[n10 + 1]);
                n2 += 2;
                ++n;
                n10 += 2;
            }
            n4 = n9 / 2;
            n8 = n7 + n4;
        }
        NFontType1.decrypt(byArray, n7, n4);
        if (n8 < byArray.length) {
            byArray = Arrayss.subset(byArray, 0, n8);
        }
        return byArray;
    }

    public byte[] toPFB() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(51200);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        Dict dict = new Dict(this.dict_);
        Dict dict2 = (Dict)dict.get("FontInfo");
        Dict dict3 = new Dict((Dict)dict.get("Private"));
        try {
            int n;
            int n2;
            int n3;
            dataOutputStream.writeBytes("%!FontType1-1.0: " + this.getName() + " " + dict2.get("version") + "\n");
            this.writeDict(dict, dataOutputStream);
            dataOutputStream.writeBytes("/Encoding");
            if (Encoding.ADOBE_STANDARD == this.encoding_) {
                dataOutputStream.writeBytes(" StandardEncoding def\n");
            } else {
                dataOutputStream.writeBytes(" 256 array\n0 1 255 {1 index exch /.notdef put } for\n");
                for (n3 = 0; n3 < 256; ++n3) {
                    char c = this.c2g_.toSelector((char)n3);
                    if (n3 != 0 && c == '\u0000' || c >= this.charstrings_.length || this.charstrings_[c] == null) continue;
                    dataOutputStream.writeBytes("dup " + n3 + " /" + this.encoding_.getName((char)n3) + " put\n");
                }
                dataOutputStream.writeBytes("readonly def\n");
            }
            dataOutputStream.writeBytes("currentdict end\n");
            dataOutputStream.writeBytes("currentfile eexec\n");
            dataOutputStream.writeBytes("    ");
            dataOutputStream.writeBytes("/Private " + dict3.size() + " dict dup begin\n");
            dataOutputStream.writeBytes("/NP {noaccess put} executeonly def\n");
            dataOutputStream.writeBytes("/RD {string currentfile exch readstring pop} executeonly def\n");
            dataOutputStream.writeBytes("/ND {noaccess def} executeonly def\n");
            n3 = 4;
            dict3.remove("lenIV");
            dataOutputStream.writeBytes("/lenIV " + n3 + " def\n");
            this.writeDict(dict3, dataOutputStream);
            byte[][] byArray = this.subrs_[0];
            if (byArray.length > 0) {
                dataOutputStream.writeBytes("/Subrs " + byArray.length + " array\n");
                n2 = byArray.length;
                for (n = 0; n < n2; ++n) {
                    byte[] byArray2 = byArray[n];
                    if (byArray2 == null) continue;
                    if (this.charstringType_ == 2) {
                        byArray2 = NFontType1.csT2t1(byArray2);
                    }
                    dataOutputStream.writeBytes("dup " + n + " " + (n3 + byArray2.length) + " RD XXXX");
                    dataOutputStream.write(byArray2);
                    dataOutputStream.writeBytes(" NP\n");
                }
                dataOutputStream.writeBytes("ND\n");
            }
            n = 0;
            int n4 = this.charstrings_.length;
            for (n2 = 0; n2 < n4; ++n2) {
                if (this.charstrings_[n2] == null) continue;
                ++n;
            }
            dataOutputStream.writeBytes("/CharStrings " + n + " dict dup begin\n");
            n4 = this.charstrings_.length;
            for (n2 = 0; n2 < n4; ++n2) {
                byte[] byArray3 = this.charstrings_[n2];
                if (byArray3 == null) continue;
                if (this.charstringType_ == 2) {
                    byArray3 = NFontType1.csT2t1(byArray3);
                }
                String string = this.intrinsic_.getName((char)n2);
                dataOutputStream.writeBytes("/" + string + " " + (4 + byArray3.length) + " RD XXXX");
                dataOutputStream.write(byArray3);
                dataOutputStream.writeBytes(" ND\n");
            }
            dataOutputStream.writeBytes("end readonly def\n");
            dataOutputStream.writeBytes("end noaccess def\n");
            dataOutputStream.writeBytes("dup /FontName get exch definefont pop\n");
            dataOutputStream.writeBytes("mark currentfile closefile\n");
            dataOutputStream.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return NFontType1.toPFB(byteArrayOutputStream.toByteArray());
    }

    private void writeDict(Dict dict, DataOutputStream dataOutputStream) throws IOException {
        Object v;
        Object k;
        Map.Entry entry;
        dataOutputStream.writeBytes(" " + dict.size() + " dict");
        dataOutputStream.writeBytes(" dup");
        dataOutputStream.writeBytes(" begin\n");
        Iterator iterator = dict.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            k = entry.getKey();
            if ("Private".equals(k) || "Encoding".equals(k) || "CharStrings".equals(k) || "Subrs".equals(k) || PostScript.CLASS_DICTIONARY == (v = entry.getValue()).getClass()) continue;
            PostScript.writeObject(k, dataOutputStream);
            PostScript.writeObject(v, dataOutputStream);
            dataOutputStream.writeBytes(" def\n");
        }
        iterator = dict.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            k = entry.getKey();
            if ("Private".equals(k) || "Encoding".equals(k) || "CharStrings".equals(k) || "Subrs".equals(k) || PostScript.CLASS_DICTIONARY != (v = entry.getValue()).getClass()) continue;
            PostScript.writeObject(k, dataOutputStream);
            this.writeDict((Dict)v, dataOutputStream);
            dataOutputStream.writeBytes("end def\n");
        }
    }

    private static byte[] csT2t1(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        boolean bl = false;
        int n = 0;
        int n2 = byArray.length;
        boolean bl2 = false;
        while (n < n2) {
            int n3 = byArray[n] & 0xFF;
            int n4 = 0;
            if (n3 <= 31) {
                if (12 == n3) {
                    n3 = (byArray[n++] & 0xFF) + 32;
                }
                switch (byArray[n]) {
                    case 35: 
                    case 36: 
                    case 37: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 46: 
                    case 47: 
                    case 50: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: {
                        break;
                    }
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: {
                        break;
                    }
                }
            } else if (n3 <= 246) {
                n4 = 1;
            } else if (n3 <= 250 || n3 <= 254) {
                n4 = 2;
            }
            if (n4 <= 0) continue;
            for (int i = 0; i < n4; ++i) {
                byteArrayOutputStream.write(byArray[n++] & 0xFF);
            }
        }
        return byArray;
    }

    public static byte[] toPFB(byte[] byArray) {
        int n;
        int n2;
        int n3 = byArray.length;
        byte[] byArray2 = Arrayss.resize(byArray, n3 + PFB_00_LENGTH);
        for (n2 = 0; n2 < 8; ++n2) {
            for (n = 0; n < 64; ++n) {
                byArray2[n3++] = 48;
            }
            byArray2[n3++] = 10;
        }
        n = "cleartomark\n".length();
        for (n2 = 0; n2 < n; ++n2) {
            byArray2[n3++] = (byte)"cleartomark\n".charAt(n2);
        }
        if (!$assertionsDisabled && n3 != byArray2.length) {
            throw new AssertionError();
        }
        n2 = NFontType1.getClen(byArray);
        n = byArray.length - n2;
        NFontType1.encrypt(byArray, n2, n);
        return byArray2;
    }

    public static byte[] toPFA(byte[] byArray) {
        byte[] byArray2 = NFontType1.toPFB(byArray);
        int n = NFontType1.getClen(byArray);
        int n2 = byArray.length - n;
        int n3 = byArray2.length - byArray.length;
        byte[] byArray3 = new byte[byArray2.length + n2];
        System.arraycopy(byArray2, 0, byArray3, 0, n);
        int n4 = n + n2;
        int n5 = n;
        for (int i = n; i < n4; ++i) {
            int n6 = byArray2[i] & 0xFF;
            byArray3[n5++] = (byte)Integer.toHexString(n6 >> 4).charAt(0);
            byArray3[n5++] = (byte)Integer.toHexString(n6 & 0xF).charAt(0);
        }
        System.arraycopy(byArray2, n + n2, byArray3, n + n2 * 2, n3);
        return byArray3;
    }

    public static byte[] toPFB_IBM(byte[] byArray) {
        byte[] byArray2 = NFontType1.toPFB(byArray);
        int n = NFontType1.getClen(byArray);
        int n2 = byArray.length - n;
        int n3 = byArray2.length - byArray.length;
        byte[] byArray3 = new byte[byArray2.length + 18 + 2];
        int n4 = NFontType1.writeIBM(1, byArray2, 0, byArray3, 0, n);
        n4 = NFontType1.writeIBM(2, byArray2, n, byArray3, n4, n2);
        n4 = NFontType1.writeIBM(1, byArray2, n + n2, byArray3, n4, n3);
        n4 = NFontType1.writeIBM(3, byArray2, -1, byArray3, n4, -1);
        if (!$assertionsDisabled && n4 != byArray3.length) {
            throw new AssertionError();
        }
        return byArray3;
    }

    private static int writeIBM(int n, byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        int n5 = n3;
        byArray2[n5++] = -128;
        byArray2[n5++] = (byte)n;
        if (3 == n) {
            return n5;
        }
        byArray2[n5++] = (byte)(n4 & 0xFF);
        byArray2[n5++] = (byte)(n4 >> 8 & 0xFF);
        byArray2[n5++] = (byte)(n4 >> 16 & 0xFF);
        byArray2[n5++] = (byte)(n4 >> 24 & 0xFF);
        System.arraycopy(byArray, n2, byArray2, n5, n4);
        return n5 + n4;
    }

    public /* synthetic */ NFontSimple deriveFont(Encoding encoding, CMap cMap) {
        return this.deriveFont(encoding, cMap);
    }

    public /* synthetic */ NFont deriveFont(AffineTransform affineTransform) {
        return this.deriveFont(affineTransform);
    }

    public /* synthetic */ NFont deriveFont(float f) {
        return this.deriveFont(f);
    }

    static {
        $assertionsDisabled = !NFontType1.class.desiredAssertionStatus();
        PFB_00_LENGTH = 520 + "cleartomark\n".length();
        MATRIX_DEFAULT = new AffineTransform(0.001, 0.0, 0.0, -0.001, 0.0, 0.0);
        CS_NAME = new String[]{"-Reserved-", "hstem", "-Reserved-", "vstem", "vmoveto", "rlineto", "hlineto", "vlineto", "rrcurveto", "closepath", "callsubr", "return", "escape", "hsbw", "endchar", "-Reserved-", "-Reserved-", "-Reserved-", "hstemhm", "hintmask", "cntrmask", "rmoveto", "hmoveto", "vstemhm", "rcurveline", "rlinecurve", "vvcurveto", "hhcurveto", "shortint", "callgsubr", "vhcurveto", "hvcurveto", "dotsection", "vstem3", "hstem3", "and", "or", "not", "seac", "sbw", "-Reserved-", "abs", "add", "sub", "div", "-Reserved-", "neg", "eq", "callothersubr", "pop", "drop", "-Reserved-", "put", "get", "ifelse", "random", "mul", "-Reserved-", "sqrt", "dup", "exch", "index", "roll", "-Reserved-", "-Reserved-", "setcurrentpoint", "hflex", "flex", "hflex1", "flex1"};
        CFF_SID = new String[]{".notdef", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quoteright", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "quoteleft", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "exclamdown", "cent", "sterling", "fraction", "yen", "florin", "section", "currency", "quotesingle", "quotedblleft", "guillemotleft", "guilsinglleft", "guilsinglright", "fi", "fl", "endash", "dagger", "daggerdbl", "periodcentered", "paragraph", "bullet", "quotesinglbase", "quotedblbase", "quotedblright", "guillemotright", "ellipsis", "perthousand", "questiondown", "grave", "acute", "circumflex", "tilde", "macron", "breve", "dotaccent", "dieresis", "ring", "cedilla", "hungarumlaut", "ogonek", "caron", "emdash", "AE", "ordfeminine", "Lslash", "Oslash", "OE", "ordmasculine", "ae", "dotlessi", "lslash", "oslash", "oe", "germandbls", "onesuperior", "logicalnot", "mu", "trademark", "Eth", "onehalf", "plusminus", "Thorn", "onequarter", "divide", "brokenbar", "degree", "thorn", "threequarters", "twosuperior", "registered", "minus", "eth", "multiply", "threesuperior", "copyright", "Aacute", "Acircumflex", "Adieresis", "Agrave", "Aring", "Atilde", "Ccedilla", "Eacute", "Ecircumflex", "Edieresis", "Egrave", "Iacute", "Icircumflex", "Idieresis", "Igrave", "Ntilde", "Oacute", "Ocircumflex", "Odieresis", "Ograve", "Otilde", "Scaron", "Uacute", "Ucircumflex", "Udieresis", "Ugrave", "Yacute", "Ydieresis", "Zcaron", "aacute", "acircumflex", "adieresis", "agrave", "aring", "atilde", "ccedilla", "eacute", "ecircumflex", "edieresis", "egrave", "iacute", "icircumflex", "idieresis", "igrave", "ntilde", "oacute", "ocircumflex", "odieresis", "ograve", "otilde", "scaron", "uacute", "ucircumflex", "udieresis", "ugrave", "yacute", "ydieresis", "zcaron", "exclamsmall", "Hungarumlautsmall", "dollaroldstyle", "dollarsuperior", "ampersandsmall", "Acutesmall", "parenleftsuperior", "parenrightsuperior", "twodotenleader", "onedotenleader", "zerooldstyle", "oneoldstyle", "twooldstyle", "threeoldstyle", "fouroldstyle", "fiveoldstyle", "sixoldstyle", "sevenoldstyle", "eightoldstyle", "nineoldstyle", "commasuperior", "threequartersemdash", "periodsuperior", "questionsmall", "asuperior", "bsuperior", "centsuperior", "dsuperior", "esuperior", "isuperior", "lsuperior", "msuperior", "nsuperior", "osuperior", "rsuperior", "ssuperior", "tsuperior", "ff", "ffi", "ffl", "parenleftinferior", "parenrightinferior", "Circumflexsmall", "hyphensuperior", "Gravesmall", "Asmall", "Bsmall", "Csmall", "Dsmall", "Esmall", "Fsmall", "Gsmall", "Hsmall", "Ismall", "Jsmall", "Ksmall", "Lsmall", "Msmall", "Nsmall", "Osmall", "Psmall", "Qsmall", "Rsmall", "Ssmall", "Tsmall", "Usmall", "Vsmall", "Wsmall", "Xsmall", "Ysmall", "Zsmall", "colonmonetary", "onefitted", "rupiah", "Tildesmall", "exclamdownsmall", "centoldstyle", "Lslashsmall", "Scaronsmall", "Zcaronsmall", "Dieresissmall", "Brevesmall", "Caronsmall", "Dotaccentsmall", "Macronsmall", "figuredash", "hypheninferior", "Ogoneksmall", "Ringsmall", "Cedillasmall", "questiondownsmall", "oneeighth", "threeeighths", "fiveeighths", "seveneighths", "onethird", "twothirds", "zerosuperior", "foursuperior", "fivesuperior", "sixsuperior", "sevensuperior", "eightsuperior", "ninesuperior", "zeroinferior", "oneinferior", "twoinferior", "threeinferior", "fourinferior", "fiveinferior", "sixinferior", "seveninferior", "eightinferior", "nineinferior", "centinferior", "dollarinferior", "periodinferior", "commainferior", "Agravesmall", "Aacutesmall", "Acircumflexsmall", "Atildesmall", "Adieresissmall", "Aringsmall", "AEsmall", "Ccedillasmall", "Egravesmall", "Eacutesmall", "Ecircumflexsmall", "Edieresissmall", "Igravesmall", "Iacutesmall", "Icircumflexsmall", "Idieresissmall", "Ethsmall", "Ntildesmall", "Ogravesmall", "Oacutesmall", "Ocircumflexsmall", "Otildesmall", "Odieresissmall", "OEsmall", "Oslashsmall", "Ugravesmall", "Uacutesmall", "Ucircumflexsmall", "Udieresissmall", "Yacutesmall", "Thornsmall", "Ydieresissmall", "001.000", "001.001", "001.002", "001.003", "Black", "Bold", "Book", "Light", "Medium", "Regular", "Roman", "Semibold"};
        CHARSET_EXPERT = new int[]{0, 1, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 13, 14, 15, 99, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 27, 28, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 109, 110, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 158, 155, 163, 319, 320, 321, 322, 323, 324, 325, 326, 150, 164, 169, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378};
        CHARSET_EXPERT_SUBSET = new int[]{0, 1, 231, 232, 235, 236, 237, 238, 13, 14, 15, 99, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 27, 28, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 109, 110, 267, 268, 269, 270, 272, 300, 301, 302, 305, 314, 315, 158, 155, 163, 320, 321, 322, 323, 324, 325, 326, 150, 164, 169, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346};
        CFF_EXPERT_MAP = new String[]{".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", "space", "exclamsmall", "Hungarumlautsmall", ".notdef", "dollaroldstyle", "dollarsuperior", "ampersandsmall", "Acutesmall", "parenleftsuperior", "parenrightsuperior", "twodotenleader", "onedotenleader", "comma", "hyphen", "period", "fraction", "zerooldstyle", "oneoldstyle", "twooldstyle", "threeoldstyle", "fouroldstyle", "fiveoldstyle", "sixoldstyle", "sevenoldstyle", "eightoldstyle", "nineoldstyle", "colon", "semicolon", "commasuperior", "threequartersemdash", "periodsuperior", "questionsmall", ".notdef", "asuperior", "bsuperior", "centsuperior", "dsuperior", "esuperior", ".notdef", ".notdef", ".notdef", "isuperior", ".notdef", ".notdef", "lsuperior", "msuperior", "nsuperior", "osuperior", ".notdef", ".notdef", "rsuperior", "ssuperior", "tsuperior", ".notdef", "ff", "fi", "fl", "ffi", "ffl", "parenleftinferior", ".notdef", "parenrightinferior", "Circumflexsmall", "hyphensuperior", "Gravesmall", "Asmall", "Bsmall", "Csmall", "Dsmall", "Esmall", "Fsmall", "Gsmall", "Hsmall", "Ismall", "Jsmall", "Ksmall", "Lsmall", "Msmall", "Nsmall", "Osmall", "Psmall", "Qsmall", "Rsmall", "Ssmall", "Tsmall", "Usmall", "Vsmall", "Wsmall", "Xsmall", "Ysmall", "Zsmall", "colonmonetary", "onefitted", "rupiah", "Tildesmall", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", "exclamdownsmall", "centoldstyle", "Lslashsmall", ".notdef", ".notdef", "Scaronsmall", "Zcaronsmall", "Dieresissmall", "Brevesmall", "Caronsmall", ".notdef", "Dotaccentsmall", ".notdef", ".notdef", "Macronsmall", ".notdef", ".notdef", "figuredash", "hypheninferior", ".notdef", ".notdef", "Ogoneksmall", "Ringsmall", "Cedillasmall", ".notdef", ".notdef", ".notdef", "onequarter", "onehalf", "threequarters", "questiondownsmall", "oneeighth", "threeeighths", "fiveeighths", "seveneighths", "onethird", "twothirds", ".notdef", ".notdef", "zerosuperior", "onesuperior", "twosuperior", "threesuperior", "foursuperior", "fivesuperior", "sixsuperior", "sevensuperior", "eightsuperior", "ninesuperior", "zeroinferior", "oneinferior", "twoinferior", "threeinferior", "fourinferior", "fiveinferior", "sixinferior", "seveninferior", "eightinferior", "nineinferior", "centinferior", "dollarinferior", "periodinferior", "commainferior", "Agravesmall", "Aacutesmall", "Acircumflexsmall", "Atildesmall", "Adieresissmall", "Aringsmall", "AEsmall", "Ccedillasmall", "Egravesmall", "Eacutesmall", "Ecircumflexsmall", "Edieresissmall", "Igravesmall", "Iacutesmall", "Icircumflexsmall", "Idieresissmall", "Ethsmall", "Ntildesmall", "Ogravesmall", "Oacutesmall", "Ocircumflexsmall", "Otildesmall", "Odieresissmall", "OEsmall", "Oslashsmall", "Ugravesmall", "Uacutesmall", "Ucircumflexsmall", "Udieresissmall", "Yacutesmall", "Thornsmall", "Ydieresissmall"};
        CFF_ENCODING_STANDARD = new Encoding("CFF_Standard", Arrayss.subset(CFF_SID, 0, 229));
        CFF_ENCODING_EXPERT = new Encoding("CFF_Expert", CFF_EXPERT_MAP);
        CFF_FLOAT = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ".", "E", "E-", null, "-"};
        CFF_KEYS = new String[]{"version", "Notice", "FullName", "FamilyName", "Weight", "FontBBox", "BlueValues", "OtherBlues", "FamilyBlues", "FamilyOtherBlues", "StdHW", "StdVW", "escape", "UniqueID", "XUID", "charset", "Encoding", "CharStrings", "Private", "Subrs", "defaultWidthX", "nominalWidthX", "Copyright", "isFixedPitch", "ItalicAngle", "UnderlinePosition", "UnderlineThickness", "PaintType", "CharstringType", "FontMatrix", "StrokeWidth", "BlueScale", "BlueShift", "BlueFuzz", "StemSnapH", "StemSnapV", "ForceBold", null, null, "LanguageGroup", "ExpansionFactor", "initialRandomSeed", "SyntheticBase", "PostScript", "BaseFontName", "BaseFontBlend", null, null, null, null, null, null, "ROS", "CIDFontVersion", "CIDFontRevision", "CIDFontType", "CIDCount", "UIDBase", "FDArray", "FDSelect", "FontName"};
        FONTINFO_KEYS = new String[]{"version", "Notice", "Copyright", "FullName", "FamilyName", "Weight", "isFixedPitch", "ItalicAngle", "UnderlinePosition", "UnderlineThickness", "BaseFontName"};
        TYPE_DELTA = new Object();
        TYPE_SID = new Object();
        CFF_TOP_NORM = new Object[]{TYPE_SID, TYPE_SID, TYPE_SID, TYPE_SID, TYPE_SID, new Object[]{Integers.ZERO, Integers.ZERO, Integers.ZERO, Integers.ZERO}, null, null, null, null, null, null, null, null, null, Integers.ZERO, Integers.ZERO, null, null, null, null, null, null, Integers.ZERO, Integers.ZERO, Integers.getInteger(100), Integers.getInteger(50), Integers.ZERO, Integers.TWO, new Object[]{new Float(0.001f), Floats.ZERO, Floats.ZERO, new Float(0.001f), Floats.ZERO, Floats.ZERO}, Integers.ONE, null, null, null, null, null, null, null, null, null, null, null, null, TYPE_SID, TYPE_SID, TYPE_DELTA, null, null, null, null, null, null, null, Integers.ZERO, Integers.ZERO, Integers.ZERO, Integers.getInteger(8720), null, null, null, TYPE_SID};
        CFF_PRIVATE_NORM = new Object[]{null, null, null, null, null, null, TYPE_DELTA, TYPE_DELTA, TYPE_DELTA, TYPE_DELTA, null, null, null, null, null, null, null, null, null, null, Integers.ZERO, Integers.ZERO, null, null, null, null, null, null, null, null, null, new Float(0.039625f), Integers.getInteger(7), Integers.ONE, TYPE_DELTA, TYPE_DELTA, Integers.ZERO, null, null, Integers.ZERO, new Float(0.06f), Integers.ZERO};
        if (!($assertionsDisabled || CFF_SID[229] == "exclamsmall" && CFF_SID[274] == "Asmall" && CFF_SID[378] == "Ydieresissmall")) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && CHARSET_EXPERT.length != 166) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && CHARSET_EXPERT_SUBSET.length != 88) {
            throw new AssertionError(CHARSET_EXPERT_SUBSET);
        }
        if (!$assertionsDisabled && CFF_EXPERT_MAP[53] != "fiveoldstyle") {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && CFF_EXPERT_MAP[126] != "Tildesmall") {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && CFF_EXPERT_MAP[219] != "nineinferior") {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && CFF_EXPERT_MAP[254] != "Thornsmall") {
            throw new AssertionError();
        }
        BBOX_MISSING = new Rectangle2D.Double(-100.0, -250.0, 900.0, 750.0);
        rand_ = new Random();
    }
}

