/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient.doc;

import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Graphics;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class HTTPClientExample
extends Applet
implements Runnable,
ActionListener {
    private HTTPConnection con;
    private HTTPResponse rsp;
    private String script = "/cgi-bin/my_script.cgi";
    private String disp = "";
    private Thread thread;
    private boolean done = false;
    private TextArea text;

    public void init() {
        this.setLayout(new BorderLayout());
        this.text = new TextArea(60, 60);
        this.add("Center", this.text);
        this.text.setEditable(false);
        Button button = new Button("Doit");
        button.addActionListener(this);
        this.add("South", button);
        try {
            this.con = new HTTPConnection(this.getCodeBase());
            return;
        }
        catch (Exception exception) {
            this.disp = "Error creating HTTPConnection:\n" + exception;
            this.repaint();
            return;
        }
    }

    public void start() {
        if (this.thread == null) {
            this.done = false;
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public void run() {
        try {
            while (true) {
                this.waitForDoit();
                if (this.done) break;
                this.disp = "POSTing ...";
                this.repaint();
                this.rsp = this.con.Post(this.script, "Hello World again");
                this.repaint();
            }
            return;
        }
        catch (Exception exception) {
            this.disp = "Error POSTing: " + exception;
            exception.printStackTrace();
            this.repaint();
            return;
        }
    }

    private synchronized void waitForDoit() {
        try {
            this.wait();
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    private synchronized void notifyDoit() {
        this.notify();
    }

    public void stop() {
        if (this.thread != null) {
            this.done = true;
            this.notifyDoit();
            this.thread = null;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.notifyDoit();
    }

    public void paint(Graphics graphics) {
        this.text.setText(String.valueOf(this.disp) + "\n");
        if (this.rsp == null) {
            return;
        }
        try {
            this.text.append("\n---Headers:\n" + this.rsp.toString());
            this.text.append("\n---Data:\n" + this.rsp.getText() + "\n");
            return;
        }
        catch (Exception exception) {
            this.text.append("\n---Got Exception:\n" + exception + "\n");
            return;
        }
    }
}

