/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.util;

import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.morpho.util.StateChangeEvent;
import edu.ucsb.nceas.morpho.util.StateChangeListener;
import java.util.Hashtable;
import java.util.Vector;

public class StateChangeMonitor {
    private static StateChangeMonitor monitor;
    private static final Object classLock;
    private Hashtable listeners = new Hashtable();

    private StateChangeMonitor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StateChangeMonitor getInstance() {
        Object object = classLock;
        synchronized (object) {
            if (monitor == null) {
                monitor = new StateChangeMonitor();
            }
            return monitor;
        }
    }

    public void addStateChangeListener(String stateChange, StateChangeListener listener) {
        Vector<StateChangeListener> currentStateListeners = null;
        if (!this.listeners.containsKey(stateChange)) {
            Log.debug(50, "Adding state vector: " + stateChange);
            currentStateListeners = new Vector<StateChangeListener>();
            this.listeners.put(stateChange, currentStateListeners);
        } else {
            currentStateListeners = (Vector<StateChangeListener>)this.listeners.get(stateChange);
        }
        if (!currentStateListeners.contains(listener)) {
            Log.debug(50, "Adding listener: " + listener.toString());
            currentStateListeners.addElement(listener);
        }
    }

    public void removeStateChangeListener(String stateChange, StateChangeListener listener) {
        Vector currentStateListeners = null;
        if (this.listeners.containsKey(stateChange)) {
            currentStateListeners = (Vector)this.listeners.get(stateChange);
            Log.debug(50, "Removing listener: " + listener.toString());
            currentStateListeners.removeElement(listener);
            if (currentStateListeners.size() == 0) {
                this.listeners.remove(stateChange);
            }
        }
    }

    public void notifyStateChange(StateChangeEvent event) {
        String stateChange = event.getChangedState();
        Vector currentStateListeners = null;
        if (this.listeners.containsKey(stateChange)) {
            currentStateListeners = (Vector)this.listeners.get(stateChange);
            for (int i = 0; i < currentStateListeners.size(); ++i) {
                StateChangeListener listener = (StateChangeListener)currentStateListeners.elementAt(i);
                if (listener == null) continue;
                listener.handleStateChange(event);
            }
        }
    }

    static {
        classLock = StateChangeMonitor.class;
    }
}

