/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.query;

import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.query.CancelCommand;
import edu.ucsb.nceas.morpho.query.LocalToNetworkCommand;
import edu.ucsb.nceas.morpho.query.NetworkToLocalCommand;
import edu.ucsb.nceas.morpho.query.OpenDialogBox;
import edu.ucsb.nceas.morpho.util.GUIAction;
import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.Window;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextArea;

public class SynchronizeDialog
extends JDialog {
    private JButton executeButton = null;
    private JButton cancelButton = null;
    private ImageIcon localIcon = new ImageIcon(this.getClass().getResource("local-package.png"));
    private ImageIcon networkIcon = new ImageIcon(this.getClass().getResource("network-package-large.png"));
    private ImageIcon arrowIcon = null;
    private static final int PADDINGWIDTH = 8;
    private static String SYNCHRONIZE = "\"Synchronize\" will keep the Data Packages on your local computer identical with those on the network. In order to do this, Morpho will copy the Data Package as shown below:";
    private static String WARNING = "Note:\n  If you are copying from local to network, you may be prompted to renumber the Data Package";
    private MorphoFrame morphoFrame = null;
    private String morphoFrameType = null;
    private OpenDialogBox openDialog = null;
    private boolean comeFromOpen = false;
    private String docid = null;
    private boolean inLocal = false;
    private boolean inNetwork = false;

    public SynchronizeDialog(MorphoFrame parent, String frameType, String myDocid, boolean myInLocal, boolean myInNetwork) {
        super(parent);
        this.morphoFrame = parent;
        this.morphoFrameType = frameType;
        this.docid = myDocid;
        this.inLocal = myInLocal;
        this.inNetwork = myInNetwork;
        this.initialize(this.morphoFrame);
    }

    public SynchronizeDialog(OpenDialogBox open, MorphoFrame frame, String myDocid, boolean myInLocal, boolean myInNetwork) {
        super(open);
        this.openDialog = open;
        this.morphoFrame = frame;
        this.docid = myDocid;
        this.inLocal = myInLocal;
        this.inNetwork = myInNetwork;
        this.initialize(this.openDialog);
    }

    private void initialize(Window parent) {
        int parentWidth = parent.getWidth();
        int parentHeight = parent.getHeight();
        int dialogWidth = 400;
        int dialogHeight = 275;
        this.setSize(dialogWidth, dialogHeight);
        this.setResizable(false);
        double parentX = parent.getLocation().getX();
        double parentY = parent.getLocation().getY();
        double centerX = parentX + 0.5 * (double)parentWidth;
        double centerY = parentY + 0.5 * (double)parentHeight;
        int dialogX = new Double(centerX - 0.5 * (double)dialogWidth).intValue();
        int dialogY = new Double(centerY - 0.5 * (double)dialogHeight).intValue();
        this.setLocation(dialogX, dialogY);
        this.setTitle("Synchronize");
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        Box noteBox = Box.createVerticalBox();
        noteBox.add(Box.createVerticalStrut(8));
        JTextArea note = new JTextArea(SYNCHRONIZE);
        note.setEditable(false);
        note.setLineWrap(true);
        note.setWrapStyleWord(true);
        note.setOpaque(false);
        note.setFont(new Font("SansSerif", 0, 11));
        noteBox.add(note);
        Box notePadding = Box.createHorizontalBox();
        notePadding.add(Box.createHorizontalStrut(8));
        notePadding.add(noteBox);
        notePadding.add(Box.createHorizontalStrut(8));
        this.getContentPane().add("North", notePadding);
        this.getContentPane().add("East", Box.createHorizontalStrut(8));
        this.getContentPane().add("West", Box.createHorizontalStrut(8));
        GUIAction executeAction = null;
        String warningMessage = null;
        if (this.inLocal && !this.inNetwork) {
            this.arrowIcon = new ImageIcon(this.getClass().getResource("rightarrow.gif"));
            executeAction = new GUIAction("Execute", null, new LocalToNetworkCommand(this.openDialog, this, this.morphoFrame, this.morphoFrameType, this.docid, this.inLocal, this.inNetwork));
            warningMessage = WARNING;
        }
        if (!this.inLocal && this.inNetwork) {
            this.arrowIcon = new ImageIcon(this.getClass().getResource("leftarrow.gif"));
            executeAction = new GUIAction("Execute", null, new NetworkToLocalCommand(this.openDialog, this, this.morphoFrame, this.morphoFrameType, this.docid, this.inLocal, this.inNetwork));
            warningMessage = "";
        }
        Box iconBox = Box.createHorizontalBox();
        JLabel localLabel = new JLabel("Local", this.localIcon, 4);
        localLabel.setHorizontalTextPosition(4);
        JLabel networkLabel = new JLabel("Network", this.networkIcon, 4);
        networkLabel.setHorizontalTextPosition(4);
        JLabel arrowLabel = new JLabel(this.arrowIcon);
        iconBox.add(Box.createHorizontalGlue());
        iconBox.add(localLabel);
        iconBox.add(Box.createHorizontalStrut(20));
        iconBox.add(arrowLabel);
        iconBox.add(Box.createHorizontalStrut(20));
        iconBox.add(networkLabel);
        iconBox.add(Box.createHorizontalGlue());
        this.getContentPane().add("Center", iconBox);
        Box bottomBox = Box.createVerticalBox();
        bottomBox.add(Box.createVerticalStrut(8));
        JTextArea warning = new JTextArea(warningMessage);
        warning.setEditable(false);
        warning.setLineWrap(true);
        warning.setWrapStyleWord(true);
        warning.setOpaque(false);
        warning.setFont(new Font("SansSerif", 0, 11));
        bottomBox.add(warning);
        bottomBox.add(Box.createVerticalStrut(8));
        Box controlButtonsBox = Box.createHorizontalBox();
        controlButtonsBox.add(Box.createHorizontalGlue());
        this.executeButton = new JButton(executeAction);
        controlButtonsBox.add(this.executeButton);
        controlButtonsBox.add(Box.createHorizontalStrut(8));
        GUIAction cancelAction = new GUIAction("Cancel", null, new CancelCommand(this));
        this.cancelButton = new JButton(cancelAction);
        controlButtonsBox.add(this.cancelButton);
        bottomBox.add(controlButtonsBox);
        bottomBox.add(Box.createVerticalStrut(10));
        Box bottomPadding = Box.createHorizontalBox();
        bottomPadding.add(Box.createHorizontalStrut(8));
        bottomPadding.add(bottomBox);
        bottomPadding.add(Box.createHorizontalStrut(8));
        this.getContentPane().add("South", bottomPadding);
        this.setVisible(false);
    }
}

