/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.query;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.query.ImageRenderer;
import edu.ucsb.nceas.morpho.query.OpenDeleteDialogCommand;
import edu.ucsb.nceas.morpho.query.OpenDialogBox;
import edu.ucsb.nceas.morpho.query.OpenExportDialogCommand;
import edu.ucsb.nceas.morpho.query.OpenPackageCommand;
import edu.ucsb.nceas.morpho.query.OpenPreviousVersionCommand;
import edu.ucsb.nceas.morpho.query.OpenSynchronizeDialogCommand;
import edu.ucsb.nceas.morpho.query.RefreshCommand;
import edu.ucsb.nceas.morpho.query.ResultPanelAndFrameMediator;
import edu.ucsb.nceas.morpho.query.ResultSet;
import edu.ucsb.nceas.morpho.query.ToolTippedSortableJTable;
import edu.ucsb.nceas.morpho.query.ToolTippedTextRenderer;
import edu.ucsb.nceas.morpho.util.GUIAction;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.morpho.util.SortTableCommand;
import edu.ucsb.nceas.morpho.util.SortableJTable;
import edu.ucsb.nceas.morpho.util.StateChangeEvent;
import edu.ucsb.nceas.morpho.util.StateChangeMonitor;
import edu.ucsb.nceas.morpho.util.StoreStateChangeEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class ResultPanel
extends JPanel
implements StoreStateChangeEvent {
    private ResultSet results = null;
    private Morpho morpho = null;
    private ResultPanelAndFrameMediator mediator = null;
    private OpenDialogBox dialog = null;
    ToolTippedSortableJTable table = null;
    Vector storedStateChangeEventlist = null;
    private JLabel titleLabel;
    private JLabel recordCountLabel;
    private JLabel bflyLabel;
    private JPopupMenu popup;
    private JMenuItem openMenu = null;
    private JMenuItem openPreviousVersion = null;
    private JMenuItem synchronizeMenu = null;
    private JMenuItem uploadMenu = null;
    private JMenuItem downloadMenu = null;
    private JMenuItem deleteMenu = null;
    private JMenuItem refreshMenu = null;
    private JMenuItem exportMenu = null;
    private JMenuItem exportToZipMenu = null;
    private String selectedId = "";
    boolean metacatLoc = false;
    boolean localLoc = false;
    private String doctype = "";
    private Dimension preferredSize;
    ImageIcon bfly;
    ImageIcon flapping;
    int threadCount = 0;
    int selectedRow = -1;
    private int vers = -1;
    private String packageName = "";
    private boolean enableMouseListener = true;

    public ResultPanel(OpenDialogBox dialog, ResultSet results, ResultPanelAndFrameMediator myMediator) {
        this(dialog, results, 12, myMediator, new Dimension(775, 500));
    }

    public ResultPanel(OpenDialogBox dialog, ResultSet results, ResultPanelAndFrameMediator myMediator, Dimension preferredSize) {
        this(dialog, results, 12, myMediator, preferredSize);
    }

    public ResultPanel(OpenDialogBox dialog, ResultSet results, int fontSize, ResultPanelAndFrameMediator myMediator, Dimension preferredSize) {
        this.dialog = dialog;
        this.results = results;
        this.morpho = results.getFramework();
        this.mediator = myMediator;
        this.preferredSize = preferredSize;
        this.storedStateChangeEventlist = new Vector();
        if (this.mediator != null) {
            this.mediator.registerResultPanel(this);
        }
        try {
            this.bfly = new ImageIcon(this.getClass().getResource("Btfly.gif"));
            this.flapping = new ImageIcon(this.getClass().getResource("Btfly4.gif"));
        }
        catch (Exception w) {
            System.out.println("Error in loading images");
        }
        this.setLayout(new BorderLayout());
        this.setBackground(Color.white);
        this.setPreferredSize(preferredSize);
        if (results != null) {
            this.setName(results.getQuery().getQueryTitle());
            this.table = new ToolTippedSortableJTable(results);
            this.table.setAutoResizeMode(0);
            this.table.setShowHorizontalLines(false);
            this.table.setShowVerticalLines(false);
            ToolTippedTextRenderer stringRenderer = new ToolTippedTextRenderer(fontSize);
            this.table.setRowHeight(results.getRowHeight());
            this.table.setDefaultRenderer(String.class, stringRenderer);
            this.table.setDefaultRenderer(ImageIcon.class, new ImageRenderer());
            JScrollPane scrollPane = new JScrollPane(this.table);
            scrollPane.getViewport().setBackground(Color.white);
            this.initTableColumnSize(this.table, results, (int)preferredSize.getWidth());
            this.add((Component)scrollPane, "Center");
            this.popup = new JPopupMenu();
            GUIAction openAction = new GUIAction("Open Package", null, new OpenPackageCommand(dialog));
            this.openMenu = new JMenuItem(openAction);
            this.popup.add(this.openMenu);
            GUIAction openPreviousAction = new GUIAction("Open Previous Version", null, new OpenPreviousVersionCommand(dialog, null));
            this.openPreviousVersion = new JMenuItem(openPreviousAction);
            this.popup.add(this.openPreviousVersion);
            openPreviousAction.setEnabled(false);
            GUIAction refreshAction = null;
            refreshAction = dialog != null ? new GUIAction("Refresh", null, new RefreshCommand(dialog)) : new GUIAction("Refresh", null, new RefreshCommand());
            this.refreshMenu = new JMenuItem(refreshAction);
            this.popup.add(this.refreshMenu);
            this.popup.add(new JSeparator());
            GUIAction synchronizeAction = new GUIAction("Synchronize...", null, new OpenSynchronizeDialogCommand(dialog));
            this.synchronizeMenu = new JMenuItem(synchronizeAction);
            this.popup.add(this.synchronizeMenu);
            this.popup.add(new JSeparator());
            GUIAction openDeleteDialogAction = new GUIAction("Delete...", null, new OpenDeleteDialogCommand(dialog));
            this.deleteMenu = new JMenuItem(openDeleteDialogAction);
            this.popup.add(this.deleteMenu);
            this.popup.add(new JSeparator());
            GUIAction exportAction = new GUIAction("Export...", null, new OpenExportDialogCommand(dialog));
            this.exportMenu = new JMenuItem(exportAction);
            this.popup.add(this.exportMenu);
            PopupListener popupListener = new PopupListener(this);
            this.table.addMouseListener(popupListener);
            this.table.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (ResultPanel.this.enableMouseListener && 2 == e.getClickCount()) {
                        ResultPanel.this.doDoubleClickOpen();
                    }
                }
            });
        }
    }

    private void doDoubleClickOpen() {
        OpenPackageCommand open = new OpenPackageCommand(this.dialog);
        open.execute(null);
    }

    public ResultSet getResultSet() {
        return this.results;
    }

    public void setResultSet(ResultSet result) {
        Vector newVector = result.getResultsVector();
        this.resetResultsVector(newVector);
    }

    public void resetResultsVector(Vector newResultVector) {
        this.results.setResultsVector(newResultVector);
        this.updateTable();
    }

    private void updateTable() {
        this.table.resetModel(this.results);
        this.results.fireTableDataChanged();
    }

    public SortableJTable getJTable() {
        return this.table;
    }

    public OpenDialogBox getDialog() {
        return this.dialog;
    }

    public String getSelectedId() {
        return this.selectedId;
    }

    public String getDocType() {
        return this.doctype;
    }

    public boolean getMetacatLocation() {
        return this.metacatLoc;
    }

    public boolean getLocalLocation() {
        return this.localLoc;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public int getPreviousVersions() {
        return this.vers;
    }

    public void setEnableMouseListener(boolean enable) {
        this.enableMouseListener = enable;
    }

    public boolean getEnableMouseListener() {
        return this.enableMouseListener;
    }

    private void initTableColumnSize(JTable table, ResultSet results, int width) {
        double[] columnWidth = new double[]{0.03, 0.355, 0.132, 0.1, 0.14, 0.13, 0.066, 0.047};
        TableColumn column = null;
        double minFactor = 0.7;
        int maxFactor = 5;
        double percentage = 0.0;
        int preferredSize = 0;
        int minimumSize = 0;
        int maxmumSize = 0;
        for (int i = 0; i < results.getColumnCount(); ++i) {
            column = table.getColumnModel().getColumn(i);
            percentage = columnWidth[i];
            preferredSize = new Double((double)width * percentage).intValue();
            minimumSize = new Double((double)preferredSize * minFactor).intValue();
            maxmumSize = preferredSize * maxFactor;
            if (i == 1 && preferredSize < 200) {
                preferredSize = 200;
                minimumSize = new Double((double)preferredSize * minFactor).intValue();
                maxmumSize = preferredSize * maxFactor;
            }
            column.setPreferredWidth(preferredSize);
            column.setMinWidth(minimumSize);
            column.setMaxWidth(maxmumSize);
        }
    }

    private void initColumnSizes(JTable table, ResultSet results) {
        TableColumn column = null;
        Component comp = null;
        Component hcomp = null;
        int headerWidth = 0;
        int cellWidth = 0;
        Object longValues = null;
        for (int i = 0; i < results.getColumnCount(); ++i) {
            column = table.getColumnModel().getColumn(i);
            hcomp = (Component)((Object)column.getHeaderRenderer());
            if (hcomp != null) {
                headerWidth = hcomp.getPreferredSize().width;
            }
            comp = table.getDefaultRenderer(results.getColumnClass(i)).getTableCellRendererComponent(table, results.getValueAt(1, i), false, false, 0, i);
            cellWidth = comp.getPreferredSize().width;
            column.setPreferredWidth(Math.max(headerWidth, cellWidth));
            if (cellWidth < 100 && i > 0) {
                column.setMinWidth(cellWidth + 100);
                continue;
            }
            if (0 != i) continue;
            column.setMinWidth(cellWidth + 20);
        }
    }

    public void sortTable(int index, String order) {
        SortTableCommand sortCommand = new SortTableCommand(this.table, index, order);
        sortCommand.execute(null);
    }

    public void storingStateChangeEvent(StateChangeEvent event) {
        if (this.storedStateChangeEventlist != null) {
            this.storedStateChangeEventlist.add(event);
        }
    }

    public Vector getStoredStateChangeEvent() {
        return this.storedStateChangeEventlist;
    }

    public void broadcastStoredStateChangeEvent() {
        if (this.storedStateChangeEventlist != null) {
            for (int i = 0; i < this.storedStateChangeEventlist.size(); ++i) {
                StateChangeEvent event = (StateChangeEvent)this.storedStateChangeEventlist.elementAt(i);
                StateChangeMonitor.getInstance().notifyStateChange(event);
            }
        }
    }

    public static int getNumberOfPrevVersions(String docId) {
        int prevVersions = 0;
        int iii = docId.lastIndexOf(".");
        String ver = docId.substring(iii + 1, docId.length());
        prevVersions = new Integer(ver);
        return --prevVersions;
    }

    public static String getIdWithoutVersion(String docId) {
        boolean prevVersions = false;
        int iii = docId.lastIndexOf(".");
        String ver = docId.substring(0, iii);
        return ver;
    }

    class PopupListener
    extends MouseAdapter {
        boolean trigger = false;
        String docid = "";
        ResultPanel pane = null;

        public PopupListener(ResultPanel panel) {
            this.pane = panel;
        }

        public void mousePressed(MouseEvent e) {
            if (ResultPanel.this.enableMouseListener) {
                int selrow;
                ResultPanel.this.table.clearSelection();
                ResultPanel.this.selectedRow = selrow = ResultPanel.this.table.rowAtPoint(new Point(e.getX(), e.getY()));
                ResultPanel.this.table.setRowSelectionInterval(selrow, selrow);
                Vector resultV = ResultPanel.this.results.getResultsVector();
                Vector rowV = (Vector)resultV.elementAt(selrow);
                if (ResultPanel.this.mediator != null) {
                    ResultPanel.this.mediator.enableOpenButton();
                }
                this.docid = (String)rowV.elementAt(6);
                ResultPanel.this.selectedId = this.docid;
                Log.debug(30, "selectedId is: " + this.docid);
                ResultPanel.this.localLoc = (Boolean)rowV.elementAt(9);
                ResultPanel.this.metacatLoc = (Boolean)rowV.elementAt(10);
                ResultPanel.this.packageName = ResultPanel.getIdWithoutVersion(ResultPanel.this.selectedId);
                Log.debug(30, "the package name is: " + ResultPanel.this.packageName);
                ResultPanel.this.vers = ResultPanel.getNumberOfPrevVersions(ResultPanel.this.selectedId);
                Log.debug(30, "the number of previous version is: " + ResultPanel.this.vers);
                ResultPanel.this.doctype = (String)rowV.elementAt(8);
                if (ResultPanel.this.dialog == null) {
                    StateChangeMonitor monitor = StateChangeMonitor.getInstance();
                    monitor.notifyStateChange(new StateChangeEvent(this.pane, StateChangeEvent.SEARCH_RESULT_SELECTED));
                    if (ResultPanel.this.localLoc ^ ResultPanel.this.metacatLoc) {
                        monitor.notifyStateChange(new StateChangeEvent(this.pane, StateChangeEvent.SEARCH_RESULT_SELECTED_UNSYNCHRONIZED));
                    } else {
                        monitor.notifyStateChange(new StateChangeEvent(this.pane, StateChangeEvent.SEARCH_RESULT_SELECTED_SYNCHRONIZED));
                    }
                    if (ResultPanel.this.vers > 0) {
                        monitor.notifyStateChange(new StateChangeEvent(this.pane, StateChangeEvent.SEARCH_RESULT_SELECTED_VERSIONS));
                    } else {
                        monitor.notifyStateChange(new StateChangeEvent(this.pane, StateChangeEvent.SEARCH_RESULT_SELECTED_NO_VERSIONS));
                    }
                }
                if (e.isPopupTrigger()) {
                    this.trigger = true;
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (ResultPanel.this.enableMouseListener) {
                this.maybeShowPopup(e);
            }
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger() || this.trigger) {
                if (ResultPanel.this.vers > 0) {
                    ResultPanel.this.openPreviousVersion.setEnabled(true);
                } else {
                    ResultPanel.this.openPreviousVersion.setEnabled(false);
                }
                ResultPanel.this.synchronizeMenu.setEnabled(ResultPanel.this.localLoc && !ResultPanel.this.metacatLoc || ResultPanel.this.metacatLoc && !ResultPanel.this.localLoc);
                ResultPanel.this.deleteMenu.setEnabled(true);
                this.trigger = false;
                ResultPanel.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

