/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.query;

import edu.ucsb.nceas.morpho.framework.DataPackageInterface;
import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceNotHandledException;
import edu.ucsb.nceas.morpho.plugins.ServiceProvider;
import edu.ucsb.nceas.morpho.query.DeleteDialog;
import edu.ucsb.nceas.morpho.query.OpenDialogBox;
import edu.ucsb.nceas.morpho.query.RefreshCommand;
import edu.ucsb.nceas.morpho.query.ResultPanel;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.Log;
import java.awt.event.ActionEvent;

public class OpenDeleteDialogCommand
implements Command {
    private OpenDialogBox openDialog = null;

    public OpenDeleteDialogCommand() {
    }

    public OpenDeleteDialogCommand(OpenDialogBox myDialog) {
        this.openDialog = myDialog;
    }

    public void execute(ActionEvent event) {
        ResultPanel resultPane = null;
        MorphoFrame frame = null;
        DeleteDialog deleteDialog = null;
        boolean parentIsOpenDialog = false;
        String selectDocId = null;
        boolean inNetwork = false;
        boolean inLocal = false;
        if (this.openDialog != null) {
            resultPane = this.openDialog.getResultPanel();
            frame = this.openDialog.getParentFrame();
            parentIsOpenDialog = true;
        } else {
            frame = UIController.getInstance().getCurrentActiveWindow();
            if (frame != null) {
                resultPane = RefreshCommand.getResultPanelFromMorphoFrame(frame);
            }
        }
        if (resultPane != null) {
            selectDocId = resultPane.getSelectedId();
            inNetwork = resultPane.getMetacatLocation();
            inLocal = resultPane.getLocalLocation();
            if (selectDocId != null && !selectDocId.equals("")) {
                deleteDialog = parentIsOpenDialog ? new DeleteDialog(this.openDialog, frame, selectDocId, inLocal, inNetwork) : new DeleteDialog(frame, "searchResultFrame", selectDocId, inLocal, inNetwork);
                deleteDialog.setModal(true);
                deleteDialog.setVisible(true);
            }
        } else {
            DataPackageInterface dataPackage = null;
            try {
                ServiceController services = ServiceController.getInstance();
                ServiceProvider provider = services.getServiceProvider(DataPackageInterface.class);
                dataPackage = (DataPackageInterface)((Object)provider);
            }
            catch (ServiceNotHandledException snhe) {
                Log.debug(6, snhe.getMessage());
                return;
            }
            selectDocId = dataPackage.getDocIdFromMorphoFrame(frame);
            inNetwork = dataPackage.isDataPackageInNetwork(frame);
            inLocal = dataPackage.isDataPackageInLocal(frame);
            if (selectDocId != null && !selectDocId.equals("")) {
                deleteDialog = new DeleteDialog(frame, "dataPackageFrame", selectDocId, inLocal, inNetwork);
                deleteDialog.setModal(true);
                deleteDialog.setVisible(true);
            }
        }
    }
}

