/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.query;

import com.arbortext.catalog.Catalog;
import com.arbortext.catalog.CatalogEntityResolver;
import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.framework.ConfigXML;
import edu.ucsb.nceas.morpho.query.HeadResultSet;
import edu.ucsb.nceas.morpho.query.Query;
import edu.ucsb.nceas.morpho.query.QueryGroup;
import edu.ucsb.nceas.morpho.query.QueryTerm;
import edu.ucsb.nceas.morpho.query.ResultSet;
import edu.ucsb.nceas.morpho.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.xml.parsers.DocumentBuilder;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class LocalQuery {
    private static Vector doNotParse_collection = new Vector();
    public static Hashtable dom_collection = new Hashtable();
    private Query savedQuery = null;
    private static Hashtable doctype_collection = new Hashtable();
    private static Hashtable dataPackage_collection = new Hashtable();
    private static Hashtable packageTriples = new Hashtable();
    private Morpho morpho = null;
    private ConfigXML config = null;
    private String currentProfile;
    private String profileDir;
    private String datadir;
    private String local_dtd_directory;
    private String xmlcatalogfile;
    private String separator;
    private Vector returnFields;
    private Vector doctypes2bsearched;
    private Vector dt2bReturned;
    private String currentDoctype;
    private ImageIcon localPackageIcon = null;
    private ImageIcon localPackageDataIcon = null;

    public LocalQuery(Query query, Morpho morpho) {
        this.savedQuery = query;
        this.localPackageIcon = new ImageIcon(this.getClass().getResource("metadata-only-small.png"));
        this.localPackageIcon.setDescription("Documentation only");
        this.localPackageDataIcon = new ImageIcon(this.getClass().getResource("metadata+data-small.png"));
        this.localPackageDataIcon.setDescription("Data & documentation");
        this.morpho = morpho;
        this.config = morpho.getConfiguration();
        this.loadConfigurationParameters();
        this.datadir = this.datadir.trim();
        LocalQuery localQuery = this;
        this.xmlcatalogfile = localQuery.config.getConfigDirectory() + File.separator + this.local_dtd_directory.trim() + "/catalog";
    }

    public ResultSet execute() {
        Vector packageList = this.executeLocal(this.savedQuery.getQueryGroup());
        Vector row = null;
        Vector<Vector> rowCollection = new Vector<Vector>();
        HeadResultSet rs = null;
        if (packageList != null) {
            Enumeration pl = packageList.elements();
            while (pl.hasMoreElements()) {
                String packageName = (String)pl.nextElement();
                row = this.createRSRow(packageName);
                rowCollection.addElement(row);
            }
            rs = new HeadResultSet(this.savedQuery, "local", rowCollection, this.morpho);
        }
        return rs;
    }

    private Vector executeXPathQuery(String xpathExpression) {
        Vector package_IDs = new Vector();
        Log.debug(30, "(3.0) Creating DOM parser...");
        LocalQuery localQuery = this;
        DocumentBuilder parser = localQuery.morpho.createDomParser();
        Log.debug(30, "(3.1) DOM parser created...");
        CatalogEntityResolver cer = new CatalogEntityResolver();
        String catalogPath = this.config.get("local_catalog_path", 0);
        try {
            Catalog myCatalog = new Catalog();
            myCatalog.loadSystemCatalogs();
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            URL catalogURL = cl.getResource(catalogPath);
            myCatalog.parseCatalog(catalogURL.toString());
            cer.setCatalog(myCatalog);
        }
        catch (Exception e) {
            Log.debug(6, "Problem creating Catalog!" + e.toString());
        }
        parser.setEntityResolver(cer);
        long starttime = System.currentTimeMillis();
        File xmldir = new File(this.datadir);
        Vector filevector = new Vector();
        this.getFiles(xmldir, filevector);
        for (int i = 0; i < filevector.size(); ++i) {
            Element root;
            File currentfile = (File)filevector.elementAt(i);
            String filename = currentfile.getPath();
            File parentFile = new File(currentfile.getParent());
            String docid = parentFile.getName() + this.separator + currentfile.getName();
            if (!currentfile.isFile() || doNotParse_collection.contains(docid)) continue;
            if (dom_collection.containsKey(docid)) {
                root = ((Document)dom_collection.get(docid)).getDocumentElement();
                if (doctype_collection.containsKey(docid)) {
                    this.currentDoctype = (String)doctype_collection.get(docid);
                }
            } else {
                InputSource in;
                try {
                    in = new InputSource(new FileInputStream(filename));
                }
                catch (FileNotFoundException fnf) {
                    Log.debug(6, "FileInputStream of " + filename + " threw: " + fnf.toString());
                    continue;
                }
                Document current_doc = null;
                try {
                    Log.debug(30, "(3.2) Starting parse...");
                    current_doc = parser.parse(in);
                    Log.debug(30, "(3.3) Ended parse...");
                }
                catch (Exception e1) {
                    Log.debug(20, "Parsing error: " + filename);
                    Log.debug(20, e1.toString());
                    doNotParse_collection.addElement(docid);
                    continue;
                }
                root = current_doc.getDocumentElement();
                dom_collection.put(docid, current_doc);
                String temp = this.getDocTypeFromDOM(current_doc);
                if (temp == null) {
                    temp = root.getNodeName();
                }
                doctype_collection.put(docid, temp);
                this.currentDoctype = temp;
                if (this.dt2bReturned.contains("any") || this.dt2bReturned.contains(this.currentDoctype)) {
                    this.addToPackageList(root, docid);
                }
            }
            String rootname = root.getNodeName();
            NodeList nl = null;
            try {
                if (!this.doctypes2bsearched.contains("any") && !this.doctypes2bsearched.contains(this.currentDoctype)) continue;
                boolean allHits = false;
                if (xpathExpression.equals("//*[text()]")) {
                    allHits = true;
                } else {
                    nl = XPathAPI.selectNodeList((Node)root, (String)xpathExpression);
                }
                if ((nl == null || nl.getLength() <= 0) && !allHits) continue;
                try {
                    if (!dataPackage_collection.containsKey(docid)) continue;
                    Vector ids = (Vector)dataPackage_collection.get(docid);
                    Enumeration q = ids.elements();
                    while (q.hasMoreElements()) {
                        Object id = q.nextElement();
                        if (package_IDs.contains(id)) continue;
                        package_IDs.addElement(id);
                    }
                    continue;
                }
                catch (Exception rogue) {
                    Log.debug(1, "Fatal error: failed getting package list.");
                    continue;
                }
            }
            catch (Exception e2) {
                Log.debug(6, "selectNodeList threw: " + e2.toString() + " perhaps your xpath didn't select any nodes");
            }
        }
        long curtime = System.currentTimeMillis();
        return package_IDs;
    }

    private String getDoctypeFor(String docid) {
        String ret = "";
        if (doctype_collection.containsKey(docid)) {
            ret = (String)doctype_collection.get(docid);
        }
        return ret;
    }

    private Vector createRSRow(String docid) {
        String ent;
        int firstSep = docid.indexOf(this.separator);
        String filename = docid.substring(0, firstSep) + File.separator + docid.substring(firstSep + 1, docid.length());
        File fn = new File(this.datadir, filename);
        String fullfilename = fn.getPath();
        Vector tripleList = (Vector)packageTriples.get(docid);
        Vector<Object> rss = new Vector<Object>();
        boolean hasData = false;
        if (tripleList != null) {
            Enumeration tripleEnum = tripleList.elements();
            while (tripleEnum.hasMoreElements()) {
                String rel;
                Hashtable currentTriple = (Hashtable)tripleEnum.nextElement();
                if (!currentTriple.containsKey("relationship") || (rel = (String)currentTriple.get("relationship")).indexOf("isDataFileFor") == -1) continue;
                hasData = true;
            }
        }
        if ((ent = this.getValueForPath("entityName", docid)).length() > 0) {
            hasData = true;
        }
        if (hasData) {
            rss.addElement(this.localPackageDataIcon);
        } else {
            rss.addElement(this.localPackageIcon);
        }
        for (int i = 0; i < 3; ++i) {
            String fieldName = (String)this.returnFields.elementAt(i);
            rss.addElement(this.getValueForPath(fieldName, docid));
        }
        File fl = new File(fullfilename);
        Timestamp creationDate = new Timestamp(fl.lastModified());
        String date = creationDate.toString();
        rss.addElement(date);
        rss.addElement(date);
        rss.addElement(docid);
        Document doc = (Document)dom_collection.get(docid);
        String docname = doc.getNodeName();
        rss.addElement(docname);
        String thisDoctype = (String)doctype_collection.get(docid);
        rss.addElement(thisDoctype);
        rss.addElement(new Boolean(true));
        rss.addElement(new Boolean(false));
        if (tripleList != null) {
            rss.addElement(tripleList);
        }
        return rss;
    }

    private String getValueForPath(String pathstring, String filename) {
        String val = "";
        if (!pathstring.startsWith("/")) {
            pathstring = "//" + pathstring;
        }
        try {
            if (dom_collection.containsKey(filename)) {
                Element doc = ((Document)dom_collection.get(filename)).getDocumentElement();
                NodeList nl = null;
                nl = XPathAPI.selectNodeList((Node)doc, (String)pathstring);
                if (nl != null && nl.getLength() > 0) {
                    for (int k = 0; k < nl.getLength(); ++k) {
                        Node cn = nl.item(k).getFirstChild();
                        if (cn == null || cn.getNodeType() != 3) continue;
                        String temp = cn.getNodeValue().trim();
                        if (val.length() > 0) {
                            val = "; " + val;
                        }
                        val = temp + val;
                    }
                }
            }
        }
        catch (Exception e) {
            Log.debug(6, "Error in getValueForPath method");
        }
        return val;
    }

    private String getDocTypeFromDOM(Document doc) {
        String ret = null;
        DocumentType ddd = doc.getDoctype();
        if (ddd == null) {
            Element root = doc.getDocumentElement();
            String temp = root.getNamespaceURI();
            if (temp != null) {
                return temp;
            }
            return ret;
        }
        ret = ddd.getPublicId();
        if (ret == null && (ret = ddd.getSystemId()) == null) {
            ret = ddd.getName();
        }
        return ret;
    }

    private void getFiles(File directoryFile, Vector vec) {
        String[] files = directoryFile.list();
        for (int i = 0; i < files.length; ++i) {
            String filename = files[i];
            File currentfile = new File(directoryFile, filename);
            if (currentfile.isDirectory()) {
                this.getFiles(currentfile, vec);
            }
            if (!currentfile.isFile()) continue;
            try {
                Double d = Double.valueOf(filename);
                vec.addElement(currentfile);
                continue;
            }
            catch (NumberFormatException nfe) {
                Log.debug(30, "Not loading file with invalid name: " + filename);
            }
        }
        this.getLatestVersion(vec);
    }

    private void getLatestVersion(Vector vec) {
        Vector<String> newvec = new Vector<String>();
        for (int j = 0; j < vec.size(); ++j) {
            File file = (File)vec.elementAt(j);
            String name = file.getName();
            newvec.addElement(name);
        }
        int cnt = 0;
        for (int k = 0; k < newvec.size(); ++k) {
            String name1 = (String)newvec.elementAt(k);
            int periodloc = name1.lastIndexOf(".");
            String namestart = name1.substring(0, periodloc);
            String vernum = name1.substring(periodloc + 1, name1.length());
            Integer Intver = new Integer(vernum);
            int iver = Intver;
            String newstr = namestart + "." + (iver + 1);
            if (!newvec.contains(newstr)) continue;
            vec.removeElementAt(k - cnt);
            ++cnt;
        }
    }

    private String QueryTermToXPath(QueryTerm qt) {
        String pathExpression;
        boolean caseSensitive = qt.isCaseSensitive();
        String searchMode = qt.getSearchMode();
        String value = qt.getValue();
        if (!caseSensitive) {
            value = value.toLowerCase();
        }
        String xpath = (pathExpression = qt.getPathExpression()) == null ? "//*" : (pathExpression.startsWith("/") ? pathExpression : "//" + pathExpression);
        if (value == null || value.equals("%") || value.equals("*") || value.equals("")) {
            xpath = xpath + "[text()]";
            return xpath;
        }
        if (!caseSensitive) {
            if (searchMode.equals("starts-with")) {
                xpath = xpath + "[starts-with(translate(text()," + "\"ABCDEFGHIJKLMNOPQRSTUVWXYZ\",\"abcdefghijklmnopqrstuvwxyz\"),\"" + value + "\")]";
            } else if (searchMode.equals("ends-with")) {
                xpath = xpath + "[contains(translate(text()," + "\"ABCDEFGHIJKLMNOPQRSTUVWXYZ\",\"abcdefghijklmnopqrstuvwxyz\"),\"" + value + "\")]";
            } else if (searchMode.equals("contains")) {
                xpath = xpath + "[contains(translate(text()," + "\"ABCDEFGHIJKLMNOPQRSTUVWXYZ\",\"abcdefghijklmnopqrstuvwxyz\"),\"" + value + "\")]";
            } else if (searchMode.equals("equals")) {
                xpath = xpath + "[translate(text()," + "\"ABCDEFGHIJKLMNOPQRSTUVWXYZ\",\"abcdefghijklmnopqrstuvwxyz\")=\"" + value + "\"]";
            } else if (searchMode.equals("less-than")) {
                xpath = xpath + "[number(text()) < " + value + "]";
            } else if (searchMode.equals("greater-than")) {
                xpath = xpath + "[number(text()) > " + value + "]";
            } else if (searchMode.equals("greater-than-equals")) {
                xpath = xpath + "[number(text()) >= " + value + "]";
            } else if (searchMode.equals("less-than-equals")) {
                xpath = xpath + "[number(text()) <= " + value + "]";
            }
        } else if (searchMode.equals("starts-with")) {
            xpath = xpath + "[starts-with(text(),\"" + value + "\")]";
        } else if (searchMode.equals("ends-with")) {
            xpath = xpath + "[contains(text(),\"" + value + "\")]";
        } else if (searchMode.equals("contains")) {
            xpath = xpath + "[contains(text(),\"" + value + "\")]";
        } else if (searchMode.equals("equals")) {
            xpath = xpath + "[text()=\"" + value + "\"]";
        } else if (searchMode.equals("less-than")) {
            xpath = xpath + "[number(text()) < " + value + "]";
        } else if (searchMode.equals("greater-than")) {
            xpath = xpath + "[number(text()) > " + value + "]";
        } else if (searchMode.equals("greater-than-equals")) {
            xpath = xpath + "[number(text()) >= " + value + "]";
        } else if (searchMode.equals("less-than-equals")) {
            xpath = xpath + "[number(text()) <= " + value + "]";
        }
        return xpath;
    }

    private Vector executeLocal(QueryGroup qg) {
        Vector combined = null;
        Vector currentResults = null;
        Enumeration children = qg.getChildren();
        while (children.hasMoreElements()) {
            Object child = children.nextElement();
            if (child instanceof QueryTerm) {
                String xpath = this.QueryTermToXPath((QueryTerm)child);
                currentResults = this.executeXPathQuery(xpath);
            } else {
                currentResults = this.executeLocal((QueryGroup)child);
            }
            if (currentResults == null && qg.getOperator().equalsIgnoreCase("intersect")) {
                combined = null;
                break;
            }
            if (qg.getOperator().equalsIgnoreCase("intersect")) {
                if (combined == null) {
                    combined = (Vector)currentResults.clone();
                    continue;
                }
                Vector original = (Vector)combined.clone();
                combined = new Vector();
                for (int i = 0; i < currentResults.size(); ++i) {
                    Object obj = currentResults.elementAt(i);
                    if (!original.contains(obj)) continue;
                    combined.addElement(obj);
                }
                continue;
            }
            if (!qg.getOperator().equalsIgnoreCase("union")) continue;
            if (combined == null) {
                combined = (Vector)currentResults.clone();
                continue;
            }
            Enumeration q = currentResults.elements();
            while (q.hasMoreElements()) {
                String temp = (String)q.nextElement();
                if (combined.contains(temp)) continue;
                combined.addElement(temp);
            }
        }
        return combined;
    }

    private void loadConfigurationParameters() {
        ConfigXML profile = this.morpho.getProfile();
        this.currentProfile = profile.get("profilename", 0);
        LocalQuery localQuery = this;
        this.profileDir = localQuery.config.getConfigDirectory() + File.separator + this.config.get("profile_directory", 0) + File.separator + this.currentProfile;
        this.datadir = this.profileDir + File.separator + profile.get("datadir", 0);
        String searchLocalString = profile.get("searchlocal", 0);
        this.returnFields = this.config.get("returnfield");
        this.doctypes2bsearched = this.config.get("doctype");
        this.dt2bReturned = this.config.get("returndoc");
        this.local_dtd_directory = this.config.get("local_dtd_directory", 0);
        this.separator = profile.get("separator", 0);
    }

    public static void removeFromCache(String docid) {
        dom_collection.remove(docid);
        doctype_collection.remove(docid);
        dataPackage_collection.remove(docid);
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            Log.debug(1, "Wrong number of arguments!!!");
            Log.debug(1, "USAGE: java LocalQuery <xmlfile>");
            return;
        }
        int i = 0;
        boolean useXMLIndex = true;
        String xmlfile = args[i];
        try {
            Morpho morpho = new Morpho(new ConfigXML("lib/config.xml"));
            FileReader xml = new FileReader(new File(xmlfile));
            Query query = new Query(xml, morpho);
            LocalQuery qspec = new LocalQuery(query, morpho);
            ResultSet rs = qspec.execute();
        }
        catch (IOException e) {
            Log.debug(1, e.getMessage());
        }
    }

    private void addToPackageList(Node docNode, String packageDocid) {
        String subject = "";
        String relationship = "";
        String object = "";
        Node currentNode = null;
        NodeList nl = null;
        String xpathExpression = "//triple";
        Vector tripleList = new Vector();
        try {
            nl = XPathAPI.selectNodeList((Node)docNode, (String)xpathExpression);
        }
        catch (Exception ee) {
            Log.debug(6, "Error in building PackageList!");
        }
        if (nl != null && nl.getLength() > 0) {
            for (int m = 0; m < nl.getLength(); ++m) {
                Vector<String> vec;
                Vector curvec;
                Hashtable<String, String> triple = new Hashtable<String, String>();
                NodeList nlchildren = nl.item(m).getChildNodes();
                for (int n = 0; n < nlchildren.getLength(); ++n) {
                    if (nlchildren.item(n).getNodeType() == 3) continue;
                    if (nlchildren.item(n).getLocalName().equalsIgnoreCase("subject")) {
                        currentNode = nlchildren.item(n).getFirstChild();
                        subject = currentNode.getNodeValue().trim();
                        triple.put("subject", subject);
                    }
                    if (nlchildren.item(n).getLocalName().equalsIgnoreCase("relationship")) {
                        currentNode = nlchildren.item(n).getFirstChild();
                        relationship = currentNode.getNodeValue().trim();
                        triple.put("relationship", relationship);
                    }
                    if (!nlchildren.item(n).getLocalName().equalsIgnoreCase("object")) continue;
                    currentNode = nlchildren.item(n).getFirstChild();
                    object = currentNode.getNodeValue().trim();
                    triple.put("object", object);
                }
                tripleList.addElement(triple);
                if (!dataPackage_collection.containsKey(packageDocid)) {
                    Vector<String> vec2 = new Vector<String>();
                    vec2.addElement(packageDocid);
                    dataPackage_collection.put(packageDocid, vec2);
                }
                if (dataPackage_collection.containsKey(subject)) {
                    curvec = (Vector)dataPackage_collection.get(subject);
                    curvec.addElement(packageDocid);
                } else {
                    vec = new Vector<String>();
                    vec.addElement(packageDocid);
                    dataPackage_collection.put(subject, vec);
                }
                if (dataPackage_collection.containsKey(object)) {
                    curvec = (Vector)dataPackage_collection.get(object);
                    curvec.addElement(packageDocid);
                    continue;
                }
                vec = new Vector();
                vec.addElement(packageDocid);
                dataPackage_collection.put(object, vec);
            }
        }
        if (!dataPackage_collection.containsKey(packageDocid)) {
            Vector<String> vec = new Vector<String>();
            vec.addElement(packageDocid);
            dataPackage_collection.put(packageDocid, vec);
        }
        if (!packageTriples.containsKey(packageDocid)) {
            packageTriples.put(packageDocid, tripleList);
        }
    }
}

