/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.query;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.query.Query;
import edu.ucsb.nceas.morpho.query.ResultSet;
import edu.ucsb.nceas.morpho.util.Log;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class HeadResultSet
extends ResultSet {
    private Vector headResultsVector = null;

    public HeadResultSet(Query query, String source, InputStream resultsXMLStream, Morpho morpho) {
        super(query, source, resultsXMLStream, morpho);
        this.consolidateResults();
    }

    public HeadResultSet(Query query, String source, Vector vec, Morpho morpho) {
        super(query, source, vec, morpho);
        this.consolidateResults();
    }

    public int getRowCount() {
        return this.headResultsVector.size();
    }

    public Vector getResultsVector() {
        return this.headResultsVector;
    }

    public void setResultsVector(Vector vector) {
        this.headResultsVector = vector;
    }

    public Object getValueAt(int row, int col) {
        Object value = null;
        try {
            Vector rowVector = (Vector)this.headResultsVector.elementAt(row);
            value = rowVector.elementAt(this.lookupResultsVectorIndex(col));
            if (col == 6) {
                Boolean isLocally = (Boolean)value;
                value = isLocally != false ? localIcon : blankIcon;
            }
            if (col == 7) {
                Boolean isNet = (Boolean)value;
                value = isNet.booleanValue() ? metacatIcon : blankIcon;
            }
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            String emptyString = "";
            value = null;
        }
        catch (NullPointerException npe) {
            String emptyString = "";
            value = emptyString;
        }
        return value;
    }

    public void openResultRecord(int row) {
        try {
            Vector rowVector = (Vector)this.headResultsVector.elementAt(row);
            this.openResultRecord(rowVector);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            Log.debug(1, "array index out of bounds");
        }
    }

    public void merge(ResultSet r2) {
        super.merge(r2);
        this.consolidateResults();
    }

    public void merge(Vector vector2) {
        super.merge(vector2);
        this.consolidateResults();
    }

    private void consolidateResults() {
        int numHeaders = this.getColumnCount();
        Hashtable<String, Integer> maxRevHash = new Hashtable<String, Integer>();
        Hashtable<String, Vector> maxRevRow = new Hashtable<String, Vector>();
        for (int i = 0; i < this.resultsVector.size(); ++i) {
            Vector rowVector = null;
            String docid = null;
            String family = null;
            String rev = null;
            Integer currentRev = null;
            Integer maxRev = null;
            try {
                rowVector = (Vector)this.resultsVector.elementAt(i);
                docid = (String)rowVector.elementAt(6);
                family = docid.substring(0, docid.lastIndexOf("."));
                rev = docid.substring(docid.lastIndexOf(".") + 1);
                currentRev = new Integer(rev);
                maxRev = (Integer)maxRevHash.get(family);
            }
            catch (Exception e) {
                // empty catch block
            }
            int currentRevint = 0;
            int maxRevint = 0;
            if (currentRev != null) {
                currentRevint = currentRev;
            }
            if (maxRev != null) {
                maxRevint = maxRev;
            }
            if (maxRev != null && currentRevint <= maxRevint || family == null) continue;
            maxRevHash.put(family, currentRev);
            maxRevRow.put(family, rowVector);
        }
        this.headResultsVector = new Vector();
        Enumeration enumeration = maxRevRow.elements();
        while (enumeration.hasMoreElements()) {
            this.headResultsVector.addElement(enumeration.nextElement());
        }
    }

    public void sortTableByColumn(int col, String order) {
        this.sortVector(this.headResultsVector, col, order);
    }
}

