/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.printer;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.framework.ConfigXML;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.printer.PrinterPlugin;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.DocumentNotFoundException;
import edu.ucsb.nceas.morpho.util.IOUtil;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.morpho.util.XMLTransformer;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import org.w3c.dom.Document;

public class PrintCommand
implements Command {
    private Morpho instanceOfMorpho;
    private PrinterPlugin printerPlugin;
    private ConfigXML config;
    private final String CONFIG_KEY_CSS_LOCATION = "emlCSSLocation";
    private final String CONFIG_KEY_MCONFJAR_LOC = "morphoConfigJarLocation";

    public void execute(ActionEvent ae) {
        AbstractDataPackage adp = UIController.getInstance().getCurrentAbstractDataPackage();
        if (adp == null) {
            Log.debug(16, " Abstract Data Package is null in the Print Plugin");
            return;
        }
        XMLTransformer transformer = XMLTransformer.getInstance();
        transformer.addTransformerProperty("displaymodule", "printall");
        transformer.addTransformerProperty("stylePath", this.getFullStylePath());
        Reader xmlReader = null;
        Reader resultReader = null;
        String htmlDoc = "<html><head><h2>Error displaying the requested Document</h2></head></html>";
        String ID = "";
        try {
            ID = adp.getPackageId();
            if (ID == null || ID.equals("")) {
                ID = "tempid";
            }
            resultReader = null;
            Document doc = adp.openAsDom(ID);
            if (doc == null) {
                xmlReader = adp.openAsReader(ID);
                resultReader = transformer.transform(xmlReader);
            } else {
                resultReader = transformer.transform(doc);
            }
            StringBuffer sb = IOUtil.getAsStringBuffer(resultReader, true);
            htmlDoc = sb.toString();
        }
        catch (DocumentNotFoundException dnfe) {
            Log.debug(12, "DocumentNotFoundException getting Reader for ID: " + ID + "; " + dnfe.getMessage());
        }
        catch (IOException io) {
            Log.debug(12, "IOException while getting the string for ID:" + ID + "; " + io);
        }
        catch (Exception e) {
            Log.debug(12, "Exception during Transformation in PrintCommand - " + e);
        }
        this.printerPlugin.print(htmlDoc, "text/html");
    }

    public PrintCommand(Morpho morpho, PrinterPlugin prPlugin) {
        this.instanceOfMorpho = morpho;
        this.printerPlugin = prPlugin;
        this.config = Morpho.getConfiguration();
    }

    private String getFullStylePath() {
        StringBuffer pathBuff = new StringBuffer();
        pathBuff.append("jar:file:");
        pathBuff.append(new File("").getAbsolutePath());
        pathBuff.append("/");
        pathBuff.append(this.config.get("morphoConfigJarLocation", 0));
        pathBuff.append("!/");
        pathBuff.append(this.config.get("emlCSSLocation", 0));
        Log.debug(50, "PrinterCommand.getFullStylePath() returning: " + pathBuff.toString());
        return pathBuff.toString();
    }
}

