/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.datapackage.DataViewContainerPanel;
import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.CustomTable;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WidgetFactory;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardPageSubPanelAPI;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.CodeDefnPanel;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.PopupHandler;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Node;

public class TaxonImportPanel
extends JPanel
implements WizardPageSubPanelAPI {
    private static final int LABEL_WIDTH = 85;
    private static final int LABEL_HEIGHT = 17;
    public static final int DIALOG_WIDTH = 600;
    public static final int DIALOG_HEIGHT = 450;
    private DataViewContainerPanel resultPane = null;
    private AbstractDataPackage adp = null;
    private CustomTable table = null;
    private JPanel radioPanel = null;
    private Vector tableNames = null;
    private Vector colNames = null;
    private Vector colData = null;
    private Vector rowData = null;
    private Vector typeNames = null;
    private static final String nominal_xPath = "/attribute/measurementScale[1]/nominal[1]/nonNumericDomain[1]";
    private static final String ordinal_xPath = "/attribute/measurementScale[1]/ordinal[1]/nonNumericDomain[1]";
    private String[] importChoiceText = new String[]{"Import all values", "Import only the values used in the dataset"};
    private int selectedImportChoice = 0;
    public boolean displayTable = true;

    TaxonImportPanel() {
        this.init();
    }

    private void init() {
        this.displayTable = true;
        this.setLayout(new BoxLayout(this, 1));
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 1));
        JLabel topLabel = WidgetFactory.makeHTMLLabel("Select the columns to import ", 1, false);
        topPanel.add(WidgetFactory.makeDefaultSpacer());
        topPanel.add(topLabel);
        this.add(topPanel);
        this.add(WidgetFactory.makeDefaultSpacer());
        int ht = 100;
        this.table = this.getCustomTable();
        if (this.table == null || this.table.getColumnCount() == 0) {
            Log.debug(45, "CustomTable is empty, hence not displaying it");
            this.displayTable = false;
        } else {
            this.table.addPopupListener(new PopupHandler());
        }
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BorderLayout());
        if (this.table != null) {
            tablePanel.add((Component)this.table, "Center");
            ht = this.table.getHeaderHeight();
            if (ht < 100) {
                ht = 100;
            }
        }
        JPanel sideLabelPanel = new JPanel(new BorderLayout());
        sideLabelPanel.add((Component)tablePanel, "Center");
        JPanel subLabelPanel = new JPanel();
        subLabelPanel.setLayout(new BoxLayout(subLabelPanel, 1));
        subLabelPanel.add(this.getLabel(""));
        subLabelPanel.add(this.getLabel(""));
        subLabelPanel.add(this.getLabel("Table Name:"));
        subLabelPanel.add(this.getLabel("Column Name:"));
        subLabelPanel.add(this.getLabel("Column Type:"));
        subLabelPanel.setMaximumSize(new Dimension(85, ht));
        subLabelPanel.setMinimumSize(new Dimension(85, ht));
        subLabelPanel.setPreferredSize(new Dimension(85, ht));
        JPanel sidePanel = new JPanel(new BorderLayout());
        sidePanel.add((Component)subLabelPanel, "North");
        sidePanel.add((Component)new JLabel(""), "Center");
        sidePanel.add(Box.createVerticalGlue(), "South");
        sideLabelPanel.add((Component)sidePanel, "West");
        JPanel emptyPanel = new JPanel(new BorderLayout());
        JLabel emptyHeaderLabel = WidgetFactory.makeHTMLLabel("<b>No columns to import</b>", 1, false);
        JLabel emptyExplLabel = WidgetFactory.makeHTMLLabel("You can import only columns of type <i>Text</i> or <i>Enumerated</i>, i.e. they should be either Nominal or Ordinal", 2, false);
        JPanel topEmptyPanel = new JPanel();
        topEmptyPanel.setLayout(new BoxLayout(topEmptyPanel, 1));
        topEmptyPanel.add(emptyHeaderLabel);
        topEmptyPanel.add(emptyExplLabel);
        emptyPanel.add((Component)topEmptyPanel, "North");
        if (this.displayTable) {
            this.add(sideLabelPanel);
        } else {
            this.add(emptyPanel);
        }
        this.add(WidgetFactory.makeDefaultSpacer());
        JLabel choiceLabel = WidgetFactory.makeHTMLLabel("What data should be imported from these columns? ", 1, true);
        if (this.displayTable) {
            this.add(choiceLabel);
        }
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Log.debug(45, "got radiobutton command: " + e.getActionCommand());
                if (e.getActionCommand().equals(TaxonImportPanel.this.importChoiceText[0])) {
                    TaxonImportPanel.this.selectedImportChoice = 0;
                } else if (e.getActionCommand().equals(TaxonImportPanel.this.importChoiceText[1])) {
                    TaxonImportPanel.this.selectedImportChoice = 1;
                }
            }
        };
        this.radioPanel = WidgetFactory.makeRadioPanel(this.importChoiceText, 0, listener);
        if (this.displayTable) {
            this.add(this.radioPanel);
        }
        this.add(WidgetFactory.makeDefaultSpacer());
    }

    private JLabel getLabel(String text) {
        if (text == null) {
            text = "";
        }
        JLabel label = new JLabel(text);
        label.setAlignmentX(1.0f);
        label.setMaximumSize(new Dimension(85, 17));
        label.setMinimumSize(new Dimension(85, 17));
        label.setPreferredSize(new Dimension(85, 17));
        return label;
    }

    public List getListOfImportedTaxa() {
        ArrayList result = new ArrayList();
        if (!this.displayTable) {
            return result;
        }
        int[] cols = this.table.getSelectedColumns();
        int ecnt = this.adp.getEntityCount();
        File[] entityFiles = new File[ecnt];
        for (int i = 0; i < ecnt; ++i) {
            entityFiles[i] = null;
        }
        int[] numHeaderLines = new int[ecnt];
        String[] delimiter = new String[ecnt];
        Morpho morpho = this.resultPane.getFramework();
        for (int i = 0; i < cols.length; ++i) {
            Vector header = this.table.getColumnHeaderStrings(cols[i]);
            String taxonClass = " ";
            if (header.size() == 4) {
                taxonClass = (String)header.get(3);
            }
            List colData = this.table.getColumnData(cols[i]);
            if (this.isText(header) || this.selectedImportChoice == 0) {
                String val;
                colData = this.removeRedundantData(colData);
                Iterator it = colData.iterator();
                while (it.hasNext() && (val = (String)it.next()) != null && !val.trim().equals("")) {
                    ArrayList<String> t = new ArrayList<String>();
                    t.add(val);
                    t.add(taxonClass);
                    result.add(t);
                }
                continue;
            }
            boolean isDefn = this.isDefinition(header);
            String tableName = (String)header.get(0);
            String colName = (String)header.get(1);
            int entityIndex = this.adp.getEntityIndex(tableName);
            if (entityFiles[entityIndex] == null) {
                entityFiles[entityIndex] = CodeDefnPanel.getEntityFile(morpho, this.adp, entityIndex);
                String numHeaders = this.adp.getPhysicalNumberHeaderLines(entityIndex, 0);
                try {
                    if (numHeaders != null) {
                        numHeaderLines[entityIndex] = Integer.parseInt(numHeaders);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                String field_delimiter = this.adp.getPhysicalFieldDelimiter(entityIndex, 0);
                delimiter[entityIndex] = this.getDelimiterString(field_delimiter);
            }
            int colIdx = this.adp.getAttributeIndex(entityIndex, colName);
            List data = CodeDefnPanel.getOneColumnValue(entityFiles[entityIndex], colIdx, numHeaderLines[entityIndex], delimiter[entityIndex], -1);
            data = this.removeRedundantData(data);
            if (!isDefn) {
                Iterator it = data.iterator();
                while (it.hasNext()) {
                    ArrayList<String> t = new ArrayList<String>();
                    t.add((String)it.next());
                    t.add(taxonClass);
                    result.add(t);
                }
                continue;
            }
            List prevColData = this.table.getColumnData(cols[i] - 1);
            int cnt = 0;
            for (String code : prevColData) {
                if (data.contains(code)) {
                    ArrayList temp = new ArrayList();
                    temp.add(colData.get(cnt));
                    temp.add(taxonClass);
                    result.add(temp);
                }
                ++cnt;
            }
        }
        return result;
    }

    private List removeRedundantData(List data) {
        ArrayList<String> newData = new ArrayList<String>();
        for (String d : data) {
            if (newData.contains(d)) continue;
            newData.add(d);
        }
        return newData;
    }

    private boolean isDefinition(Vector headerVector) {
        if (headerVector.size() < 3) {
            return false;
        }
        String type = (String)headerVector.get(2);
        return type.indexOf("Code") <= -1;
    }

    private boolean isText(Vector headerVector) {
        if (headerVector.size() < 3) {
            return false;
        }
        String type = (String)headerVector.get(2);
        return type.indexOf("Text") > -1;
    }

    private CustomTable getCustomTable() {
        if (this.adp == null) {
            this.getADP();
        }
        if (this.adp == null) {
            Log.debug(10, "Unable to obtain the Abstract Data Package while building CustomTable in taxonomic page");
            return null;
        }
        this.tableNames = new Vector();
        this.colNames = new Vector();
        this.rowData = new Vector();
        this.typeNames = new Vector();
        String[] tables = this.getEntityNames();
        if (tables == null) {
            return null;
        }
        Morpho morpho = this.resultPane.getFramework();
        for (int i = 0; i < tables.length; ++i) {
            List textData;
            Vector<Integer> colsToExtract = new Vector<Integer>();
            String[] cols = this.getColumnNames(i);
            for (int j = 0; j < cols.length; ++j) {
                String colType = this.adp.getAttributeDataType(i, j);
                if (!colType.trim().equalsIgnoreCase("text") && !colType.trim().equalsIgnoreCase("Nominal") && !colType.trim().equalsIgnoreCase("Ordinal") && !colType.trim().equalsIgnoreCase("String")) continue;
                colsToExtract.add(new Integer(j));
            }
            if (colsToExtract.size() <= 0) continue;
            if (this.adp == null) {
                this.getADP();
            }
            Node[] attributes = this.adp.getAttributeArray(i);
            OrderedMap[] maps = new OrderedMap[colsToExtract.size()];
            char[] measScale = new char[colsToExtract.size()];
            Vector<Integer> enumCols = new Vector<Integer>();
            Vector<Integer> textCols = new Vector<Integer>();
            for (int k = 0; k < colsToExtract.size(); ++k) {
                int col = (Integer)colsToExtract.get(k);
                maps[k] = XMLUtilities.getDOMTreeAsXPathMap((Node)attributes[col]);
                measScale[k] = this.findMeasurementScale(maps[k], "/attribute");
                if (measScale[k] == 'R' || measScale[k] == ' ') continue;
                if (measScale[k] == 'n' || measScale[k] == 'o') {
                    textCols.add(new Integer(col));
                    continue;
                }
                enumCols.add(new Integer(col));
            }
            List data = this.getCodeDefinitionsFromAttributes(maps, measScale, enumCols);
            if (data.size() > 0) {
                TaxonImportPanel.addColumnsToRowData(this.rowData, data);
                Iterator it = enumCols.iterator();
                while (it.hasNext()) {
                    int c = (Integer)it.next();
                    this.tableNames.add(tables[i]);
                    this.tableNames.add(tables[i]);
                    this.colNames.add(cols[c]);
                    this.colNames.add(cols[c]);
                    this.typeNames.add("[ Code ]");
                    this.typeNames.add("[ Definition ]");
                }
            }
            if ((textData = this.getTextValuesFromAttributes(i, textCols)).size() <= 0) continue;
            TaxonImportPanel.addColumnsToRowData(this.rowData, textData);
            Iterator it = textCols.iterator();
            while (it.hasNext()) {
                int c = (Integer)it.next();
                this.tableNames.add(tables[i]);
                this.colNames.add(cols[c]);
                this.typeNames.add("[ Text ]");
            }
        }
        Vector<Vector> header = new Vector<Vector>();
        header.add(this.tableNames);
        header.add(this.colNames);
        header.add(this.typeNames);
        return new CustomTable(header, this.rowData);
    }

    List getTextValuesFromAttributes(int entityIndex, Vector textCols) {
        Morpho morpho = this.resultPane.getFramework();
        File entityFile = CodeDefnPanel.getEntityFile(morpho, this.adp, entityIndex);
        String numHeaders = this.adp.getPhysicalNumberHeaderLines(entityIndex, 0);
        int numHeaderLines = 0;
        try {
            if (numHeaders != null) {
                numHeaderLines = Integer.parseInt(numHeaders);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String field_delimiter = this.adp.getPhysicalFieldDelimiter(entityIndex, 0);
        String delimiter = this.getDelimiterString(field_delimiter);
        boolean ignoreConsecutiveDelimiters = this.adp.ignoreConsecutiveDelimiters(entityIndex, 0);
        List rowData = CodeDefnPanel.getColumnValues(entityFile, textCols, numHeaderLines, delimiter, ignoreConsecutiveDelimiters, -1);
        return rowData;
    }

    private List getCodeDefinitionsFromAttributes(OrderedMap[] maps, char[] measScale, Vector cols) {
        ArrayList res = new ArrayList();
        int cnt = 1;
        while (true) {
            ArrayList<String> row = new ArrayList<String>();
            boolean dataPresent = false;
            for (int i = 0; i < maps.length; ++i) {
                if (!cols.contains(new Integer(i)) || maps[i] == null) continue;
                Object o = null;
                if (measScale[i] == 'N') {
                    o = maps[i].get((Object)("/attribute/measurementScale[1]/nominal[1]/nonNumericDomain[1]/enumeratedDomain[1]/codeDefinition[" + cnt + "]/code[1]"));
                } else if (measScale[i] == 'O') {
                    o = maps[i].get((Object)("/attribute/measurementScale[1]/ordinal[1]/nonNumericDomain[1]/enumeratedDomain[1]/codeDefinition[" + cnt + "]/code[1]"));
                }
                if (o == null) {
                    row.add("");
                    row.add("");
                    continue;
                }
                row.add((String)o);
                String defn = "";
                if (measScale[i] == 'N') {
                    defn = (String)maps[i].get((Object)("/attribute/measurementScale[1]/nominal[1]/nonNumericDomain[1]/enumeratedDomain[1]/codeDefinition[" + cnt + "]/definition[1]"));
                } else if (measScale[i] == 'O') {
                    defn = (String)maps[i].get((Object)("/attribute/measurementScale[1]/ordinal[1]/nonNumericDomain[1]/enumeratedDomain[1]/codeDefinition[" + cnt + "]/definition[1]"));
                }
                row.add(defn);
                dataPresent = true;
            }
            if (!dataPresent) break;
            res.add(row);
            ++cnt;
        }
        return res;
    }

    public static void addColumnsToRowData(Vector rowData, List data) {
        if (data.size() == 0) {
            return;
        }
        if (rowData.size() == 0) {
            for (int i = 0; i < data.size(); ++i) {
                rowData.add(new Vector((List)data.get(i)));
            }
            return;
        }
        int cnt = rowData.size();
        int dcnt = data.size();
        int cols = ((Vector)rowData.get(0)).size();
        int dcols = ((List)data.get(0)).size();
        for (int i = 0; i < cnt; ++i) {
            Vector row = (Vector)rowData.get(i);
            if (i < dcnt) {
                row.addAll((List)data.get(i));
                continue;
            }
            for (int j = 0; j < dcols; ++j) {
                row.add("");
            }
        }
        if (cnt < dcnt) {
            for (int l = cnt; l < dcnt; ++l) {
                Vector<String> newRow = new Vector<String>();
                for (int k = 0; k < cols; ++k) {
                    newRow.add("");
                }
                newRow.addAll((List)data.get(l));
                rowData.add(newRow);
            }
        }
    }

    private char findMeasurementScale(OrderedMap map, String xPath) {
        Object o1 = map.get((Object)(xPath + "/measurementScale[1]/nominal[1]/nonNumericDomain[1]/enumeratedDomain[1]/codeDefinition[1]/code[1]"));
        if (o1 != null) {
            return 'N';
        }
        o1 = map.get((Object)(xPath + "/measurementScale[1]/nominal[1]/nonNumericDomain[1]/textDomain[1]/definition[1]"));
        if (o1 != null) {
            return 'n';
        }
        boolean b1 = map.containsKey((Object)(xPath + "/measurementScale[1]/nominal[1]/nonNumericDomain[1]/enumeratedDomain[1]/entityCodeList[1]/entityReference[1]"));
        if (b1) {
            return 'R';
        }
        o1 = map.get((Object)(xPath + "/measurementScale[1]/ordinal[1]/nonNumericDomain[1]/enumeratedDomain[1]/codeDefinition[1]/code[1]"));
        if (o1 != null) {
            return 'O';
        }
        o1 = map.get((Object)(xPath + "/measurementScale[1]/ordinal[1]/nonNumericDomain[1]/textDomain[1]/definition[1]"));
        if (o1 != null) {
            return 'o';
        }
        b1 = map.containsKey((Object)(xPath + "/measurementScale[1]/ordinal[1]/nonNumericDomain[1]/enumeratedDomain[1]/entityCodeList[1]/entityReference[1]"));
        if (b1) {
            return 'R';
        }
        return ' ';
    }

    private void getADP() {
        MorphoFrame morphoFrame = UIController.getInstance().getCurrentActiveWindow();
        if (morphoFrame != null) {
            this.resultPane = morphoFrame.getDataViewContainerPanel();
        }
        if (this.resultPane != null) {
            this.adp = this.resultPane.getAbstractDataPackage();
        }
    }

    private String[] getEntityNames() {
        if (this.adp == null) {
            this.getADP();
        }
        String[] entNames = null;
        if (this.adp != null) {
            int cnt = this.adp.getEntityCount();
            entNames = new String[cnt];
            for (int i = 0; i < cnt; ++i) {
                entNames[i] = this.adp.getEntityName(i);
            }
        } else {
            Log.debug(45, "Error - Unable to get the AbstractDataPackage in CodeImportPanel. ");
        }
        return entNames;
    }

    private String[] getColumnNames(int entityIndex) {
        if (this.adp == null) {
            this.getADP();
        }
        String[] cols = new String[]{};
        int num = this.adp.getAttributeCountForAnEntity(entityIndex);
        if (this.adp != null) {
            cols = new String[num];
            for (int i = 0; i < num; ++i) {
                cols[i] = this.adp.getAttributeName(entityIndex, i);
            }
        }
        return cols;
    }

    private String getDelimiterString(String field_delimiter) {
        String str = "";
        String temp = field_delimiter.trim();
        if (temp.startsWith("#x")) {
            if ((temp = temp.substring(2)).equals("0A")) {
                str = "\n";
            }
            if (temp.equals("09")) {
                str = "\t";
            }
            if (temp.equals("20")) {
                str = " ";
            }
        } else {
            str = temp;
        }
        return str;
    }

    public void onLoadAction() {
    }

    public boolean onAdvanceAction() {
        return true;
    }

    public boolean validateUserInput() {
        return true;
    }

    public OrderedMap getPanelData(String xPathRoot) {
        return null;
    }

    public void setPanelData(String xPathRoot, OrderedMap map) {
    }
}

