/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages;

import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardSettings;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.TaxonLevel;
import java.util.Iterator;
import java.util.Vector;

class TaxonHierarchy
implements Comparable {
    private Vector taxonLevels;

    TaxonHierarchy() {
        this.taxonLevels = new Vector();
        for (int i = 0; i < WizardSettings.commonTaxonRanks.length; ++i) {
            TaxonLevel level = new TaxonLevel(WizardSettings.commonTaxonRanks[i], "", null);
            this.taxonLevels.add(level);
        }
    }

    TaxonHierarchy(TaxonLevel[] levels) {
        this.taxonLevels = new Vector();
        for (int i = 0; i < levels.length; ++i) {
            this.taxonLevels.add(levels[i]);
        }
    }

    TaxonHierarchy(Vector levels) {
        this.taxonLevels = levels;
    }

    public void addTaxon(TaxonLevel level) {
        if (level == null) {
            return;
        }
        if (this.taxonLevels == null) {
            this.taxonLevels = new Vector();
        }
        this.taxonLevels.add(level);
    }

    public void insertTaxonAtLevel(int pos, TaxonLevel level) {
        if (level == null) {
            return;
        }
        if (this.taxonLevels == null) {
            this.taxonLevels = new Vector();
        }
        if (pos < 0) {
            return;
        }
        if (pos >= this.taxonLevels.size()) {
            this.taxonLevels.add(level);
        } else {
            this.taxonLevels.add(pos, level);
        }
    }

    public TaxonLevel getTaxonAtLevel(int level) {
        if (level < 0 || level >= this.taxonLevels.size()) {
            return null;
        }
        return (TaxonLevel)this.taxonLevels.get(level);
    }

    public void setTaxonAtLevel(int level, TaxonLevel taxon) {
        if (level < 0 || level >= this.taxonLevels.size() || taxon == null) {
            return;
        }
        this.taxonLevels.set(level, taxon);
    }

    public int getLevelCount() {
        return this.taxonLevels.size();
    }

    public void removeTaxon(TaxonLevel level) {
        this.taxonLevels.remove(level);
    }

    public TaxonLevel getTaxonAtRank(String rank) {
        for (int i = 0; i < this.taxonLevels.size(); ++i) {
            TaxonLevel level = (TaxonLevel)this.taxonLevels.get(i);
            String cr = level.getRank();
            if (cr == null || !cr.equals(rank)) continue;
            return level;
        }
        return null;
    }

    public TaxonHierarchy getParentsOfName(String name) {
        for (int i = 0; i < this.taxonLevels.size(); ++i) {
            TaxonLevel level = (TaxonLevel)this.taxonLevels.get(i);
            String cn = level.getName();
            if (cn == null || !cn.equals(name)) continue;
            TaxonHierarchy result = new TaxonHierarchy(new Vector());
            for (int j = 0; j <= i; ++j) {
                result.addTaxon((TaxonLevel)this.taxonLevels.get(j));
            }
            return result;
        }
        return null;
    }

    public Vector getAllTaxons() {
        return this.taxonLevels;
    }

    public int compareTo(Object o) {
        int i;
        if (!(o instanceof TaxonHierarchy)) {
            return -1;
        }
        TaxonHierarchy th = (TaxonHierarchy)o;
        for (i = 0; i < this.taxonLevels.size(); ++i) {
            TaxonLevel t2;
            if (i >= th.taxonLevels.size()) {
                return i + 1;
            }
            TaxonLevel t1 = (TaxonLevel)this.taxonLevels.get(i);
            int c = t1.compareTo(t2 = (TaxonLevel)th.taxonLevels.get(i));
            if (c > 0) {
                return i + 1;
            }
            if (c >= 0) continue;
            return -(i + 1);
        }
        if (this.taxonLevels.size() == th.taxonLevels.size()) {
            return 0;
        }
        return -(i + 1);
    }

    public boolean isValidHierarchy() {
        if (this.taxonLevels.size() < 2) {
            return true;
        }
        Vector<TaxonLevel> temp = new Vector<TaxonLevel>();
        for (int i = 0; i < this.taxonLevels.size(); ++i) {
            TaxonLevel level = (TaxonLevel)this.taxonLevels.get(i);
            if (temp.contains(level)) {
                return false;
            }
            temp.add(level);
        }
        return true;
    }

    public String toString() {
        String ret = "";
        for (int i = 0; i < this.taxonLevels.size(); ++i) {
            TaxonLevel l = (TaxonLevel)this.taxonLevels.get(i);
            for (int j = 0; j < i; ++j) {
                ret = ret + "\t";
            }
            ret = ret + "--";
            ret = ret + l.toString();
            ret = ret + '\n';
        }
        return ret;
    }

    public Iterator iterator() {
        return this.taxonLevels.iterator();
    }

    public Object clone() {
        Vector<Object> newV = new Vector<Object>();
        for (int i = 0; i < this.taxonLevels.size(); ++i) {
            newV.add(((TaxonLevel)this.taxonLevels.get(i)).clone());
        }
        return new TaxonHierarchy(newV);
    }
}

