/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages;

import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.framework.ConfigXML;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WidgetFactory;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardSettings;
import edu.ucsb.nceas.morpho.query.LiveMapPanel;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class GeographicPage
extends AbstractUIPage {
    public final String pageID = "GEOGRAPHIC";
    public final String nextPageID = "TEMPORAL";
    public final String pageNumber = "1";
    public final String title = "Geographic Information";
    public final String subtitle = "";
    private JTextArea covDescField;
    private JLabel covDescLabel;
    private JLabel regionSelectionLabel;
    private JList regionList;
    private LiveMapPanel lmp;
    private boolean deleteFlag = false;
    private String xPathRoot = "/eml:eml/dataset/coverage/geographicCoverage";
    private ConfigXML locationsXML = null;
    double north = -1000.0;
    double west = -1000.0;
    double south = -1000.0;
    double east = -1000.0;
    private boolean covDescFieldChangedFlag = false;
    private boolean eventFromSortCommand = false;
    private OrderedMap returnMap = new OrderedMap();
    private final StringBuffer surrogateBuff = new StringBuffer();

    public GeographicPage() {
        this.init();
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        GeographicPage vbox = this;
        JLabel coverageDesc = WidgetFactory.makeHTMLLabel("<b>Enter a description of the geographic coverage.</b> Enter a general description of the geographic area in which the data were collected. This can be a simple place name (e.g., Santa Barbara) or a fuller description.", 2);
        vbox.add(coverageDesc);
        JPanel covDescPanel = WidgetFactory.makePanel();
        this.covDescLabel = WidgetFactory.makeLabel(" Description:", true);
        this.covDescLabel.setVerticalAlignment(1);
        this.covDescLabel.setAlignmentY(1.0f);
        covDescPanel.add(this.covDescLabel);
        this.covDescField = WidgetFactory.makeTextArea("", 2, true);
        JScrollPane jscrl = new JScrollPane(this.covDescField);
        covDescPanel.add(jscrl);
        SymFocus aSymFocus = new SymFocus();
        this.covDescField.addFocusListener(aSymFocus);
        covDescPanel.setBorder(new EmptyBorder(0, 0, 0, 25));
        vbox.add(covDescPanel);
        vbox.add(WidgetFactory.makeHalfSpacer());
        JLabel bbDesc = WidgetFactory.makeHTMLLabel("<p><b>Set the geographic coordinates which bound the coverage:</b> Latitude and longitude values are used to create a 'bounding box' containing the region of interest. Drag or click on the map and then edit the text boxes if necessary. [Default entries are in fractional degrees. To enter in degrees/minutes/seconds, simply type a space between the degrees, minutes, and seconds values]</p>", 3);
        vbox.add(bbDesc);
        JPanel bboxPanel = WidgetFactory.makePanel();
        JLabel bboxLabel = WidgetFactory.makeLabel(" Bounding Box:", true);
        bboxLabel.setVerticalAlignment(1);
        bboxLabel.setAlignmentY(1.0f);
        bboxPanel.add(bboxLabel);
        this.lmp = new LiveMapPanel(true);
        bboxPanel.add(this.lmp);
        bboxPanel.setBorder(new EmptyBorder(0, 0, 4, 25));
        vbox.add(bboxPanel);
        JPanel regionPanel = new JPanel();
        regionPanel.setLayout(new GridLayout(1, 2));
        JPanel regionSelectionPanel = WidgetFactory.makePanel(4);
        this.regionSelectionLabel = WidgetFactory.makeLabel(" Named Regions:", false, WizardSettings.WIZARD_CONTENT_LABEL_DIMS);
        this.regionSelectionLabel.setVerticalAlignment(1);
        this.regionSelectionLabel.setAlignmentY(1.0f);
        regionSelectionPanel.add(this.regionSelectionLabel);
        Vector names = this.getLocationNames();
        final DefaultListModel model = new DefaultListModel();
        for (int i = 0; i < names.size(); ++i) {
            model.addElement(names.elementAt(i));
        }
        this.regionList = new JList(model);
        this.regionList.setFont(WizardSettings.WIZARD_CONTENT_FONT);
        this.regionList.setForeground(WizardSettings.WIZARD_CONTENT_TEXT_COLOR);
        this.regionList.setSelectedIndex(-1);
        this.regionList.setSelectionMode(0);
        ListSelectionModel lsm = this.regionList.getSelectionModel();
        lsm.addListSelectionListener(new RegionSelectionHandler());
        JScrollPane jscr2 = new JScrollPane(this.regionList);
        regionSelectionPanel.add(jscr2);
        JLabel selectHelpLabel = this.getLabel("Click button to display selected region.");
        JButton selectButton = new JButton("Select");
        selectButton.setPreferredSize(new Dimension(60, 24));
        selectButton.setMaximumSize(new Dimension(60, 24));
        selectButton.setMargin(new Insets(0, 2, 1, 2));
        selectButton.setEnabled(true);
        selectButton.setFont(WizardSettings.WIZARD_CONTENT_FONT);
        selectButton.setFocusPainted(false);
        selectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String selection = (String)GeographicPage.this.regionList.getSelectedValue();
                double n = new Double(GeographicPage.this.getNorth(selection));
                double w = new Double(GeographicPage.this.getWest(selection));
                double s = new Double(GeographicPage.this.getSouth(selection));
                double e = new Double(GeographicPage.this.getEast(selection));
                GeographicPage.this.lmp.setBoundingBox(n, w, s, e);
                GeographicPage.this.covDescField.setText(GeographicPage.this.getDescription(selection));
            }
        });
        final GeographicPage currentInstance = this;
        final JTextField textField = new JTextField(20);
        String msg1 = "Enter short name to appear in list.";
        final Object[] array = new Object[]{"Enter short name to appear in list.", textField};
        String descText = this.covDescField.getText().trim();
        JLabel addHelpLabel = this.getLabel("Click to add current selection to list.");
        JButton addButton = new JButton("Add");
        addButton.setPreferredSize(new Dimension(60, 24));
        addButton.setMaximumSize(new Dimension(60, 24));
        addButton.setMargin(new Insets(0, 2, 1, 2));
        addButton.setEnabled(true);
        addButton.setFont(WizardSettings.WIZARD_CONTENT_FONT);
        addButton.setFocusPainted(false);
        addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String btnString1 = "Enter";
                String btnString2 = "Cancel";
                Object[] options = new Object[]{btnString1, btnString2};
                JOptionPane optionPane = new JOptionPane(array, 3, 0, null, options, options[0]);
                JDialog dialog = optionPane.createDialog(currentInstance, "Add Current Selection to Named Region List?");
                dialog.show();
                String selectedValue = (String)optionPane.getValue();
                if (selectedValue != null && selectedValue.equals("Enter")) {
                    String inputName = textField.getText().trim();
                    if (inputName.length() == 0) {
                        Log.debug(1, "Sorry, but a Name must be entered.");
                    } else {
                        String description = GeographicPage.this.covDescField.getText().trim();
                        if (description.equals("")) {
                            description = inputName;
                        }
                        GeographicPage.this.addLocation(inputName, description, GeographicPage.this.lmp.getNorth(), GeographicPage.this.lmp.getWest(), GeographicPage.this.lmp.getSouth(), GeographicPage.this.lmp.getEast());
                        model.addElement(inputName);
                    }
                }
            }
        });
        JLabel deleteHelpLabel = this.getLabel("Click to remove selected region from list.");
        JButton deleteButton = new JButton("Delete");
        deleteButton.setPreferredSize(new Dimension(60, 24));
        deleteButton.setMaximumSize(new Dimension(60, 24));
        deleteButton.setMargin(new Insets(0, 2, 1, 2));
        deleteButton.setEnabled(true);
        deleteButton.setFont(WizardSettings.WIZARD_CONTENT_FONT);
        deleteButton.setFocusPainted(false);
        deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                GeographicPage.this.deleteFlag = true;
                int selindex = GeographicPage.this.regionList.getSelectedIndex();
                model.remove(selindex);
                GeographicPage.this.locationsXML.removeNode("location", selindex);
                GeographicPage.this.locationsXML.save();
                GeographicPage.this.regionList.setSelectedIndex(0);
                GeographicPage.this.deleteFlag = false;
            }
        });
        JLabel sortHelpLabel = this.getLabel("Click to sort the list of locations.");
        JButton sortButton = new JButton("Sort");
        sortButton.setPreferredSize(new Dimension(60, 24));
        sortButton.setMaximumSize(new Dimension(60, 24));
        sortButton.setMargin(new Insets(0, 2, 1, 2));
        sortButton.setEnabled(true);
        sortButton.setFont(WizardSettings.WIZARD_CONTENT_FONT);
        sortButton.setFocusPainted(false);
        sortButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                GeographicPage.this.eventFromSortCommand = true;
                StringBuffer sb = new StringBuffer();
                sb.append("<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"");
                sb.append(" version=\"1.0\">\n");
                sb.append("<xsl:template match=\"locationList\">\n");
                sb.append("<locationList>\n");
                sb.append("<xsl:for-each select=\"./location\">\n");
                sb.append("<xsl:sort select=\"./name\" />\n");
                sb.append("<location>\n");
                sb.append("<xsl:apply-templates />\n");
                sb.append("</location>\n");
                sb.append("</xsl:for-each>\n");
                sb.append("</locationList>\n");
                sb.append("</xsl:template>\n");
                sb.append("<xsl:template ");
                sb.append("match=\"*|@*|comment()|processing-instruction()|text()\">\n");
                sb.append("<xsl:copy>\n");
                sb.append("<xsl:apply-templates ");
                sb.append("select=\"*|@*|comment()|processing-instruction()|text()\"/>\n");
                sb.append("</xsl:copy>\n");
                sb.append("</xsl:template>");
                sb.append("</xsl:stylesheet>\n");
                try {
                    GeographicPage.this.locationsXML.sort(sb.toString());
                }
                catch (Exception e) {
                    JOptionPane optionPane = new JOptionPane("Sorry, the list can't be sorted.", 0, 0);
                    Log.debug(1, "Error sorting regions: " + e.getMessage());
                }
                GeographicPage.this.locationsXML.save();
                Vector names = GeographicPage.this.getLocationNames();
                DefaultListModel model = (DefaultListModel)GeographicPage.this.regionList.getModel();
                model.clear();
                for (int i = 0; i < names.size(); ++i) {
                    model.addElement(names.elementAt(i));
                }
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(4, 1));
        JPanel buttonSubpanel2 = new JPanel();
        JPanel buttonSubpanel3 = new JPanel();
        JPanel buttonSubpanel4 = new JPanel();
        buttonSubpanel2.setLayout(new FlowLayout(0));
        buttonSubpanel2.add(addButton);
        buttonSubpanel2.add(addHelpLabel);
        buttonSubpanel3.setLayout(new FlowLayout(0));
        buttonSubpanel3.add(deleteButton);
        buttonSubpanel3.add(deleteHelpLabel);
        buttonSubpanel4.setLayout(new FlowLayout(0));
        buttonSubpanel4.add(sortButton);
        buttonSubpanel4.add(sortHelpLabel);
        buttonPanel.add(buttonSubpanel2);
        buttonPanel.add(buttonSubpanel3);
        buttonPanel.add(buttonSubpanel4);
        regionPanel.add(regionSelectionPanel);
        regionPanel.add(buttonPanel);
        vbox.add(regionPanel);
    }

    private Vector getLocationNames() {
        try {
            this.locationsXML = new ConfigXML("./lib/locations.xml");
            Vector vec = this.locationsXML.getValuesForPath("name");
            return vec;
        }
        catch (Exception w) {
            Log.debug(5, "problem reading locations file!");
            return null;
        }
    }

    private String getNorth(String locname) {
        String res = "";
        if (this.locationsXML != null) {
            Vector vec = this.locationsXML.getValuesForPath("location/name[.='" + locname + "']/../north");
            res = (String)vec.firstElement();
        }
        return res;
    }

    private String getWest(String locname) {
        String res = "";
        if (this.locationsXML != null) {
            Vector vec = this.locationsXML.getValuesForPath("location/name[.='" + locname + "']/../west");
            res = (String)vec.firstElement();
        }
        return res;
    }

    private String getSouth(String locname) {
        String res = "";
        if (this.locationsXML != null) {
            Vector vec = this.locationsXML.getValuesForPath("location/name[.='" + locname + "']/../south");
            res = (String)vec.firstElement();
        }
        return res;
    }

    private String getEast(String locname) {
        String res = "";
        if (this.locationsXML != null) {
            Vector vec = this.locationsXML.getValuesForPath("location/name[.='" + locname + "']/../east");
            res = (String)vec.firstElement();
        }
        return res;
    }

    private String getDescription(String locname) {
        String res = "";
        if (this.locationsXML != null) {
            Vector vec = this.locationsXML.getValuesForPath("location/name[.='" + locname + "']/../description");
            res = (String)vec.firstElement();
        }
        return res;
    }

    private Node createNewLocation(String name, String desc, double north, double west, double south, double east) {
        Element head = null;
        if (this.locationsXML != null) {
            Document doc = this.locationsXML.getDocument();
            head = doc.createElement("location");
            Element temp = doc.createElement("name");
            Text temp1 = doc.createTextNode(name);
            temp.appendChild(temp1);
            head.appendChild(temp);
            temp = doc.createElement("description");
            temp1 = doc.createTextNode(desc);
            temp.appendChild(temp1);
            head.appendChild(temp);
            temp = doc.createElement("north");
            temp1 = doc.createTextNode(new Double(north).toString());
            temp.appendChild(temp1);
            head.appendChild(temp);
            temp = doc.createElement("west");
            temp1 = doc.createTextNode(new Double(west).toString());
            temp.appendChild(temp1);
            head.appendChild(temp);
            temp = doc.createElement("south");
            temp1 = doc.createTextNode(new Double(south).toString());
            temp.appendChild(temp1);
            head.appendChild(temp);
            temp = doc.createElement("east");
            temp1 = doc.createTextNode(new Double(east).toString());
            temp.appendChild(temp1);
            head.appendChild(temp);
        }
        return head;
    }

    public void addLocation(String name, String desc, double north, double west, double south, double east) {
        if (this.locationsXML != null) {
            Node nd = this.createNewLocation(name, desc, north, west, south, east);
            Node root = this.locationsXML.getRoot();
            root.appendChild(nd);
            this.locationsXML.save();
        }
    }

    public void onLoadAction() {
        this.lmp.addMap();
        if (this.north > -1000.0) {
            this.lmp.setBoundingBox(this.north, this.west, this.south, this.east);
        }
    }

    public void onRewindAction() {
    }

    public boolean onAdvanceAction() {
        this.north = this.lmp.getNorth();
        this.west = this.lmp.getWest();
        this.east = this.lmp.getEast();
        this.south = this.lmp.getSouth();
        if (this.covDescField.getText().trim().equals("")) {
            WidgetFactory.hiliteComponent(this.covDescLabel);
            this.covDescField.requestFocus();
            return false;
        }
        WidgetFactory.unhiliteComponent(this.covDescLabel);
        this.lmp.removeMap();
        return true;
    }

    public OrderedMap getPageData() {
        return this.getPageData(this.xPathRoot);
    }

    public OrderedMap getPageData(String xPathRoot) {
        this.returnMap.clear();
        this.returnMap.put((Object)(xPathRoot + "/geographicDescription"), (Object)this.covDescField.getText().trim());
        this.returnMap.put((Object)(xPathRoot + "/boundingCoordinates/westBoundingCoordinate"), (Object)new Double(this.west).toString());
        this.returnMap.put((Object)(xPathRoot + "/boundingCoordinates/eastBoundingCoordinate"), (Object)new Double(this.east).toString());
        this.returnMap.put((Object)(xPathRoot + "/boundingCoordinates/northBoundingCoordinate"), (Object)new Double(this.north).toString());
        this.returnMap.put((Object)(xPathRoot + "/boundingCoordinates/southBoundingCoordinate"), (Object)new Double(this.south).toString());
        return this.returnMap;
    }

    public String getPageID() {
        return "GEOGRAPHIC";
    }

    public String getTitle() {
        return "Geographic Information";
    }

    public String getSubtitle() {
        return "";
    }

    public String getNextPageID() {
        return "TEMPORAL";
    }

    public String getPageNumber() {
        return "1";
    }

    public boolean setPageData(OrderedMap map, String _xPathRoot) {
        String name;
        if (_xPathRoot != null && _xPathRoot.trim().length() > 0) {
            this.xPathRoot = _xPathRoot;
        }
        if ((name = (String)map.get((Object)(_xPathRoot + "/geographicDescription[1]"))) != null) {
            map = this.stripIndexOneFromMapKeys(map);
            map.remove((Object)(this.xPathRoot + "/geographicDescription[1]"));
        }
        if ((name = (String)map.get((Object)(this.xPathRoot + "/geographicDescription"))) != null) {
            this.covDescField.setText(name);
            map.remove((Object)(this.xPathRoot + "/geographicDescription"));
        }
        if ((name = (String)map.get((Object)(this.xPathRoot + "/boundingCoordinates/northBoundingCoordinate"))) != null) {
            Double N = new Double(name);
            if (N != null) {
                this.north = N;
            }
            map.remove((Object)(this.xPathRoot + "/boundingCoordinates/northBoundingCoordinate"));
        }
        if ((name = (String)map.get((Object)(this.xPathRoot + "/boundingCoordinates/westBoundingCoordinate"))) != null) {
            Double W = new Double(name);
            if (W != null) {
                this.west = W;
            }
            map.remove((Object)(this.xPathRoot + "/boundingCoordinates/westBoundingCoordinate"));
        }
        if ((name = (String)map.get((Object)(this.xPathRoot + "/boundingCoordinates/southBoundingCoordinate"))) != null) {
            Double S = new Double(name);
            if (S != null) {
                this.south = S;
            }
            map.remove((Object)(this.xPathRoot + "/boundingCoordinates/southBoundingCoordinate"));
        }
        if ((name = (String)map.get((Object)(this.xPathRoot + "/boundingCoordinates/eastBoundingCoordinate"))) != null) {
            Double E = new Double(name);
            if (E != null) {
                this.east = E;
            }
            map.remove((Object)(this.xPathRoot + "/boundingCoordinates/eastBoundingCoordinate"));
        }
        if (this.east == this.west && this.north == this.south) {
            this.lmp.setTool("PT");
        }
        this.lmp.setBoundingBox(this.north, this.west, this.south, this.east);
        boolean returnVal = map.isEmpty();
        if (!returnVal) {
            Log.debug(20, "GeographicPage.setPageData returning FALSE! Map still contains:" + map);
        }
        return returnVal;
    }

    private JLabel getLabel(String text) {
        if (text == null) {
            text = "";
        }
        JLabel label = new JLabel(text);
        label.setAlignmentX(1.0f);
        label.setFont(WizardSettings.WIZARD_CONTENT_FONT);
        label.setBorder(BorderFactory.createMatteBorder(1, 10, 1, 3, (Color)null));
        return label;
    }

    public List getSurrogate() {
        ArrayList<String> surrogate = new ArrayList<String>();
        String temp1 = this.covDescField.getText().trim();
        String temp2 = "West: " + new Double(this.lmp.getWest()).toString() + "; East: " + new Double(this.lmp.getEast()).toString() + "; North: " + new Double(this.lmp.getNorth()).toString() + "; South: " + new Double(this.lmp.getSouth()).toString();
        surrogate.add(temp1);
        surrogate.add(temp2);
        return surrogate;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Demo/Test");
        frame.setSize(800, 600);
        frame.getContentPane().setLayout(new BorderLayout());
        GeographicPage geo = new GeographicPage();
        frame.getContentPane().add((Component)geo, "Center");
        frame.setVisible(true);
    }

    private OrderedMap stripIndexOneFromMapKeys(OrderedMap map) {
        OrderedMap newMap = new OrderedMap();
        for (String key : map.keySet()) {
            String val = (String)map.get((Object)key);
            int pos = key.indexOf("[1]");
            if (pos < 0) {
                newMap.put((Object)key, (Object)val);
                continue;
            }
            String newKey = "";
            while (pos != -1) {
                newKey = newKey + key.substring(0, pos);
                key = key.substring(pos + 3);
                pos = key.indexOf("[1]");
            }
            newKey = newKey + key;
            newMap.put((Object)newKey, (Object)val);
        }
        return newMap;
    }

    class SymFocus
    extends FocusAdapter {
        private String startingString = "";

        SymFocus() {
        }

        public void focusLost(FocusEvent event) {
            String currentString = GeographicPage.this.covDescField.getText();
            if (!this.startingString.equals(currentString) && currentString.length() > 0) {
                GeographicPage.this.covDescFieldChangedFlag = true;
            }
        }

        public void focusGained(FocusEvent event) {
            this.startingString = GeographicPage.this.covDescField.getText();
        }
    }

    class RegionSelectionHandler
    implements ListSelectionListener {
        RegionSelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent eee) {
            boolean setTextFlag = true;
            if (GeographicPage.this.deleteFlag) {
                return;
            }
            if (GeographicPage.this.eventFromSortCommand) {
                GeographicPage.this.eventFromSortCommand = false;
                return;
            }
            String selection = (String)GeographicPage.this.regionList.getSelectedValue();
            if (GeographicPage.this.covDescField.hasFocus()) {
                return;
            }
            if (GeographicPage.this.covDescFieldChangedFlag && GeographicPage.this.covDescField.getText().length() > 0) {
                int res = JOptionPane.showConfirmDialog(GeographicPage.this.covDescField, "Replace existing description", "Confirm:", 0);
                setTextFlag = res == 0;
            }
            double n = new Double(GeographicPage.this.getNorth(selection));
            double w = new Double(GeographicPage.this.getWest(selection));
            double s = new Double(GeographicPage.this.getSouth(selection));
            double e = new Double(GeographicPage.this.getEast(selection));
            GeographicPage.this.lmp.setBoundingBox(n, w, s, e);
            if (setTextFlag) {
                GeographicPage.this.covDescField.setText(GeographicPage.this.getDescription(selection));
                GeographicPage.this.covDescFieldChangedFlag = false;
            }
        }
    }
}

