/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.datapackage.AccessionNumber;
import edu.ucsb.nceas.morpho.datapackage.Entity;
import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WidgetFactory;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardContainerFrame;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardSettings;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.CodeDefnPanel;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CodeImportPage
extends AbstractUIPage {
    public final String pageID = "CODE_IMPORT_PAGE";
    public String nextPageID = "DATA_LOCATION";
    public final String pageNumber = "";
    public final String title = "Code Defintions Import Page";
    public final String subtitle = "Import/Define the codes and definitions";
    private WizardContainerFrame mainWizFrame;
    private OrderedMap resultsMap;
    private String[] importChoiceText = new String[]{"The table containing the definitions has already been imported into Morpho", "The table containing the definitions needs to be imported into Morpho"};
    private boolean importCompletedOK = false;
    private CodeDefnPanel importPanel = null;
    private JPanel radioPanel;
    private JTextField attrField;
    private JTextField entityField;
    private JLabel choiceLabel;
    private short importChoice = 0;
    private static final short IMPORT_DONE = 10;
    private static final short INVOKE_TIW = 20;

    public CodeImportPage(WizardContainerFrame mainWizFrame) {
        this.mainWizFrame = mainWizFrame;
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new BoxLayout(infoPanel, 1));
        JLabel label = WidgetFactory.makeHTMLLabel("Import Codes and Definitions for the following Attribute - ", 1, false);
        JLabel attrLabel = WidgetFactory.makeLabel("Attribute Name:", false, WizardSettings.WIZARD_CONTENT_LABEL_DIMS);
        this.attrField = WidgetFactory.makeOneLineTextField();
        this.attrField.setEditable(false);
        JPanel attrPanel = WidgetFactory.makePanel();
        attrPanel.add(attrLabel);
        attrPanel.add(this.attrField);
        JLabel entityLabel = WidgetFactory.makeLabel("Entity Name:", false, WizardSettings.WIZARD_CONTENT_LABEL_DIMS);
        this.entityField = WidgetFactory.makeOneLineTextField();
        this.entityField.setEditable(false);
        JPanel entityPanel = WidgetFactory.makePanel();
        entityPanel.add(entityLabel);
        entityPanel.add(this.entityField);
        infoPanel.add(label);
        infoPanel.add(WidgetFactory.makeDefaultSpacer());
        infoPanel.add(attrPanel);
        infoPanel.add(WidgetFactory.makeDefaultSpacer());
        infoPanel.add(entityPanel);
        infoPanel.add(WidgetFactory.makeDefaultSpacer());
        this.choiceLabel = WidgetFactory.makeHTMLLabel("Select one of the following", 1, true);
        infoPanel.add(this.choiceLabel);
        infoPanel.add(WidgetFactory.makeDefaultSpacer());
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Log.debug(45, "got radiobutton command: " + e.getActionCommand());
                if (e.getActionCommand().equals(CodeImportPage.this.importChoiceText[0])) {
                    if (CodeImportPage.this.importPanel == null) {
                        CodeImportPage.this.importPanel = new CodeDefnPanel(true);
                        CodeImportPage.this.add((Component)CodeImportPage.this.importPanel, "Center");
                        CodeImportPage.this.validate();
                        CodeImportPage.this.repaint();
                    }
                    CodeImportPage.this.importPanel.setVisible(true);
                    CodeImportPage.this.importChoice = (short)10;
                } else if (e.getActionCommand().equals(CodeImportPage.this.importChoiceText[1])) {
                    if (CodeImportPage.this.importPanel != null) {
                        CodeImportPage.this.importPanel.setVisible(false);
                    }
                    CodeImportPage.this.importChoice = (short)20;
                }
            }
        };
        this.radioPanel = WidgetFactory.makeRadioPanel(this.importChoiceText, -1, listener);
        infoPanel.add(this.radioPanel);
        this.add((Component)infoPanel, "North");
    }

    public void onLoadAction() {
        AbstractDataPackage adp = this.getADP();
        if (adp == null) {
            Log.debug(15, "Unable to obtain the ADP in CodeImportPage");
            return;
        }
        Entity[] arr = adp.getOriginalEntityArray();
        if (arr == null) {
            arr = adp.getEntityArray();
            if (arr == null) {
                arr = new Entity[]{};
            }
            adp.setOriginalEntityArray(arr);
        }
        String attr = adp.getCurrentImportAttributeName();
        String entity = adp.getCurrentImportEntityName();
        this.attrField.setText(attr);
        this.entityField.setText(entity);
        String prevPageID = this.mainWizFrame.getPreviousPageID();
        if (prevPageID != null && prevPageID.equals("ENTITY")) {
            Node newDOM = this.mainWizFrame.collectDataFromPages();
            this.mainWizFrame.setDOMToReturn(null);
            Node entNode = null;
            String entityXpath = "";
            try {
                entityXpath = XMLUtilities.getTextNodeWithXPath((Node)adp.getMetadataPath(), (String)"/xpathKeyMap/contextNode[@name='package']/entities").getNodeValue();
                NodeList entityNodes = XMLUtilities.getNodeListWithXPath((Node)newDOM, (String)entityXpath);
                entNode = entityNodes.item(0);
            }
            catch (Exception w) {
                Log.debug(5, "Error in trying to get entNode in ImportDataCommand");
            }
            Entity entityNode = new Entity(entNode);
            Log.debug(30, "Adding Entity object to AbstractDataPackage..");
            adp.addEntity(entityNode);
            Morpho morpho = Morpho.thisStaticInstance;
            AccessionNumber an = new AccessionNumber(morpho);
            String curid = adp.getAccessionNumber();
            String newid = null;
            newid = !curid.equals("") ? an.incRev(curid) : an.getNextId();
            adp.setAccessionNumber(newid);
            adp.setLocation("");
            this.mainWizFrame.reInitializePageStack();
        }
    }

    private AbstractDataPackage getADP() {
        return UIController.getInstance().getCurrentAbstractDataPackage();
    }

    public void onRewindAction() {
    }

    public boolean onAdvanceAction() {
        if (this.importChoice != 10 && this.importChoice != 20) {
            WidgetFactory.hiliteComponent(this.choiceLabel);
            return false;
        }
        WidgetFactory.unhiliteComponent(this.choiceLabel);
        if (this.importChoice == 10) {
            if (this.importPanel.validateUserInput()) {
                AbstractDataPackage adp = this.getADP();
                if (adp == null) {
                    Log.debug(15, "Unable to obtain the ADP in CodeImportPage");
                    return true;
                }
                OrderedMap map = adp.getCurrentImportMap();
                String relativeXPath = adp.getCurrentImportXPath();
                String scale = adp.getCurrentImportScale().toLowerCase();
                String path = relativeXPath + "/measurementScale/" + scale + "/nonNumericDomain/enumeratedDomain[1]/entityCodeList";
                if (!map.containsKey((Object)(path + "/entityReference"))) {
                    Log.debug(15, "Error in CodeImportPage!! map doesnt have the key - " + path);
                } else {
                    map.remove((Object)(path + "/entityReference"));
                    map.remove((Object)(path + "/valueAttributeReference"));
                    map.remove((Object)(path + "/definitionAttributeReference"));
                    OrderedMap importMap = this.importPanel.getPanelData(path);
                    map.putAll((Map)importMap);
                }
                this.nextPageID = "CODE_IMPORT_SUMMARY";
                return true;
            }
            return false;
        }
        this.nextPageID = "DATA_LOCATION";
        return true;
    }

    public OrderedMap getPageData() {
        return this.resultsMap;
    }

    public OrderedMap getPageData(String rootXPath) {
        throw new UnsupportedOperationException("getPageData(String rootXPath) Method Not Implemented");
    }

    public String getPageID() {
        return "CODE_IMPORT_PAGE";
    }

    public String getTitle() {
        return "Code Defintions Import Page";
    }

    public String getSubtitle() {
        return "Import/Define the codes and definitions";
    }

    public String getNextPageID() {
        return this.nextPageID;
    }

    public String getPageNumber() {
        return "";
    }

    public boolean setPageData(OrderedMap data, String xPathRoot) {
        return false;
    }
}

