/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard;

import edu.ucsb.nceas.morpho.plugins.datapackagewizard.CustomList;
import edu.ucsb.nceas.morpho.util.Log;
import java.awt.Component;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.InputVerifier;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

class CustomJTable
extends JTable {
    private DefaultTableCellRenderer defaultRenderer = new DefaultTableCellRenderer();
    private DefaultCellEditor defaultCellEditor = new DefaultCellEditor(new JTextField());
    Object[] editors;
    boolean[] columnsEditableFlags;
    int DOUBLE_CLICK = 2;
    private int currentRow = -1;
    private int currentCol = -1;

    public CustomJTable(final CustomList parentList, Vector rowVect, Vector colNamesVec, Object[] editors) {
        super(new DefaultTableModel(rowVect, colNamesVec));
        this.editors = editors;
        super.setSelectionMode(2);
        this.defaultCellEditor.setClickCountToStart(1);
        this.columnsEditableFlags = new boolean[colNamesVec.size()];
        Arrays.fill(this.columnsEditableFlags, true);
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == CustomJTable.this.DOUBLE_CLICK) {
                    parentList.fireEditAction();
                }
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    public TableCellRenderer getCellRenderer(int row, int col) {
        Class<?> colClass = null;
        if (this.editors != null && this.editors[col] != null) {
            colClass = this.editors[col].getClass();
        }
        if (colClass == null) {
            return this.defaultRenderer;
        }
        if (colClass.getName().equals("javax.swing.JCheckBox")) {
            return new TableCellRenderer(){

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JCheckBox cell;
                    boolean checked = false;
                    if (value != null) {
                        checked = (Boolean)value;
                    }
                    if ((cell = new JCheckBox("", checked)).getForeground() == null) {
                        cell.setForeground(table.getForeground());
                    }
                    if (cell.getBackground() == null) {
                        cell.setBackground(table.getBackground());
                    }
                    if (isSelected) {
                        cell.setForeground(table.getSelectionForeground());
                    }
                    if (hasFocus && table.isCellEditable(row, column)) {
                        cell.setForeground(table.getSelectionForeground());
                        cell.setBackground(table.getSelectionBackground());
                    }
                    if (cell.getFont() == null) {
                        cell.setFont(table.getFont());
                    }
                    cell.setOpaque(true);
                    cell.validate();
                    cell.repaint();
                    return cell;
                }
            };
        }
        if (colClass.getName().equals("javax.swing.JComboBox")) {
            JComboBox origList = (JComboBox)this.editors[col];
            ComboBoxModel model = origList.getModel();
            int listLength = model.getSize();
            final Object[] listElemArray = new Object[listLength];
            for (int i = 0; i < listLength; ++i) {
                listElemArray[i] = model.getElementAt(i);
            }
            return new TableCellRenderer(){

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JComboBox<Object> cell = new JComboBox<Object>(listElemArray);
                    if (value != null) {
                        cell.setSelectedItem(value);
                    } else {
                        cell.setSelectedIndex(0);
                    }
                    if (cell.getFont() == null) {
                        cell.setFont(table.getFont());
                    }
                    cell.validate();
                    cell.repaint();
                    return cell;
                }
            };
        }
        if (colClass.getName().equals("javax.swing.JLabel")) {
            final JLabel origLabel = (JLabel)this.editors[col];
            return new TableCellRenderer(){

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JLabel cell = new JLabel(origLabel.getText());
                    cell.setHorizontalAlignment(origLabel.getHorizontalAlignment());
                    return cell;
                }
            };
        }
        if (colClass.getName().equals("javax.swing.JTextField")) {
            JTextField origTextField = (JTextField)this.editors[col];
            DefaultTableCellRenderer defaultR = new DefaultTableCellRenderer();
            defaultR.setBackground(origTextField.getBackground());
            defaultR.setForeground(origTextField.getForeground());
            EventListener[] list = origTextField.getListeners(FocusListener.class);
            for (int i = 0; i < list.length; ++i) {
                defaultR.addFocusListener((FocusListener)list[i]);
            }
            return defaultR;
        }
        return this.defaultRenderer;
    }

    public Class getColumnClass(int col) {
        Class colClass = String.class;
        if (this.editors != null && this.editors[col] != null) {
            colClass = this.editors[col].getClass();
        }
        Log.debug(45, "\nCustomJTable.getColumnClass(" + col + "): " + colClass.getName());
        return colClass;
    }

    private JTextField getTextFieldEditor(int row, int col) {
        String val = (String)this.getValueAt(row, col);
        return new JTextField(val);
    }

    public boolean getDragEnabled() {
        return false;
    }

    public int getSelectedRow() {
        return super.getSelectionModel().getMaxSelectionIndex();
    }

    public void makeColumnNotEditable(int col) {
        this.columnsEditableFlags[col] = false;
    }

    public void setEditableForAllColumns(boolean editable) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.columnsEditableFlags[i] = editable;
        }
    }

    public boolean isCellEditable(int row, int col) {
        return this.columnsEditableFlags[col];
    }

    public void selectAndEditCell(int row, int col) {
        this.editCellAt(row, col);
        this.changeSelection(row, col, false, false);
    }

    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        if ((rowIndex != this.currentRow || columnIndex != this.currentCol) && this.editors != null && this.currentCol >= 0 && this.currentCol < this.editors.length && this.editors[this.currentCol] != null && this.editors[this.currentCol] instanceof JTextField) {
            boolean res;
            InputVerifier iv = ((JTextField)this.editors[this.currentCol]).getInputVerifier();
            JTextField jtf = this.getTextFieldEditor(this.currentRow, this.currentCol);
            if (iv != null && !(res = iv.verify(jtf))) {
                this.editCellAt(this.currentRow, this.currentCol);
                return;
            }
        }
        this.currentRow = rowIndex;
        this.currentCol = columnIndex;
        super.changeSelection(rowIndex, columnIndex, toggle, extend);
    }
}

