/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.framework;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.framework.ConnectionListener;
import edu.ucsb.nceas.morpho.framework.DataPackageInterface;
import edu.ucsb.nceas.morpho.framework.LoginClientInterface;
import edu.ucsb.nceas.morpho.framework.LoginCommand;
import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.framework.ProfileAddedListener;
import edu.ucsb.nceas.morpho.framework.QueryRefreshInterface;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceNotHandledException;
import edu.ucsb.nceas.morpho.plugins.ServiceProvider;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.GUIAction;
import edu.ucsb.nceas.morpho.util.HyperlinkButton;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.morpho.util.UISettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class InitialScreen
extends JPanel {
    private final Morpho morpho;
    private final MorphoFrame parentFrame;
    private final JComboBox profileComboBox;
    private final JPasswordField passwordField;
    private ProfileComboBoxModel profileComboBoxModel;
    private final JLabel currentProfileLDAPLabel;
    private static boolean ignoreSelectionEvents;
    private HyperlinkButton logoutLink;
    private LeftPanel dataPanel;
    private LeftPanel loginPanel;
    private LeftPanel profilePanel;
    private Command logoutCommand;
    private String[] profileStrings;
    private ItemListener pickListListener;
    private boolean prevLoginStatus = !Morpho.isConnected();

    public InitialScreen(Morpho morpho, MorphoFrame parentFrame) {
        this.setLayout(new BorderLayout(0, 0));
        this.morpho = morpho;
        this.parentFrame = parentFrame;
        this.profileComboBox = new JComboBox();
        this.currentProfileLDAPLabel = new JLabel();
        this.passwordField = new JPasswordField();
        ignoreSelectionEvents = false;
        this.init();
        this.addLeftPanels();
        this.passwordField.requestFocus();
    }

    private void init() {
        this.setBackground(UISettings.INIT_SCRN_MAIN_BG_COLOR);
        this.setOpaque(true);
    }

    private void addLeftPanels() {
        Box leftPanelLayoutBox = Box.createHorizontalBox();
        Box leftPanelContainer = Box.createVerticalBox();
        InitialScreen initialScreen = this;
        this.profilePanel = new LeftPanel("<html><p style=\"color: #ffffff; font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 9px; align: left;\">&nbsp;Current profile:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<font color=\"#d2ffad\"><b>" + initialScreen.morpho.getCurrentProfileName() + "</b></font>" + "</p></html>", 110);
        this.loginPanel = new LeftPanel("<html><p style=\"color: #ffffff; font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 9px; align: left;\">&nbsp;Network Status:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</p></html>", 120);
        this.dataPanel = new LeftPanel("<html><p style=\"color: #ffffff; font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 9px; align: left;\">&nbsp;Work with your data...</p></html>", 115);
        leftPanelContainer.add(Box.createVerticalStrut(15));
        leftPanelContainer.add(this.profilePanel);
        leftPanelContainer.add(Box.createVerticalStrut(15));
        leftPanelContainer.add(this.loginPanel);
        leftPanelContainer.add(Box.createVerticalStrut(15));
        leftPanelContainer.add(this.dataPanel);
        leftPanelContainer.add(Box.createVerticalGlue());
        leftPanelLayoutBox.add(Box.createHorizontalStrut(15));
        leftPanelLayoutBox.add(leftPanelContainer);
        leftPanelLayoutBox.add(Box.createHorizontalStrut(15));
        this.add((Component)leftPanelLayoutBox, "West");
        this.populateProfilePanel(this.profilePanel);
        this.populateLoginPanel(this.loginPanel);
        this.populateDataPanel(this.dataPanel);
    }

    private void populateProfilePanel(LeftPanel panel) {
        panel.addToRow1(this.currentProfileLDAPLabel);
        panel.addToRow1(Box.createHorizontalGlue());
        JLabel changeProfileLabel = new JLabel("<html><p style=\"color: #000000; align: left; font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 9px;\">&nbsp;<b>Change profile:</b></p></html>");
        this.setSizes(changeProfileLabel, UISettings.INIT_SCRN_LEFT_PANELS_LABELDIMS);
        panel.addToRow2(changeProfileLabel);
        this.profileComboBoxModel = new ProfileComboBoxModel();
        this.profileComboBox.setModel(this.profileComboBoxModel);
        panel.addToRow2(this.profileComboBox);
        this.setSizes(this.profileComboBox, UISettings.INIT_SCRN_LEFT_PANELS_PICKLISTDIMS);
        this.pickListListener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (ignoreSelectionEvents) {
                    return;
                }
                if (InitialScreen.this.logoutCommand == null) {
                    return;
                }
                Object selectedProfileObj = InitialScreen.this.profileComboBox.getSelectedItem();
                if (selectedProfileObj == null) {
                    return;
                }
                String selectedProfile = (String)selectedProfileObj;
                InitialScreen.this.morpho;
                if (selectedProfile.equals(Morpho.getCurrentProfileName())) {
                    return;
                }
                InitialScreen.this.logoutCommand.execute(null);
                InitialScreen.this.morpho.setProfileDontLogin(selectedProfile);
                InitialScreen.this.updateProfileStatus();
            }
        };
        this.profileComboBox.addItemListener(this.pickListListener);
        this.morpho.addProfileAddedListener(new ProfileAddedListener(){

            public void profileAdded(String profileName) {
                InitialScreen.this.logoutCommand.execute(null);
                InitialScreen.this.updateProfileStatus();
            }
        });
        panel.addToRow2(Box.createHorizontalGlue());
        Morpho.CreateNewProfileCommand newProfileCmd = new Morpho.CreateNewProfileCommand();
        GUIAction newProfileAction = new GUIAction("Create a new profile...", UISettings.NEW_PROFILE_ICON, newProfileCmd);
        newProfileAction.setRolloverSmallIcon(UISettings.NEW_PROFILE_ICON_ROLLOVER);
        HyperlinkButton newProfileLink = new HyperlinkButton(newProfileAction);
        this.setSizes(newProfileLink, UISettings.INIT_SCR_LINKBUTTON_DIMS);
        panel.addToRow3(newProfileLink);
        panel.addToRow3(Box.createHorizontalGlue());
        this.updateProfileStatus();
    }

    private void setCurrentPicklistSelection() {
        for (int sel = 0; sel < this.profileComboBoxModel.getSize(); ++sel) {
            InitialScreen initialScreen = this;
            if (!initialScreen.morpho.getCurrentProfileName().equals(this.profileStrings[sel])) continue;
            ignoreSelectionEvents = true;
            this.profileComboBox.setSelectedIndex(sel);
            ignoreSelectionEvents = false;
            break;
        }
    }

    private void updateProfileStatus() {
        this.profileStrings = this.morpho.getProfilesList();
        ignoreSelectionEvents = true;
        this.profileComboBoxModel.resetElementsTo(this.profileStrings);
        this.setCurrentPicklistSelection();
        ignoreSelectionEvents = false;
        this.profileComboBox.invalidate();
        InitialScreen initialScreen = this;
        this.profilePanel.setTitle("<html><p style=\"color: #ffffff; font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 9px; align: left;\">&nbsp;Current profile:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<font color=\"#d2ffad\"><b>" + initialScreen.morpho.getCurrentProfileName() + "</b></font>" + "</p></html>");
        this.profilePanel.invalidate();
        this.currentProfileLDAPLabel.setText("<html><p style=\"color: #666666; font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 8px; align: left;\">(" + this.morpho.getUserName() + ")" + "</p></html>");
        this.currentProfileLDAPLabel.invalidate();
        this.profilePanel.revalidate();
    }

    private void populateLoginPanel(LeftPanel panel) {
        final JButton loginButton = new JButton();
        final JLabel loginMessageLabel = new JLabel();
        panel.addToRow1(loginMessageLabel);
        panel.addToRow1(Box.createHorizontalGlue());
        final JLabel loginHeaderLabel = new JLabel();
        panel.addToRow2(loginHeaderLabel);
        panel.addToRow2(Box.createHorizontalGlue());
        final JLabel passwordLabel = new JLabel("<html><p style=\"color: #000000; align: left; font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 9px;\">&nbsp;Password:</p></html>");
        this.setSizes(passwordLabel, UISettings.INIT_SCRN_LEFT_PANELS_LABELDIMS);
        this.setSizes(this.passwordField, UISettings.INIT_SCRN_LEFT_PANELS_PICKLISTDIMS);
        this.passwordField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                loginButton.doClick();
            }
        });
        this.logoutCommand = new Command(){

            public void execute(ActionEvent e) {
                InitialScreen.this.morpho.logOut();
                InitialScreen.this.updateLoginStatus(loginMessageLabel, loginHeaderLabel, passwordLabel, InitialScreen.this.passwordField, loginButton);
            }
        };
        GUIAction logoutAction = new GUIAction("<b>Logout</b> from network...", UISettings.LOGOUT_ICON, this.logoutCommand);
        logoutAction.setRolloverSmallIcon(UISettings.LOGOUT_ICON_ROLLOVER);
        this.logoutLink = new HyperlinkButton(logoutAction);
        this.setSizes(this.logoutLink, UISettings.INIT_SCR_LINKBUTTON_DIMS);
        GUIAction loginAction = new GUIAction("<html><p style=\"color: #000000; font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 9px; align: left;\">login</p></html>", null, new LoginCommand(this.morpho, new LoginClientInterface(){

            public String getPassword() {
                InitialScreen.this.parentFrame.setBusy(true);
                loginButton.setEnabled(false);
                InitialScreen.this.passwordField.setEnabled(false);
                return new String(InitialScreen.this.passwordField.getPassword());
            }

            public void setLoginSuccessful(boolean success) {
                InitialScreen.this.parentFrame.setBusy(false);
                loginButton.setEnabled(true);
                InitialScreen.this.passwordField.setEnabled(true);
                if (success) {
                    InitialScreen.this.updateLoginStatus(loginMessageLabel, loginHeaderLabel, passwordLabel, InitialScreen.this.passwordField, loginButton);
                } else {
                    Log.debug(9, "Login failed.\nPlease check the Caps Lock key and try again.");
                }
            }
        }));
        loginButton.setAction(loginAction);
        loginButton.setContentAreaFilled(false);
        loginButton.setRolloverEnabled(true);
        loginButton.setHorizontalAlignment(0);
        loginButton.setMargin(new Insets(0, 0, 0, 0));
        this.setSizes(loginButton, UISettings.INIT_SCR_LOGIN_BUTTON_DIMS);
        this.morpho.addConnectionListener(new ConnectionListener(){

            public void connectionChanged(boolean isConnected) {
                InitialScreen.this.updateLoginStatus(loginMessageLabel, loginHeaderLabel, passwordLabel, InitialScreen.this.passwordField, loginButton);
            }

            public void usernameChanged(String username) {
                InitialScreen.this.updateProfileStatus();
            }
        });
        this.updateLoginStatus(loginMessageLabel, loginHeaderLabel, passwordLabel, this.passwordField, loginButton);
    }

    private void updateLoginStatus(JLabel loginMessageLabel, JLabel loginHeaderLabel, JLabel passwordLabel, JPasswordField passwordField, JButton loginButton) {
        InitialScreen initialScreen = this;
        this.loginPanel.setTitle("<html><p style=\"color: #ffffff; font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 9px; align: left;\">&nbsp;Network Status:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<font color=\"#d2ffad\"><b>" + (initialScreen.morpho.isConnected() ? "Logged In" : "NOT Logged In") + "</b></font>" + "</p></html>");
        InitialScreen initialScreen2 = this;
        loginMessageLabel.setText("<html><p style=\"color: #666666; font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 8px; align: left;\">" + (initialScreen2.morpho.isConnected() ? "You are logged into the network, and may work with all files for which you have access privileges " : "If you do not choose to login, you will be able to access only \"public\" network files as a Guest User") + "</p></html>");
        InitialScreen initialScreen3 = this;
        if (initialScreen3.morpho.isConnected() == this.prevLoginStatus) {
            return;
        }
        InitialScreen initialScreen4 = this;
        if (initialScreen4.morpho.isConnected()) {
            this.loginPanel.clearRow3();
            this.loginPanel.addToRow3(this.logoutLink);
            this.logoutLink.resetRollovers();
            this.loginPanel.addToRow3(Box.createHorizontalGlue());
            loginHeaderLabel.setText("");
            this.prevLoginStatus = true;
        } else {
            this.loginPanel.clearRow3();
            this.loginPanel.addToRow3(passwordLabel);
            passwordField.setText("");
            this.loginPanel.addToRow3(passwordField);
            this.loginPanel.addToRow3(Box.createHorizontalStrut(10));
            this.loginPanel.addToRow3(loginButton);
            this.loginPanel.addToRow3(Box.createHorizontalGlue());
            loginHeaderLabel.setText("<html><p style=\"color: #000000; align: left; font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 9px;font-weight: bold;\">Login to network using current profile:</p></html>");
            this.prevLoginStatus = false;
        }
    }

    private void populateDataPanel(LeftPanel panel) {
        ServiceProvider providr = null;
        ServiceController services = ServiceController.getInstance();
        DataPackageInterface dataPackagePlugin = null;
        try {
            providr = services.getServiceProvider(DataPackageInterface.class);
            dataPackagePlugin = (DataPackageInterface)((Object)providr);
        }
        catch (ServiceNotHandledException snhe) {
            Log.debug(6, snhe.getMessage());
        }
        QueryRefreshInterface queryPlugin = null;
        try {
            providr = services.getServiceProvider(QueryRefreshInterface.class);
            queryPlugin = (QueryRefreshInterface)((Object)providr);
        }
        catch (ServiceNotHandledException snhe) {
            Log.debug(6, snhe.getMessage());
        }
        Command newPkgCmd = null;
        Command openPkgCmd = null;
        Command searchCmd = null;
        try {
            newPkgCmd = dataPackagePlugin.getCommandObject(10);
        }
        catch (ClassNotFoundException cnfe) {
            Log.debug(6, "InitialScreen.java - Command not found \nwhile getting NEW_DATAPACKAGE_COMMAND: " + cnfe.getMessage());
        }
        try {
            openPkgCmd = queryPlugin.getCommandObject(20);
        }
        catch (ClassNotFoundException cnfe) {
            Log.debug(6, "InitialScreen.java - Command not found \nwhile getting OPEN_DATAPACKAGE_COMMAND: " + cnfe.getMessage());
        }
        try {
            searchCmd = queryPlugin.getCommandObject(30);
        }
        catch (ClassNotFoundException cnfe) {
            Log.debug(6, "InitialScreen.java - Command not found \nwhile getting SEARCH_COMMAND: " + cnfe.getMessage());
        }
        GUIAction newAction = new GUIAction("Create a <b>new</b> data package...", UISettings.NEW_DATAPACKAGE_ICON, newPkgCmd);
        newAction.setRolloverSmallIcon(UISettings.NEW_DATAPACKAGE_ICON_ROLLOVER);
        HyperlinkButton newLink = new HyperlinkButton(newAction);
        this.setSizes(newLink, UISettings.INIT_SCR_LINKBUTTON_DIMS);
        panel.addToRow1(newLink);
        panel.addToRow1(Box.createHorizontalGlue());
        GUIAction openAction = new GUIAction("Open an <b>existing</b> data package...", UISettings.OPEN_DATAPACKAGE_ICON, openPkgCmd);
        openAction.setRolloverSmallIcon(UISettings.OPEN_DATAPACKAGE_ICON_ROLLOVER);
        HyperlinkButton openLink = new HyperlinkButton(openAction);
        this.setSizes(openLink, UISettings.INIT_SCR_LINKBUTTON_DIMS);
        panel.addToRow2(openLink);
        panel.addToRow2(Box.createHorizontalGlue());
        GUIAction searchAction = new GUIAction("<b>Search</b> for an existing data package...", UISettings.SEARCH_ICON, searchCmd);
        searchAction.setRolloverSmallIcon(UISettings.SEARCH_ICON_ROLLOVER);
        HyperlinkButton searchLink = new HyperlinkButton(searchAction);
        this.setSizes(searchLink, UISettings.INIT_SCR_LINKBUTTON_DIMS);
        panel.addToRow3(searchLink);
        panel.addToRow3(Box.createHorizontalGlue());
    }

    private void setSizes(JComponent comp, Dimension dims) {
        comp.setPreferredSize(dims);
        comp.setMinimumSize(dims);
        comp.setMaximumSize(dims);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawImage(UISettings.INIT_SCR_BACKGROUND, 0, 0, this);
    }

    class ProfileComboBoxModel
    extends DefaultComboBoxModel {
        ProfileComboBoxModel() {
        }

        ProfileComboBoxModel(Object[] elements) {
            super(elements);
        }

        public void resetElementsTo(Object[] elements) {
            if (elements == null) {
                return;
            }
            this.removeAllElements();
            for (int i = 0; i < elements.length; ++i) {
                if (elements[i] == null) continue;
                this.addElement(elements[i]);
            }
        }
    }

    class LeftPanel
    extends JPanel {
        private JLabel titleLabel;
        private Box topBox;
        private Box middleBox;
        private Box bottomBox;

        public LeftPanel(String title, int height) {
            super(new BorderLayout());
            Dimension thisDim = new Dimension(340, height);
            this.setBackground(UISettings.INIT_SCRN_LEFT_PANELS_BG_COLOR);
            InitialScreen.this.setSizes(this, thisDim);
            this.setOpaque(true);
            this.titleLabel = new JLabel(title);
            InitialScreen.this.setSizes(this.titleLabel, UISettings.INIT_SCRN_LEFT_PANELS_TITLE_DIMS);
            this.titleLabel.setBackground(UISettings.INIT_SCRN_LEFT_PANELS_TITLE_BG_COLOR);
            this.titleLabel.setOpaque(true);
            this.add((Component)this.titleLabel, "North");
            Box vertBox = Box.createVerticalBox();
            this.topBox = Box.createHorizontalBox();
            this.middleBox = Box.createHorizontalBox();
            this.bottomBox = Box.createHorizontalBox();
            vertBox.add(Box.createVerticalGlue());
            vertBox.add(this.topBox);
            vertBox.add(Box.createVerticalGlue());
            vertBox.add(this.middleBox);
            vertBox.add(Box.createVerticalGlue());
            vertBox.add(this.bottomBox);
            vertBox.add(Box.createVerticalGlue());
            Box horizBox = Box.createHorizontalBox();
            horizBox.add(Box.createHorizontalStrut(10));
            horizBox.add(vertBox);
            horizBox.add(Box.createHorizontalStrut(10));
            this.add((Component)horizBox, "Center");
        }

        public void setTitle(String title) {
            this.titleLabel.setText(title);
            this.validate();
        }

        public void addToRow1(Component comp) {
            this.topBox.add(comp);
        }

        public void clearRow1() {
            this.topBox.removeAll();
            this.topBox.validate();
        }

        public void addToRow2(Component comp) {
            this.middleBox.add(comp);
        }

        public void clearRow2() {
            this.middleBox.removeAll();
            this.middleBox.validate();
        }

        public void addToRow3(Component comp) {
            this.bottomBox.add(comp);
        }

        public void clearRow3() {
            this.bottomBox.removeAll();
            this.bottomBox.validate();
        }
    }
}

