/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import com.arbortext.catalog.CatalogEntityResolver;
import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.datapackage.AccessionNumber;
import edu.ucsb.nceas.morpho.datapackage.EMLConvert;
import edu.ucsb.nceas.morpho.datapackage.PackageUtil;
import edu.ucsb.nceas.morpho.datapackage.Triple;
import edu.ucsb.nceas.morpho.datapackage.TripleCollection;
import edu.ucsb.nceas.morpho.datastore.CacheAccessException;
import edu.ucsb.nceas.morpho.datastore.FileSystemDataStore;
import edu.ucsb.nceas.morpho.datastore.MetacatDataStore;
import edu.ucsb.nceas.morpho.datastore.MetacatUploadException;
import edu.ucsb.nceas.morpho.framework.ConfigXML;
import edu.ucsb.nceas.morpho.plugins.XMLFactoryInterface;
import edu.ucsb.nceas.morpho.query.LocalQuery;
import edu.ucsb.nceas.morpho.util.DocumentNotFoundException;
import edu.ucsb.nceas.morpho.util.IOUtil;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.morpho.util.XMLTransformer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DataPackage
implements XMLFactoryInterface {
    private ConfigXML config;
    private Morpho morpho;
    private TripleCollection triples;
    private File tripleFile;
    private File dataPkgFile;
    private String location;
    private String id;
    private Document tripleFileDom;
    private Hashtable docAtts = new Hashtable();
    private final FileSystemDataStore fileSysDataStore;
    private final MetacatDataStore metacatDataStore;
    private final String HTMLEXTENSION = ".html";
    private final String METADATAHTML = "metadata";
    private final String CONFIG_KEY_CSS_LOCATION = "emlCSSLocation";
    private final String CONFIG_KEY_MCONFJAR_LOC = "morphoConfigJarLocation";
    private final String EXPORTSYLE = "export";
    private final String EXPORTSYLEEXTENSION = ".css";
    Hashtable entity2PhysicalFile;
    Hashtable entity2AttributeFile;
    Hashtable entity2DataFile;
    Properties params = new Properties();

    public DataPackage(String location, String identifier, Vector relations, Morpho morpho, boolean accessCheckFlag) {
        this.entity2PhysicalFile = new Hashtable();
        this.entity2AttributeFile = new Hashtable();
        this.entity2DataFile = new Hashtable();
        this.morpho = morpho;
        this.location = location;
        this.id = identifier;
        this.config = morpho.getConfiguration();
        Log.debug(11, "Creating new DataPackage Object");
        Log.debug(11, "id: " + this.id);
        Log.debug(11, "location: " + location);
        this.fileSysDataStore = new FileSystemDataStore(morpho);
        this.metacatDataStore = new MetacatDataStore(morpho);
        try {
            this.tripleFile = this.getFileWithID(this.id);
        }
        catch (Throwable t) {
            return;
        }
        this.initTriplesCollection();
        this.parseTripleFile();
        if (accessCheckFlag) {
            this.checkTriplesForAccess();
        }
    }

    private File getFileWithID(String ID) throws Throwable {
        Object returnFile = null;
        if (this.location.equals("metacat")) {
            try {
                Log.debug(11, "opening metacat file");
                this.dataPkgFile = this.metacatDataStore.openFile(ID);
                Log.debug(11, "metacat file opened");
            }
            catch (FileNotFoundException fnfe) {
                Log.debug(0, "Error in DataPackage.getFileFromDataStore(): metacat file not found: " + fnfe.getMessage());
                fnfe.printStackTrace();
                throw fnfe.fillInStackTrace();
            }
            catch (CacheAccessException cae) {
                Log.debug(0, "Error in DataPackage.getFileFromDataStore(): metacat cache problem: " + cae.getMessage());
                cae.printStackTrace();
                throw cae.fillInStackTrace();
            }
        }
        try {
            Log.debug(11, "opening local file");
            this.dataPkgFile = this.fileSysDataStore.openFile(ID);
            Log.debug(11, "local file opened");
        }
        catch (FileNotFoundException fnfe) {
            Log.debug(0, "Error in DataPackage.getFileFromDataStore(): local file not found: " + fnfe.getMessage());
            fnfe.printStackTrace();
            throw fnfe.fillInStackTrace();
        }
        return this.dataPkgFile;
    }

    private void initTriplesCollection() {
        this.triples = new TripleCollection(this.tripleFile, this.morpho);
    }

    private boolean idExists(String identifier) {
        return this.getAllIdentifiers().contains(identifier);
    }

    private File openAsFile(String identifier) throws DocumentNotFoundException {
        if (!this.idExists(identifier)) {
            throw new DocumentNotFoundException("DataPackage.open(): Element with ID: " + identifier + " does not exist");
        }
        File elementSrcFile = null;
        try {
            elementSrcFile = this.getFileWithID(identifier);
        }
        catch (Throwable t) {
            throw new DocumentNotFoundException("DataPackage.open(): Error opening element with ID: " + identifier);
        }
        return elementSrcFile;
    }

    public Reader openAsReader(String identifier) throws DocumentNotFoundException {
        int paramIndex = identifier.indexOf("?");
        if (paramIndex >= 0) {
            this.params.clear();
            String paramString = identifier.substring(1 + paramIndex);
            StringTokenizer tokenizer = new StringTokenizer(paramString, "&");
            while (tokenizer.hasMoreTokens()) {
                String nextToken = tokenizer.nextToken();
                int eqIndex = nextToken.indexOf("=");
                if (eqIndex < 0) continue;
                this.params.setProperty(nextToken.substring(0, eqIndex), nextToken.substring(1 + eqIndex));
                Log.debug(44, "DataPackage.openAsReader() got uri params: " + nextToken);
            }
            identifier = identifier.substring(0, paramIndex);
        }
        FileReader reader = null;
        try {
            reader = new FileReader(this.openAsFile(identifier));
        }
        catch (Exception ioe) {
            Log.debug(12, "Error instantiating reader " + ioe.getMessage());
            DocumentNotFoundException dnfe = new DocumentNotFoundException("DataPackage.openAsReader() - Nested Exception: " + ioe);
            dnfe.fillInStackTrace();
            throw dnfe;
        }
        return reader;
    }

    public Document openAsDom(String id) {
        return null;
    }

    public InputStream openAsInputStream(String identifier) throws DocumentNotFoundException, FileNotFoundException {
        return new FileInputStream(this.openAsFile(identifier));
    }

    public Document getTripleFileDom() {
        return this.tripleFileDom;
    }

    private void parseTripleFile() {
        String s;
        Node n;
        int i;
        Document doc;
        DataPackage dataPackage = this;
        DocumentBuilder parser = dataPackage.morpho.createDomParser();
        CatalogEntityResolver cer = new CatalogEntityResolver();
        try {
            String catalogPath = this.config.get("local_catalog_path", 0);
            this.tripleFileDom = doc = PackageUtil.getDoc(this.tripleFile, catalogPath);
        }
        catch (Exception e) {
            Log.debug(0, "error parsing " + this.tripleFile.getPath() + " : " + e.getMessage());
            e.printStackTrace();
            return;
        }
        NodeList originatorNodeList = null;
        NodeList titleNodeList = null;
        NodeList altTitleNodeList = null;
        String originatorPath = this.config.get("originatorPath", 0);
        String titlePath = this.config.get("titlePath", 0);
        String altTitlePath = this.config.get("altTitlePath", 0);
        try {
            originatorNodeList = XPathAPI.selectNodeList((Node)doc, (String)originatorPath);
            titleNodeList = XPathAPI.selectNodeList((Node)doc, (String)titlePath);
            altTitleNodeList = XPathAPI.selectNodeList((Node)doc, (String)altTitlePath);
            if (titleNodeList.getLength() == 0) {
                titleNodeList = XPathAPI.selectNodeList((Node)doc, (String)"//title");
            }
        }
        catch (TransformerException se) {
            System.err.println("parseTripleFile : parse threw: " + se.toString());
        }
        Vector<String> v = new Vector<String>();
        for (i = 0; i < originatorNodeList.getLength(); ++i) {
            String s2;
            n = originatorNodeList.item(i);
            Node child = n.getFirstChild();
            if (null == child || v.contains((s2 = child.getNodeValue()).trim())) continue;
            v.addElement(s2.trim());
        }
        this.docAtts.put("originator", v);
        v = new Vector();
        for (i = 0; i < titleNodeList.getLength(); ++i) {
            n = titleNodeList.item(i);
            s = n.getFirstChild().getNodeValue();
            if (v.contains(s.trim())) continue;
            v.addElement(s.trim());
        }
        this.docAtts.put("title", v);
        v = new Vector();
        for (i = 0; i < altTitleNodeList.getLength(); ++i) {
            n = altTitleNodeList.item(i);
            s = n.getFirstChild().getNodeValue();
            if (v.contains(s.trim())) continue;
            v.addElement(s.trim());
        }
        this.docAtts.put("altTitle", v);
    }

    public Hashtable getRelatedFiles() {
        Vector tripleVec = this.triples.getCollection();
        Hashtable<String, Vector> filesHash = new Hashtable<String, Vector>();
        String catalogPath = this.config.get("local_catalog_path", 0);
        for (int i = 0; i < tripleVec.size(); ++i) {
            File objfile;
            Vector v;
            String name;
            DocumentType dt;
            String xmlString;
            FileReader fr;
            File subfile;
            Triple t = (Triple)tripleVec.elementAt(i);
            String subject = t.getSubject();
            String object = t.getObject();
            if (subject.trim().equals("") || object.trim().equals("")) continue;
            try {
                subfile = this.fileSysDataStore.openFile(subject.trim());
            }
            catch (FileNotFoundException fnfe) {
                try {
                    subfile = this.metacatDataStore.openFile(subject.trim());
                }
                catch (FileNotFoundException fnfe2) {
                    Log.debug(0, "File " + subject + " not found locally or " + "on metacat.");
                    return null;
                }
                catch (CacheAccessException cae) {
                    Log.debug(0, "The cache could not be accessed in DataPackage.getRelatedFiles.");
                    return null;
                }
            }
            try {
                fr = new FileReader(subfile);
                xmlString = "";
                for (int j = 0; j < 5; ++j) {
                    xmlString = xmlString + (char)fr.read();
                }
                if (xmlString.equals("<?xml")) {
                    Document subDoc = PackageUtil.getDoc(subfile, catalogPath);
                    dt = subDoc.getDoctype();
                    name = dt.getPublicId();
                } else {
                    name = "Data File";
                }
                v = filesHash.containsKey(name) ? (Vector)filesHash.remove(name) : new Vector();
                if (!v.contains(subject)) {
                    v.addElement(subject);
                }
                filesHash.put(name, v);
                fr.close();
            }
            catch (Exception e) {
                Log.debug(10, "error in DataPackage.getRelatedFiles():(subjects) " + e.getMessage());
            }
            try {
                objfile = this.fileSysDataStore.openFile(object.trim());
            }
            catch (FileNotFoundException fnfe) {
                try {
                    objfile = this.metacatDataStore.openFile(object.trim());
                }
                catch (FileNotFoundException fnfe2) {
                    Log.debug(0, "File " + subject + " not found locally or " + "on metacat.");
                    return null;
                }
                catch (CacheAccessException cae) {
                    Log.debug(0, "The cache could not be accessed in DataPackage.getRelatedFiles.");
                    return null;
                }
            }
            try {
                fr = new FileReader(objfile);
                xmlString = "";
                for (int j = 0; j < 5; ++j) {
                    xmlString = xmlString + (char)fr.read();
                }
                if (xmlString.equals("<?xml")) {
                    Document objDoc = PackageUtil.getDoc(objfile, catalogPath);
                    dt = objDoc.getDoctype();
                    name = dt.getPublicId();
                } else {
                    name = "Data File";
                }
                v = filesHash.containsKey(name) ? (Vector)filesHash.remove(name) : new Vector();
                if (!v.contains(object)) {
                    v.addElement(object);
                }
                filesHash.put(name, v);
                fr.close();
                continue;
            }
            catch (Exception e) {
                Log.debug(10, "error in DataPackage.getRelatedFiles():objects " + e.getMessage());
            }
        }
        return filesHash;
    }

    public String getLocation() {
        return this.location;
    }

    public Hashtable getAttributes() {
        return this.docAtts;
    }

    public TripleCollection getTriples() {
        return this.triples;
    }

    public File getTriplesFile() {
        return this.tripleFile;
    }

    public String getID() {
        return this.id;
    }

    public boolean hasMutipleVersions() {
        boolean flag = false;
        int versions = 0;
        int index = this.id.lastIndexOf(".");
        String ver = this.id.substring(index + 1, this.id.length());
        versions = new Integer(ver);
        if (versions > 1) {
            flag = true;
        }
        return flag;
    }

    public String getAccessId() throws FileNotFoundException, Exception, CacheAccessException {
        Vector fileids = this.getAllIdentifiers();
        Vector accessFileType = this.config.get("accessFileType");
        for (int i = 0; i < fileids.size(); ++i) {
            File f;
            try {
                f = this.location.equals("local") || this.location.equals("localmetacat") ? this.fileSysDataStore.openFile((String)fileids.elementAt(i)) : this.metacatDataStore.openFile((String)fileids.elementAt(i));
            }
            catch (FileNotFoundException fnfe) {
                throw new FileNotFoundException("file: " + (String)fileids.elementAt(i) + " not found.");
            }
            catch (CacheAccessException cae) {
                throw cae;
            }
            String catalogpath = this.config.get("local_catalog_path", 0);
            String publicid = null;
            FileInputStream fis = new FileInputStream(f);
            int c = fis.read();
            String s = "";
            for (int j = 0; j < 10; ++j) {
                s = s + (char)c;
                c = fis.read();
            }
            fis.close();
            if (s.indexOf("<?xml") == -1) continue;
            Document doc = PackageUtil.getDoc(f, catalogpath);
            DocumentType dt = doc.getDoctype();
            publicid = dt.getPublicId();
            for (int j = 0; j < accessFileType.size(); ++j) {
                String accesstype = ((String)accessFileType.elementAt(j)).trim();
                if (!accesstype.equals(publicid = publicid.trim())) continue;
                return (String)fileids.elementAt(i);
            }
            continue;
        }
        throw new FileNotFoundException("The package did not contain an access file (DataPackage.getAccessId()");
    }

    public Vector getAllIdentifiers() {
        Vector<String> v = new Vector<String>();
        Vector trips = this.triples.getCollection();
        for (int i = 0; i < trips.size(); ++i) {
            String sub = ((Triple)trips.elementAt(i)).getSubject();
            String obj = ((Triple)trips.elementAt(i)).getObject();
            if (!v.contains(sub.trim())) {
                v.addElement(sub.trim());
            }
            if (v.contains(obj.trim())) continue;
            v.addElement(obj.trim());
        }
        String accessID = this.getAccessFileIdForDataPackage();
        int accessLoc = v.indexOf(accessID = accessID.trim());
        if (accessLoc > -1) {
            v.removeElementAt(accessLoc);
            v.insertElementAt(accessID, 0);
        }
        return v;
    }

    public DataPackage upload() throws MetacatUploadException {
        return this.upload(true);
    }

    public DataPackage upload(boolean updateIds) throws MetacatUploadException {
        Log.debug(20, "Uploading package.");
        if (!this.location.equals("localmetacat") && !this.location.equals("metacat")) {
            Vector ids = this.getAllIdentifiers();
            Hashtable<String, File> files = new Hashtable<String, File>();
            for (int i = 0; i < ids.size(); ++i) {
                String id = (String)ids.elementAt(i);
                try {
                    files.put(id, this.fileSysDataStore.openFile(id));
                    continue;
                }
                catch (FileNotFoundException fnfe) {
                    Log.debug(0, "There is an error in this package, a file is missing.  Missing file: " + id);
                }
            }
            Enumeration keys = files.keys();
            Vector<String> keysVec = new Vector<String>();
            String accessKey = this.getAccessFileIdForDataPackage();
            keysVec.addElement(accessKey);
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (key.equals(accessKey)) continue;
                keysVec.addElement(key);
            }
            Enumeration keysVecEnum = keysVec.elements();
            while (keysVecEnum.hasMoreElements()) {
                String key = (String)keysVecEnum.nextElement();
                File f = (File)files.get(key);
                try {
                    Log.debug(20, "Uploading " + key);
                    AccessionNumber a = new AccessionNumber(this.morpho);
                    Vector idVec = a.getParts(key);
                    String scope = (String)idVec.elementAt(0);
                    String id = (String)idVec.elementAt(1);
                    String rev = (String)idVec.elementAt(2);
                    String sep = (String)idVec.elementAt(3);
                    Integer revI = new Integer(rev);
                    int revi = revI;
                    if (!this.isDataFile(key)) {
                        for (int i = 1; i <= revi; ++i) {
                            String accnum = scope + sep + id + sep + i;
                            File g = this.fileSysDataStore.openFile(accnum);
                            if (i == 1) {
                                this.metacatDataStore.newFile(accnum, new FileReader(g));
                                continue;
                            }
                            this.metacatDataStore.saveFile(accnum, new FileReader(g));
                        }
                        continue;
                    }
                    this.metacatDataStore.newDataFile(key, f);
                }
                catch (Exception e) {
                    String message = e.getMessage();
                    System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>message: " + message);
                    String accNumMess1 = "Accession number";
                    String accNumMess2 = "is already in use.";
                    String accNumMess3 = "unique constraint";
                    String accNumMess4 = "violated";
                    if (message.indexOf(accNumMess1) != -1 && message.indexOf(accNumMess2) != -1 || message.indexOf(accNumMess3) != -1 && message.indexOf(accNumMess4) != -1 || message.indexOf("null") != -1) {
                        if (updateIds) {
                            return this.incrementPackageIds();
                        }
                        throw new MetacatUploadException(e.getMessage());
                    }
                    throw new MetacatUploadException(e.getMessage());
                }
            }
        }
        return this;
    }

    private DataPackage incrementPackageIds() {
        Vector fileIds = this.getAllIdentifiers();
        Hashtable<String, String> updatedIds = new Hashtable<String, String>();
        Hashtable updatedFiles = new Hashtable();
        AccessionNumber accNum = new AccessionNumber(this.morpho);
        String newId = "";
        for (int i = 0; i < fileIds.size(); ++i) {
            FileInputStream fis;
            File f;
            String fileId = (String)fileIds.elementAt(i);
            StringBuffer sb = new StringBuffer();
            if (fileId.equals(this.id)) continue;
            newId = accNum.getNextId();
            updatedIds.put(fileId, newId);
            if (!this.isDataFile(fileId)) {
                try {
                    f = PackageUtil.openFile(fileId, this.morpho);
                    fis = new FileInputStream(f);
                    int c = fis.read();
                    while (c != -1) {
                        sb.append((char)c);
                        c = fis.read();
                    }
                    fis.close();
                }
                catch (Exception e) {
                    Log.debug(0, "Error reading file " + fileId + " in package." + "DataPackage.incrementPackageIds()");
                }
                String fileString = sb.toString();
                fileString = this.replaceTextInString(fileString, fileId, newId);
                this.fileSysDataStore.newFile(newId, new StringReader(fileString));
                try {
                    this.metacatDataStore.newFile(newId, new StringReader(fileString));
                }
                catch (MetacatUploadException mue) {
                    Log.debug(0, "Error uploading file " + fileId + " to metacat" + " in DataPackage.incrementPackageIds(): " + mue.getMessage());
                }
                continue;
            }
            f = null;
            try {
                f = PackageUtil.openFile(fileId, this.morpho);
                fis = new FileInputStream(f);
                this.fileSysDataStore.newDataFile(newId, fis);
                fis.close();
            }
            catch (Exception w) {
                Log.debug(0, "Problem writing new local data file");
            }
            try {
                this.metacatDataStore.newDataFile(newId, f);
                continue;
            }
            catch (MetacatUploadException mue) {
                Log.debug(0, "Error uploading file " + newId + " to metacat" + " in DataPackage.incrementPackageIds(): " + mue.getMessage());
            }
        }
        StringBuffer sb = new StringBuffer();
        try {
            File packageFile = this.getTriplesFile();
            FileInputStream fis = new FileInputStream(packageFile);
            int c = fis.read();
            while (c != -1) {
                sb.append((char)c);
                c = fis.read();
            }
        }
        catch (FileNotFoundException fnfe) {
            Log.debug(0, "Error finding package file in DataPackage.incrementPackageIds(): " + fnfe.getMessage());
        }
        catch (IOException ioe) {
            Log.debug(0, "Error reading package file in DataPackage.incrementPackageIds(): " + ioe.getMessage());
        }
        String packageFileString = sb.toString();
        Enumeration oldids = updatedIds.keys();
        while (oldids.hasMoreElements()) {
            String oldid = (String)oldids.nextElement();
            String newid = (String)updatedIds.get(oldid);
            packageFileString = this.replaceTextInString(packageFileString, oldid, newid);
        }
        String newPackageId = accNum.getNextId();
        packageFileString = this.replaceTextInString(packageFileString, this.id, newPackageId);
        this.fileSysDataStore.newFile(newPackageId, new StringReader(packageFileString));
        try {
            this.metacatDataStore.newFile(newPackageId, new StringReader(packageFileString));
        }
        catch (MetacatUploadException mue) {
            Log.debug(0, "Error uploading file " + newPackageId + " to metacat" + " in DataPackage.incrementPackageIds(): " + mue.getMessage());
        }
        DataPackage dp = new DataPackage(this.location, newPackageId, null, this.morpho, false);
        this.delete(this.location);
        return dp;
    }

    private String replaceTextInString(String text, String s1, String s2) {
        int s1Index = text.indexOf(s1);
        while (s1Index != -1) {
            String begin = text.substring(0, s1Index);
            String end = text.substring(s1Index + s1.length(), text.length());
            begin = begin + s2;
            text = begin + end;
            s1Index = text.indexOf(s1);
        }
        return text;
    }

    public void download() {
        Log.debug(20, "Downloading package.");
        if (!this.location.equals("localmetacat") && !this.location.equals("local")) {
            Vector ids = this.getAllIdentifiers();
            Hashtable<String, File> files = new Hashtable<String, File>();
            for (int i = 0; i < ids.size(); ++i) {
                String id = (String)ids.elementAt(i);
                try {
                    files.put(id, this.metacatDataStore.openFile(id));
                    continue;
                }
                catch (FileNotFoundException fnfe) {
                    Log.debug(0, "There is an error in this package, a file is missing.  Missing file: " + id);
                    continue;
                }
                catch (CacheAccessException cae) {
                    Log.debug(0, "The cache is locked.  Unlock it to continue.");
                }
            }
            Enumeration keys = files.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                File f = (File)files.get(key);
                String beginFile = "";
                try {
                    FileInputStream fis = new FileInputStream(f);
                    for (int i = 0; i < 10; ++i) {
                        beginFile = beginFile + (char)fis.read();
                    }
                    fis.close();
                }
                catch (Exception e) {
                    Log.debug(0, "Error reading file in package.");
                }
                try {
                    Log.debug(20, "Downloading " + key);
                    AccessionNumber a = new AccessionNumber(this.morpho);
                    Vector idVec = a.getParts(key);
                    String scope = (String)idVec.elementAt(0);
                    String id = (String)idVec.elementAt(1);
                    String rev = (String)idVec.elementAt(2);
                    String sep = (String)idVec.elementAt(3);
                    Integer revI = new Integer(rev);
                    int revi = revI;
                    if (beginFile.indexOf("<?xml") != -1) {
                        for (int i = 1; i <= revi; ++i) {
                            String accnum = scope + sep + id + sep + i;
                            File g = this.metacatDataStore.openFile(accnum);
                            if (i == 1) {
                                this.fileSysDataStore.newFile(accnum, new FileReader(g));
                                continue;
                            }
                            this.fileSysDataStore.saveFile(accnum, new FileReader(g));
                        }
                        continue;
                    }
                    this.fileSysDataStore.saveDataFile(key, new FileInputStream(f));
                }
                catch (Exception e) {
                    Log.debug(0, "Error downloading " + key + " from metacat: " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
    }

    public void delete(String location) {
        Vector v = this.getAllIdentifiers();
        boolean metacatLoc = false;
        boolean localLoc = false;
        if (location.equals("metacat") || location.equals("localmetacat")) {
            metacatLoc = true;
        }
        if (location.equals("local") || location.equals("localmetacat")) {
            localLoc = true;
        }
        for (int i = 0; i < v.size(); ++i) {
            try {
                if (localLoc) {
                    String delfile = (String)v.elementAt(i);
                    String rev = delfile.substring(delfile.lastIndexOf(".") + 1, delfile.length());
                    int revi = new Integer(rev);
                    for (int j = 1; j <= revi; ++j) {
                        String acc = delfile.substring(0, delfile.lastIndexOf("."));
                        this.fileSysDataStore.deleteFile(acc + "." + j);
                        LocalQuery.removeFromCache(acc + "." + j);
                    }
                }
                if (!metacatLoc) continue;
                this.metacatDataStore.deleteFile((String)v.elementAt(i));
                continue;
            }
            catch (Exception w) {
                // empty catch block
            }
        }
    }

    public void exportToZip(String path) throws Exception {
        DataPackage dataPackage = this;
        String tempdir = dataPackage.config.getConfigDirectory() + File.separator + this.config.get("tempDir", 0);
        this.export(tempdir + "/tmppackage");
        File zipfile = new File(path);
        FileOutputStream fos = new FileOutputStream(zipfile);
        ZipOutputStream zos = new ZipOutputStream(fos);
        String temppackdir = tempdir + "/tmppackage/" + this.id + ".package";
        File packdirfile = new File(temppackdir);
        String[] dirlist = packdirfile.list();
        String packdir = this.id + ".package";
        for (int i = 0; i < dirlist.length; ++i) {
            String entry = temppackdir + "/" + dirlist[i];
            ZipEntry ze = new ZipEntry(packdir + "/" + dirlist[i]);
            File entryFile = new File(entry);
            if (entryFile.isDirectory()) continue;
            ze.setSize(entryFile.length());
            zos.putNextEntry(ze);
            FileInputStream fis = new FileInputStream(entryFile);
            int c = fis.read();
            while (c != -1) {
                zos.write(c);
                c = fis.read();
            }
            zos.closeEntry();
        }
        String dataPackdir = packdir + "/data";
        String tempDatapackdir = temppackdir + "/data";
        File dataFile = new File(tempDatapackdir);
        String[] dataFileList = dataFile.list();
        if (dataFileList != null) {
            for (int i = 0; i < dataFileList.length; ++i) {
                String entry = tempDatapackdir + "/" + dataFileList[i];
                ZipEntry ze = new ZipEntry(dataPackdir + "/" + dataFileList[i]);
                File entryFile = new File(entry);
                ze.setSize(entryFile.length());
                zos.putNextEntry(ze);
                FileInputStream fis = new FileInputStream(entryFile);
                int c = fis.read();
                while (c != -1) {
                    zos.write(c);
                    c = fis.read();
                }
                zos.closeEntry();
            }
        }
        packdir = packdir + "/metadata";
        temppackdir = temppackdir + "/metadata";
        File sourcedir = new File(temppackdir);
        File[] sourcefiles = this.listFiles(sourcedir);
        for (int i = 0; i < sourcefiles.length; ++i) {
            File f = sourcefiles[i];
            ZipEntry ze = new ZipEntry(packdir + "/" + f.getName());
            ze.setSize(f.length());
            zos.putNextEntry(ze);
            FileInputStream fis = new FileInputStream(f);
            int c = fis.read();
            while (c != -1) {
                zos.write(c);
                c = fis.read();
            }
            zos.closeEntry();
        }
        zos.flush();
        zos.close();
    }

    public void export(String path) {
        Log.debug(20, "exporting...");
        Log.debug(20, "path: " + path);
        Log.debug(20, "id: " + this.id);
        Log.debug(20, "location: " + this.location);
        Vector<File> fileV = new Vector<File>();
        boolean localloc = false;
        boolean metacatloc = false;
        if (this.location.equals("localmetacat")) {
            localloc = true;
            metacatloc = true;
        } else if (this.location.equals("metacat")) {
            metacatloc = true;
        } else if (this.location.equals("local")) {
            localloc = true;
        }
        String packagePath = path + "/" + this.id + ".package";
        String sourcePath = packagePath + "/metadata";
        String dataPath = packagePath + "/data";
        File savedir = new File(packagePath);
        File savedirSub = new File(sourcePath);
        File savedirDataSub = new File(dataPath);
        savedir.mkdirs();
        savedirSub.mkdirs();
        Hashtable dataFileNameMap = this.getMapBetweenDataIdAndDataFileName();
        Vector files = this.getAllIdentifiers();
        StringBuffer[] htmldoc = new StringBuffer[files.size()];
        for (int i = 0; i < files.size(); ++i) {
            try {
                String docid = (String)files.elementAt(i);
                File f = null;
                if (dataFileNameMap.containsKey(docid)) {
                    savedirDataSub.mkdirs();
                    String dataFile = (String)dataFileNameMap.get(docid);
                    dataFile = this.trimFullPathFromFileName(dataFile);
                    f = new File(dataPath + "/" + dataFile);
                } else {
                    f = new File(sourcePath + "/" + docid);
                }
                File openfile = null;
                if (localloc) {
                    openfile = this.fileSysDataStore.openFile(docid);
                } else if (metacatloc) {
                    openfile = this.metacatDataStore.openFile(docid);
                }
                fileV.addElement(openfile);
                FileInputStream fis = new FileInputStream(openfile);
                BufferedInputStream bfis = new BufferedInputStream(fis);
                FileOutputStream fos = new FileOutputStream(f);
                BufferedOutputStream bfos = new BufferedOutputStream(fos);
                int c = bfis.read();
                while (c != -1) {
                    bfos.write(c);
                    c = bfis.read();
                }
                bfos.flush();
                bfis.close();
                bfos.close();
                FileReader xmlInputReader = null;
                Reader result = null;
                StringBuffer tempPathBuff = new StringBuffer();
                if (!dataFileNameMap.containsKey(docid)) {
                    xmlInputReader = new FileReader(openfile);
                    XMLTransformer transformer = XMLTransformer.getInstance();
                    transformer.removeAllTransformerProperties();
                    transformer.addTransformerProperty("href_path_extension", ".html");
                    transformer.addTransformerProperty("package_id", this.id);
                    transformer.addTransformerProperty("package_index_name", "metadata");
                    transformer.addTransformerProperty("qformat", "export");
                    transformer.addTransformerProperty("entitystyle", "export");
                    transformer.addTransformerProperty("stylePath", ".");
                    try {
                        result = transformer.transform(xmlInputReader);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        Log.debug(9, "Unexpected Error Styling Document: " + e.getMessage());
                        e.fillInStackTrace();
                        throw e;
                    }
                    finally {
                        ((Reader)xmlInputReader).close();
                    }
                    transformer.removeAllTransformerProperties();
                    try {
                        htmldoc[i] = IOUtil.getAsStringBuffer(result, true);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        Log.debug(9, "Unexpected Error Reading Styled Document: " + e.getMessage());
                        e.fillInStackTrace();
                        throw e;
                    }
                }
                htmldoc[i] = new StringBuffer("<html><head></head><body>");
                htmldoc[i].append("<h2>Data File: ");
                htmldoc[i].append(docid);
                htmldoc[i].append("</h2>");
                htmldoc[i].append("<a href=\"");
                String dataFileName = null;
                dataFileName = (String)dataFileNameMap.get(docid);
                dataFileName = this.trimFullPathFromFileName(dataFileName);
                htmldoc[i].append("./data/").append(dataFileName).append("\">");
                htmldoc[i].append("Data File: ");
                htmldoc[i].append(dataFileName).append("</a><br>");
                htmldoc[i].append("<br><hr><br>");
                htmldoc[i].append("</body></html>");
                tempPathBuff.delete(0, tempPathBuff.length());
                tempPathBuff.append(packagePath);
                tempPathBuff.append("/");
                if (this.id.equals(docid)) {
                    tempPathBuff.append("metadata");
                } else {
                    tempPathBuff.append(docid);
                }
                tempPathBuff.append(".html");
                this.saveToFile(htmldoc[i], new File(tempPathBuff.toString()));
                continue;
            }
            catch (Exception e) {
                System.out.println("Error in DataPackage.export(): " + e.getMessage());
                e.printStackTrace();
            }
        }
        this.exportStyleSheet(packagePath);
    }

    public void exportToEml2(String path) {
        Log.debug(20, "exporting...");
        Log.debug(20, "path: " + path);
        Log.debug(20, "id: " + this.id);
        Log.debug(20, "location: " + this.location);
        Vector<File> fileV = new Vector<File>();
        boolean localloc = false;
        boolean metacatloc = false;
        if (this.location.equals("localmetacat")) {
            localloc = true;
            metacatloc = true;
        } else if (this.location.equals("metacat")) {
            metacatloc = true;
        } else if (this.location.equals("local")) {
            localloc = true;
        }
        String sourcePath = "metadata";
        File savedirSub = new File(sourcePath);
        savedirSub.mkdirs();
        Hashtable dataFileNameMap = this.getMapBetweenDataIdAndDataFileName();
        Vector files = this.getAllIdentifiers();
        StringBuffer[] htmldoc = new StringBuffer[files.size()];
        for (int i = 0; i < files.size(); ++i) {
            try {
                String docid = (String)files.elementAt(i);
                File f = null;
                if (!dataFileNameMap.containsKey(docid)) {
                    f = new File(sourcePath + "/" + docid);
                }
                File openfile = null;
                if (localloc) {
                    openfile = this.fileSysDataStore.openFile(docid);
                } else if (metacatloc) {
                    openfile = this.metacatDataStore.openFile(docid);
                }
                if (f == null) continue;
                fileV.addElement(openfile);
                FileInputStream fis = new FileInputStream(openfile);
                BufferedInputStream bfis = new BufferedInputStream(fis);
                FileOutputStream fos = new FileOutputStream(f);
                BufferedOutputStream bfos = new BufferedOutputStream(fos);
                int c = bfis.read();
                while (c != -1) {
                    bfos.write(c);
                    c = bfis.read();
                }
                bfos.flush();
                bfis.close();
                bfos.close();
                continue;
            }
            catch (Exception e) {
                System.out.println("Error in DataPackage.exportToEml2(): " + e.getMessage());
                e.printStackTrace();
            }
        }
        try {
            EMLConvert.outputfileName = path;
            String murl = this.morpho.getMetacatURLString();
            if (!metacatloc) {
                murl = "file://" + this.id;
            }
            EMLConvert.doTransform("metadata/" + this.id, murl);
        }
        catch (Exception ee) {
            System.out.println("Error in EMLConvert: " + ee.getMessage());
            ee.printStackTrace();
        }
        String[] filelist = savedirSub.list();
        for (int k = 0; k < filelist.length; ++k) {
            File nf = new File(savedirSub, filelist[k]);
            nf.delete();
        }
        savedirSub.delete();
        JOptionPane.showMessageDialog(null, "Conversion to EML2 Complete ! ");
    }

    private String trimFullPathFromFileName(String fileName) {
        String onlyFileName = fileName;
        String slash = "/";
        String backSlash = "\\";
        if (fileName == null || fileName.equals("")) {
            return fileName;
        }
        int size = fileName.length();
        int lastBackSlashIndex = fileName.lastIndexOf(backSlash);
        int lastSlashIndex = fileName.lastIndexOf(slash);
        if (lastBackSlashIndex != -1) {
            onlyFileName = fileName.substring(lastBackSlashIndex + 1, size);
            return onlyFileName;
        }
        if (lastSlashIndex != -1) {
            onlyFileName = fileName.substring(lastSlashIndex + 1, size);
            return onlyFileName;
        }
        return onlyFileName;
    }

    private void saveToFile(StringBuffer buff, File outputFile) throws IOException {
        FileWriter fileWriter = new FileWriter(outputFile);
        IOUtil.writeToWriter(buff, fileWriter, true);
    }

    private String getIdFromPath(String path) {
        char sep = '/';
        if (path.indexOf("\\") != -1) {
            sep = '\\';
        }
        int lastSep = path.lastIndexOf(sep);
        String num = path.substring(lastSep + 1, path.length());
        int secondToLastSep = lastSep - 1;
        char c = path.charAt(secondToLastSep--);
        while (c != sep) {
            c = path.charAt(--secondToLastSep);
        }
        String scope = path.substring(secondToLastSep + 1, lastSep);
        return scope + "." + num;
    }

    private Hashtable getMapBetweenDataIdAndDataFileName() {
        Hashtable<String, String> map = new Hashtable<String, String>();
        Vector triplesV = this.triples.getCollection();
        int i = 1;
        String dataFileName = null;
        for (int j = 0; j < triplesV.size(); ++j) {
            Triple triple = (Triple)triplesV.elementAt(j);
            String relationship = triple.getRelationship();
            String subject = triple.getSubject();
            if (relationship.indexOf("isDataFileFor") == -1) continue;
            int lparenindex = relationship.indexOf("(");
            dataFileName = relationship.substring(lparenindex + 1, relationship.length() - 1);
            if ((dataFileName = this.trimFullPathFromFileName(dataFileName)) == null) continue;
            if (map.containsValue(dataFileName)) {
                dataFileName = this.appendFileNameNumber(dataFileName, i);
                ++i;
            }
            map.put(subject, dataFileName);
        }
        return map;
    }

    private String appendFileNameNumber(String fileName, int number) {
        int index = -1;
        String dot = ".";
        String extension = null;
        String prefix = null;
        if (fileName == null || fileName.equals("")) {
            fileName = "" + number;
            return fileName;
        }
        int size = fileName.length();
        index = fileName.lastIndexOf(dot);
        if (index == -1) {
            fileName = fileName + number;
            return fileName;
        }
        extension = fileName.substring(index + 1, size);
        prefix = fileName.substring(0, index);
        fileName = prefix + number + dot + extension;
        return fileName;
    }

    private void exportStyleSheet(String path) {
        String styleSheetSource = this.getStylePath();
        try {
            InputStream input = this.getClass().getResourceAsStream(styleSheetSource);
            InputStreamReader styleSheetReader = new InputStreamReader(input);
            StringBuffer buffer = IOUtil.getAsStringBuffer(styleSheetReader, true);
            String fileName = path + "/" + "export" + ".css";
            FileWriter writer = new FileWriter(fileName);
            IOUtil.writeToWriter(buffer, writer, true);
        }
        catch (Exception e) {
            Log.debug(30, "Error in exportStyleSheet: " + e.getMessage());
        }
    }

    private String getStylePath() {
        StringBuffer pathBuff = new StringBuffer();
        pathBuff.append("/");
        pathBuff.append(this.config.get("emlCSSLocation", 0));
        pathBuff.append("/");
        pathBuff.append("export");
        pathBuff.append(".css");
        Log.debug(50, "DataPackage.getFullStylePath() returning: " + pathBuff.toString());
        return pathBuff.toString();
    }

    private boolean isTextFile(File file) {
        boolean text = true;
        int maxcnt = 2000;
        try {
            int res;
            FileInputStream in = new FileInputStream(file);
            for (int cnt = 0; (res = in.read()) > -1 && cnt < maxcnt; ++cnt) {
                if (res != 0) continue;
                text = false;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return text;
    }

    public boolean isDataFile(String id) {
        boolean res = false;
        Vector triplesV = this.triples.getCollection();
        for (int i = 0; i < triplesV.size(); ++i) {
            String relationship;
            Triple triple = (Triple)triplesV.elementAt(i);
            String subject = triple.getSubject();
            if (!subject.trim().equals(id.trim()) || (relationship = triple.getRelationship()).indexOf("isDataFileFor") == -1) continue;
            res = true;
            return res;
        }
        return res;
    }

    public boolean hasDataFile(String entityID) {
        boolean result = false;
        Vector triplesV = this.triples.getCollection();
        for (int i = 0; i < triplesV.size(); ++i) {
            Triple triple = (Triple)triplesV.elementAt(i);
            String relationship = triple.getRelationship();
            if (relationship.indexOf("isDataFileFor") == -1) continue;
            String dataFileID = triple.getSubject();
            for (int j = 0; j < triplesV.size(); ++j) {
                Triple tripleA = (Triple)triplesV.elementAt(j);
                if (!tripleA.getSubject().equals(entityID) || !tripleA.getObject().equals(dataFileID)) continue;
                result = true;
            }
        }
        return result;
    }

    public boolean isDataFileText(String entityID) {
        boolean result = false;
        File fl = this.getDataFile(entityID);
        result = fl != null ? this.isTextFile(fl) : false;
        return result;
    }

    public String getDataFileName(String entityID) {
        String dataFileName = null;
        boolean result = false;
        Vector triplesV = this.triples.getCollection();
        for (int i = 0; i < triplesV.size(); ++i) {
            Triple triple = (Triple)triplesV.elementAt(i);
            String relationship = triple.getRelationship();
            if (relationship.indexOf("isDataFileFor") == -1) continue;
            int lparenindex = relationship.indexOf("(");
            dataFileName = relationship.substring(lparenindex + 1, relationship.length() - 1);
            String dataFileID = triple.getSubject();
            for (int j = 0; j < triplesV.size(); ++j) {
                Triple tripleA = (Triple)triplesV.elementAt(j);
                if (!tripleA.getSubject().equals(entityID) || !tripleA.getObject().equals(dataFileID)) continue;
                result = true;
                return dataFileName;
            }
        }
        String resultString = null;
        if (result) {
            resultString = dataFileName;
        }
        return resultString;
    }

    public File getPhysicalFile(String entityID) {
        if (this.entity2PhysicalFile.containsKey(entityID)) {
            return (File)this.entity2PhysicalFile.get(entityID);
        }
        File physicalfile = null;
        boolean localloc = false;
        boolean metacatloc = false;
        if (this.location.equals("localmetacat")) {
            localloc = true;
            metacatloc = true;
        } else if (this.location.equals("metacat")) {
            metacatloc = true;
        } else if (this.location.equals("local")) {
            localloc = true;
        }
        Vector triplesV = this.triples.getCollectionByObject(entityID);
        for (int i = 0; i < triplesV.size(); ++i) {
            Triple triple = (Triple)triplesV.elementAt(i);
            String sub = triple.getSubject();
            physicalfile = this.getFileType(sub, "physical");
            if (physicalfile == null) continue;
            if (!this.entity2PhysicalFile.contains(entityID)) {
                this.entity2PhysicalFile.put(entityID, physicalfile);
            }
            return physicalfile;
        }
        return physicalfile;
    }

    public String getPhysicalFileId(String entityID) {
        File physicalfile = null;
        boolean localloc = false;
        boolean metacatloc = false;
        if (this.location.equals("localmetacat")) {
            localloc = true;
            metacatloc = true;
        } else if (this.location.equals("metacat")) {
            metacatloc = true;
        } else if (this.location.equals("local")) {
            localloc = true;
        }
        Vector triplesV = this.triples.getCollectionByObject(entityID);
        for (int i = 0; i < triplesV.size(); ++i) {
            Triple triple = (Triple)triplesV.elementAt(i);
            String sub = triple.getSubject();
            physicalfile = this.getFileType(sub, "physical");
            if (physicalfile == null) continue;
            return sub;
        }
        return null;
    }

    public File getAttributeFile(String entityID) {
        if (this.entity2AttributeFile.containsKey(entityID)) {
            return (File)this.entity2AttributeFile.get(entityID);
        }
        File attributefile = null;
        boolean localloc = false;
        boolean metacatloc = false;
        if (this.location.equals("localmetacat")) {
            localloc = true;
            metacatloc = true;
        } else if (this.location.equals("metacat")) {
            metacatloc = true;
        } else if (this.location.equals("local")) {
            localloc = true;
        }
        Vector triplesV = this.triples.getCollectionByObject(entityID);
        for (int i = 0; i < triplesV.size(); ++i) {
            Triple triple = (Triple)triplesV.elementAt(i);
            String sub = triple.getSubject();
            attributefile = this.getFileType(sub, "attribute");
            if (attributefile == null) continue;
            if (!this.entity2AttributeFile.contains(entityID)) {
                this.entity2AttributeFile.put(entityID, attributefile);
            }
            return attributefile;
        }
        return attributefile;
    }

    public String getAttributeFileId(String entityID) {
        File attributefile = null;
        boolean localloc = false;
        boolean metacatloc = false;
        if (this.location.equals("localmetacat")) {
            localloc = true;
            metacatloc = true;
        } else if (this.location.equals("metacat")) {
            metacatloc = true;
        } else if (this.location.equals("local")) {
            localloc = true;
        }
        Vector triplesV = this.triples.getCollectionByObject(entityID);
        for (int i = 0; i < triplesV.size(); ++i) {
            Triple triple = (Triple)triplesV.elementAt(i);
            String sub = triple.getSubject();
            attributefile = this.getFileType(sub, "attribute");
            if (attributefile == null) continue;
            return sub;
        }
        return null;
    }

    public String getAccessFileId(String id) {
        File accessfile = null;
        boolean localloc = false;
        boolean metacatloc = false;
        if (this.location.equals("localmetacat")) {
            localloc = true;
            metacatloc = true;
        } else if (this.location.equals("metacat")) {
            metacatloc = true;
        } else if (this.location.equals("local")) {
            localloc = true;
        }
        Vector triplesV = this.triples.getCollectionByObject(id);
        for (int i = 0; i < triplesV.size(); ++i) {
            Triple triple = (Triple)triplesV.elementAt(i);
            String sub = triple.getSubject();
            accessfile = this.getFileType(sub, "access");
            if (accessfile == null) continue;
            return sub.trim();
        }
        return "unknown";
    }

    public String getAccessFileIdForDataPackage() {
        String temp = this.getAccessFileId(this.id);
        return temp;
    }

    public File getDataFile(String entityID) {
        if (this.entity2DataFile.containsKey(entityID)) {
            return (File)this.entity2DataFile.get(entityID);
        }
        File datafile = null;
        boolean localloc = false;
        boolean metacatloc = false;
        if (this.location.equals("localmetacat")) {
            localloc = true;
            metacatloc = true;
        } else if (this.location.equals("metacat")) {
            metacatloc = true;
        } else if (this.location.equals("local")) {
            localloc = true;
        }
        Vector triplesV = this.triples.getCollection();
        for (int i = 0; i < triplesV.size(); ++i) {
            Triple triple = (Triple)triplesV.elementAt(i);
            String relationship = triple.getRelationship();
            if (relationship.indexOf("isDataFileFor") == -1) continue;
            String dataFileID = triple.getSubject();
            for (int j = 0; j < triplesV.size(); ++j) {
                Triple tripleA = (Triple)triplesV.elementAt(j);
                if (!tripleA.getSubject().equals(entityID) || !tripleA.getObject().equals(dataFileID)) continue;
                if (localloc) {
                    try {
                        datafile = this.fileSysDataStore.openFile(dataFileID);
                        if (!this.entity2DataFile.contains(entityID)) {
                            this.entity2DataFile.put(entityID, datafile);
                        }
                        return datafile;
                    }
                    catch (Exception e) {
                        System.out.println("Error in DataPackage.getDataFile(): " + e.getMessage());
                        e.printStackTrace();
                        continue;
                    }
                }
                if (!metacatloc) continue;
                try {
                    datafile = this.metacatDataStore.openFile(dataFileID);
                    if (!this.entity2DataFile.contains(entityID)) {
                        this.entity2DataFile.put(entityID, datafile);
                    }
                    return datafile;
                }
                catch (Exception e) {
                    System.out.println("Error in DataPackage.getDataFile(): " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
        return datafile;
    }

    public String getDataFileID(String entityID) {
        String dataFileID = "";
        Vector triplesV = this.triples.getCollection();
        for (int i = 0; i < triplesV.size(); ++i) {
            Triple triple = (Triple)triplesV.elementAt(i);
            String relationship = triple.getRelationship();
            if (relationship.indexOf("isDataFileFor") == -1) continue;
            String dFileID = triple.getSubject();
            for (int j = 0; j < triplesV.size(); ++j) {
                Triple tripleA = (Triple)triplesV.elementAt(j);
                if (!tripleA.getSubject().equals(entityID) || !tripleA.getObject().equals(dFileID)) continue;
                try {
                    dataFileID = dFileID;
                    return dataFileID;
                }
                catch (Exception e) {
                    System.out.println("Error in DataPackage.getDataFile(): " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
        return dataFileID;
    }

    public File getFileFromId(String id) {
        File xmlFile = null;
        try {
            if (this.location.equals("local") || this.location.equals("localmetacat")) {
                FileSystemDataStore fsds = new FileSystemDataStore(this.morpho);
                xmlFile = fsds.openFile(id);
                return xmlFile;
            }
            MetacatDataStore mds = new MetacatDataStore(this.morpho);
            xmlFile = mds.openFile(id);
            return xmlFile;
        }
        catch (FileNotFoundException fnfe) {
            Log.debug(0, "Error reading file : " + xmlFile + " " + fnfe.getMessage() + "---File NOT found.");
        }
        catch (CacheAccessException cae) {
            Log.debug(0, "Error reading file : " + xmlFile + " " + cae.getMessage() + "---Cache could not be accessed");
        }
        return null;
    }

    private File[] listFiles(File dir) {
        String[] fileStrings = dir.list();
        int len = fileStrings.length;
        File[] list = new File[len];
        for (int i = 0; i < len; ++i) {
            list[i] = new File(dir, fileStrings[i]);
        }
        return list;
    }

    private File getFileType(String id, String typeString) {
        File subfile;
        String catalogPath = this.config.get("local_catalog_path", 0);
        String name = "unknown";
        try {
            subfile = this.fileSysDataStore.openFile(id.trim());
        }
        catch (FileNotFoundException fnfe) {
            try {
                subfile = this.metacatDataStore.openFile(id.trim());
            }
            catch (FileNotFoundException fnfe2) {
                Log.debug(0, "File " + id + " not found locally or " + "on metacat.");
                return null;
            }
            catch (CacheAccessException cae) {
                Log.debug(0, "The cache could not be accessed in DataPackage.getRelatedFiles.");
                return null;
            }
        }
        try {
            FileReader fr = new FileReader(subfile);
            String xmlString = "";
            for (int j = 0; j < 5; ++j) {
                xmlString = xmlString + (char)fr.read();
            }
            fr.close();
            if (xmlString.equals("<?xml")) {
                Document subDoc = PackageUtil.getDoc(subfile, catalogPath);
                DocumentType dt = subDoc.getDoctype();
                name = dt.getPublicId();
            } else {
                name = "Data File";
            }
        }
        catch (Exception ww) {
            // empty catch block
        }
        if (name.indexOf(typeString) > -1) {
            return subfile;
        }
        subfile = null;
        return subfile;
    }

    public void checkTriplesForAccess() {
        int choice;
        String accessId = null;
        try {
            accessId = this.getAccessId();
        }
        catch (Exception e) {
            // empty catch block
        }
        Vector ids = this.getAllIdentifiers();
        Vector<String> missingIds = new Vector<String>();
        String temp = "";
        if (accessId != null) {
            for (int i = 0; i < ids.size(); ++i) {
                String obj = (String)ids.elementAt(i);
                temp = temp + obj + "::";
                if (this.subjectAndObjectCheck(accessId, obj)) continue;
                missingIds.addElement(obj);
            }
        } else {
            Log.debug(11, "No access file in package!!!!");
        }
        if (missingIds.size() > 0 && (choice = JOptionPane.showConfirmDialog(null, "This package is missing some access\ncontrol information, possibly\nbecause it was created using an\nearlier version of Morpho.\nWould you like to update the\npackage with the missing\ninformation (recommended)?\n\n(Changes will appear the next\ntime the package is opened.)", "Access Information Missing ", 0, 2)) == 0) {
            this.fixMissingAccess(accessId, missingIds);
        }
    }

    private boolean subjectAndObjectCheck(String sub, String obj) {
        boolean res = false;
        TripleCollection tc = this.getTriples();
        Vector triples = tc.getCollection();
        for (int i = 0; i < triples.size(); ++i) {
            Triple tpl = (Triple)triples.elementAt(i);
            if (!sub.equals(tpl.getSubject()) || !obj.equals(tpl.getObject())) continue;
            res = true;
            return res;
        }
        return res;
    }

    private void fixMissingAccess(String accessId, Vector missingIds) {
        File newDPTempFile;
        TripleCollection newTriples = new TripleCollection();
        for (int i = 0; i < missingIds.size(); ++i) {
            Triple tr = new Triple(accessId, "provides access control rules for", (String)missingIds.elementAt(i));
            newTriples.addTriple(tr);
        }
        AccessionNumber a = new AccessionNumber(this.morpho);
        FileSystemDataStore fsds = new FileSystemDataStore(this.morpho);
        String docString = PackageUtil.addTriplesToTriplesFile(newTriples, this, this.morpho);
        String dataPackageId = a.incRev(this.getID());
        try {
            newDPTempFile = fsds.saveTempFile(dataPackageId, new StringReader(docString));
            docString = a.incRevInTriples(newDPTempFile, this.getID(), dataPackageId);
            newDPTempFile = fsds.saveTempFile(dataPackageId, new StringReader(docString));
        }
        catch (Exception e) {
            Log.debug(0, "Error saving file(5): " + e.getMessage());
            e.printStackTrace();
            return;
        }
        String location = this.getLocation();
        boolean locMetacat = false;
        boolean locLocal = false;
        if (location.equals("local") || location.equals("localmetacat")) {
            locLocal = true;
        }
        if (location.equals("metacat") || location.equals("localmetacat")) {
            locMetacat = true;
        }
        if (locLocal) {
            try {
                fsds.saveFile(dataPackageId, new FileReader(newDPTempFile));
            }
            catch (Exception e) {
                Log.debug(0, "Error saving file(3): " + e.getMessage());
                e.printStackTrace();
                return;
            }
        }
        if (locMetacat) {
            MetacatDataStore mds = new MetacatDataStore(this.morpho);
            try {
                mds.saveFile(dataPackageId, new FileReader(newDPTempFile));
            }
            catch (Exception e) {
                Log.debug(0, "Error saving file(2): " + e.getMessage());
                e.printStackTrace();
                return;
            }
        }
    }
}

