/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.framework.ModalDialog;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.DataPackageWizardInterface;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceNotHandledException;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class AddMethodCommand
implements Command {
    private final String DATAPACKAGE_METHOD_GENERIC_NAME = "methods";
    private final String METHOD_SUBTREE_NODENAME = "/methods/";
    private Node methodRoot;
    private AbstractDataPackage adp;
    private AbstractUIPage methodPage;

    public void execute(ActionEvent event) {
        this.adp = UIController.getInstance().getCurrentAbstractDataPackage();
        if (this.showMethodDialog()) {
            try {
                this.insertMethod();
                UIController.showNewPackage(this.adp);
            }
            catch (Exception w) {
                Log.debug(15, "Exception trying to modify method DOM: " + w);
                w.printStackTrace();
                Log.debug(5, "Unable to add method details!");
            }
        }
    }

    private boolean showMethodDialog() {
        DataPackageWizardInterface dpwPlugin = null;
        try {
            ServiceController sc = ServiceController.getInstance();
            dpwPlugin = (DataPackageWizardInterface)((Object)sc.getServiceProvider(DataPackageWizardInterface.class));
        }
        catch (ServiceNotHandledException se) {
            Log.debug(6, se.getMessage());
            se.printStackTrace();
        }
        if (dpwPlugin == null) {
            return false;
        }
        this.methodPage = dpwPlugin.getPage("METHODS");
        OrderedMap existingValuesMap = null;
        this.methodRoot = this.adp.getSubtree("methods", 0);
        if (this.methodRoot != null) {
            existingValuesMap = XMLUtilities.getDOMTreeAsXPathMap((Node)this.methodRoot);
        }
        Log.debug(45, "sending previous data to methodPage -\n\n" + existingValuesMap);
        boolean pageCanHandleAllData = this.methodPage.setPageData(existingValuesMap, "/methods/");
        ModalDialog dialog = null;
        if (!pageCanHandleAllData) {
            UIController.getInstance().launchEditorAtSubtreeForCurrentFrame("methods", 0);
            return false;
        }
        dialog = new ModalDialog(this.methodPage, UIController.getInstance().getCurrentActiveWindow(), 770, 570);
        return dialog.USER_RESPONSE == 10;
    }

    private void insertMethod() {
        OrderedMap map = this.methodPage.getPageData("/methods/");
        Log.debug(45, "\n insertMethod() Got method details from Methods page -\n" + map.toString());
        if (map == null || map.isEmpty()) {
            Log.debug(5, "Unable to get method details from input!");
            return;
        }
        DOMImplementation impl = DOMImplementationImpl.getDOMImplementation();
        Document doc = impl.createDocument("", "methods", null);
        this.methodRoot = doc.getDocumentElement();
        try {
            XMLUtilities.getXPathMapAsDOMTree((Map)map, (Node)this.methodRoot);
        }
        catch (TransformerException w) {
            Log.debug(5, "Unable to add method details to package!");
            Log.debug(15, "TransformerException (" + w + ") calling " + "XMLUtilities.getXPathMapAsDOMTree(map, methodRoot) with \n" + "map = " + map + " and methodRoot = " + this.methodRoot);
            return;
        }
        this.adp.deleteSubtree("methods", 0);
        Node check = this.adp.insertSubtree("methods", this.methodRoot, 0);
        if (check != null) {
            Log.debug(45, "added new method details to package...");
        } else {
            Log.debug(5, "** ERROR: Unable to add new method details to package **");
        }
    }
}

