/*
 * Decompiled with CFR 0.152.
 */
package com.toedter.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class JSpinField
extends JPanel
implements CaretListener,
AdjustmentListener,
ActionListener {
    protected JTextField textField;
    protected JScrollBar scrollBar;
    private Color darkGreen = new Color(0, 150, 0);
    private int min = 0;
    private int max = 100;
    private int value = 0;

    public JSpinField() {
        this.setLayout(new BorderLayout());
        this.textField = new JTextField(Integer.toString(this.value));
        this.textField.addCaretListener(this);
        this.textField.addActionListener(this);
        this.textField.setHorizontalAlignment(4);
        this.add((Component)this.textField, "Center");
        this.scrollBar = new JScrollBar(1, 0, 0, 0, 100);
        this.scrollBar.setPreferredSize(new Dimension(this.scrollBar.getPreferredSize().width, this.textField.getPreferredSize().height));
        this.scrollBar.setMinimum(this.min);
        this.scrollBar.setMaximum(this.max);
        this.scrollBar.setValue(this.max + this.min - this.value);
        this.scrollBar.setVisibleAmount(0);
        this.scrollBar.addAdjustmentListener(this);
        this.add((Component)this.scrollBar, "East");
    }

    protected void setValue(int newValue, boolean updateTextField, boolean updateScrollbar) {
        int oldValue = this.value;
        this.value = newValue < this.min ? this.min : (newValue > this.max ? this.max : newValue);
        if (updateTextField) {
            this.textField.setText(Integer.toString(this.value));
            this.textField.setForeground(Color.black);
        }
        if (updateScrollbar) {
            this.scrollBar.setValue(this.max + this.min - this.value);
        }
        this.firePropertyChange("value", oldValue, this.value);
    }

    public void setValue(int newValue) {
        this.setValue(newValue, true, true);
    }

    public int getValue() {
        return this.value;
    }

    public void setMinimum(int newMinimum) {
        this.min = newMinimum;
        this.scrollBar.setMinimum(this.min);
    }

    public int getMinimum() {
        return this.min;
    }

    public void setMaximum(int newMaximum) {
        this.max = newMaximum;
        this.scrollBar.setMaximum(this.max);
        this.textField.setPreferredSize(new Dimension(new JTextField((String)Integer.toString((int)newMaximum)).getPreferredSize().width, this.textField.getPreferredSize().height));
    }

    public void setHorizontalAlignment(int alignment) {
        this.textField.setHorizontalAlignment(alignment);
    }

    public int getMaximum() {
        return this.max;
    }

    public void setFont(Font font) {
        if (this.textField != null) {
            this.textField.setFont(font);
        }
    }

    public void setForeground(Color fg) {
        if (this.textField != null) {
            this.textField.setForeground(fg);
        }
    }

    public void caretUpdate(CaretEvent e) {
        block4: {
            try {
                int testValue = Integer.valueOf(this.textField.getText());
                if (testValue >= this.min && testValue <= this.max) {
                    this.textField.setForeground(this.darkGreen);
                    this.setValue(testValue, false, false);
                } else {
                    this.textField.setForeground(Color.red);
                }
            }
            catch (Exception ex) {
                if (!(ex instanceof NumberFormatException)) break block4;
                this.textField.setForeground(Color.red);
            }
        }
        this.textField.repaint();
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.setValue(this.max + this.min - e.getValue(), true, false);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.textField.getForeground().equals(this.darkGreen)) {
            this.setValue(Integer.valueOf(this.textField.getText()));
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.textField.setEnabled(enabled);
        this.scrollBar.setEnabled(enabled);
    }

    public static void main(String[] s) {
        JFrame frame = new JFrame("JSpinField");
        frame.getContentPane().add(new JSpinField());
        frame.pack();
        frame.setVisible(true);
    }
}

