/*
 * Decompiled with CFR 0.152.
 */
package com.toedter.calendar;

import com.toedter.calendar.JDayChooser;
import com.toedter.calendar.JYearChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public class JMonthChooser
extends JPanel
implements ItemListener,
AdjustmentListener {
    public static final int RIGHT_SPINNER = 0;
    public static final int LEFT_SPINNER = 1;
    public static final int NO_SPINNER = 2;
    private Locale locale;
    private int month;
    private int oldScrollBarValue = 0;
    private JDayChooser dayChooser = null;
    private JYearChooser yearChooser = null;
    private JComboBox comboBox;
    private JScrollBar scrollBar;
    private boolean initialized = false;
    private boolean localInitialize = false;

    public JMonthChooser() {
        this(0);
    }

    public JMonthChooser(int spinner) {
        this.setLayout(new BorderLayout());
        this.comboBox = new JComboBox();
        this.comboBox.addItemListener(this);
        this.dayChooser = null;
        this.locale = Locale.getDefault();
        this.initNames();
        this.add((Component)this.comboBox, "Center");
        if (spinner != 2) {
            this.scrollBar = new JScrollBar(1, 0, 0, -10000, 10000);
            this.scrollBar.setPreferredSize(new Dimension(this.scrollBar.getPreferredSize().width, this.getPreferredSize().height));
            this.scrollBar.setVisibleAmount(0);
            this.scrollBar.addAdjustmentListener(this);
            if (spinner == 0) {
                this.add((Component)this.scrollBar, "East");
            } else {
                this.add((Component)this.scrollBar, "West");
            }
        }
        this.initialized = true;
        this.setMonth(Calendar.getInstance().get(2));
    }

    public void initNames() {
        this.localInitialize = true;
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(this.locale);
        String[] monthNames = dateFormatSymbols.getMonths();
        if (this.comboBox.getItemCount() == 12) {
            this.comboBox.removeAllItems();
        }
        for (int i = 0; i < 12; ++i) {
            this.comboBox.addItem(monthNames[i]);
        }
        this.localInitialize = false;
        this.comboBox.setSelectedIndex(this.month);
    }

    public void itemStateChanged(ItemEvent iEvt) {
        int index = this.comboBox.getSelectedIndex();
        if (index >= 0) {
            this.setMonth(index, false);
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        boolean increase = true;
        int newScrollBarValue = e.getValue();
        if (newScrollBarValue > this.oldScrollBarValue) {
            increase = false;
        }
        this.oldScrollBarValue = newScrollBarValue;
        int month = this.getMonth();
        if (increase) {
            if (++month == 12) {
                month = 0;
                if (this.yearChooser != null) {
                    int year = this.yearChooser.getYear();
                    this.yearChooser.setYear(++year);
                }
            }
        } else if (--month == -1) {
            month = 11;
            if (this.yearChooser != null) {
                int year = this.yearChooser.getYear();
                this.yearChooser.setYear(--year);
            }
        }
        this.setMonth(month);
    }

    private void setMonth(int newMonth, boolean select) {
        if (!this.initialized || this.localInitialize) {
            return;
        }
        int oldMonth = this.month;
        this.month = newMonth;
        if (select) {
            this.comboBox.setSelectedIndex(this.month);
        }
        if (this.dayChooser != null) {
            this.dayChooser.setMonth(this.month);
        }
        this.firePropertyChange("month", oldMonth, this.month);
    }

    public void setMonth(int newMonth) {
        this.setMonth(newMonth, true);
    }

    public int getMonth() {
        return this.month;
    }

    public void setDayChooser(JDayChooser dayChooser) {
        this.dayChooser = dayChooser;
    }

    public void setYearChooser(JYearChooser yearChooser) {
        this.yearChooser = yearChooser;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale l) {
        if (!this.initialized) {
            super.setLocale(l);
        } else {
            this.locale = l;
            this.initNames();
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.comboBox.setEnabled(enabled);
        if (this.scrollBar != null) {
            this.scrollBar.setEnabled(enabled);
        }
    }

    public static void main(String[] s) {
        JFrame frame = new JFrame("MonthChooser");
        frame.getContentPane().add(new JMonthChooser());
        frame.pack();
        frame.setVisible(true);
    }
}

