/*
 * Decompiled with CFR 0.152.
 */
package com.toedter.calendar;

import com.incors.plaf.kunststoff.KunststoffLookAndFeel;
import com.incors.plaf.kunststoff.KunststoffTheme;
import com.toedter.calendar.JCalendar;
import com.toedter.components.JLocaleChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.metal.MetalTheme;

public class JCalendarDemo
extends JApplet
implements PropertyChangeListener {
    private JPanel calendarPanel;
    private JPanel demoPanel;
    private JCalendar jcalendar1;
    private JCalendar jcalendar2;
    private JCalendar jcalendar3;
    private JTextField dateField;
    private JLocaleChooser localeChooser;
    private Calendar calendar;
    private KunststoffLookAndFeel kunststoffLnF;

    public void init() {
        this.initializeLookAndFeel();
        this.getContentPane().setLayout(new BorderLayout());
        this.calendarPanel = new JPanel();
        this.calendarPanel.setLayout(new BorderLayout());
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BorderLayout());
        JLocaleChooser localeChooser = new JLocaleChooser();
        localeChooser.addPropertyChangeListener(this);
        controlPanel.add((Component)new JLabel(" Locale:   "), "West");
        controlPanel.add((Component)localeChooser, "Center");
        this.dateField = new JTextField();
        this.dateField.setEditable(false);
        controlPanel.add((Component)this.dateField, "South");
        JTabbedPane tabbedPane = new JTabbedPane();
        this.jcalendar1 = new JCalendar();
        this.jcalendar1.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.jcalendar1.addPropertyChangeListener(this);
        this.jcalendar2 = new JCalendar(1);
        this.jcalendar2.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.jcalendar2.addPropertyChangeListener(this);
        this.jcalendar3 = new JCalendar(2);
        this.jcalendar3.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.jcalendar3.addPropertyChangeListener(this);
        tabbedPane.addTab("Demo 1", null, this.jcalendar1, "Default JCalendar");
        tabbedPane.addTab("Demo 2", null, this.jcalendar2, "JCalendar with left month spinner");
        tabbedPane.addTab("Demo 3", null, this.jcalendar3, "JCalendar with no month spinner");
        tabbedPane.setSelectedIndex(0);
        Box disablePanel = new Box(0);
        disablePanel.add(Box.createHorizontalStrut(4));
        JLabel disableLabel = new JLabel("Disable Calendars");
        disablePanel.add(disableLabel);
        disablePanel.add(Box.createHorizontalStrut(7));
        final JCheckBox disableCheckBox = new JCheckBox();
        disableCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (disableCheckBox.isSelected()) {
                    JCalendarDemo.this.jcalendar1.setEnabled(false);
                    JCalendarDemo.this.jcalendar2.setEnabled(false);
                    JCalendarDemo.this.jcalendar3.setEnabled(false);
                } else {
                    JCalendarDemo.this.jcalendar1.setEnabled(true);
                    JCalendarDemo.this.jcalendar2.setEnabled(true);
                    JCalendarDemo.this.jcalendar3.setEnabled(true);
                }
            }
        });
        disablePanel.add(disableCheckBox);
        this.calendarPanel.add((Component)controlPanel, "North");
        this.calendarPanel.add((Component)tabbedPane, "Center");
        this.calendarPanel.add((Component)disablePanel, "South");
        this.getContentPane().add((Component)this.createMenuBar(), "North");
        this.getContentPane().add((Component)this.calendarPanel, "Center");
        this.calendar = Calendar.getInstance();
        this.jcalendar1.setCalendar(this.calendar);
    }

    public final void initializeLookAndFeel() {
        UIManager.put("ClassLoader", UIManager.class.getClassLoader());
        try {
            this.kunststoffLnF = new KunststoffLookAndFeel();
            KunststoffLookAndFeel.setCurrentTheme((MetalTheme)new KunststoffTheme());
            UIManager.setLookAndFeel((LookAndFeel)this.kunststoffLnF);
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            // empty catch block
        }
        UIManager.getLookAndFeelDefaults().put("ClassLoader", this.getClass().getClassLoader());
    }

    public JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        UIManager.LookAndFeelInfo[] lnfs = UIManager.getInstalledLookAndFeels();
        ButtonGroup lnfGroup = new ButtonGroup();
        JMenu lnfMenu = new JMenu("Look&Feel");
        lnfMenu.setMnemonic('L');
        menuBar.add(lnfMenu);
        for (int i = 0; i < lnfs.length; ++i) {
            if (lnfs[i].getName().equals("CDE/Motif")) continue;
            JRadioButtonMenuItem rbmi = new JRadioButtonMenuItem(lnfs[i].getName());
            lnfMenu.add(rbmi);
            rbmi.setSelected(UIManager.getLookAndFeel().getName().equals(lnfs[i].getName()));
            rbmi.putClientProperty("lnf name", lnfs[i]);
            rbmi.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent ie) {
                    JRadioButtonMenuItem rbmi2 = (JRadioButtonMenuItem)ie.getSource();
                    if (rbmi2.isSelected()) {
                        UIManager.LookAndFeelInfo info = (UIManager.LookAndFeelInfo)rbmi2.getClientProperty("lnf name");
                        try {
                            if (info.getClassName().equals("com.incors.plaf.kunststoff.KunststoffLookAndFeel")) {
                                UIManager.setLookAndFeel((LookAndFeel)JCalendarDemo.this.kunststoffLnF);
                            } else {
                                UIManager.setLookAndFeel(info.getClassName());
                            }
                            SwingUtilities.updateComponentTreeUI(JCalendarDemo.this);
                        }
                        catch (Exception e) {
                            System.err.println("Unable to set UI " + e.getMessage());
                        }
                    }
                }
            });
            lnfGroup.add(rbmi);
        }
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic('H');
        JMenuItem aboutItem = helpMenu.add(new AboutAction(this));
        aboutItem.setMnemonic('A');
        aboutItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        menuBar.add(helpMenu);
        return menuBar;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.calendarPanel != null) {
            if (evt.getPropertyName().equals("locale")) {
                this.jcalendar1.setLocale((Locale)evt.getNewValue());
                this.jcalendar2.setLocale((Locale)evt.getNewValue());
                this.jcalendar3.setLocale((Locale)evt.getNewValue());
                DateFormat df = DateFormat.getDateInstance(1, this.jcalendar1.getLocale());
                this.dateField.setText(df.format(this.calendar.getTime()));
            } else if (evt.getPropertyName().equals("calendar")) {
                this.calendar = (Calendar)evt.getNewValue();
                DateFormat df = DateFormat.getDateInstance(1, this.jcalendar1.getLocale());
                this.dateField.setText(df.format(this.calendar.getTime()));
                this.jcalendar1.setCalendar(this.calendar);
                this.jcalendar2.setCalendar(this.calendar);
                this.jcalendar3.setCalendar(this.calendar);
            }
        }
    }

    public static void main(String[] s) {
        WindowAdapter l = new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        };
        JFrame frame = new JFrame("JCalendar Demo");
        frame.addWindowListener(l);
        JCalendarDemo demo = new JCalendarDemo();
        demo.init();
        frame.getContentPane().add(demo);
        frame.pack();
        frame.setVisible(true);
    }

    class AboutAction
    extends AbstractAction {
        private JCalendarDemo demo;

        AboutAction(JCalendarDemo demo) {
            super("About...");
            this.demo = demo;
        }

        public void actionPerformed(ActionEvent event) {
            JOptionPane.showMessageDialog(this.demo, "JCalendar Demo\nVersion 1.1\n\nKai Toedter\nkai@toedter.com\nwww.toedter.com", "About...", 1);
        }
    }
}

