/**
 *  '$RCSfile: AddInstructorCommand.java,v $'
 *  Copyright: 2000 Regents of the University of California and the
 *              National Center for Ecological Analysis and Synthesis
 *    Authors: Saurabh Garg
 *    Release: @release@
 *
 *   '$Author: leinfelder $'
 *     '$Date: 2008/03/28 19:26:49 $'
 * '$Revision: 1.1 $'
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package edu.ucsb.nceas.morpho.first.edml.commands;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import javax.xml.transform.TransformerException;

import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.first.plugins.wizard.EdMLWizardInterface;
import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.framework.ModalDialog;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.DataPackageWizardInterface;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceNotHandledException;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.morpho.util.UISettings;
import edu.ucsb.nceas.utilities.OrderedMap;
import edu.ucsb.nceas.utilities.XMLUtilities;

/**
 * Class to handle add instructor command
 */
public class AddInstructorCommand
    implements Command {

  //generic name for lookup in edml listings
  private final String INSTRUCTOR_GENERIC_NAME = "instructor";

  public AddInstructorCommand() {}

  /**
   * execute add command
   *
   * @param event ActionEvent
   */
  public void execute(ActionEvent event) {

    adp = UIController.getInstance().getCurrentAbstractDataPackage();
    exsitingInstructorRoot =
        adp.getSubtrees(INSTRUCTOR_GENERIC_NAME);

    if (showInstructorDialog()) {

      try {
        insertInstructor();
        UIController.showNewPackage(adp);
      }
      catch (Exception w) {
        Log.debug(15, "Exception trying to modify instructor DOM: " + w);
        w.printStackTrace();
        Log.debug(5, "Unable to add instructor details!");
      }
    } else {
      //gets here if user has pressed "cancel" on dialog... ////////////////////

      //Restore project subtree to state it was in when we started...
      adp.deleteAllSubtrees(INSTRUCTOR_GENERIC_NAME);
      if (!exsitingInstructorRoot.isEmpty()) {
        Object nextXPathObj = null;

        int count = exsitingInstructorRoot.size();
        DOMImplementation impl = DOMImplementationImpl.getDOMImplementation();
        for (int i = count - 1; i > -1; i--) {
          instructorRoot = (Node) exsitingInstructorRoot.get(i);
          Node check = adp.insertSubtree(
        		  INSTRUCTOR_GENERIC_NAME,
              instructorRoot, 0);
          if (check != null) {
            Log.debug(45, "added new creator details to package...");
          } else {
            Log.debug(5,
                "** ERROR: Unable to add new creator details to package **");
          }

        }
      }
    }

  }

  private boolean showInstructorDialog() {

    ServiceController sc;
    DataPackageWizardInterface dpwPlugin = null;
    try {
      sc = ServiceController.getInstance();
      dpwPlugin = (DataPackageWizardInterface) sc.getServiceProvider(
    		  DataPackageWizardInterface.class);

    }
    catch (ServiceNotHandledException se) {

      Log.debug(6, se.getMessage());
      se.printStackTrace();
    }
    if (dpwPlugin == null) {
      return false;
    }

    instructorPage = dpwPlugin.getPage(EdMLWizardInterface.INSTRUCTOR_MAIN_PAGE);

    OrderedMap existingValuesMap = new OrderedMap();

    List instructorList = adp.getSubtrees(
    		INSTRUCTOR_GENERIC_NAME);

    if (!instructorList.isEmpty()) {
      Iterator listIt = instructorList.iterator();
      Object nextObj = null;
      Object nextTempObj = null;
      String nextTempString = null;
      int count = 1;

      while (listIt.hasNext()) {
        nextObj = listIt.next();
        OrderedMap tempMap = XMLUtilities.getDOMTreeAsXPathMap( (Node) nextObj);
        Iterator tempIt = tempMap.keySet().iterator();
        while (tempIt.hasNext()) {
          nextTempObj = tempIt.next();
          nextTempString = (String) nextTempObj;
          if (nextTempString != null) {
            existingValuesMap.put("/"
                + INSTRUCTOR_GENERIC_NAME + "["
                + count + "]" + nextTempString.substring(
                		INSTRUCTOR_GENERIC_NAME.length() + 1,
                nextTempString.length()),
                tempMap.get(nextTempObj));
          }
        }
        count++;
      }
    }

    Log.debug(45, "sending previous data to instructorPage -\n\n"
        + existingValuesMap);

    boolean pageCanHandleAllData
        = instructorPage.setPageData(existingValuesMap, "/" + INSTRUCTOR_GENERIC_NAME);

    ModalDialog dialog = null;
    if (pageCanHandleAllData) {

      dialog = new ModalDialog(instructorPage,
          UIController.getInstance().
          getCurrentActiveWindow(),
          UISettings.POPUPDIALOG_WIDTH,
          UISettings.POPUPDIALOG_HEIGHT);
    } else {

      UIController.getInstance().launchEditorAtSubtreeForCurrentFrame(
    		  INSTRUCTOR_GENERIC_NAME, 0);
      return false;
    }

    return (dialog.USER_RESPONSE == ModalDialog.OK_OPTION);
  }

  private void insertInstructor() {

    OrderedMap map = instructorPage.getPageData("/" + INSTRUCTOR_GENERIC_NAME + "[");
    Log.debug(45,
        "\n insertInstructor() Got instructor details from "
        + "instructor page -\n" + map.toString());

    if (map == null) {
      Log.debug(5, "Unable to get instructor details from input!");
      return;
    } else if (map.isEmpty()) {
      Log.debug(45, "Deleting all instructor details!");
    }

    DOMImplementation impl = DOMImplementationImpl.getDOMImplementation();
    //delete old title from datapackage
    adp.deleteAllSubtrees(INSTRUCTOR_GENERIC_NAME);

    Iterator instructorIt = map.keySet().iterator();
    Object nextXPathObj = null;
    String nextXPath = null;
    HashMap instructorSetMap = new HashMap();

    while (instructorIt.hasNext()) {
      nextXPathObj = instructorIt.next();
      if (nextXPathObj == null) {
        continue;
      }
      nextXPath = (String) nextXPathObj;

      String temp = nextXPath.substring(
    		  INSTRUCTOR_GENERIC_NAME.length()
          + 2, nextXPath.length());
      temp = temp.substring(0, temp.indexOf("]"));
      nextXPath = nextXPath.replaceFirst(temp, "1");

      if (instructorSetMap.containsKey(temp)) {
        OrderedMap instructorMap = (OrderedMap) instructorSetMap.get(
            temp);
        instructorMap.put(nextXPath, map.get(nextXPathObj));
      } else {
        OrderedMap instructorMap = new OrderedMap();
        instructorMap.put(nextXPath, map.get(nextXPathObj));
        instructorSetMap.put(temp, instructorMap);
      }
    }

    Iterator instructorSetIt = instructorSetMap.keySet().iterator();
    while (instructorSetIt.hasNext()) {
      nextXPathObj = instructorSetIt.next();
      OrderedMap instructorMap = (OrderedMap) instructorSetMap.get(
          nextXPathObj);
      Document doc = impl.createDocument("", INSTRUCTOR_GENERIC_NAME, null);
      instructorRoot = doc.getDocumentElement();

      try {
        XMLUtilities.getXPathMapAsDOMTree(instructorMap,
            instructorRoot);
      }
      catch (TransformerException w) {
        Log.debug(5, "Unable to add instructor details to package!");
        Log.debug(15, "TransformerException (" + w + ") calling "
            +
            "XMLUtilities.getXPathMapAsDOMTree(map, instructorRoot) with \n"
            + "map = " + map
            + " and instructor = " + instructorRoot);
        return;
      }

      // add to the datapackage
      Node check = adp.insertSubtree(INSTRUCTOR_GENERIC_NAME,
          instructorRoot,
          0);
      if (check != null) {
        Log.debug(45, "added new instructor details to package...");
      } else {
        Log.debug(5,
            "** ERROR: Unable to add new instructor details to package **");
      }
    }
  }

  private List exsitingInstructorRoot;
  private Node instructorRoot;
  private AbstractDataPackage adp;
  private AbstractUIPage instructorPage;
}
