/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.ui;

import com.pt.io.Cache;
import com.pt.io.InputUni;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import multivalent.Behavior;
import multivalent.Browser;
import multivalent.DocInfo;
import multivalent.Document;
import multivalent.ESISNode;
import multivalent.INode;
import multivalent.Layer;
import multivalent.SemanticEvent;
import phelps.net.RobustHyperlink;
import phelps.net.URIs;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bookmark
extends Behavior {
    public static final String MSG_ADD = "bookmarkAdd";
    public static final String MSG_DELETE = "bookmarkDelete";
    private static final String FILENAME = "Bookmarks.txt";
    static List<Entry> bookmarks_ = null;

    int find(URI uRI) {
        return this.find(uRI.toString());
    }

    int find(String string) {
        int n = 0;
        for (Entry entry : bookmarks_) {
            String string2 = RobustHyperlink.stripSignature(entry.uri);
            if (string2.equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private void read() throws IOException {
        String string;
        InputUni inputUni = this.getGlobal().getCache().getInputUni(null, FILENAME, "personal");
        BufferedReader bufferedReader = null;
        if (inputUni != null) {
            try {
                bufferedReader = new BufferedReader(inputUni.getReader());
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if (bufferedReader == null) {
            bufferedReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/sys/Bookmarks.txt")));
        }
        while ((string = bufferedReader.readLine()) != null) {
            if (string.startsWith("#")) continue;
            bookmarks_.add(new Entry(string));
        }
        bufferedReader.close();
    }

    private void write() throws IOException {
        Cache cache = this.getGlobal().getCache();
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(cache.getOutputStream(null, FILENAME, "personal")));
        int n = bookmarks_.size();
        for (int i = 0; i < n; ++i) {
            Entry entry = bookmarks_.get(i);
            bufferedWriter.write(entry.toString());
            bufferedWriter.newLine();
        }
        bufferedWriter.close();
    }

    @Override
    public boolean semanticEventBefore(SemanticEvent semanticEvent, String string) {
        if (super.semanticEventBefore(semanticEvent, string)) {
            return true;
        }
        if ("createWidget/Bookmark" == string) {
            INode iNode = (INode)semanticEvent.getOut();
            int n = this.find(this.getBrowser().getCurDocument().getURI());
            this.createUI("button", new StringBuffer().append(n == -1 ? "Add" : "Delete").append(" Current Page").toString(), new StringBuffer().append("event ").append(n == -1 ? MSG_ADD : MSG_DELETE).toString(), iNode, null, false);
            if (bookmarks_.size() > 0) {
                this.createUI("separator", "_PAGES", null, iNode, "Go", false);
                for (Entry entry : bookmarks_) {
                    this.createUI("button", entry.title, new StringBuffer().append("event openDocument ").append(entry.uri).toString(), iNode, null, false);
                }
            }
        }
        return false;
    }

    @Override
    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        Object object = semanticEvent.getArg();
        if ("openedDocument" == string && object instanceof DocInfo) {
            int n = this.find(((DocInfo)object).uri);
            if (n != -1) {
                Bookmark.bookmarks_.get((int)n).read = System.currentTimeMillis();
            }
            return false;
        }
        if (MSG_ADD == string || MSG_DELETE == string) {
            boolean bl = MSG_ADD == string;
            Browser browser = this.getBrowser();
            Document document = browser.getCurDocument();
            String string2 = document.getURI().toString();
            int n = this.find(string2);
            boolean bl2 = true;
            if (bl && n == -1) {
                bookmarks_.add(new Entry(string2, document.getAttr("title")));
            } else if (!bl && n != -1) {
                bookmarks_.remove(n);
            } else {
                bl2 = false;
            }
            if (bl2) {
                try {
                    this.write();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return super.semanticEventAfter(semanticEvent, string);
    }

    @Override
    public void restore(ESISNode eSISNode, Map<String, Object> map, Layer layer) {
        super.restore(eSISNode, map, layer);
        if (bookmarks_ == null) {
            bookmarks_ = new ArrayList<Entry>(100);
            try {
                this.read();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static class Entry {
        String uri = "";
        String title = "";
        long create;
        long read;
        long modified;

        Entry(String string, String string2) {
            long l;
            this.uri = string;
            this.title = string2;
            this.read = this.modified = (l = System.currentTimeMillis());
            this.create = this.modified;
        }

        Entry(String string, String string2, int n, int n2, int n3) {
            this.uri = string;
            this.title = string2;
            this.create = n;
            this.read = n2;
            this.modified = n3;
        }

        Entry(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.hasMoreTokens()) {
                this.uri = stringTokenizer.nextToken();
            }
            if (stringTokenizer.hasMoreTokens()) {
                this.title = URIs.decode(stringTokenizer.nextToken());
            }
            if (stringTokenizer.hasMoreTokens()) {
                try {
                    this.create = Long.parseLong(stringTokenizer.nextToken());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (stringTokenizer.hasMoreTokens()) {
                try {
                    this.read = Long.parseLong(stringTokenizer.nextToken());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (stringTokenizer.hasMoreTokens()) {
                try {
                    this.modified = Long.parseLong(stringTokenizer.nextToken());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        public String toString() {
            return this.uri.toString() + "   " + URIs.encode(this.title) + "   " + Long.toString(this.create) + "   " + Long.toString(this.read) + "\t" + Long.toString(this.modified);
        }
    }
}

