/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.adaptor.pdf;

import com.pt.io.InputStreamASCII85;
import com.pt.io.InputStreamLZW;
import com.pt.io.RandomAccess;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.zip.InflaterInputStream;
import multivalent.Meta;
import multivalent.std.adaptor.pdf.COS;
import multivalent.std.adaptor.pdf.CryptFilter;
import multivalent.std.adaptor.pdf.DecodeASCIIHex;
import multivalent.std.adaptor.pdf.DecodePredictor;
import multivalent.std.adaptor.pdf.DecodeRunLength;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.Encrypt;
import multivalent.std.adaptor.pdf.IRef;
import multivalent.std.adaptor.pdf.PDFReader;
import org.apache.tools.bzip2.CBZip2InputStream;
import phelps.io.InputStreams;
import phelps.lang.Objects;
import phelps.util.Arrayss;

public class InputStreamComposite
extends InputStream {
    static final boolean DEBUG = false;
    private static final String[] FILTER_SELFDELIMITING;
    private static final int INVALID_CHAR = -2;
    private PDFReader pdfr_;
    private Object[] sub_;
    private int subi_ = -1;
    private InputStream in_ = InputStreams.DEVNULL;
    private int pushch_ = -2;
    private boolean isContent_;
    private boolean didBogusSpace_ = true;
    static final /* synthetic */ boolean $assertionsDisabled;

    public InputStreamComposite(Object object, boolean bl, PDFReader pDFReader) throws IOException {
        Object object2;
        Object object3;
        Class<?> clazz = object.getClass();
        if (!$assertionsDisabled && (object == null || COS.CLASS_ARRAY != clazz && COS.CLASS_IREF != clazz && COS.CLASS_DATA != clazz && COS.CLASS_DICTIONARY != clazz)) {
            throw new AssertionError((Object)("unknown stream type: " + (object != null ? clazz.getName() : null)));
        }
        if (!$assertionsDisabled && pDFReader == null) {
            throw new AssertionError();
        }
        this.isContent_ = bl;
        this.pdfr_ = pDFReader;
        if (COS.CLASS_ARRAY == clazz) {
            object3 = object;
        } else if (COS.CLASS_IREF == clazz) {
            object2 = this.pdfr_.getObject(object);
            if (COS.CLASS_ARRAY == object2.getClass()) {
                object3 = object2;
            } else {
                Object[] objectArray;
                Object object4;
                if (!$assertionsDisabled && COS.CLASS_DICTIONARY != object2.getClass()) {
                    throw new AssertionError();
                }
                Dict dict = (Dict)object2;
                Object object5 = object4 = "ObjStm".equals(pDFReader.getObject(dict.get("Type"))) ? dict.get("Extends") : null;
                if (object4 == null) {
                    objectArray = object;
                } else {
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = object;
                    objectArray = objectArray2;
                    objectArray2[1] = object4;
                }
                object3 = objectArray;
                object3 = object;
            }
        } else if (COS.CLASS_DATA == clazz) {
            object2 = new Dict(5);
            ((Dict)object2).put("DATA", object);
            object3 = object2;
        } else {
            Object[] objectArray;
            Object object6;
            if (!$assertionsDisabled && COS.CLASS_DICTIONARY != clazz) {
                throw new AssertionError(clazz);
            }
            object2 = (Dict)object;
            Object object7 = object6 = "ObjStm".equals(pDFReader.getObject(((Dict)object2).get("Type"))) ? ((Dict)object2).get("Extends") : null;
            if (object6 == null) {
                objectArray = object;
            } else {
                Object[] objectArray3 = new Object[2];
                objectArray3[0] = object;
                objectArray = objectArray3;
                objectArray3[1] = object6;
            }
            object3 = objectArray;
        }
        this.sub_ = COS.CLASS_ARRAY == object3.getClass() ? (((Object[])(object2 = (Object[])object3)).length > 0 ? (Object[])object2.clone() : object2) : new Object[]{object3};
        this.nextStream();
    }

    public int peek() throws IOException {
        if (-2 == this.pushch_) {
            this.pushch_ = this.read();
        }
        return this.pushch_;
    }

    public void unread(int n) {
        if (!$assertionsDisabled && this.pushch_ != -2) {
            throw new AssertionError((Object)"already have a pushback");
        }
        if (!($assertionsDisabled || n >= -1 && n <= 255)) {
            throw new AssertionError((Object)("pushed back " + n + " not -1 (EOF) or in 0..255"));
        }
        this.pushch_ = n;
    }

    public int read() throws IOException {
        int n;
        if (this.pushch_ != -2) {
            n = this.pushch_;
            this.pushch_ = -2;
        } else {
            n = this.in_.read();
            if (n == -1) {
                if (this.isContent_ && !this.didBogusSpace_) {
                    n = 32;
                    this.didBogusSpace_ = true;
                } else if (this.subi_ + 1 < this.sub_.length) {
                    this.nextStream();
                    n = this.read();
                }
            }
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (!($assertionsDisabled || byArray != null && n >= 0 && n2 >= 0 && n2 + n <= byArray.length)) {
            throw new AssertionError((Object)("b=" + byArray + ", off=" + n + ", len+off=" + (n2 + n) + " vs " + byArray.length));
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.pushch_ != -2) {
            byArray[n] = (byte)this.pushch_;
            this.pushch_ = -2;
            return 1;
        }
        int n3 = this.in_.read(byArray, n, n2);
        if (n3 == -1) {
            if (this.isContent_ && !this.didBogusSpace_) {
                byArray[n] = 32;
                this.didBogusSpace_ = true;
                return 1;
            }
            if (this.subi_ + 1 < this.sub_.length) {
                this.nextStream();
                return this.read(byArray, n, n2);
            }
        }
        return n3;
    }

    private void nextStream() throws IOException {
        InputStream inputStream;
        if (this.subi_ + 1 >= this.sub_.length) {
            return;
        }
        if (this.subi_ >= 0) {
            this.in_.close();
            this.sub_[this.subi_] = null;
        }
        Object object = this.sub_[++this.subi_];
        boolean bl = false;
        this.didBogusSpace_ = false;
        Dict dict = (Dict)this.pdfr_.getObject(object);
        boolean bl2 = dict.get("F") != null;
        Object object2 = dict.get("DATA");
        if (object2 == null) {
            inputStream = null;
        } else if (COS.CLASS_DATA == object2.getClass()) {
            byte[] byArray = (byte[])object2;
            inputStream = byArray.length > 0 ? new ByteArrayInputStream(byArray) : null;
        } else if (bl2) {
            Meta.sampledata("external file");
            InputStream inputStream2 = this.pdfr_.getFileInputStream(dict.get("F"));
            inputStream = inputStream2 instanceof BufferedInputStream ? inputStream2 : new BufferedInputStream(inputStream2, 8192);
        } else {
            Object[] objectArray;
            if (!$assertionsDisabled && !(object2 instanceof Number)) {
                throw new AssertionError(object2);
            }
            RandomAccess randomAccess = this.pdfr_.getRA();
            long l = ((Number)object2).longValue();
            int n = this.pdfr_.getObjInt(dict.get("Length"));
            Object[] objectArray2 = this.pdfr_.getObject(dict.get("Filter"));
            if (objectArray2 != null && n > 0) {
                if (COS.CLASS_ARRAY != objectArray2.getClass()) {
                    objectArray2 = new Object[]{objectArray2};
                }
                objectArray = objectArray2;
                int n2 = objectArray.length;
                for (int i = 0; i < n2; ++i) {
                    byte by = objectArray[i];
                    if (Arrayss.indexOf(FILTER_SELFDELIMITING, (Object)by) < 0) continue;
                    ++n;
                    break;
                }
            }
            if (randomAccess == null) {
                inputStream = null;
            } else if (n == 0) {
                inputStream = null;
            } else {
                objectArray = new byte[n];
                randomAccess.seek(l);
                randomAccess.readFully((byte[])objectArray);
                inputStream = new ByteArrayInputStream((byte[])objectArray);
            }
            bl = true;
        }
        this.in_ = inputStream != null ? this.wrapStream(inputStream, object, bl) : InputStreams.DEVNULL;
    }

    private InputStream wrapStream(InputStream inputStream, Object object, boolean bl) throws IOException {
        Dict dict = (Dict)this.pdfr_.getObject(object);
        boolean bl2 = dict.get("F") != null;
        Object object2 = this.pdfr_.getObject(dict.get(bl2 ? "FFilter" : "Filter"));
        Object object3 = this.pdfr_.getObject(dict.get(bl2 ? "FDecodeParms" : "DecodeParms"));
        if (object3 == null) {
            object3 = this.pdfr_.getObject(dict.get("DP"));
        }
        Object[] objectArray = object2 == null ? Objects.ARRAY0 : (object2.getClass() == COS.CLASS_NAME ? new Object[]{object2} : (Object[])object2);
        Object[] objectArray2 = new Object[objectArray.length];
        if (object3 != null && objectArray2.length != 0) {
            if (object3.getClass() == COS.CLASS_DICTIONARY) {
                objectArray2[0] = (Dict)object3;
            } else {
                objectArray2 = (Object[])object3;
            }
        }
        Encrypt encrypt = this.pdfr_.getEncrypt();
        int n = -1;
        int n2 = -1;
        if (COS.CLASS_IREF == object.getClass()) {
            IRef iRef = (IRef)object;
            n = iRef.id;
            n2 = this.pdfr_.getObjGen(iRef.id);
        }
        if (bl && encrypt != null && encrypt.getStmF() != CryptFilter.IDENTITY && !bl2 && COS.CLASS_IREF == object.getClass() && Arrays.asList(objectArray).indexOf("Crypt") == -1) {
            if (!($assertionsDisabled || n != -1 && n2 != -1)) {
                throw new AssertionError();
            }
            inputStream = new CryptFilter(encrypt.getStmF(), inputStream, n, n2);
        }
        int n3 = objectArray.length;
        for (int i = 0; i < n3; ++i) {
            int n4;
            String string = (String)this.pdfr_.getObject(objectArray[i]);
            object2 = this.pdfr_.getObject(objectArray2[i]);
            if (COS.OBJECT_NULL == object2) {
                object2 = null;
            }
            Dict dict2 = (Dict)object2;
            boolean bl3 = false;
            if (COS.OBJECT_NULL != string && !"None".equals(string)) {
                if ("FlateDecode".equals(string) || "Fl".equals(string)) {
                    inputStream = new InflaterInputStream(inputStream);
                    if (i + 1 < n3) {
                        try {
                            inputStream = new ByteArrayInputStream(InputStreams.toByteArray(inputStream));
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    bl3 = true;
                } else if ("LZWDecode".equals(string) || "LZW".equals(string)) {
                    int n5 = 1;
                    if (dict2 != null && (object2 = dict2.get("EarlyChange")) != null) {
                        n5 = this.pdfr_.getObjInt(object2);
                        if (!$assertionsDisabled && n5 != 0 && n5 != 1) {
                            throw new AssertionError(n5);
                        }
                    }
                    inputStream = new InputStreamLZW(inputStream, n5 == 1);
                    bl3 = true;
                } else if ("BZip2Decode".equals(string)) {
                    inputStream = new CBZip2InputStream(inputStream);
                    bl3 = true;
                } else if ("ASCIIHexDecode".equals(string) || "AHx".equals(string)) {
                    inputStream = new DecodeASCIIHex(inputStream);
                } else if ("ASCII85Decode".equals(string) || "A85".equals(string)) {
                    inputStream = new InputStreamASCII85(inputStream);
                } else if ("RunLengthDecode".equals(string) || "RL".equals(string)) {
                    inputStream = new DecodeRunLength(inputStream);
                } else if ("Crypt".equals(string)) {
                    if (!$assertionsDisabled && !"CryptFilterDecodeParms".equals(dict2.get("Type"))) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && (bl2 || n == -1 || n2 == -1)) {
                        throw new AssertionError();
                    }
                    CryptFilter cryptFilter = encrypt.getCryptFilter((String)dict2.get("Name"));
                    if (bl && cryptFilter != CryptFilter.IDENTITY) {
                        inputStream = new CryptFilter(cryptFilter, inputStream, n, n2);
                    }
                } else {
                    if (!($assertionsDisabled || "CCITTFaxDecode".equals(string) || "CCF".equals(string) || "DCTDecode".equals(string) || "DCT".equals(string) || "JPXDecode".equals(string) || "JBIG2Decode".equals(string))) {
                        throw new AssertionError((Object)string);
                    }
                    if (!$assertionsDisabled && i + 1 != n3) {
                        throw new AssertionError((Object)(i + " < " + (n3 - 1)));
                    }
                }
            }
            if (!bl3 || dict2 == null || (object2 = dict2.get("Predictor")) == null || (n4 = this.pdfr_.getObjInt(object2)) == 1 || n4 == 10) continue;
            inputStream = new DecodePredictor(inputStream, n4, dict2, this.pdfr_);
        }
        return inputStream;
    }

    public boolean markSupported() {
        return this.in_.markSupported();
    }

    public synchronized void reset() throws IOException {
        this.in_.reset();
        this.pushch_ = -2;
    }

    public synchronized void mark(int n) {
        this.in_.mark(n);
    }

    public void close() throws IOException {
        if (this.in_ != null) {
            this.in_.close();
            this.in_ = null;
            this.sub_ = null;
            this.pdfr_ = null;
        }
    }

    public int available() throws IOException {
        return this.in_.available();
    }

    public long skip(long l) throws IOException {
        return this.in_.skip(l);
    }

    static {
        $assertionsDisabled = !InputStreamComposite.class.desiredAssertionStatus();
        FILTER_SELFDELIMITING = new String[]{"FlateDecode", "Fl", "LZWDecode", "LZW", "ASCIIHexDecode", "AHx", "ASCII85Decode", "A85", "RunlengthDecode", "RL"};
    }
}

