/*
 * Decompiled with CFR 0.152.
 */
import [Ljava.lang.String;;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import phelps.lang.Classes;

public class Multivalent {
    public static final String USAGE = "java [-Xmx128m] -jar Multivalent.jar [<options>] <URI-or-File...>\n\t[-version] [-help]";

    private ClassLoader getJARsClassLoader() {
        return new URLClassLoader(this.findJARs(), this.getClass().getClassLoader());
    }

    private URL[] findJARs() {
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                String string2 = string.toLowerCase();
                return string2.endsWith(".jar") && !string2.startsWith("multivalent") && new File(file, string).canRead();
            }
        };
        File file = Classes.getRootDir(this.getClass());
        ArrayList<URL> arrayList = new ArrayList<URL>(20);
        if (file != null) {
            try {
                File[] fileArray = file.listFiles(filenameFilter);
                int n = fileArray.length;
                for (int i = 0; i < n; ++i) {
                    arrayList.add(fileArray[i].toURL());
                }
            }
            catch (MalformedURLException malformedURLException) {
                System.exit(1);
            }
        }
        return arrayList.toArray(new URL[0]);
    }

    private int commandLine(String[] stringArray) {
        String string;
        int n;
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).startsWith("-"); ++n) {
            if ((string = string.toLowerCase()).startsWith("--")) {
                string = string.substring(1);
            }
            if (string.startsWith("-cache")) continue;
            if (string.startsWith("-v")) {
                System.out.println("Multivalent Browser v" + multivalent.Multivalent.VERSION);
                System.out.println("Home site: " + multivalent.Multivalent.HOME_SITE);
                System.exit(0);
                continue;
            }
            if (string.startsWith("-h")) {
                System.out.println(USAGE);
                System.exit(0);
                continue;
            }
            System.err.println("Unknown option: " + string);
            System.err.println(USAGE);
            System.exit(1);
        }
        return n;
    }

    public static void main(String[] stringArray) {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        Multivalent multivalent = new Multivalent();
        int n = multivalent.commandLine(stringArray);
        try {
            Class<?> clazz = multivalent.getJARsClassLoader().loadClass("multivalent.Multivalent");
            Method method = clazz.getMethod("main", String;.class);
            method.invoke(null, new Object[]{new String[0]});
        }
        catch (Exception exception) {
            System.err.println("Can't launch: " + exception);
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

