/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.query;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.query.Query;
import edu.ucsb.nceas.morpho.query.QueryDialog;
import edu.ucsb.nceas.morpho.query.ResultPanel;
import edu.ucsb.nceas.morpho.query.ResultSet;
import edu.ucsb.nceas.morpho.query.SearchCommand;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.morpho.util.SortableJTable;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;

public class ReviseSearchCommand
implements Command {
    private MorphoFrame morphoFrame = null;
    private Morpho morpho = null;

    public ReviseSearchCommand(Morpho morpho) {
        this.morpho = morpho;
    }

    public void execute(ActionEvent event) {
        this.morphoFrame = UIController.getInstance().getCurrentActiveWindow();
        if (this.morphoFrame == null) {
            Log.debug(5, "Morpho frame was null so I could refresh it!");
        }
        Component comp = this.morphoFrame.getContentComponent();
        Object myQuery = null;
        if (comp != null && comp instanceof ResultPanel) {
            ResultPanel resultPane = (ResultPanel)comp;
            ResultSet results = resultPane.getResultSet();
            String oldIdentifier = results.getQuery().getQueryTitle();
            SortableJTable table = resultPane.getJTable();
            boolean sorted = false;
            int index = -1;
            String order = null;
            if (table != null) {
                sorted = table.getSorted();
                index = table.getIndexOfSortedColumn();
                order = table.getOrderOfSortedColumn();
            }
            QueryDialog queryDialog1 = null;
            queryDialog1 = new QueryDialog((Frame)this.morphoFrame, this.morpho);
            queryDialog1.setQuery(results.getQuery());
            queryDialog1.setModal(true);
            queryDialog1.show();
            if (queryDialog1.isSearchStarted()) {
                Query query = queryDialog1.getQuery();
                String currentIdentifier = query.getQueryTitle();
                if (currentIdentifier != null && !currentIdentifier.equals("") && !currentIdentifier.equals(oldIdentifier)) {
                    UIController.getInstance().updateWindow(this.morphoFrame, currentIdentifier);
                }
                this.morphoFrame.setMessage("");
                SearchCommand.doQuery(this.morphoFrame, query, sorted, index, order, false);
            }
        }
    }
}

