/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.query;

import edu.ucsb.nceas.morpho.util.Log;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.StringTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import tmap_30.convert.Convert;
import tmap_30.convert.ConvertLatitude;
import tmap_30.convert.ConvertLongitude;
import tmap_30.map.MapCanvas;
import tmap_30.map.MapConstants;
import tmap_30.map.MapGrid;
import tmap_30.map.MapRegion;
import tmap_30.map.MapTool;
import tmap_30.map.MaxZoomException;
import tmap_30.map.MinZoomException;
import tmap_30.map.PTTool;
import tmap_30.map.PTcXTool;
import tmap_30.map.PTcXYTool;
import tmap_30.map.PTcYTool;
import tmap_30.map.XTool;
import tmap_30.map.XYTool;
import tmap_30.map.XcYTool;
import tmap_30.map.YTool;
import tmap_30.map.YcXTool;

public class LiveMapPanel
extends JPanel
implements MapConstants {
    boolean toolFlag = false;
    static final int IMAGE_SIZE_X = 450;
    static final int IMAGE_SIZE_Y = 225;
    static final Color MAPTOOL_COLOR1 = Color.white;
    static final int TOOL_TYPE_PT = 0;
    static final int TOOL_TYPE_X = 1;
    static final int TOOL_TYPE_Y = 2;
    static final int TOOL_TYPE_XY = 3;
    double n = 45.0;
    double w = -90.0;
    double s = -45.0;
    double e = 90.0;
    MediaTracker tracker;
    static MapCanvas map;
    MapGrid grid;
    MapTool[] toolArray = new MapTool[1];
    MapRegion[] regionArray = new MapRegion[0];
    Convert XConvert;
    Convert YConvert;
    Convert XText;
    Convert YText;
    JTextField North;
    JTextField West;
    JTextField East;
    JTextField South;
    JButton zoom_in;
    JButton zoom_out;
    JRadioButton boxTool;
    JRadioButton ptTool;
    static Image img_0;
    int imgSizeX = 450;
    int imgSizeY = 225;
    int tool_type = 3;
    boolean need_to_center = false;

    public LiveMapPanel() {
        this.init();
    }

    public LiveMapPanel(boolean flag) {
        this.toolFlag = flag;
        this.init();
        if (this.toolFlag) {
            map.getTool().setDelta_X(0.125);
            map.getTool().setDelta_Y(0.125);
            map.selectTool(map.getSelected());
        }
    }

    public void init() {
        StringTokenizer st;
        String img = "java_0_world_234k.jpg";
        String img_x_domain = "-180 180";
        String img_y_domain = "-90 90";
        String toolType = "XY";
        String tool_x_range = "-180 180";
        String tool_y_range = "-90 90";
        if (img_0 == null) {
            img_0 = this.getToolkit().getImage(this.getClass().getResource("java_0_world_234k.jpg"));
            this.tracker = new MediaTracker(this);
            this.tracker.addImage(img_0, 1);
            try {
                this.tracker.waitForID(1);
            }
            catch (InterruptedException e) {
                System.out.println("Caught InterruptedException while loading image.");
                return;
            }
            if (this.tracker.isErrorID(1)) {
                System.out.println("Error loading image...");
                return;
            }
        }
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel entryPanel = new JPanel();
        entryPanel.setLayout(gridbag);
        JPanel posPanel = new JPanel();
        posPanel.setLayout(gridbag);
        Font textFont = new Font("Sans-Serif", 0, 10);
        this.North = new JTextField("90 N", 8);
        this.West = new JTextField("180 W", 8);
        this.East = new JTextField("180 E", 8);
        this.South = new JTextField("90 S", 8);
        this.North.setFont(textFont);
        this.South.setFont(textFont);
        this.East.setFont(textFont);
        this.West.setFont(textFont);
        tfAction tfaction = new tfAction();
        this.North.addActionListener(tfaction);
        this.South.addActionListener(tfaction);
        this.East.addActionListener(tfaction);
        this.West.addActionListener(tfaction);
        tfFocus tffocus = new tfFocus();
        this.North.addFocusListener(tffocus);
        this.South.addFocusListener(tffocus);
        this.East.addFocusListener(tffocus);
        this.West.addFocusListener(tffocus);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.anchor = 10;
        c.insets.left = 4;
        c.insets.right = 4;
        gridbag.setConstraints(this.North, c);
        posPanel.add(this.North);
        c.gridx = 0;
        c.gridy = 1;
        gridbag.setConstraints(this.West, c);
        posPanel.add(this.West);
        c.gridx = 2;
        c.gridy = 1;
        gridbag.setConstraints(this.East, c);
        posPanel.add(this.East);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 0;
        gridbag.setConstraints(this.South, c);
        posPanel.add(this.South);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets.top = 4;
        c.insets.bottom = 4;
        gridbag.setConstraints(posPanel, c);
        entryPanel.add(posPanel);
        this.zoom_in = new JButton("Zoom In");
        this.zoom_out = new JButton("Zoom Out");
        this.boxTool = new JRadioButton("Box Tool", true);
        this.ptTool = new JRadioButton("Point Tool", false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.boxTool);
        group.add(this.ptTool);
        Font buttonFont = new Font("Sans-Serif", 0, 10);
        this.zoom_in.setFont(buttonFont);
        this.zoom_out.setFont(buttonFont);
        this.boxTool.setFont(buttonFont);
        this.ptTool.setFont(buttonFont);
        this.zoom_in.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    map.zoom_in();
                }
                catch (MaxZoomException mze) {
                    System.out.println((Object)mze);
                }
                catch (MinZoomException mze) {
                    System.out.println((Object)mze);
                }
            }
        });
        this.zoom_out.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    map.zoom_out();
                }
                catch (MaxZoomException mze) {
                    System.out.println((Object)mze);
                }
                catch (MinZoomException mze) {
                    System.out.println((Object)mze);
                }
            }
        });
        this.boxTool.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (LiveMapPanel.this.boxTool.isSelected()) {
                    LiveMapPanel.this.setTool("XY");
                }
            }
        });
        this.ptTool.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (LiveMapPanel.this.ptTool.isSelected()) {
                    LiveMapPanel.this.setTool("PT");
                }
            }
        });
        JPanel zoomPanel = new JPanel();
        zoomPanel.setLayout(gridbag);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets.top = 0;
        c.insets.bottom = 0;
        gridbag.setConstraints(this.zoom_in, c);
        zoomPanel.add(this.zoom_in);
        c.gridx = 1;
        gridbag.setConstraints(this.zoom_out, c);
        zoomPanel.add(this.zoom_out);
        if (this.toolFlag) {
            c.insets.top = 20;
            c.gridx = 0;
            c.gridy = 1;
            gridbag.setConstraints(this.boxTool, c);
            zoomPanel.add(this.boxTool);
            c.gridx = 1;
            gridbag.setConstraints(this.ptTool, c);
            zoomPanel.add(this.ptTool);
        }
        c.gridx = 0;
        c.gridy = 1;
        c.insets.top = 4;
        c.insets.bottom = 4;
        gridbag.setConstraints(zoomPanel, c);
        entryPanel.add(zoomPanel);
        this.XConvert = new ConvertLongitude(3);
        this.YConvert = new ConvertLatitude(2);
        this.XText = new ConvertLongitude(3);
        this.YText = new ConvertLatitude(2);
        this.grid = new MapGrid(0.0, 360.0, -90.0, 90.0);
        this.toolArray[0] = toolType.equals("PT") ? new PTTool(50, 50, 1, 1, MAPTOOL_COLOR1) : (toolType.equals("X") ? new XTool(50, 50, 100, 1, MAPTOOL_COLOR1) : (toolType.equals("Y") ? new YTool(50, 50, 1, 50, MAPTOOL_COLOR1) : new XYTool(50, 50, 100, 50, MAPTOOL_COLOR1)));
        this.toolArray[0].setRange_X(0.0, 360.0);
        this.toolArray[0].setRange_Y(-90.0, 90.0);
        if (this.toolFlag) {
            this.toolArray[0].setSnapping(true, true);
        }
        double lo = 0.0;
        double hi = 360.0;
        if (img_x_domain != null && (st = new StringTokenizer(img_x_domain)).hasMoreTokens()) {
            lo = Double.valueOf(st.nextToken());
            if (st.hasMoreTokens()) {
                hi = Double.valueOf(st.nextToken());
            }
        }
        this.grid.setDomain_X(lo, hi);
        this.toolArray[0].setRange_X(lo, hi);
        this.XConvert.setRange(lo, hi);
        lo = -90.0;
        hi = 90.0;
        if (img_y_domain != null && (st = new StringTokenizer(img_y_domain)).hasMoreTokens()) {
            lo = Double.valueOf(st.nextToken());
            if (st.hasMoreTokens()) {
                hi = Double.valueOf(st.nextToken());
            }
        }
        this.grid.setDomain_Y(lo, hi);
        this.toolArray[0].setRange_Y(lo, hi);
        this.YConvert.setRange(lo, hi);
        if (map == null) {
            map = new MapCanvas(img_0, this.imgSizeX, this.imgSizeY, this.toolArray, this.grid);
        }
        map.setToolArray(this.toolArray);
        double x_lo = 0.0;
        double x_hi = 0.0;
        double y_lo = 0.0;
        double y_hi = 0.0;
        try {
            StringTokenizer st2;
            if (tool_x_range != null) {
                st2 = new StringTokenizer(tool_x_range);
                x_lo = this.XConvert.toDouble(st2.nextToken());
                if (st2.hasMoreTokens()) {
                    x_hi = this.XConvert.toDouble(st2.nextToken());
                }
            }
            if (tool_y_range != null) {
                st2 = new StringTokenizer(tool_y_range);
                y_lo = this.YConvert.toDouble(st2.nextToken());
                if (st2.hasMoreTokens()) {
                    y_hi = this.YConvert.toDouble(st2.nextToken());
                }
            }
        }
        catch (IllegalArgumentException e) {
            System.out.println("During map canvas creation: " + e);
        }
        if (toolType == null) {
            toolType = "XY";
        }
        if (toolType.equals("PT")) {
            this.tool_type = 0;
            x_hi = x_lo;
            y_hi = y_lo;
        } else if (toolType.equals("X")) {
            this.tool_type = 1;
            y_hi = y_lo;
        } else if (toolType.equals("Y")) {
            this.tool_type = 2;
            x_hi = x_lo;
        } else {
            this.tool_type = 3;
        }
        if (x_lo < this.grid.domain_X[0] || x_lo > this.grid.domain_X[1]) {
            x_lo = this.grid.domain_X[0];
            this.need_to_center = true;
        }
        if (x_hi < this.grid.domain_X[0] || x_hi > this.grid.domain_X[1]) {
            x_hi = this.grid.domain_X[1];
            this.need_to_center = true;
        }
        if (y_lo < this.grid.domain_Y[0] || y_lo > this.grid.domain_Y[1]) {
            y_lo = this.grid.domain_Y[0];
            this.need_to_center = true;
        }
        if (y_hi < this.grid.domain_Y[0] || y_hi > this.grid.domain_Y[1]) {
            y_hi = this.grid.domain_Y[1];
            this.need_to_center = true;
        }
        this.toolArray[0].setRange_X(x_lo, x_hi);
        this.toolArray[0].setRange_Y(y_lo, y_hi);
        this.toolArray[0].setSnapping(true, true);
        this.toolArray[0].setUserBounds(x_lo, x_hi, y_lo, y_hi);
        map.setRegionArray(this.regionArray);
        this.set_strings(false);
        this.setLayout(new BorderLayout());
        if (map == null) {
            System.out.println("map is null!");
        }
        if (entryPanel == null) {
            System.out.println("entryPanel is null!");
        }
        this.addMap();
        this.add("East", entryPanel);
        this.setVisible(true);
    }

    public void addMap() {
        this.remove((Component)map);
        this.add((Component)map, "Center");
        this.setBoundingBoxToSaved();
    }

    public void removeMap() {
        this.remove((Component)map);
    }

    private Frame getFrame() {
        Container parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof Frame); parent = parent.getParent()) {
        }
        return (Frame)parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean action(Event ev, Object arg) {
        double top = 0.0;
        double bottom = 0.0;
        double left = 0.0;
        double right = 0.0;
        Object target = ev.target;
        if (target instanceof JTextField) {
            try {
                switch (this.tool_type) {
                    case 0: {
                        if (target == this.North) {
                            bottom = top = this.YConvert.toDouble(this.North.getText());
                            right = left = this.XConvert.toDouble(this.West.getText());
                            break;
                        }
                        if (target == this.South) {
                            bottom = top = this.YConvert.toDouble(this.South.getText());
                            right = left = this.XConvert.toDouble(this.West.getText());
                            break;
                        }
                        if (target == this.East) {
                            bottom = top = this.YConvert.toDouble(this.North.getText());
                            right = left = this.XConvert.toDouble(this.East.getText());
                            break;
                        }
                        if (target != this.West) break;
                        bottom = top = this.YConvert.toDouble(this.North.getText());
                        right = left = this.XConvert.toDouble(this.West.getText());
                        break;
                    }
                    case 1: {
                        bottom = target == this.North ? (top = this.YConvert.toDouble(this.North.getText())) : (target == this.South ? (top = this.YConvert.toDouble(this.South.getText())) : (top = this.YConvert.toDouble(this.North.getText())));
                        left = this.XConvert.toDouble(this.West.getText());
                        right = this.XConvert.toDouble(this.East.getText());
                        break;
                    }
                    case 2: {
                        right = target == this.West ? (left = this.XConvert.toDouble(this.West.getText())) : (target == this.East ? (left = this.XConvert.toDouble(this.East.getText())) : (left = this.XConvert.toDouble(this.West.getText())));
                        top = this.YConvert.toDouble(this.North.getText());
                        bottom = this.YConvert.toDouble(this.South.getText());
                        break;
                    }
                    default: {
                        top = this.YConvert.toDouble(this.North.getText());
                        bottom = this.YConvert.toDouble(this.South.getText());
                        left = this.XConvert.toDouble(this.West.getText());
                        right = this.XConvert.toDouble(this.East.getText());
                    }
                }
                if (top < bottom) {
                    double old_bottom = bottom;
                    bottom = top;
                    top = old_bottom;
                }
                if (right < left) {
                    double old_left = left;
                    left = right;
                    right = old_left;
                }
                map.getTool().setUserBounds(left, right, bottom, top);
                map.center_tool(1.0);
            }
            catch (IllegalArgumentException e) {
                System.out.println(e.toString());
            }
            finally {
                map.repaint();
                this.set_strings(true);
            }
        }
        return super.action(ev, arg);
    }

    public void setBoundingBox(double top, double left, double bottom, double right) {
        try {
            this.n = top;
            this.w = left;
            this.s = bottom;
            this.e = right;
            if (this.w == this.e && this.tool_type != 0) {
                this.e = this.e < 0.0 ? 0.999 * this.e : 1.001 * this.e;
                right = this.e;
            }
            map.getTool().setUserBounds(left, right, bottom, top);
            map.center_tool(1.0);
        }
        catch (Exception w) {
            Log.debug(9, "error in setting Bounding Box in LiveMapPanel!");
        }
        map.repaint();
        this.set_strings(true);
    }

    public void setBoundingBoxToSaved() {
        this.setBoundingBox(this.n, this.w, this.s, this.e);
    }

    public double getNorth() {
        double ret = 0.0;
        ret = this.YConvert.toDouble(this.North.getText());
        return ret;
    }

    public double getWest() {
        double ret = 0.0;
        ret = this.XConvert.toDouble(this.West.getText());
        return ret;
    }

    public double getSouth() {
        double ret = 0.0;
        ret = this.YConvert.toDouble(this.South.getText());
        return ret;
    }

    public double getEast() {
        double ret = 0.0;
        ret = this.XConvert.toDouble(this.East.getText());
        return ret;
    }

    public boolean handleEvent(Event evt) {
        if (evt.target instanceof JButton && evt.id == 1001) {
            String which = ((JButton)evt.target).getLabel();
            if (which.equals("Zoom In")) {
                try {
                    map.zoom_in();
                }
                catch (MaxZoomException mze) {
                    System.out.println((Object)mze);
                }
                catch (MinZoomException mze) {
                    System.out.println((Object)mze);
                }
                return true;
            }
            if (which.equals("Zoom Out")) {
                try {
                    map.zoom_out();
                }
                catch (MaxZoomException mze) {
                    System.out.println((Object)mze);
                }
                catch (MinZoomException mze) {
                    System.out.println((Object)mze);
                }
                return true;
            }
        } else if (evt.target instanceof JTextField && evt.id == 1005) {
            this.action(evt, null);
        }
        return super.handleEvent(evt);
    }

    public void set_strings(boolean saveCoordinates) {
        this.XText.setRange(this.grid.domain_X[0], this.grid.domain_X[1]);
        this.YText.setRange(this.grid.domain_Y[0], this.grid.domain_Y[1]);
        try {
            if (this.tool_type == 0 || this.tool_type == 1) {
                this.North.setText(this.YText.toString(LiveMapPanel.map.getTool().user_Y[2]));
                this.South.setText(this.YText.toString(LiveMapPanel.map.getTool().user_Y[2]));
                if (saveCoordinates) {
                    this.n = LiveMapPanel.map.getTool().user_Y[2];
                    this.s = LiveMapPanel.map.getTool().user_Y[2];
                }
            } else {
                this.North.setText(this.YText.toString(LiveMapPanel.map.getTool().user_Y[1]));
                this.South.setText(this.YText.toString(LiveMapPanel.map.getTool().user_Y[0]));
                if (saveCoordinates) {
                    this.n = LiveMapPanel.map.getTool().user_Y[1];
                    this.s = LiveMapPanel.map.getTool().user_Y[0];
                }
            }
            if (this.tool_type == 0 || this.tool_type == 2) {
                this.East.setText(this.XText.toString(LiveMapPanel.map.getTool().user_X[2]));
                this.West.setText(this.XText.toString(LiveMapPanel.map.getTool().user_X[2]));
                if (saveCoordinates) {
                    this.e = LiveMapPanel.map.getTool().user_X[2];
                    this.w = LiveMapPanel.map.getTool().user_X[2];
                }
            } else {
                this.East.setText(this.XText.toString(LiveMapPanel.map.getTool().user_X[1]));
                this.West.setText(this.XText.toString(LiveMapPanel.map.getTool().user_X[0]));
                if (saveCoordinates) {
                    this.e = LiveMapPanel.map.getTool().user_X[1];
                    this.w = LiveMapPanel.map.getTool().user_X[0];
                }
            }
        }
        catch (IllegalArgumentException e) {
            System.out.println("During set_strings(): " + e);
        }
    }

    public boolean mouseUp(Event evt, int x, int y) {
        this.set_strings(true);
        return true;
    }

    public void zoom_in() {
        try {
            map.zoom_in();
        }
        catch (MaxZoomException mze) {
            System.out.println((Object)mze);
        }
        catch (MinZoomException mze) {
            System.out.println((Object)mze);
        }
    }

    public void zoom_out() {
        try {
            map.zoom_out();
        }
        catch (MaxZoomException mze) {
            System.out.println((Object)mze);
        }
        catch (MinZoomException mze) {
            System.out.println((Object)mze);
        }
    }

    public double getTop() {
        double top = this.YConvert.toDouble(this.North.getText());
        return top;
    }

    public double getBottom() {
        double bottom = this.YConvert.toDouble(this.South.getText());
        return bottom;
    }

    public double getLeft() {
        double left = this.XConvert.toDouble(this.West.getText());
        return left;
    }

    public double getRight() {
        double right = this.XConvert.toDouble(this.East.getText());
        return right;
    }

    public void setTool(String type) {
        this.setTool(map.getSelected(), type);
    }

    public void setTool(int i, String type) {
        PTTool newTool;
        MapTool oldTool = map.getTool(i);
        if (type.equals("PT")) {
            newTool = new PTTool(oldTool.getRectangle(), oldTool.getColor());
            this.tool_type = 0;
        } else if (type.equals("X")) {
            newTool = new XTool(oldTool.getRectangle(), oldTool.getColor());
            this.tool_type = 1;
        } else if (type.equals("Y")) {
            newTool = new YTool(oldTool.getRectangle(), oldTool.getColor());
            this.tool_type = 2;
        } else if (type.equals("XY")) {
            newTool = new XYTool(oldTool.getRectangle(), oldTool.getColor());
            this.tool_type = 3;
        } else if (type.equals("XcY")) {
            newTool = new XcYTool(oldTool.getRectangle(), oldTool.getColor());
            this.tool_type = 3;
        } else if (type.equals("YcX")) {
            newTool = new YcXTool(oldTool.getRectangle(), oldTool.getColor());
            this.tool_type = 3;
        } else if (type.equals("PTcX")) {
            newTool = new PTcXTool(oldTool.getRectangle(), oldTool.getColor());
            this.tool_type = 1;
        } else if (type.equals("PTcY")) {
            newTool = new PTcYTool(oldTool.getRectangle(), oldTool.getColor());
            this.tool_type = 2;
        } else if (type.equals("PTcXY")) {
            newTool = new PTcXYTool(oldTool.getRectangle(), oldTool.getColor());
            this.tool_type = 3;
        } else {
            newTool = new XYTool(oldTool.getRectangle(), oldTool.getColor());
            this.tool_type = 3;
        }
        map.newToolFromOld(i, (MapTool)newTool, oldTool);
        map.repaint();
        this.set_strings(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doTextFieldEdit(Object target) {
        double top = 0.0;
        double bottom = 0.0;
        double left = 0.0;
        double right = 0.0;
        if (target instanceof JTextField) {
            try {
                switch (this.tool_type) {
                    case 0: {
                        if (target == this.North) {
                            bottom = top = this.YConvert.toDouble(this.North.getText());
                            right = left = this.XConvert.toDouble(this.West.getText());
                            break;
                        }
                        if (target == this.South) {
                            bottom = top = this.YConvert.toDouble(this.South.getText());
                            right = left = this.XConvert.toDouble(this.West.getText());
                            break;
                        }
                        if (target == this.East) {
                            bottom = top = this.YConvert.toDouble(this.North.getText());
                            right = left = this.XConvert.toDouble(this.East.getText());
                            break;
                        }
                        if (target != this.West) break;
                        bottom = top = this.YConvert.toDouble(this.North.getText());
                        right = left = this.XConvert.toDouble(this.West.getText());
                        break;
                    }
                    case 1: {
                        bottom = target == this.North ? (top = this.YConvert.toDouble(this.North.getText())) : (target == this.South ? (top = this.YConvert.toDouble(this.South.getText())) : (top = this.YConvert.toDouble(this.North.getText())));
                        left = this.XConvert.toDouble(this.West.getText());
                        right = this.XConvert.toDouble(this.East.getText());
                        break;
                    }
                    case 2: {
                        right = target == this.West ? (left = this.XConvert.toDouble(this.West.getText())) : (target == this.East ? (left = this.XConvert.toDouble(this.East.getText())) : (left = this.XConvert.toDouble(this.West.getText())));
                        top = this.YConvert.toDouble(this.North.getText());
                        bottom = this.YConvert.toDouble(this.South.getText());
                        break;
                    }
                    default: {
                        top = this.YConvert.toDouble(this.North.getText());
                        bottom = this.YConvert.toDouble(this.South.getText());
                        left = this.XConvert.toDouble(this.West.getText());
                        right = this.XConvert.toDouble(this.East.getText());
                    }
                }
                if (top < bottom) {
                    double old_bottom = bottom;
                    bottom = top;
                    top = old_bottom;
                }
                if (right < left) {
                    double old_left = left;
                    left = right;
                    right = old_left;
                }
                if (left == right && this.tool_type != 0) {
                    right = right < 0.0 ? 0.999 * right : 1.001 * right;
                }
                map.getTool().setUserBounds(left, right, bottom, top);
                map.center_tool(1.0);
            }
            catch (IllegalArgumentException e) {
                System.out.println(e.toString());
            }
            finally {
                map.repaint();
                this.set_strings(true);
            }
        }
    }

    class tfFocus
    extends FocusAdapter {
        tfFocus() {
        }

        public void focusLost(FocusEvent event) {
            Object target = event.getSource();
            LiveMapPanel.this.doTextFieldEdit(target);
        }
    }

    class tfAction
    implements ActionListener {
        tfAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Object target = event.getSource();
            LiveMapPanel.this.doTextFieldEdit(target);
        }
    }
}

