/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.xsltresolver;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.framework.ConfigXML;
import edu.ucsb.nceas.morpho.plugins.PluginInterface;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceExistsException;
import edu.ucsb.nceas.morpho.plugins.ServiceProvider;
import edu.ucsb.nceas.morpho.plugins.XSLTResolverInterface;
import edu.ucsb.nceas.morpho.util.DocumentNotFoundException;
import edu.ucsb.nceas.morpho.util.Log;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Hashtable;

public class XSLTResolverPlugin
implements XSLTResolverInterface,
PluginInterface,
ServiceProvider {
    private final String CONFIG_KEY_GENERIC_STYLESHEET = "genericStylesheet";
    private final String CONFIG_KEY_DOCTYPE_TO_XSLT = "doctype_xslt_mappings";
    private final String CONFIG_KEY_DOCTYPE = "doctype";
    private final String CONFIG_KEY_XSLT = "xslt";
    private final String CONFIG_KEY_GENERIC_LOCATION = "genericStylesheetLocation";
    private final String CONFIG_KEY_DOCTYPE_TO_LOCATIONS = "doctype_xslt_location_mappings";
    private final String CONFIG_KEY_LOCATIONS = "location";
    private final String CONFIG_KEY_TREE_EDITOR_XML = "tree_editor_xml_location_mappings";
    private final String GENERIC_STYLESHEET;
    private final ConfigXML config;
    private Hashtable xslt_mappings;
    private Hashtable location_mappings;
    private Hashtable tree_editor_mappings;
    private final ClassLoader classLoader = Morpho.class.getClassLoader();

    public XSLTResolverPlugin() {
        Thread t = Thread.currentThread();
        t.setContextClassLoader(this.classLoader);
        this.config = Morpho.getConfiguration();
        this.GENERIC_STYLESHEET = this.config.get("genericStylesheet", 0);
        this.initDoctypeToXSLTMappings();
    }

    public void initialize(Morpho morpho) {
        try {
            ServiceController services = ServiceController.getInstance();
            services.addService(XSLTResolverInterface.class, this);
            Log.debug(20, "Service added: XSLTResolverInterface.");
        }
        catch (ServiceExistsException see) {
            Log.debug(6, "Service registration failed: XSLTResolverInterface");
            Log.debug(6, see.toString());
        }
    }

    public Reader getXSLTStylesheetReader(String identifier) throws DocumentNotFoundException {
        Log.debug(50, "\nXSLTResolver got: " + identifier);
        InputStreamReader rdr = null;
        String xslPathString = this.getFromMappings(this.xslt_mappings, identifier);
        if (xslPathString == null || xslPathString.trim().equals("")) {
            rdr = new InputStreamReader(this.classLoader.getResourceAsStream(this.GENERIC_STYLESHEET));
            Log.debug(50, "getXSLTStylesheetReader() failed to find valid stylesheet for identifier: " + identifier + "\n returning default: " + this.GENERIC_STYLESHEET);
        } else {
            rdr = new InputStreamReader(this.classLoader.getResourceAsStream(xslPathString));
            Log.debug(50, "getXSLTStylesheetReader() found a value for the stylesheet for identifier: " + identifier + "\n returning: " + xslPathString);
        }
        Log.debug(50, "\nXSLTResolver returning Reader: " + rdr);
        return rdr;
    }

    public String getXSLTStylesheetLocation(String identifier) {
        Log.debug(50, "\ngetXSLTStylesheetLocation got: " + identifier);
        String xslPathString = this.getFromMappings(this.location_mappings, identifier);
        if (xslPathString == null || xslPathString.trim().equals("")) {
            xslPathString = this.config.get("genericStylesheetLocation", 0);
        }
        Log.debug(50, "\ngetXSLTStylesheetLocation returning: " + xslPathString);
        return xslPathString;
    }

    public String getTreeEditorXMLLocation(String identifier) {
        Log.debug(50, "\ngetTreeEditorXMLLocation got: " + identifier);
        String xmlPathString = this.getFromMappings(this.tree_editor_mappings, identifier);
        Log.debug(50, "\ngetTreeEditorXMLLocation returning: " + xmlPathString);
        return xmlPathString;
    }

    private void initDoctypeToXSLTMappings() {
        this.xslt_mappings = this.config.getHashtable("doctype_xslt_mappings", "doctype", "xslt");
        this.location_mappings = this.config.getHashtable("doctype_xslt_location_mappings", "doctype", "location");
        this.tree_editor_mappings = this.config.getHashtable("tree_editor_xml_location_mappings", "doctype", "location");
    }

    private String getFromMappings(Hashtable mappings, String key) {
        Log.debug(50, "XSLTResolverPlugin.getFromMappings() got key=" + key);
        if (key == null || key.equals("")) {
            Log.debug(12, "ALERT: XSLTResolverPlugin.getFromMappings(): got key=" + key);
        } else if (!mappings.containsKey(key)) {
            Log.debug(12, "ALERT: XSLTResolverPlugin.getFromMappings(): could not find key=" + key);
        } else {
            String xslt = (String)mappings.get(key);
            Log.debug(50, "XSLTResolverPlugin.getFromMappings() value = " + xslt);
            return xslt;
        }
        return null;
    }
}

