/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages;

import com.toedter.calendar.JCalendar;
import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WidgetFactory;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardSettings;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class TemporalPage
extends AbstractUIPage {
    private final String pageID = "TEMPORAL_PAGE";
    private final String nextPageID = "";
    private final String pageNumber = "";
    private final String title = "Access Page";
    private final String subtitle = "";
    private int selDateTypeSingle = 1;
    private int selDateTypeStart = 1;
    private int selDateTypeEnd = 1;
    private JPanel topPanel;
    private JLabel descLabel;
    private JPanel currentPanel;
    private JPanel singlePointPanel;
    private JPanel rangeTimePanel;
    private JPanel dateTypeRadioPanel;
    private JTextField singleTimeTF;
    private JTextField startTimeTF;
    private JTextField endTimeTF;
    private JCalendar singleTimeCalendar;
    private JCalendar startTimeCalendar;
    private JCalendar endTimeCalendar;
    private final String[] timeTypeText = new String[]{"Single Point in Time", "Range of Date/Time"};
    private final String[] timeText = new String[]{"Enter Year Only", "Enter Day, Month and Year"};
    private final String[] Months = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private String xPathRoot = "/eml:eml/dataset/coverage/temporalCoverage";
    private static final Dimension PANEL_DIMS = new Dimension(325, 350);
    private static final int YYYYMMDD = 8;
    private static final int ALL = 4;
    private static final int YEAR_ONLY = 1;
    private final StringBuffer surrogateBuff = new StringBuffer();
    private OrderedMap returnMap = new OrderedMap();

    public TemporalPage() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new BoxLayout(this.topPanel, 1));
        JLabel desc = WidgetFactory.makeHTMLLabel("<font size=\"4\"><b>Define Temporal Coverage:</b></font>", 1);
        this.topPanel.add(desc);
        final TemporalPage instance = this;
        ActionListener accessTypeListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Log.debug(45, "got radiobutton command: " + e.getActionCommand());
                TemporalPage.this.onLoadAction();
                if (e.getActionCommand().equals(TemporalPage.this.timeTypeText[0])) {
                    TemporalPage.this.enableSingleDatePanel();
                } else if (e.getActionCommand().equals(TemporalPage.this.timeTypeText[1])) {
                    TemporalPage.this.enableDateRangePanel();
                }
                instance.validate();
                instance.repaint();
            }
        };
        JPanel dateTypeRadioOuterPanel = WidgetFactory.makePanel(2);
        this.dateTypeRadioPanel = WidgetFactory.makeRadioPanel(this.timeTypeText, 0, accessTypeListener);
        dateTypeRadioOuterPanel.add(WidgetFactory.makeLabel("", false));
        dateTypeRadioOuterPanel.add(this.dateTypeRadioPanel);
        this.topPanel.add(WidgetFactory.makeDefaultSpacer());
        this.descLabel = WidgetFactory.makeHTMLLabel("<p><b>Choose date type:</b>", 1);
        this.topPanel.add(this.descLabel);
        this.topPanel.add(dateTypeRadioOuterPanel);
        this.add((Component)this.topPanel, "North");
        this.singlePointPanel = this.getSinglePointPanel();
        this.rangeTimePanel = this.getRangeTimePanel();
        if (this.currentPanel == null) {
            this.currentPanel = this.singlePointPanel;
        }
        this.remove(this.currentPanel);
        if (this.currentPanel == this.singlePointPanel) {
            this.add((Component)this.singlePointPanel, "Center");
        } else {
            this.add((Component)this.rangeTimePanel, "Center");
        }
    }

    public JPanel getSinglePointPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        this.singleTimeTF = new JTextField();
        this.singleTimeTF.setEditable(false);
        if (this.singleTimeCalendar == null) {
            this.singleTimeCalendar = new JCalendar();
        }
        this.singleTimeCalendar.setVisible(true);
        this.singleTimeCalendar.setFont(WizardSettings.WIZARD_CONTENT_FONT);
        this.singleTimeCalendar.getMonthChooser().setFont(WizardSettings.WIZARD_CONTENT_FONT);
        JPanel singlePanel = this.getDateTimePanel("Enter date:", this.singleTimeTF, this.singleTimeCalendar, this.selDateTypeSingle);
        panel.add(Box.createGlue());
        panel.add(singlePanel);
        panel.add(Box.createGlue());
        return panel;
    }

    public JPanel getRangeTimePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        this.startTimeTF = new JTextField();
        this.startTimeTF.setEditable(false);
        if (this.startTimeCalendar == null) {
            this.startTimeCalendar = new JCalendar();
        }
        this.startTimeCalendar.setVisible(true);
        JPanel startingPanel = this.getDateTimePanel("Enter starting date:", this.startTimeTF, this.startTimeCalendar, this.selDateTypeStart);
        panel.add(Box.createGlue());
        panel.add(startingPanel);
        this.endTimeTF = new JTextField();
        this.endTimeTF.setEditable(false);
        if (this.endTimeCalendar == null) {
            this.endTimeCalendar = new JCalendar();
        }
        this.endTimeCalendar.setVisible(true);
        JPanel endingPanel = this.getDateTimePanel("Enter ending date:", this.endTimeTF, this.endTimeCalendar, this.selDateTypeEnd);
        panel.add(endingPanel);
        panel.add(Box.createGlue());
        return panel;
    }

    public JPanel getDateTimePanel(String panelHeading, JTextField timeTextField, JCalendar timeCalendar, int selDateType) {
        JPanel outerPanel = new JPanel();
        outerPanel.setLayout(new BoxLayout(outerPanel, 1));
        WidgetFactory.addTitledBorder(outerPanel, panelHeading);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(new EmptyBorder(10, 20, 0, 20));
        final JCalendar finalTimeCalendar = timeCalendar;
        final JTextField finalTimeTextField = timeTextField;
        PropertyChangeListener propertyListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                Log.debug(45, "got radiobutton command: " + e.getPropertyName());
                if (e.getPropertyName().equals("calendar")) {
                    if (finalTimeCalendar.getDayChooser().isEnabled()) {
                        finalTimeTextField.setText(TemporalPage.this.calendarToString(finalTimeCalendar, 4));
                    } else {
                        finalTimeTextField.setText(TemporalPage.this.calendarToString(finalTimeCalendar, 1));
                    }
                }
            }
        };
        ActionListener dayTypeListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Log.debug(45, "got radiobutton command: " + e.getActionCommand());
                TemporalPage.this.onLoadAction();
                if (e.getActionCommand().equals(TemporalPage.this.timeText[0])) {
                    TemporalPage.this.enableYearOnlyFields(finalTimeCalendar, finalTimeTextField);
                } else if (e.getActionCommand().equals(TemporalPage.this.timeText[1])) {
                    TemporalPage.this.enableDayMonthYearFields(finalTimeCalendar, finalTimeTextField);
                }
            }
        };
        JPanel typeRadioContainer = WidgetFactory.makeVerticalPanel(3);
        JPanel dateFieldsRadioPanel = WidgetFactory.makeRadioPanel(this.timeText, selDateType, dayTypeListener);
        switch (selDateType) {
            case 0: {
                this.enableYearOnlyFields(timeCalendar, timeTextField);
                break;
            }
            default: {
                this.enableDayMonthYearFields(timeCalendar, timeTextField);
            }
        }
        typeRadioContainer.add(dateFieldsRadioPanel);
        typeRadioContainer.add(Box.createGlue());
        panel.add((Component)typeRadioContainer, "North");
        JPanel calendarPanel = new JPanel();
        calendarPanel.setLayout(new BoxLayout(calendarPanel, 1));
        WidgetFactory.setPrefMaxSizes(timeTextField, WizardSettings.WIZARD_CONTENT_TEXTFIELD_DIMS);
        calendarPanel.add(Box.createVerticalStrut(5));
        calendarPanel.add(timeTextField);
        calendarPanel.add(Box.createVerticalStrut(5));
        timeCalendar.addPropertyChangeListener(propertyListener);
        calendarPanel.add(timeCalendar);
        calendarPanel.add(Box.createGlue());
        panel.add((Component)calendarPanel, "Center");
        this.setPrefMinMaxSizes(panel, PANEL_DIMS);
        outerPanel.add(panel);
        return outerPanel;
    }

    private String calendarToString(JCalendar c, int returnType) {
        Calendar calendar = c.getCalendar();
        DateFormat df = DateFormat.getDateInstance(1, c.getLocale());
        if (returnType == 1) {
            return calendar.get(1) + "";
        }
        if (returnType == 8) {
            String dateString = calendar.get(1) + "-";
            int month = calendar.get(2) + 1;
            int day = calendar.get(5);
            dateString = c.getMonthChooser().isEnabled() ? (month < 10 ? dateString + "0" + month + "-" : dateString + month + "-") : dateString + "01" + "-";
            dateString = !c.getDayChooser().isEnabled() ? dateString + "01" : (day < 10 ? dateString + "0" + day : dateString + day);
            return dateString;
        }
        return df.format(calendar.getTime());
    }

    private void setPrefMinMaxSizes(JComponent component, Dimension dims) {
        WidgetFactory.setPrefMaxSizes(component, dims);
        component.setMinimumSize(dims);
    }

    public boolean onAdvanceAction() {
        Calendar eCalendar;
        Calendar sCalendar;
        if (this.currentPanel == this.rangeTimePanel && (sCalendar = this.startTimeCalendar.getCalendar()).after(eCalendar = this.endTimeCalendar.getCalendar())) {
            Log.debug(1, "Starting date should be before ending date.");
            return false;
        }
        return true;
    }

    public List getSurrogate() {
        ArrayList<String> surrogate = new ArrayList<String>();
        if (this.currentPanel == this.singlePointPanel) {
            surrogate.add(" " + this.singleTimeTF.getText().trim());
        } else {
            surrogate.add(" " + this.startTimeTF.getText().trim() + "-" + this.endTimeTF.getText().trim());
        }
        return surrogate;
    }

    public OrderedMap getPageData() {
        return this.getPageData(this.xPathRoot);
    }

    public OrderedMap getPageData(String xPathRoot) {
        this.returnMap.clear();
        if (this.currentPanel == this.singlePointPanel) {
            String singleDate = this.singleTimeCalendar.getDayChooser().isEnabled() ? this.calendarToString(this.singleTimeCalendar, 8) : this.calendarToString(this.singleTimeCalendar, 1);
            this.returnMap.put((Object)(xPathRoot + "/singleDateTime/calendarDate"), (Object)singleDate);
        } else {
            String startDate = this.startTimeCalendar.getDayChooser().isEnabled() ? this.calendarToString(this.startTimeCalendar, 8) : this.calendarToString(this.startTimeCalendar, 1);
            String endDate = this.endTimeCalendar.getDayChooser().isEnabled() ? this.calendarToString(this.endTimeCalendar, 8) : this.calendarToString(this.endTimeCalendar, 1);
            this.returnMap.put((Object)(xPathRoot + "/rangeOfDates/beginDate/calendarDate"), (Object)startDate);
            this.returnMap.put((Object)(xPathRoot + "/rangeOfDates/endDate/calendarDate"), (Object)endDate);
        }
        return this.returnMap;
    }

    public void onRewindAction() {
    }

    public void onLoadAction() {
    }

    public String getPageID() {
        return this.pageID;
    }

    public String getTitle() {
        return "Access Page";
    }

    public String getSubtitle() {
        return "";
    }

    public String getNextPageID() {
        this.getClass();
        return "";
    }

    public String getPageNumber() {
        return "";
    }

    public boolean setPageData(OrderedMap map, String _xPathRoot) {
        String dateString;
        if (_xPathRoot != null && _xPathRoot.trim().length() > 0) {
            this.xPathRoot = _xPathRoot;
        }
        if ((dateString = (String)map.get((Object)(this.xPathRoot + "/singleDateTime[1]/calendarDate[1]"))) != null) {
            map.remove((Object)(this.xPathRoot + "/singleDateTime[1]/calendarDate[1]"));
            Calendar singleCalendar = this.createCalendarFromDateString(dateString);
            this.singleTimeCalendar.setCalendar(singleCalendar);
            switch (dateString.length()) {
                case 4: {
                    this.selDateTypeSingle = 0;
                    break;
                }
                default: {
                    this.selDateTypeSingle = 1;
                }
            }
            this.activateSingleDateMode();
        } else {
            String startString = (String)map.get((Object)(this.xPathRoot + "/rangeOfDates[1]/beginDate[1]/calendarDate[1]"));
            String endString = (String)map.get((Object)(this.xPathRoot + "/rangeOfDates[1]/endDate[1]/calendarDate[1]"));
            if (startString != null && endString != null) {
                map.remove((Object)(this.xPathRoot + "/rangeOfDates[1]/beginDate[1]/calendarDate[1]"));
                map.remove((Object)(this.xPathRoot + "/rangeOfDates[1]/endDate[1]/calendarDate[1]"));
                Calendar startCalendar = this.createCalendarFromDateString(startString);
                Calendar endCalendar = this.createCalendarFromDateString(endString);
                this.startTimeCalendar.setCalendar(startCalendar);
                this.endTimeCalendar.setCalendar(endCalendar);
                switch (startString.length()) {
                    case 4: {
                        this.selDateTypeStart = 0;
                        break;
                    }
                    default: {
                        this.selDateTypeStart = 1;
                    }
                }
                switch (endString.length()) {
                    case 4: {
                        this.selDateTypeEnd = 0;
                        break;
                    }
                    default: {
                        this.selDateTypeEnd = 1;
                    }
                }
                this.activateDateRangeMode();
            }
        }
        boolean returnVal = map.isEmpty();
        if (!returnVal) {
            Log.debug(20, "TemporalPage.setPageData returning FALSE! Map still contains:" + map);
        }
        return returnVal;
    }

    private Calendar createCalendarFromDateString(String dateString) {
        if (dateString == null || dateString.length() == 0) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        try {
            Log.debug(30, "creating cal: " + dateString);
            String yearS = dateString.substring(0, 4);
            int year = new Integer(yearS);
            cal.set(1, year);
            cal.set(2, 0);
            cal.set(5, 1);
            if (dateString.length() > 7) {
                String monthS = dateString.substring(5, 7);
                int month = new Integer(monthS);
                cal.set(2, month - 1);
                String dayS = dateString.substring(8, 10);
                int day = new Integer(dayS);
                cal.set(5, day);
            }
        }
        catch (Exception ex) {
            cal = Calendar.getInstance();
            Log.debug(1, "Problem creating calendar from: " + dateString);
        }
        return cal;
    }

    private void enableYearOnlyFields(JCalendar cal, JTextField f) {
        cal.getDayChooser().setEnabled(false);
        cal.getYearChooser().setEnabled(true);
        f.setText(this.calendarToString(cal, 1));
    }

    private void enableDayMonthYearFields(JCalendar cal, JTextField f) {
        cal.getDayChooser().setEnabled(true);
        cal.getYearChooser().setEnabled(true);
        f.setText(this.calendarToString(cal, 4));
    }

    private void enableSingleDatePanel() {
        this.remove(this.currentPanel);
        this.currentPanel = this.singlePointPanel = this.getSinglePointPanel();
        this.add((Component)this.singlePointPanel, "Center");
    }

    private void enableDateRangePanel() {
        this.remove(this.currentPanel);
        this.currentPanel = this.rangeTimePanel = this.getRangeTimePanel();
        this.add((Component)this.rangeTimePanel, "Center");
    }

    private void activateSingleDateMode() {
        JPanel radioPanel = (JPanel)this.dateTypeRadioPanel.getComponent(1);
        ((JRadioButton)radioPanel.getComponent(0)).setSelected(true);
        this.enableSingleDatePanel();
    }

    private void activateDateRangeMode() {
        JPanel radioPanel = (JPanel)this.dateTypeRadioPanel.getComponent(1);
        ((JRadioButton)radioPanel.getComponent(1)).setSelected(true);
        this.enableDateRangePanel();
    }
}

