/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages;

import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.framework.DataPackageInterface;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceNotHandledException;
import edu.ucsb.nceas.morpho.plugins.ServiceProvider;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WidgetFactory;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardContainerFrame;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardSettings;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.GUIAction;
import edu.ucsb.nceas.morpho.util.HyperlinkButton;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class Summary
extends AbstractUIPage {
    public final String pageID = "SUMMARY";
    public final String nextPageID;
    public final String pageNumber = "15";
    public final String PACKAGE_WIZ_SUMMARY_TITLE = "New Data Package Wizard";
    public final String ENTITY_WIZ_SUMMARY_TITLE = "New Data Table Wizard";
    public final String SUBTITLE = "Summary";
    private JLabel desc1;
    private JLabel desc2;
    private JLabel desc4;
    private WizardContainerFrame mainWizFrame;
    private JComponent showMeButton;

    public Summary(WizardContainerFrame mainWizFrame) {
        this.nextPageID = null;
        this.mainWizFrame = mainWizFrame;
        this.init();
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(WidgetFactory.makeDefaultSpacer());
        this.add(WidgetFactory.makeDefaultSpacer());
        this.add(WidgetFactory.makeDefaultSpacer());
        this.desc1 = WidgetFactory.makeHTMLLabel("", 2);
        this.add(this.desc1);
        this.desc2 = WidgetFactory.makeHTMLLabel("<br></br><p><b>" + WizardSettings.getSummaryText() + "</b></p><br></br>", 3);
        if (this.desc2 != null && WizardSettings.getSummaryText() != null) {
            this.add(this.desc2);
        }
        JLabel desc3 = WidgetFactory.makeHTMLLabel(this.getSecondParagraph(), 2);
        this.add(desc3);
        this.desc4 = WidgetFactory.makeHTMLLabel("", 2);
        this.add(this.desc4);
        this.add(this.getShowMeButton());
        this.desc1.setAlignmentX(-1.0f);
        this.desc2.setAlignmentX(-1.0f);
        desc3.setAlignmentX(-1.0f);
        this.desc4.setAlignmentX(-1.0f);
        this.add(Box.createVerticalGlue());
    }

    private String getSecondParagraph() {
        String ID = this.mainWizFrame.getFirstPageID();
        if (ID == null) {
            return "";
        }
        if (ID.equals("INTRODUCTION")) {
            return "<p>You can press the \"Finish\" button, or you can use the \"< Back\" button to return to previous pages and change the information you have added.</p>";
        }
        if (ID.equals("DATA_LOCATION")) {
            return "<p>You can press the \"Finish\" button to add the data table to your package.</p>";
        }
        return "";
    }

    private String getLastParagraph() {
        String ID = this.mainWizFrame.getFirstPageID();
        if (ID == null) {
            return "";
        }
        if (ID.equals("INTRODUCTION")) {
            return "<p>After you press \"Finish\", you will see your new package description information displayed in the Morpho main screen.  If you want to add data tables to your package, select the \"Create/Import New Data Table...\" option from the \"Data\" menu</p>";
        }
        if (ID.equals("DATA_LOCATION")) {
            return "<p>If you want to add more data tables to your package, select the \"Create/Import New Data Table...\" option from the \"Data\" menu</p>";
        }
        return "";
    }

    private String getProductName() {
        String ID = this.mainWizFrame.getFirstPageID();
        if (ID == null) {
            return "";
        }
        if (ID.equals("DATA_LOCATION")) {
            return "data table";
        }
        return "data package";
    }

    public void onLoadAction() {
        this.desc1.setText("<html><table width=\"100%\"><tr><td valign=\"top\" width=\"100%\"><font style=\"font-size: 9px;\" face=\"Sans-Serif\"><p>This wizard has now collected all the information that is required to create your new " + this.getProductName() + ".</p>" + "</font></td></tr></table></html>");
        this.desc2.setText("<html><table width=\"100%\"><tr><td valign=\"top\" width=\"100%\"><font style=\"font-size: 9px;\" face=\"Sans-Serif\"><p><b>" + WizardSettings.getSummaryText() + this.getDataLocation() + "</b></p><br></br>" + "</font></td></tr></table></html>");
        this.desc4.setText("<html><table width=\"100%\"><tr><td valign=\"top\" width=\"100%\"><font style=\"font-size: 9px;\" face=\"Sans-Serif\">" + this.getLastParagraph() + "</font></td></tr></table></html>");
        this.updateShowMeButton();
        String ID = this.mainWizFrame.getFirstPageID();
        if (ID == null) {
            return;
        }
        if (ID.equals("DATA_LOCATION")) {
            this.mainWizFrame.setButtonsStatus(false, false, true);
        }
    }

    private JComponent getShowMeButton() {
        if (this.showMeButton == null) {
            ServiceProvider provider = null;
            ServiceController services = ServiceController.getInstance();
            DataPackageInterface dataPackagePlugin = null;
            try {
                provider = services.getServiceProvider(DataPackageInterface.class);
                dataPackagePlugin = (DataPackageInterface)((Object)provider);
            }
            catch (ServiceNotHandledException snhe) {
                Log.debug(6, snhe.getMessage());
            }
            final DataPackageInterface finalDataPackagePlugin = dataPackagePlugin;
            GUIAction newDataTableAction = new GUIAction("or click here to finish this wizard and add a new data table now.", null, new Command(){

                public void execute(ActionEvent ae) {
                    Summary.this.mainWizFrame.finishAction();
                    try {
                        finalDataPackagePlugin.getCommandObject(20).execute(ae);
                    }
                    catch (ClassNotFoundException cnfe) {
                        Log.debug(5, "Sorry - unable to start the table creator automatically - please select the \"Create/Import New Data Table...\" option from the \"Data\" menu by hand ");
                        cnfe.printStackTrace();
                    }
                }
            });
            this.showMeButton = new HyperlinkButton(newDataTableAction);
            Dimension DIM = new Dimension(400, 20);
            this.showMeButton.setMinimumSize(DIM);
            this.showMeButton.setPreferredSize(DIM);
            this.showMeButton.setMaximumSize(DIM);
        }
        this.updateShowMeButton();
        return this.showMeButton;
    }

    private void updateShowMeButton() {
        String ID = this.mainWizFrame.getFirstPageID();
        if (ID == null) {
            this.showMeButton.setEnabled(false);
            this.showMeButton.setVisible(false);
        } else if (ID.equals("INTRODUCTION") || ID.equals("DATA_LOCATION")) {
            this.showMeButton.setEnabled(true);
            this.showMeButton.setVisible(true);
        } else {
            this.showMeButton.setEnabled(false);
            this.showMeButton.setVisible(false);
        }
    }

    private String getDataLocation() {
        String loc;
        String summaryText = WizardSettings.getSummaryText();
        if (summaryText != null && (summaryText.equals("You have chosen to describe data that is available online at: ") || summaryText.equals("In addition to describing your data, you have chosen to include it within the data package.")) && (loc = WizardSettings.getDataLocation()) != null) {
            return "<span style=\"text-decoration: underline;\">" + loc + "</span>";
        }
        return "";
    }

    public void onRewindAction() {
    }

    public boolean onAdvanceAction() {
        return true;
    }

    public OrderedMap getPageData() {
        return null;
    }

    public OrderedMap getPageData(String rootXPath) {
        throw new UnsupportedOperationException("getPageData(String rootXPath) Method Not Implemented");
    }

    public String getPageID() {
        return "SUMMARY";
    }

    public String getTitle() {
        if (this.mainWizFrame.getFirstPageID() == "DATA_LOCATION") {
            return "New Data Table Wizard";
        }
        return "New Data Package Wizard";
    }

    public String getSubtitle() {
        return "Summary";
    }

    public String getNextPageID() {
        return this.nextPageID;
    }

    public String getPageNumber() {
        return "15";
    }

    public boolean setPageData(OrderedMap data, String xPathRoot) {
        return false;
    }
}

